/**
 *  Freeverb DLL
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CheckCPU.hpp"
#include "StereoEnhancer.hpp"

#if WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

#define FV3_CONF_XML_W L"freeverb3cfg.xml"
#define FV3_CONF_XML    "freeverb3cfg.xml"
#define FV3_STENH_CONF_VERSION 101
#define FV3_STENH_CONF_KEY_VERSION "/Freeverb3VST_StereoEnhancer/Version"
#define FV3_STENH_CONF_KEY_LATENCY "/Freeverb3VST_StereoEnhancer/Latency"

#ifdef WIN32
wchar_t ModuleFileNameW[MAX_PATH];
#else
#define MAX_PATH PATH_MAX
#endif
char XMLConfigPath[MAX_PATH];

void initXMLConfigPath()
{
  XMLConfigPath[0] = '\0';
#ifdef WIN32
  wchar_t szDrive[_MAX_DRIVE], szDir[_MAX_DIR], szFileName[_MAX_FNAME], szExt[_MAX_EXT], szConfigFile[MAX_PATH];
  _wsplitpath(ModuleFileNameW, szDrive, szDir, szFileName, szExt);
  wsprintfW(szConfigFile, L"%s%s"FV3_CONF_XML_W, szDrive, szDir);
  WideCharToMultiByte(CP_ACP, WC_NO_BEST_FIT_CHARS, szConfigFile, -1, XMLConfigPath, MAX_PATH, NULL, NULL);
#endif
#ifdef MAC
  char hDIR[MAX_PATH];
  getHomeDirectoryName(hDIR);
  snprintf(XMLConfigPath, MAX_PATH, "%s/Library/Audio/Plug-Ins/VST/%s", hDIR, FV3_CONF_XML);
#endif
}

#if WIN32
extern "C" __declspec(dllexport) AEffect *VSTPluginMain(audioMasterCallback audioMaster);
#elif MAC
extern "C" AEffect *VSTPluginMain(audioMasterCallback audioMaster);
extern "C" AEffect *main_macho(audioMasterCallback audioMaster){return VSTPluginMain(audioMaster);}
extern "C" AEffect *main_plugin(audioMasterCallback audioMaster){return VSTPluginMain(audioMaster);}
#endif

extern "C" AEffect *VSTPluginMain(audioMasterCallback audioMaster)
{
  initXMLConfigPath();
  XMLConfig xmlConfig;
  xmlConfig.registerXML(XMLConfigPath);
  if (!audioMaster(NULL, audioMasterVersion, 0, 0, NULL, 0)) return NULL;
  if(detectCPU() == 0) return NULL;
  StereoEnhancer *plug;
  try
    {
      plug = new StereoEnhancer(audioMaster);
      if(xmlConfig.getKeyAsInt(FV3_STENH_CONF_KEY_VERSION) < FV3_STENH_CONF_VERSION)
	{
	  MacMessageBox(XMLConfigPath, "Freeverb3 StereoEnhancer: You should update your configuration XML file. Skipping...");
	  plug->setLatency(0);
	}
      else
	{
	  plug->setLatency(xmlConfig.getKeyAsInt(FV3_STENH_CONF_KEY_LATENCY));
	}
    }
  catch(std::bad_alloc)
    {
      MacMessageBox("VSTPluginMain()", "Freeverb3 StereoEnhancer: std::bad_alloc");
      return NULL;
    }
  return plug->getAeffect();
}

#if WIN32
void *hInstance;
extern "C" BOOL WINAPI
DllMain(HINSTANCE hInst, DWORD dwReason, LPVOID lpvReserved)
{
  DWORD dwRet;    
  hInstance = hInst;
  switch(dwReason)
    {
    case DLL_PROCESS_ATTACH:
      dwRet = GetModuleFileNameW((HMODULE)hInstance, ModuleFileNameW, MAX_PATH);
      if(dwRet == 0) return FALSE;
      break;
    case DLL_PROCESS_DETACH:
      break;
    case DLL_THREAD_ATTACH:
      break;
    case DLL_THREAD_DETACH:
      break;
    }
  return TRUE;
}
#endif
