/**
 *  General GUI
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "X1_Limiter_Editor.hpp"

X1LimiterEditor::X1LimiterEditor(AudioEffectX *effect) :
  AEffGUIEditor(effect), aeffect(effect)
{
  CBitmap backBitmap(kX1LBackBitmap);
  rect.left = 0; rect.top = 0; rect.right = backBitmap.getWidth(); rect.bottom = backBitmap.getHeight();
  cgainL = cgavuL = cgainR = cgavuR = 0;
  paramConv = NULL;
}

X1LimiterEditor::~X1LimiterEditor()
{
  ;
}

void X1LimiterEditor::registerParamConverter(PARAMCONV def)
{
  if(def != NULL) paramConv = def;
}

void X1LimiterEditor::valueChanged(CControl * pControl)
{
  VstInt32 index = pControl->getTag();
  float value = pControl->getValue();
  if(index >= 0&&index < KNumParams)
    aeffect->setParameterAutomated(index, value);
  if(index >= KNumParams&&index < KNumParams*2)
    {
      VstInt32 paramIndex = index - KNumParams;
      char str[16]; float fvalue = 0;
      ((CTextEdit*)pControl)->getText(str), fvalue = atof(str);
      if(paramConv != NULL) fvalue = paramConv(paramIndex, fvalue);
      if(fvalue < 0) fvalue = 0; if(fvalue > 1) fvalue = 1;
      effect->setParameterAutomated(paramIndex, fvalue);
    }
  pControl->setDirty();
}

static char * LabelSet[kKnobs] = { "PreGain", "Ceiling", "Threshold", "Release", "Attack", "LookRatio", "LKahead", "RMS"};
static char * LabelSet2[kKnobs] = { "dB", "dB", "dB", "ms", "ms", "t", "ms", "ms",};
static VstInt32 knobSet[kKnobs][3] = {
  {KPreGain,     26,  20,}, {KCeiling, 110,  20,},
  {KThreshold,   26, 119,}, {KRelease, 110, 119,},
  {KAttack,      26, 218,}, {KLookaheadRatio, 110, 218,},
  {KLookahead,  640,  20,}, {KRMS,     724,  20,},
};

void X1LimiterEditor::setParameter(VstInt32 index, float value)
{
  if(!frame) return;
  switch(index)
    {
    case KStLink:
      stLinkB->setValue(value);
      break;
    case KPreGain:
    case KCeiling:
    case KThreshold:
    case KRelease:
    case KAttack:
    case KLookaheadRatio:
    case KLookahead:
    case KRMS:
      {
	for(unsigned int fi = 0;fi < kKnobs;fi ++)
	  {
	    if(index == knobSet[fi][0])
	      {
		animKnob[fi]->setValue(value);
		char str[kVstMaxParamStrLen];
		aeffect->getParameterDisplay(index, str), str[5] = '\0';
		textEdit[fi]->setText(str);
	      }
	  }
      }
      break;
    default:
      break;
    }
}

bool X1LimiterEditor::open(void *ptr)
{
  AEffGUIEditor::open(ptr);
  
  CBitmap *backBitmap = new CBitmap(kX1LBackBitmap);
  CRect size(0, 0, backBitmap->getWidth(), backBitmap->getHeight());
  CFrame * _frame = new CFrame(size, ptr, this);
  _frame->setBackground(backBitmap);
  backBitmap->forget();
  
  CBitmap *ckKnob1 = new CBitmap(kX1KnobBitmap1);

  for(int i = 0;i < kKnobs;i ++)
    {
      size(knobSet[i][1],                     knobSet[i][2],
	   knobSet[i][1]+ckKnob1->getWidth(), knobSet[i][2]+ckKnob1->getWidth());
      animKnob[i] = new CAnimKnob(size, this, knobSet[i][0], ckKnob1->getHeight()/ckKnob1->getWidth(), ckKnob1->getWidth(), ckKnob1, CPoint(0,0));
      animKnob[i]->setValue(limitFader(aeffect->getParameter(knobSet[i][0])));
      _frame->addView(animKnob[i]);
      
      size(knobSet[i][1],                        knobSet[i][2]+ckKnob1->getWidth()+2,
	   knobSet[i][1]+ckKnob1->getWidth()-20, knobSet[i][2]+ckKnob1->getWidth()+19);
      textEdit[i] = new CTextEdit(size, this, KNumParams+knobSet[i][0], NULL, NULL, kCenterText);
      textEdit[i]->setFont(kNormalFontBig);
      textEdit[i]->setFontColor(kWhiteCColor); textEdit[i]->setBackColor(kBlackCColor); textEdit[i]->setFrameColor(kBlackCColor);
      char str[kVstMaxParamStrLen];
      aeffect->getParameterDisplay(knobSet[i][0], str), str[5] = '\0';
      textEdit[i]->setText(str);
      _frame->addView(textEdit[i]);
      
      size(knobSet[i][1]-10,                     knobSet[i][2]-14,
	   knobSet[i][1]+ckKnob1->getWidth()+10, knobSet[i][2]-1);
      CTextLabel * cLabel = new CTextLabel(size, LabelSet[i], 0);
      cLabel->setFont(kNormalFontVeryBig); cLabel->setFontColor(kWhiteCColor); cLabel->setBackColor(kBlackCColor); cLabel->setFrameColor(kBlackCColor);
      _frame->addView(cLabel);

      size(knobSet[i][1]+ckKnob1->getWidth()-20, knobSet[i][2]+ckKnob1->getWidth()+2,
	   knobSet[i][1]+ckKnob1->getWidth(),    knobSet[i][2]+ckKnob1->getWidth()+19);
      cLabel = new CTextLabel(size, LabelSet2[i], 0);
      cLabel->setFont(kNormalFontBig); cLabel->setFontColor(kWhiteCColor); cLabel->setBackColor(kBlackCColor); cLabel->setFrameColor(kBlackCColor);
      _frame->addView(cLabel);
    }

  CBitmap *onOffBmp = new CBitmap(kX1OnOffBitmap1);
  size(230,                      265,
       230+onOffBmp->getWidth(), 265+onOffBmp->getHeight()/2);
  stLinkB = new COnOffButton(size, this, KStLink, onOffBmp);
  stLinkB->setValue(effect->getParameter(KStLink));
  _frame->addView(stLinkB);
    
  size(255,    270,
       255+100, 270+17);
  CTextLabel * cLabel = new CTextLabel(size, "StereoLink", 0);
  cLabel->setFont(kNormalFontVeryBig); cLabel->setFontColor(kWhiteCColor); cLabel->setBackColor(kBlackCColor); cLabel->setFrameColor(kBlackCColor);
  _frame->addView(cLabel);  

  size(0, 0, kVuMeterX, kVuMeterY);
  size.offset(kVuMeterOffsetX1, kVuMeterOffsetY);
  vuMeterL = new CNeedleMeter(size, kBlueCColor, kRedCColor, CPoint(kVuMeterCX, kVuMeterCY), kVuMeterD1, kVuMeterD2, kVuMeterN1, kVuMeterN2, kVuMeterN3);
  _frame->addView(vuMeterL);

  size(0, 0, kVuMeterX, kVuMeterY);
  size.offset(kVuMeterOffsetX2, kVuMeterOffsetY);
  vuMeterR = new CNeedleMeter(size, kBlueCColor, kRedCColor, CPoint(kVuMeterCX, kVuMeterCY), kVuMeterD1, kVuMeterD2, kVuMeterN1, kVuMeterN2, kVuMeterN3);
  _frame->addView(vuMeterR);

  _frame->setDirty();
  this->frame = _frame;
  return true;
}

void X1LimiterEditor::close()
{
  if (frame != NULL) delete frame;
  frame = NULL;
}

void X1LimiterEditor::idle()
{
  if(!frame) return;
  if(vuMeterL) vuMeterL->updateValue(cgainL, cgavuL);
  if(vuMeterR) vuMeterR->updateValue(cgainR, cgavuR);
  AEffGUIEditor::idle();
}

void X1LimiterEditor::setVuMeter(float t, float v, float s, float u)
{
  cgainL = (t-0.1f)/1.31254f; cgavuL = s;
  cgainR = (v-0.1f)/1.31254f; cgavuR = u;
}

float X1LimiterEditor::limitFader(float value)
{
  if(value < 0) return 0;
  if(value > 1) return 1;
  return value;
}
