/**
 *  Chunk Library
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CChunk.hpp"

CChunk::CChunk()
{
  isValid = 0;
  chunkHead.numberOfSlot = 0;
  chunkData = NULL;
}

void CChunk::clear()
{
  isValid = 0;
  chunkHead.numberOfSlot = 0;
  delete[] chunkData;
  chunkData = NULL;
  chunkSlotVector.clear();
  chunkStringVector.clear();
  chunkFloatVector.clear();
}

CChunk::~CChunk()
{
  clear();
}

int CChunk::registerChunk(int size, void * data)
{
  if(data == NULL) return -1;
  char * cdata = (char *)data;
  // head
  isValid = 0;
  chunkHead.numberOfSlot = 0;
  if(size < (int)sizeof(CChunkHead))
    {
      return -1;
    }
  std::memcpy(&chunkHead, cdata, sizeof(CChunkHead));
  cdata += sizeof(CChunkHead);
  size -= (int)sizeof(CChunkHead);
  // slot
  for(int i = 0;i < chunkHead.numberOfSlot;i ++)
    {
      CChunkSlot tmpSlot;
      if(size < (int)sizeof(CChunkSlot))
	{
	  return -3;
	}
      std::memcpy(&tmpSlot, cdata, sizeof(CChunkSlot));
      cdata += sizeof(CChunkSlot);
      size -= (int)sizeof(CChunkSlot);
      if(tmpSlot.typeOfSlot == kStringType)
	{
	  if(size < tmpSlot.sizeOfData)
	    {
	      return -5;
	    }
	  char dataString[tmpSlot.sizeOfData+1];
	  dataString[tmpSlot.sizeOfData] = 0;
	  std::memcpy(dataString, cdata, tmpSlot.sizeOfData);
	  chunkSlotVector.push_back(tmpSlot);
	  chunkStringVector.push_back(std::string(dataString));
	  chunkFloatVector.push_back(0);
	  cdata += tmpSlot.sizeOfData;
	  size -= tmpSlot.sizeOfData;
	}
      else if(tmpSlot.typeOfSlot == kIntType)
	{
	  chunkSlotVector.push_back(tmpSlot);
	  chunkStringVector.push_back(std::string(""));
	  chunkFloatVector.push_back(0);
	}
      else if(tmpSlot.typeOfSlot == kFloatType)
	{
	  float value;
	  std::memcpy(&value, cdata, sizeof(float));
	  chunkSlotVector.push_back(tmpSlot);
	  chunkStringVector.push_back(std::string(""));
	  chunkFloatVector.push_back(value);
	  cdata += tmpSlot.sizeOfData;
	  size -= tmpSlot.sizeOfData;
	}
    }
  return 0;
}

int CChunk::getChunk(int * size, void ** data)
{
  if(size == NULL||data == NULL) return -1;
  // count data size
  int csize = 0;
  unsigned char * cdata = NULL;

  csize = (int)sizeof(CChunkHead);
  for(int i = 0;i < chunkHead.numberOfSlot;i ++)
    {
      csize += (int)sizeof(CChunkSlot);
      csize += (int)chunkStringVector.at(i).size();
      if(chunkSlotVector.at(i).typeOfSlot == kFloatType)
	csize += sizeof(float);
    }
  if(csize <= 0) return -1;
  delete[] chunkData;
  chunkData = new unsigned char[csize];
  cdata = chunkData;
  // head
  chunkHead.sizeOfChunk = csize;
  std::memcpy(cdata, &chunkHead, sizeof(chunkHead));
  cdata += sizeof(chunkHead);
  // slot
  for(int i = 0;i < chunkHead.numberOfSlot;i ++)
    {
      std::memcpy(cdata, &chunkSlotVector.at(i), sizeof(CChunkSlot));
      cdata += sizeof(CChunkSlot);
      std::memcpy(cdata, chunkStringVector.at(i).c_str(),
	     chunkStringVector.at(i).size());
      cdata += chunkStringVector.at(i).size();
      if(chunkSlotVector.at(i).typeOfSlot == kFloatType)
	{
	  std::memcpy(cdata, &chunkFloatVector.at(i), sizeof(float));
	  cdata += sizeof(float);
	}
    }
  *size = csize;
  *data = chunkData;
  return 0;
}

int CChunk::getNumberOfSlots()
{
  return chunkHead.numberOfSlot;
}

int CChunk::getVLSize()
{
  return chunkSlotVector.size();
}

int CChunk::getVTSize()
{
  return chunkStringVector.size();
}

int CChunk::getSlotString(int slot, char ** data)
{
  if(data == NULL) return -1;
  if(chunkHead.numberOfSlot <= 0) return -2;
  for(unsigned int i = 0;i < chunkSlotVector.size();i ++)
    {
      if(chunkSlotVector.at(i).numberOfSlot == slot)
	{
	  *data = (char *)chunkStringVector.at(i).c_str();
	  return 0;
	}
    }
  return -3;
}

int CChunk::getSlotInt(int slot, int * value)
{
  if(value == NULL) return -1;
  if(chunkHead.numberOfSlot <= 0) return -2;
  for(unsigned int i = 0;i < chunkSlotVector.size();i ++)
    {
      if(chunkSlotVector.at(i).numberOfSlot == slot)
	{
	  *value = chunkSlotVector.at(i).sizeOfData;
	  return 0;
	}
    }
  return -3;
}

int CChunk::getSlotFloat(int slot, float * value)
{
  if(value == NULL) return -1;
  if(chunkHead.numberOfSlot <= 0) return -2;
  for(unsigned int i = 0;i < chunkSlotVector.size();i ++)
    {
      if(chunkSlotVector.at(i).numberOfSlot == slot)
	{
	  *value = chunkFloatVector.at(i);
	  return 0;
	}
    }
  return -3;
}

int CChunk::setSlotString(int slot, const char * data)
{
  if(data == NULL) return -1;
 setSlotString_s:
  int slotAt = -1;
  for(unsigned int i = 0;i < chunkSlotVector.size();i ++)
    {
      if(chunkSlotVector.at(i).numberOfSlot == slot)
	slotAt = i;
    }
  if(slotAt < 0)
    {
      addSlot(slot, kStringType);
      goto setSlotString_s;
    }
  chunkStringVector.at(slotAt) = std::string(data);
  chunkSlotVector.at(slotAt).sizeOfData = std::string(data).size();
  return 0;
}

int CChunk::setSlotInt(int slot, int value)
{
 setSlotInt_s:
  int slotAt = -1;
  for(unsigned int i = 0;i < chunkSlotVector.size();i ++)
    {
      if(chunkSlotVector.at(i).numberOfSlot == slot)
	slotAt = i;
    }
  if(slotAt < 0)
    {
      addSlot(slot, kIntType);
      goto setSlotInt_s;
    }
  chunkSlotVector.at(slotAt).sizeOfData = value;
  return 0;
}

int CChunk::setSlotFloat(int slot, float value)
{
 setSlotFloat_s:
  int slotAt = -1;
  for(unsigned int i = 0;i < chunkSlotVector.size();i ++)
    {
      if(chunkSlotVector.at(i).numberOfSlot == slot)
	slotAt = i;
    }
  if(slotAt < 0)
    {
      addSlot(slot, kFloatType);
      goto setSlotFloat_s;
    }
  chunkFloatVector.at(slotAt) = value;
  chunkSlotVector.at(slotAt).sizeOfData = sizeof(float);
  return 0;
}

void CChunk::setVersion(int version)
{
  chunkHead.versionOfSlot = version;
}

int CChunk::getVersion()
{
  return chunkHead.versionOfSlot;
}

void CChunk::addSlot(int slot, int type)
{
  CChunkSlot cSlot;
  cSlot.numberOfSlot = slot;
  cSlot.typeOfSlot = type;
  chunkHead.numberOfSlot ++;
  chunkSlotVector.push_back(cSlot);
  chunkStringVector.push_back(std::string(""));
  chunkFloatVector.push_back(0);
}
