/**
 *  Progenitor Reverb
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __STRev_H
#define __STRev_H

#define EFFECT_NAME "Freeverb3_ProG_Reverb"

#include <cstdlib>

#include <new>
#include <vector>
#include <string>
#include <cstdio>
#include <typeinfo>
#include <audioeffectx.h>
#include <freeverb/earlyref.hpp>
#include <freeverb/progenitor2.hpp>
#include "ProcessBlock.hpp"
#include "Locker.hpp"

#ifdef PLUGDOUBLE
typedef fv3::earlyref_ EARLYREF;
typedef fv3::progenitor2_ PROGREV;
typedef fv3::utils_ UTILS;
typedef double pfloat_t;
#else
typedef fv3::earlyref_f EARLYREF;
typedef fv3::progenitor2_f PROGREV;
typedef fv3::utils_f UTILS;
typedef float pfloat_t;
#endif

enum {
  KOFactor, KDry, KERefWet, KERefWidth, KERefFactor, KERtoLate, KWet, KWidth, KDelay, KRT60,
  KInputLPF, KDampLPF, KBassLPF, KBassFactor, KOutputLPF, KOutputBW, KSpin, KWander,
  KNumParams,
};

class ProGRevProgram
{
public:
  ProGRevProgram()
  {
    fOFactor = 2, fDry = -4, fERefWet = -3, fERefWidth = 0.2, fERefFactor = 1.2, fERtoLate = 1, fWet = -6, fWidth = 1, fDelay = 1, fRT60 = 2.8,
      fInputLPF = 18000, fDampLPF = 8000, fBassLPF = 1500, fBassFactor = 0.15, fOutputLPF = 16000, fOutputBW = 2, fSpin = 0.7, fWander = 0.35;
    strcpy(name, "(Default Preset)");
  }
  ~ProGRevProgram(){}
  void setProgram(char * n, float v[KNumParams])
  {
    fOFactor = v[0], fDry = v[1], fERefWet = v[2], fERefWidth = v[3], fERefFactor = v[4], fERtoLate = v[5],
      fWet = v[6], fWidth = v[7], fDelay = v[8], fRT60 = v[9],
      fInputLPF = v[10], fDampLPF = v[11], fBassLPF = v[12], fBassFactor = v[13], fOutputLPF = v[14], fOutputBW = v[15], fSpin = v[16], fWander = v[17];
    strcpy(name, n);
  }
  pfloat_t getParameterValue(VstInt32 index)
  {
    pfloat_t ret = 0.;
    switch (index)
      {
      case KOFactor:    ret = this->fOFactor;   break;
      case KDry:        ret = this->fDry;       break;
      case KERefWet:    ret = this->fERefWet;	break;
      case KERefWidth:  ret = this->fERefWidth;	break;
      case KERefFactor: ret = this->fERefFactor;break;
      case KERtoLate:   ret = this->fERtoLate;  break;
      case KWet:        ret = this->fWet;	break;
      case KWidth:      ret = this->fWidth;	break;
      case KDelay:	ret = this->fDelay;	break;
      case KRT60:	ret = this->fRT60;	break;
      case KInputLPF:	ret = this->fInputLPF;	break;
      case KDampLPF:	ret = this->fDampLPF;	break;
      case KBassLPF:	ret = this->fBassLPF;	break;
      case KBassFactor:	ret = this->fBassFactor;break;
      case KOutputLPF:	ret = this->fOutputLPF;	break;
      case KOutputBW:	ret = this->fOutputBW;	break;
      case KSpin:	ret = this->fSpin;	break;
      case KWander:	ret = this->fWander;	break;
      default:          break;
      }
    return ret;
  }
private:
  friend class ProGRev;
  pfloat_t fOFactor, fDry, fERefWet, fERefWidth, fERefFactor, fERtoLate, fWet, fWidth, fDelay, fRT60,
    fInputLPF, fDampLPF, fBassLPF, fBassFactor, fOutputLPF, fOutputBW, fSpin, fWander;
  char name[kVstMaxProgNameLen];
};

class ProGRev :
  public AudioEffectX, ProcessBlock, Locker
{
public:
  ProGRev(audioMasterCallback audioMaster) ALIGN_ARG_POINTER;
  virtual ~ProGRev();
  virtual VstPlugCategory getPlugCategory();
  virtual VstInt32 getProgram();
  virtual void     setProgram(VstInt32 program);
  virtual void setProgramName(char *name);
  virtual void getProgramName(char *name);
  virtual bool getProgramNameIndexed(VstInt32 category, VstInt32 index, char* text);
  virtual void getParameterLabel(VstInt32 index, char *label);
  virtual void getParameterDisplay(VstInt32 index, char *text);
  virtual void getParameterName(VstInt32 index, char *text);
  virtual bool getEffectName (char* name);
  virtual bool getVendorString (char* text);
  virtual bool getProductString (char* text);
  virtual VstInt32 canDo(char* text);
  virtual bool setBypass(bool onOff);
  virtual bool getInputProperties(VstInt32 index, VstPinProperties* properties);
  virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);
  
  virtual void  suspend() ALIGN_ARG_POINTER;
  virtual void  resume() ALIGN_ARG_POINTER;
  virtual void  setSampleRate (float sampleRate) ALIGN_ARG_POINTER;
  virtual float getSampleRate() ALIGN_ARG_POINTER;
  virtual void  setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual float getParameter(VstInt32 index) ALIGN_ARG_POINTER;
  virtual void process               (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  virtual void processReplacing      (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#ifdef PLUGDOUBLE
  virtual void processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#endif
  virtual void processLRModel(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;

  void setConverterType(int type);
  void setLatency(int size);
  
  static pfloat_t param2model(int index, float value);
  static float model2param(int index, pfloat_t value);
  static pfloat_t pconv(int index, pfloat_t value, bool p2m);
  
private:
  void setParameterM(VstInt32 index, float value);
  void setParameter(VstInt32 index, float value, bool vstp);

  ProGRevProgram * programs;
  EARLYREF *dsp_eref;
  PROGREV  *dsp_prev;
  SLOT tmp1Block, tmp2Block;
  pfloat_t vERtoLate, dryDB, erDB;
  double currentFs;
  int converter_type;
  bool byPass, ModeProG2;
};

#endif
