/**
 *  X1_Limiter
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __X1_Limiter_H
#define __X1_Limiter_H

#define EFFECT_NAME "Freeverb3_X1_Limiter"

#include <cstdlib>

#include <new>
#include <vector>
#include <string>
#include <audioeffectx.h>

#include <freeverb/src.hpp>
#include <freeverb/limitmodel.hpp>

#include "ProcessBlock.hpp"
#include "Locker.hpp"

#ifdef PLUGDOUBLE
typedef fv3::limitmodel_ REVMODEL;
typedef fv3::rms_ RMS;
typedef double pfloat_t;
#else
typedef fv3::limitmodel_f REVMODEL;
typedef fv3::rms_f RMS;
typedef float pfloat_t;
#endif

enum { KCeiling, KThreshold, KPreGain, KRelease, KAttack, KLookahead, KLookaheadRatio, KRMS, KFactor, KStLink, KType, KNumParams, };

class X1LimiterProgram
{
public:
  X1LimiterProgram()
  {
    fCeiling = 0, fThreshold = -2, fPreGain = 10, fRelease = 100, fAttack = 0, fLookahead = 1, fLookaheadRatio = 1,
      fRMS = 0, fFactor = 1, fStLink = 1, fType = 0;
    strcpy(name, "(Default Preset)");
  }
  ~X1LimiterProgram(){}
  void setProgram(char * n, float v[KNumParams])
  {
    fCeiling = v[0], fThreshold = v[1], fPreGain = v[2], fRelease = v[3], fAttack = v[4], fLookahead = v[5], fLookaheadRatio = v[6],
      fRMS = v[7], fFactor = v[8], fStLink = v[9], fType = v[10];
    strcpy(name, n);
  }
private:
  friend class X1Limiter;
  pfloat_t fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead, fLookaheadRatio, fRMS, fFactor, fStLink, fType;
  char name[kVstMaxProgNameLen];
};

class X1Limiter :
  public AudioEffectX, ProcessBlock, Locker
{
public:
  X1Limiter(audioMasterCallback audioMaster) ALIGN_ARG_POINTER;
  virtual ~X1Limiter();
  virtual VstPlugCategory getPlugCategory();
  virtual VstInt32 getProgram();
  virtual void     setProgram(VstInt32 program);
  virtual void setProgramName(char *name);
  virtual void getProgramName(char *name);
  virtual bool getProgramNameIndexed(VstInt32 category, VstInt32 index, char* text);
  virtual void getParameterLabel(VstInt32 index, char *label);
  virtual void getParameterDisplay(VstInt32 index, char *text);
  virtual void getParameterName(VstInt32 index, char *text);
  virtual bool getEffectName(char* name);
  virtual bool getVendorString(char* text);
  virtual bool getProductString(char* text);
  virtual VstInt32 canDo(char* text);
  virtual bool setBypass(bool onOff);
  virtual bool getInputProperties (VstInt32 index, VstPinProperties* properties);
  virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);

  virtual void  suspend() ALIGN_ARG_POINTER;
  virtual void  resume() ALIGN_ARG_POINTER;
  virtual float getSampleRate() ALIGN_ARG_POINTER;
  virtual void  setSampleRate (float sampleRate) ALIGN_ARG_POINTER;
  virtual void  setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual float getParameter(VstInt32 index) ALIGN_ARG_POINTER;
  virtual void process(float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  virtual void processReplacing(float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#ifdef PLUGDOUBLE
  virtual void processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#endif
  virtual void processLRModel(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;

  void setConverterType(int type);
  void setLatency(int size);

  static pfloat_t param2model(int index, float value);
  static float model2param(int index, pfloat_t value);
  static pfloat_t pconv(int index, pfloat_t value, bool p2m);
  
private:
  void setParameterM(VstInt32 index, float value);
  void setParameter(VstInt32 index, float value, bool vstp);
  X1LimiterProgram * programs;
  REVMODEL * model; RMS rmsL, rmsR;
  pfloat_t limiterGain;
  int converter_type;
  double currentFs;
  bool byPass;
};
#endif
