/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef APPLICATION_WINDOW_HXX
#define APPLICATION_WINDOW_HXX

#include <gtkmm/window.h>
#include <boost/ptr_container/ptr_vector.hpp>
#include <vector>
#include "history_data.hxx"


namespace dialektos {

namespace bbs_detail {
  class Base;
}


class ApplicationWindow: public Gtk::Window {
public:
  virtual ~ApplicationWindow();
  static ApplicationWindow* find(const bbs_detail::Base& bbs);
  static void load();
  virtual void save_state() const = 0;
protected:
  ApplicationWindow();
  static void regist(ApplicationWindow* window);
  static void save();
  static void close_windows(const std::vector<ApplicationWindow*>&);
  virtual bool on_delete_event(GdkEventAny*);
private:
  virtual bool is_same(const bbs_detail::Base& bbs) const = 0;
public:
  virtual std::string get_uri() const = 0;
protected:
  static boost::ptr_vector<ApplicationWindow> windows;
  static history::Data histories;
};


} // namespace dialektos


#endif
