/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bbs_detail_judge.hxx"

#include "bbs_detail_base.hxx"
#include "bbs_detail_2ch.hxx"
#include "bbs_detail_yy.hxx"


namespace dialektos {

namespace bbs_detail {


std::auto_ptr<Base> judge(const std::string& uri) {

  if (Base* bbs = CH2::judge(uri)) return std::auto_ptr<Base>(bbs);
  if (Base* bbs = YY::judge(uri)) return std::auto_ptr<Base>(bbs);
//  if (Base* bbs = Base::judge(uri)) return bbs;

  return std::auto_ptr<Base>();
}


} // namespace bbs_detail

} // namespace dialektos
