/*
 * Copyright (C) 2010 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BBS_DETAIL_YY_HXX
#define BBS_DETAIL_YY_HXX

#include <string>
#include <memory>
#include "bbs_detail_base.hxx"


namespace dialektos {

namespace bbs_detail {


class YY: public dialektos::bbs_detail::Base {
public:
  YY(const std::string& uri, const std::string& host,
      const std::string& board, const std::string& thread);
  virtual ~YY();

  static YY* judge(const std::string& uri);

protected:
  explicit YY(const YY& rhs);

private:
  virtual YY* do_clone() const;
  virtual const std::string& get_bbs_name() const;

  static YY* judge_thread(const std::string& uri);
  static YY* judge_board(const std::string& uri);


  static const std::string bbs_name;
};


} // namespace dialektos

} // namespace dialektos


#endif
