/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef BOARD_SUBJECT_HXX
#define BOARD_SUBJECT_HXX

#include <boost/serialization/access.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/filesystem.hpp>
#include <string>


namespace dialektos {


struct SubjectIdx {
  SubjectIdx();

  static SubjectIdx from_xml(const boost::filesystem::path& xml);
  void to_xml(const boost::filesystem::path& xml);

  std::string last_modified_;
private:
  friend class boost::serialization::access;
  template <typename ArchiveType>
  void serialize(ArchiveType& ar, const unsigned int version) {
    ar & boost::serialization::make_nvp("LastModified", last_modified_);
  }
};


} // namespace dialektos


#endif
