/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "board_view_column.hxx"

#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/date_time/local_time_adjustor.hpp>
#include <boost/lexical_cast.hpp>
#include <sstream>


namespace dialektos {

namespace view_column {


void RenderCellStartTime::operator()(
    Gtk::CellRenderer* cell,
    const Gtk::TreeModel::iterator& iter) const {

  model_column::ID::type value;
  iter->get_value(boost::mpl::find<ModelColumns::type,
      model_column::ID>::type::pos::value, value);

  try {
    typedef boost::date_time::local_adjustor<
      boost::posix_time::ptime, 9, boost::posix_time::no_dst> jpn;

    std::time_t t = boost::lexical_cast<std::time_t>(value);
    boost::posix_time::ptime ptime = boost::posix_time::from_time_t(t);
    boost::posix_time::time_facet* facet =
      new boost::posix_time::time_facet("%Y/%m/%d %H:%M:%S");
    std::stringstream ss;
    ss.imbue(std::locale(ss.getloc(), facet));
    ss << jpn::utc_to_local(ptime);
    value = ss.str();
  } catch (const std::exception& /*e*/) {
    value = "";
  }

  cell->set_property("text", value);
}


} // namespace view_column

} // namespace dialektos
