/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOOKMARK_ITEM_HXX
#define BOOKMARK_ITEM_HXX

#include <boost/serialization/access.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/string.hpp>
#include <boost/filesystem/path.hpp>
#include <vector>
#include <string>
#include <algorithm>


namespace dialektos {

namespace bookmark {


struct Item {
  std::string name;
  std::string uri;
  std::vector<std::string> categories;

  bool belongs_to(const std::string& category) const {
    return std::find(categories.begin(), categories.end(), category) !=
      categories.end();
  }

private:
  friend class boost::serialization::access;
  template <typename ArchiveType>
  void serialize(ArchiveType& ar, const unsigned int version) {
    ar & boost::serialization::make_nvp("Name", name);
    ar & boost::serialization::make_nvp("URI", uri);
    ar & boost::serialization::make_nvp("Categories", categories);
  }
};

std::vector<Item> from_html(const std::string& html);
std::vector<Item> from_xml(const boost::filesystem::path&);
void to_xml(const boost::filesystem::path&, const std::vector<Item>&);

} // namespace bookmark

} // namespace dialektos


#endif
