/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOOKMARK_WINDOW_HXX
#define BOOKMARK_WINDOW_HXX


#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treeview.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/widget.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/actiongroup.h>
#include <gtkmm/liststore.h>
#include <glibmm/refptr.h>
#include <boost/scoped_ptr.hpp>
#include <boost/filesystem/path.hpp>
#include <string>
#include <vector>
#include "bookmark_item.hxx"


namespace dialektos {

namespace http {
  struct GetInThread;
}


class BookmarkWindow : public Gtk::Window {

  struct CategoryColumnRecord : public Gtk::TreeModelColumnRecord {
    CategoryColumnRecord() : Gtk::TreeModelColumnRecord() {
      add(category_);
    }
    Gtk::TreeModelColumn<std::string> category_;
  };

  struct BookmakrItemColumnRecord : public Gtk::TreeModelColumnRecord {
    BookmakrItemColumnRecord() : Gtk::TreeModelColumnRecord() {
      add(name_);
      add(uri_);
    }
    Gtk::TreeModelColumn<std::string> name_;
    Gtk::TreeModelColumn<std::string> uri_;
  };

public:
  static void create();
  virtual ~BookmarkWindow();
protected:
  BookmarkWindow();
  virtual bool on_delete_event(GdkEventAny*);
private:
  void build_menu();

  void on_action_view_refresh();
  void on_action_view_stop();
  void on_action_view_menubar();
  void on_action_view_toolbar();
  void on_action_view_statusbar();

  void on_http_get_end(bool);

  void on_category_cursor_changed();
  void on_category_row_activated(const Gtk::TreeModel::Path&,
      Gtk::TreeViewColumn*);
  void on_bookmark_row_activated(const Gtk::TreeModel::Path&,
      Gtk::TreeViewColumn*);

  void save_content();

  void reconstruct_category();
  boost::filesystem::path get_xml_path() const;

  Gtk::VBox vbox_;
  Gtk::HPaned hpaned_;
  Gtk::ScrolledWindow scrolled1_;
  Gtk::ScrolledWindow scrolled2_;
  Gtk::TreeView view_category_;
  Gtk::TreeView view_bookmark_;
  Gtk::Statusbar statusbar_;

  CategoryColumnRecord category_column_record_;
  BookmakrItemColumnRecord bookmark_column_record_;
  Glib::RefPtr<Gtk::ListStore> category_list_store_;
  Glib::RefPtr<Gtk::ListStore> bookmark_list_store_;

  Glib::RefPtr<Gtk::UIManager> ui_manager_;
  Glib::RefPtr<Gtk::ActionGroup> action_group_;
  Gtk::Widget* menubar_;
  Gtk::Widget* toolbar_;
  Gtk::Menu* popupmenu_;

  boost::scoped_ptr<http::GetInThread> http_getter_;

  std::vector<bookmark::Item> bookmarks_;

  static boost::scoped_ptr<BookmarkWindow> single_window;
  static const std::string filename;
};

}


#endif
