/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "buffer_builder.hxx"

#include "text_view_layoutable.hxx"
#include "text_line.hxx"
#include "text_element_res_num.hxx"


namespace dialektos {


BufferBuilder::BufferBuilder(text_view::Layoutable& view, int res_num) :
  text_view_(view), res_num_(res_num), current_line_(0) {
}
BufferBuilder::~BufferBuilder() { flush(); }

void BufferBuilder::add_res_num(int res_num, bool bold) {
  assert( current_line_ != 0);
  current_line_->add_element(
      new text_element::ResNum(res_num, bold, text_view_.get_res_num_map()));
}

void BufferBuilder::new_line(int left_margin) {
  flush();
  current_line_ = new TextLine(res_num_, left_margin);
}

void BufferBuilder::flush() {
  if (current_line_) {
    current_line_->trim_right();
    text_view_.add_line(current_line_);
    current_line_ = 0;
  }
}


} // namespace dialektos
