/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "cp932_table.hxx"

namespace dialektos {

namespace convert {

CP932Table::CP932Table() {}


const unsigned short CP932Table::codemap_81[] = {
    0x3000,  // 8140
    0x3001,  // 8141
    0x3002,  // 8142
    0xff0c,  // 8143
    0xff0e,  // 8144
    0x30fb,  // 8145
    0xff1a,  // 8146
    0xff1b,  // 8147
    0xff1f,  // 8148
    0xff01,  // 8149
    0x309b,  // 814a
    0x309c,  // 814b
    0x00b4,  // 814c
    0xff40,  // 814d
    0x00a8,  // 814e
    0xff3e,  // 814f
    0xffe3,  // 8150
    0xff3f,  // 8151
    0x30fd,  // 8152
    0x30fe,  // 8153
    0x309d,  // 8154
    0x309e,  // 8155
    0x3003,  // 8156
    0x4edd,  // 8157
    0x3005,  // 8158
    0x3006,  // 8159
    0x3007,  // 815a
    0x30fc,  // 815b
    0x2015,  // 815c
    0x2010,  // 815d
    0xff0f,  // 815e
    0xff3c,  // 815f
    0xff5e,  // 8160
    0x2225,  // 8161
    0xff5c,  // 8162
    0x2026,  // 8163
    0x2025,  // 8164
    0x2018,  // 8165
    0x2019,  // 8166
    0x201c,  // 8167
    0x201d,  // 8168
    0xff08,  // 8169
    0xff09,  // 816a
    0x3014,  // 816b
    0x3015,  // 816c
    0xff3b,  // 816d
    0xff3d,  // 816e
    0xff5b,  // 816f
    0xff5d,  // 8170
    0x3008,  // 8171
    0x3009,  // 8172
    0x300a,  // 8173
    0x300b,  // 8174
    0x300c,  // 8175
    0x300d,  // 8176
    0x300e,  // 8177
    0x300f,  // 8178
    0x3010,  // 8179
    0x3011,  // 817a
    0xff0b,  // 817b
    0xff0d,  // 817c
    0x00b1,  // 817d
    0x00d7,  // 817e
    0x0000,  // 817f
    0x00f7,  // 8180
    0xff1d,  // 8181
    0x2260,  // 8182
    0xff1c,  // 8183
    0xff1e,  // 8184
    0x2266,  // 8185
    0x2267,  // 8186
    0x221e,  // 8187
    0x2234,  // 8188
    0x2642,  // 8189
    0x2640,  // 818a
    0x00b0,  // 818b
    0x2032,  // 818c
    0x2033,  // 818d
    0x2103,  // 818e
    0xffe5,  // 818f
    0xff04,  // 8190
    0xffe0,  // 8191
    0xffe1,  // 8192
    0xff05,  // 8193
    0xff03,  // 8194
    0xff06,  // 8195
    0xff0a,  // 8196
    0xff20,  // 8197
    0x00a7,  // 8198
    0x2606,  // 8199
    0x2605,  // 819a
    0x25cb,  // 819b
    0x25cf,  // 819c
    0x25ce,  // 819d
    0x25c7,  // 819e
    0x25c6,  // 819f
    0x25a1,  // 81a0
    0x25a0,  // 81a1
    0x25b3,  // 81a2
    0x25b2,  // 81a3
    0x25bd,  // 81a4
    0x25bc,  // 81a5
    0x203b,  // 81a6
    0x3012,  // 81a7
    0x2192,  // 81a8
    0x2190,  // 81a9
    0x2191,  // 81aa
    0x2193,  // 81ab
    0x3013,  // 81ac
    0x0000,  // 81ad
    0x0000,  // 81ae
    0x0000,  // 81af
    0x0000,  // 81b0
    0x0000,  // 81b1
    0x0000,  // 81b2
    0x0000,  // 81b3
    0x0000,  // 81b4
    0x0000,  // 81b5
    0x0000,  // 81b6
    0x0000,  // 81b7
    0x2208,  // 81b8
    0x220b,  // 81b9
    0x2286,  // 81ba
    0x2287,  // 81bb
    0x2282,  // 81bc
    0x2283,  // 81bd
    0x222a,  // 81be
    0x2229,  // 81bf
    0x0000,  // 81c0
    0x0000,  // 81c1
    0x0000,  // 81c2
    0x0000,  // 81c3
    0x0000,  // 81c4
    0x0000,  // 81c5
    0x0000,  // 81c6
    0x0000,  // 81c7
    0x2227,  // 81c8
    0x2228,  // 81c9
    0xffe2,  // 81ca
    0x21d2,  // 81cb
    0x21d4,  // 81cc
    0x2200,  // 81cd
    0x2203,  // 81ce
    0x0000,  // 81cf
    0x0000,  // 81d0
    0x0000,  // 81d1
    0x0000,  // 81d2
    0x0000,  // 81d3
    0x0000,  // 81d4
    0x0000,  // 81d5
    0x0000,  // 81d6
    0x0000,  // 81d7
    0x0000,  // 81d8
    0x0000,  // 81d9
    0x2220,  // 81da
    0x22a5,  // 81db
    0x2312,  // 81dc
    0x2202,  // 81dd
    0x2207,  // 81de
    0x2261,  // 81df
    0x2252,  // 81e0
    0x226a,  // 81e1
    0x226b,  // 81e2
    0x221a,  // 81e3
    0x223d,  // 81e4
    0x221d,  // 81e5
    0x2235,  // 81e6
    0x222b,  // 81e7
    0x222c,  // 81e8
    0x0000,  // 81e9
    0x0000,  // 81ea
    0x0000,  // 81eb
    0x0000,  // 81ec
    0x0000,  // 81ed
    0x0000,  // 81ee
    0x0000,  // 81ef
    0x212b,  // 81f0
    0x2030,  // 81f1
    0x266f,  // 81f2
    0x266d,  // 81f3
    0x266a,  // 81f4
    0x2020,  // 81f5
    0x2021,  // 81f6
    0x00b6,  // 81f7
    0x0000,  // 81f8
    0x0000,  // 81f9
    0x0000,  // 81fa
    0x0000,  // 81fb
    0x25ef,  // 81fc
    0x0000,  // 8240
    0x0000,  // 8241
    0x0000,  // 8242
    0x0000,  // 8243
    0x0000,  // 8244
    0x0000,  // 8245
    0x0000,  // 8246
    0x0000,  // 8247
    0x0000,  // 8248
    0x0000,  // 8249
    0x0000,  // 824a
    0x0000,  // 824b
    0x0000,  // 824c
    0x0000,  // 824d
    0x0000,  // 824e
    0xff10,  // 824f
    0xff11,  // 8250
    0xff12,  // 8251
    0xff13,  // 8252
    0xff14,  // 8253
    0xff15,  // 8254
    0xff16,  // 8255
    0xff17,  // 8256
    0xff18,  // 8257
    0xff19,  // 8258
    0x0000,  // 8259
    0x0000,  // 825a
    0x0000,  // 825b
    0x0000,  // 825c
    0x0000,  // 825d
    0x0000,  // 825e
    0x0000,  // 825f
    0xff21,  // 8260
    0xff22,  // 8261
    0xff23,  // 8262
    0xff24,  // 8263
    0xff25,  // 8264
    0xff26,  // 8265
    0xff27,  // 8266
    0xff28,  // 8267
    0xff29,  // 8268
    0xff2a,  // 8269
    0xff2b,  // 826a
    0xff2c,  // 826b
    0xff2d,  // 826c
    0xff2e,  // 826d
    0xff2f,  // 826e
    0xff30,  // 826f
    0xff31,  // 8270
    0xff32,  // 8271
    0xff33,  // 8272
    0xff34,  // 8273
    0xff35,  // 8274
    0xff36,  // 8275
    0xff37,  // 8276
    0xff38,  // 8277
    0xff39,  // 8278
    0xff3a,  // 8279
    0x0000,  // 827a
    0x0000,  // 827b
    0x0000,  // 827c
    0x0000,  // 827d
    0x0000,  // 827e
    0x0000,  // 827f
    0x0000,  // 8280
    0xff41,  // 8281
    0xff42,  // 8282
    0xff43,  // 8283
    0xff44,  // 8284
    0xff45,  // 8285
    0xff46,  // 8286
    0xff47,  // 8287
    0xff48,  // 8288
    0xff49,  // 8289
    0xff4a,  // 828a
    0xff4b,  // 828b
    0xff4c,  // 828c
    0xff4d,  // 828d
    0xff4e,  // 828e
    0xff4f,  // 828f
    0xff50,  // 8290
    0xff51,  // 8291
    0xff52,  // 8292
    0xff53,  // 8293
    0xff54,  // 8294
    0xff55,  // 8295
    0xff56,  // 8296
    0xff57,  // 8297
    0xff58,  // 8298
    0xff59,  // 8299
    0xff5a,  // 829a
    0x0000,  // 829b
    0x0000,  // 829c
    0x0000,  // 829d
    0x0000,  // 829e
    0x3041,  // 829f
    0x3042,  // 82a0
    0x3043,  // 82a1
    0x3044,  // 82a2
    0x3045,  // 82a3
    0x3046,  // 82a4
    0x3047,  // 82a5
    0x3048,  // 82a6
    0x3049,  // 82a7
    0x304a,  // 82a8
    0x304b,  // 82a9
    0x304c,  // 82aa
    0x304d,  // 82ab
    0x304e,  // 82ac
    0x304f,  // 82ad
    0x3050,  // 82ae
    0x3051,  // 82af
    0x3052,  // 82b0
    0x3053,  // 82b1
    0x3054,  // 82b2
    0x3055,  // 82b3
    0x3056,  // 82b4
    0x3057,  // 82b5
    0x3058,  // 82b6
    0x3059,  // 82b7
    0x305a,  // 82b8
    0x305b,  // 82b9
    0x305c,  // 82ba
    0x305d,  // 82bb
    0x305e,  // 82bc
    0x305f,  // 82bd
    0x3060,  // 82be
    0x3061,  // 82bf
    0x3062,  // 82c0
    0x3063,  // 82c1
    0x3064,  // 82c2
    0x3065,  // 82c3
    0x3066,  // 82c4
    0x3067,  // 82c5
    0x3068,  // 82c6
    0x3069,  // 82c7
    0x306a,  // 82c8
    0x306b,  // 82c9
    0x306c,  // 82ca
    0x306d,  // 82cb
    0x306e,  // 82cc
    0x306f,  // 82cd
    0x3070,  // 82ce
    0x3071,  // 82cf
    0x3072,  // 82d0
    0x3073,  // 82d1
    0x3074,  // 82d2
    0x3075,  // 82d3
    0x3076,  // 82d4
    0x3077,  // 82d5
    0x3078,  // 82d6
    0x3079,  // 82d7
    0x307a,  // 82d8
    0x307b,  // 82d9
    0x307c,  // 82da
    0x307d,  // 82db
    0x307e,  // 82dc
    0x307f,  // 82dd
    0x3080,  // 82de
    0x3081,  // 82df
    0x3082,  // 82e0
    0x3083,  // 82e1
    0x3084,  // 82e2
    0x3085,  // 82e3
    0x3086,  // 82e4
    0x3087,  // 82e5
    0x3088,  // 82e6
    0x3089,  // 82e7
    0x308a,  // 82e8
    0x308b,  // 82e9
    0x308c,  // 82ea
    0x308d,  // 82eb
    0x308e,  // 82ec
    0x308f,  // 82ed
    0x3090,  // 82ee
    0x3091,  // 82ef
    0x3092,  // 82f0
    0x3093,  // 82f1
    0x0000,  // 82f2
    0x0000,  // 82f3
    0x0000,  // 82f4
    0x0000,  // 82f5
    0x0000,  // 82f6
    0x0000,  // 82f7
    0x0000,  // 82f8
    0x0000,  // 82f9
    0x0000,  // 82fa
    0x0000,  // 82fb
    0x0000,  // 82fc
    0x30a1,  // 8340
    0x30a2,  // 8341
    0x30a3,  // 8342
    0x30a4,  // 8343
    0x30a5,  // 8344
    0x30a6,  // 8345
    0x30a7,  // 8346
    0x30a8,  // 8347
    0x30a9,  // 8348
    0x30aa,  // 8349
    0x30ab,  // 834a
    0x30ac,  // 834b
    0x30ad,  // 834c
    0x30ae,  // 834d
    0x30af,  // 834e
    0x30b0,  // 834f
    0x30b1,  // 8350
    0x30b2,  // 8351
    0x30b3,  // 8352
    0x30b4,  // 8353
    0x30b5,  // 8354
    0x30b6,  // 8355
    0x30b7,  // 8356
    0x30b8,  // 8357
    0x30b9,  // 8358
    0x30ba,  // 8359
    0x30bb,  // 835a
    0x30bc,  // 835b
    0x30bd,  // 835c
    0x30be,  // 835d
    0x30bf,  // 835e
    0x30c0,  // 835f
    0x30c1,  // 8360
    0x30c2,  // 8361
    0x30c3,  // 8362
    0x30c4,  // 8363
    0x30c5,  // 8364
    0x30c6,  // 8365
    0x30c7,  // 8366
    0x30c8,  // 8367
    0x30c9,  // 8368
    0x30ca,  // 8369
    0x30cb,  // 836a
    0x30cc,  // 836b
    0x30cd,  // 836c
    0x30ce,  // 836d
    0x30cf,  // 836e
    0x30d0,  // 836f
    0x30d1,  // 8370
    0x30d2,  // 8371
    0x30d3,  // 8372
    0x30d4,  // 8373
    0x30d5,  // 8374
    0x30d6,  // 8375
    0x30d7,  // 8376
    0x30d8,  // 8377
    0x30d9,  // 8378
    0x30da,  // 8379
    0x30db,  // 837a
    0x30dc,  // 837b
    0x30dd,  // 837c
    0x30de,  // 837d
    0x30df,  // 837e
    0x0000,  // 837f
    0x30e0,  // 8380
    0x30e1,  // 8381
    0x30e2,  // 8382
    0x30e3,  // 8383
    0x30e4,  // 8384
    0x30e5,  // 8385
    0x30e6,  // 8386
    0x30e7,  // 8387
    0x30e8,  // 8388
    0x30e9,  // 8389
    0x30ea,  // 838a
    0x30eb,  // 838b
    0x30ec,  // 838c
    0x30ed,  // 838d
    0x30ee,  // 838e
    0x30ef,  // 838f
    0x30f0,  // 8390
    0x30f1,  // 8391
    0x30f2,  // 8392
    0x30f3,  // 8393
    0x30f4,  // 8394
    0x30f5,  // 8395
    0x30f6,  // 8396
    0x0000,  // 8397
    0x0000,  // 8398
    0x0000,  // 8399
    0x0000,  // 839a
    0x0000,  // 839b
    0x0000,  // 839c
    0x0000,  // 839d
    0x0000,  // 839e
    0x0391,  // 839f
    0x0392,  // 83a0
    0x0393,  // 83a1
    0x0394,  // 83a2
    0x0395,  // 83a3
    0x0396,  // 83a4
    0x0397,  // 83a5
    0x0398,  // 83a6
    0x0399,  // 83a7
    0x039a,  // 83a8
    0x039b,  // 83a9
    0x039c,  // 83aa
    0x039d,  // 83ab
    0x039e,  // 83ac
    0x039f,  // 83ad
    0x03a0,  // 83ae
    0x03a1,  // 83af
    0x03a3,  // 83b0
    0x03a4,  // 83b1
    0x03a5,  // 83b2
    0x03a6,  // 83b3
    0x03a7,  // 83b4
    0x03a8,  // 83b5
    0x03a9,  // 83b6
    0x0000,  // 83b7
    0x0000,  // 83b8
    0x0000,  // 83b9
    0x0000,  // 83ba
    0x0000,  // 83bb
    0x0000,  // 83bc
    0x0000,  // 83bd
    0x0000,  // 83be
    0x03b1,  // 83bf
    0x03b2,  // 83c0
    0x03b3,  // 83c1
    0x03b4,  // 83c2
    0x03b5,  // 83c3
    0x03b6,  // 83c4
    0x03b7,  // 83c5
    0x03b8,  // 83c6
    0x03b9,  // 83c7
    0x03ba,  // 83c8
    0x03bb,  // 83c9
    0x03bc,  // 83ca
    0x03bd,  // 83cb
    0x03be,  // 83cc
    0x03bf,  // 83cd
    0x03c0,  // 83ce
    0x03c1,  // 83cf
    0x03c3,  // 83d0
    0x03c4,  // 83d1
    0x03c5,  // 83d2
    0x03c6,  // 83d3
    0x03c7,  // 83d4
    0x03c8,  // 83d5
    0x03c9,  // 83d6
    0x0000,  // 83d7
    0x0000,  // 83d8
    0x0000,  // 83d9
    0x0000,  // 83da
    0x0000,  // 83db
    0x0000,  // 83dc
    0x0000,  // 83dd
    0x0000,  // 83de
    0x0000,  // 83df
    0x0000,  // 83e0
    0x0000,  // 83e1
    0x0000,  // 83e2
    0x0000,  // 83e3
    0x0000,  // 83e4
    0x0000,  // 83e5
    0x0000,  // 83e6
    0x0000,  // 83e7
    0x0000,  // 83e8
    0x0000,  // 83e9
    0x0000,  // 83ea
    0x0000,  // 83eb
    0x0000,  // 83ec
    0x0000,  // 83ed
    0x0000,  // 83ee
    0x0000,  // 83ef
    0x0000,  // 83f0
    0x0000,  // 83f1
    0x0000,  // 83f2
    0x0000,  // 83f3
    0x0000,  // 83f4
    0x0000,  // 83f5
    0x0000,  // 83f6
    0x0000,  // 83f7
    0x0000,  // 83f8
    0x0000,  // 83f9
    0x0000,  // 83fa
    0x0000,  // 83fb
    0x0000,  // 83fc
    0x0410,  // 8440
    0x0411,  // 8441
    0x0412,  // 8442
    0x0413,  // 8443
    0x0414,  // 8444
    0x0415,  // 8445
    0x0401,  // 8446
    0x0416,  // 8447
    0x0417,  // 8448
    0x0418,  // 8449
    0x0419,  // 844a
    0x041a,  // 844b
    0x041b,  // 844c
    0x041c,  // 844d
    0x041d,  // 844e
    0x041e,  // 844f
    0x041f,  // 8450
    0x0420,  // 8451
    0x0421,  // 8452
    0x0422,  // 8453
    0x0423,  // 8454
    0x0424,  // 8455
    0x0425,  // 8456
    0x0426,  // 8457
    0x0427,  // 8458
    0x0428,  // 8459
    0x0429,  // 845a
    0x042a,  // 845b
    0x042b,  // 845c
    0x042c,  // 845d
    0x042d,  // 845e
    0x042e,  // 845f
    0x042f,  // 8460
    0x0000,  // 8461
    0x0000,  // 8462
    0x0000,  // 8463
    0x0000,  // 8464
    0x0000,  // 8465
    0x0000,  // 8466
    0x0000,  // 8467
    0x0000,  // 8468
    0x0000,  // 8469
    0x0000,  // 846a
    0x0000,  // 846b
    0x0000,  // 846c
    0x0000,  // 846d
    0x0000,  // 846e
    0x0000,  // 846f
    0x0430,  // 8470
    0x0431,  // 8471
    0x0432,  // 8472
    0x0433,  // 8473
    0x0434,  // 8474
    0x0435,  // 8475
    0x0451,  // 8476
    0x0436,  // 8477
    0x0437,  // 8478
    0x0438,  // 8479
    0x0439,  // 847a
    0x043a,  // 847b
    0x043b,  // 847c
    0x043c,  // 847d
    0x043d,  // 847e
    0x0000,  // 847f
    0x043e,  // 8480
    0x043f,  // 8481
    0x0440,  // 8482
    0x0441,  // 8483
    0x0442,  // 8484
    0x0443,  // 8485
    0x0444,  // 8486
    0x0445,  // 8487
    0x0446,  // 8488
    0x0447,  // 8489
    0x0448,  // 848a
    0x0449,  // 848b
    0x044a,  // 848c
    0x044b,  // 848d
    0x044c,  // 848e
    0x044d,  // 848f
    0x044e,  // 8490
    0x044f,  // 8491
    0x0000,  // 8492
    0x0000,  // 8493
    0x0000,  // 8494
    0x0000,  // 8495
    0x0000,  // 8496
    0x0000,  // 8497
    0x0000,  // 8498
    0x0000,  // 8499
    0x0000,  // 849a
    0x0000,  // 849b
    0x0000,  // 849c
    0x0000,  // 849d
    0x0000,  // 849e
    0x2500,  // 849f
    0x2502,  // 84a0
    0x250c,  // 84a1
    0x2510,  // 84a2
    0x2518,  // 84a3
    0x2514,  // 84a4
    0x251c,  // 84a5
    0x252c,  // 84a6
    0x2524,  // 84a7
    0x2534,  // 84a8
    0x253c,  // 84a9
    0x2501,  // 84aa
    0x2503,  // 84ab
    0x250f,  // 84ac
    0x2513,  // 84ad
    0x251b,  // 84ae
    0x2517,  // 84af
    0x2523,  // 84b0
    0x2533,  // 84b1
    0x252b,  // 84b2
    0x253b,  // 84b3
    0x254b,  // 84b4
    0x2520,  // 84b5
    0x252f,  // 84b6
    0x2528,  // 84b7
    0x2537,  // 84b8
    0x253f,  // 84b9
    0x251d,  // 84ba
    0x2530,  // 84bb
    0x2525,  // 84bc
    0x2538,  // 84bd
    0x2542,  // 84be
    0x0000,  // 84bf
    0x0000,  // 84c0
    0x0000,  // 84c1
    0x0000,  // 84c2
    0x0000,  // 84c3
    0x0000,  // 84c4
    0x0000,  // 84c5
    0x0000,  // 84c6
    0x0000,  // 84c7
    0x0000,  // 84c8
    0x0000,  // 84c9
    0x0000,  // 84ca
    0x0000,  // 84cb
    0x0000,  // 84cc
    0x0000,  // 84cd
    0x0000,  // 84ce
    0x0000,  // 84cf
    0x0000,  // 84d0
    0x0000,  // 84d1
    0x0000,  // 84d2
    0x0000,  // 84d3
    0x0000,  // 84d4
    0x0000,  // 84d5
    0x0000,  // 84d6
    0x0000,  // 84d7
    0x0000,  // 84d8
    0x0000,  // 84d9
    0x0000,  // 84da
    0x0000,  // 84db
    0x0000,  // 84dc
    0x0000,  // 84dd
    0x0000,  // 84de
    0x0000,  // 84df
    0x0000,  // 84e0
    0x0000,  // 84e1
    0x0000,  // 84e2
    0x0000,  // 84e3
    0x0000,  // 84e4
    0x0000,  // 84e5
    0x0000,  // 84e6
    0x0000,  // 84e7
    0x0000,  // 84e8
    0x0000,  // 84e9
    0x0000,  // 84ea
    0x0000,  // 84eb
    0x0000,  // 84ec
    0x0000,  // 84ed
    0x0000,  // 84ee
    0x0000,  // 84ef
    0x0000,  // 84f0
    0x0000,  // 84f1
    0x0000,  // 84f2
    0x0000,  // 84f3
    0x0000,  // 84f4
    0x0000,  // 84f5
    0x0000,  // 84f6
    0x0000,  // 84f7
    0x0000,  // 84f8
    0x0000,  // 84f9
    0x0000,  // 84fa
    0x0000,  // 84fb
    0x0000,  // 84fc
    0x0000,  // 8540
    0x0000,  // 8541
    0x0000,  // 8542
    0x0000,  // 8543
    0x0000,  // 8544
    0x0000,  // 8545
    0x0000,  // 8546
    0x0000,  // 8547
    0x0000,  // 8548
    0x0000,  // 8549
    0x0000,  // 854a
    0x0000,  // 854b
    0x0000,  // 854c
    0x0000,  // 854d
    0x0000,  // 854e
    0x0000,  // 854f
    0x0000,  // 8550
    0x0000,  // 8551
    0x0000,  // 8552
    0x0000,  // 8553
    0x0000,  // 8554
    0x0000,  // 8555
    0x0000,  // 8556
    0x0000,  // 8557
    0x0000,  // 8558
    0x0000,  // 8559
    0x0000,  // 855a
    0x0000,  // 855b
    0x0000,  // 855c
    0x0000,  // 855d
    0x0000,  // 855e
    0x0000,  // 855f
    0x0000,  // 8560
    0x0000,  // 8561
    0x0000,  // 8562
    0x0000,  // 8563
    0x0000,  // 8564
    0x0000,  // 8565
    0x0000,  // 8566
    0x0000,  // 8567
    0x0000,  // 8568
    0x0000,  // 8569
    0x0000,  // 856a
    0x0000,  // 856b
    0x0000,  // 856c
    0x0000,  // 856d
    0x0000,  // 856e
    0x0000,  // 856f
    0x0000,  // 8570
    0x0000,  // 8571
    0x0000,  // 8572
    0x0000,  // 8573
    0x0000,  // 8574
    0x0000,  // 8575
    0x0000,  // 8576
    0x0000,  // 8577
    0x0000,  // 8578
    0x0000,  // 8579
    0x0000,  // 857a
    0x0000,  // 857b
    0x0000,  // 857c
    0x0000,  // 857d
    0x0000,  // 857e
    0x0000,  // 857f
    0x0000,  // 8580
    0x0000,  // 8581
    0x0000,  // 8582
    0x0000,  // 8583
    0x0000,  // 8584
    0x0000,  // 8585
    0x0000,  // 8586
    0x0000,  // 8587
    0x0000,  // 8588
    0x0000,  // 8589
    0x0000,  // 858a
    0x0000,  // 858b
    0x0000,  // 858c
    0x0000,  // 858d
    0x0000,  // 858e
    0x0000,  // 858f
    0x0000,  // 8590
    0x0000,  // 8591
    0x0000,  // 8592
    0x0000,  // 8593
    0x0000,  // 8594
    0x0000,  // 8595
    0x0000,  // 8596
    0x0000,  // 8597
    0x0000,  // 8598
    0x0000,  // 8599
    0x0000,  // 859a
    0x0000,  // 859b
    0x0000,  // 859c
    0x0000,  // 859d
    0x0000,  // 859e
    0x0000,  // 859f
    0x0000,  // 85a0
    0x0000,  // 85a1
    0x0000,  // 85a2
    0x0000,  // 85a3
    0x0000,  // 85a4
    0x0000,  // 85a5
    0x0000,  // 85a6
    0x0000,  // 85a7
    0x0000,  // 85a8
    0x0000,  // 85a9
    0x0000,  // 85aa
    0x0000,  // 85ab
    0x0000,  // 85ac
    0x0000,  // 85ad
    0x0000,  // 85ae
    0x0000,  // 85af
    0x0000,  // 85b0
    0x0000,  // 85b1
    0x0000,  // 85b2
    0x0000,  // 85b3
    0x0000,  // 85b4
    0x0000,  // 85b5
    0x0000,  // 85b6
    0x0000,  // 85b7
    0x0000,  // 85b8
    0x0000,  // 85b9
    0x0000,  // 85ba
    0x0000,  // 85bb
    0x0000,  // 85bc
    0x0000,  // 85bd
    0x0000,  // 85be
    0x0000,  // 85bf
    0x0000,  // 85c0
    0x0000,  // 85c1
    0x0000,  // 85c2
    0x0000,  // 85c3
    0x0000,  // 85c4
    0x0000,  // 85c5
    0x0000,  // 85c6
    0x0000,  // 85c7
    0x0000,  // 85c8
    0x0000,  // 85c9
    0x0000,  // 85ca
    0x0000,  // 85cb
    0x0000,  // 85cc
    0x0000,  // 85cd
    0x0000,  // 85ce
    0x0000,  // 85cf
    0x0000,  // 85d0
    0x0000,  // 85d1
    0x0000,  // 85d2
    0x0000,  // 85d3
    0x0000,  // 85d4
    0x0000,  // 85d5
    0x0000,  // 85d6
    0x0000,  // 85d7
    0x0000,  // 85d8
    0x0000,  // 85d9
    0x0000,  // 85da
    0x0000,  // 85db
    0x0000,  // 85dc
    0x0000,  // 85dd
    0x0000,  // 85de
    0x0000,  // 85df
    0x0000,  // 85e0
    0x0000,  // 85e1
    0x0000,  // 85e2
    0x0000,  // 85e3
    0x0000,  // 85e4
    0x0000,  // 85e5
    0x0000,  // 85e6
    0x0000,  // 85e7
    0x0000,  // 85e8
    0x0000,  // 85e9
    0x0000,  // 85ea
    0x0000,  // 85eb
    0x0000,  // 85ec
    0x0000,  // 85ed
    0x0000,  // 85ee
    0x0000,  // 85ef
    0x0000,  // 85f0
    0x0000,  // 85f1
    0x0000,  // 85f2
    0x0000,  // 85f3
    0x0000,  // 85f4
    0x0000,  // 85f5
    0x0000,  // 85f6
    0x0000,  // 85f7
    0x0000,  // 85f8
    0x0000,  // 85f9
    0x0000,  // 85fa
    0x0000,  // 85fb
    0x0000,  // 85fc
    0x0000,  // 8640
    0x0000,  // 8641
    0x0000,  // 8642
    0x0000,  // 8643
    0x0000,  // 8644
    0x0000,  // 8645
    0x0000,  // 8646
    0x0000,  // 8647
    0x0000,  // 8648
    0x0000,  // 8649
    0x0000,  // 864a
    0x0000,  // 864b
    0x0000,  // 864c
    0x0000,  // 864d
    0x0000,  // 864e
    0x0000,  // 864f
    0x0000,  // 8650
    0x0000,  // 8651
    0x0000,  // 8652
    0x0000,  // 8653
    0x0000,  // 8654
    0x0000,  // 8655
    0x0000,  // 8656
    0x0000,  // 8657
    0x0000,  // 8658
    0x0000,  // 8659
    0x0000,  // 865a
    0x0000,  // 865b
    0x0000,  // 865c
    0x0000,  // 865d
    0x0000,  // 865e
    0x0000,  // 865f
    0x0000,  // 8660
    0x0000,  // 8661
    0x0000,  // 8662
    0x0000,  // 8663
    0x0000,  // 8664
    0x0000,  // 8665
    0x0000,  // 8666
    0x0000,  // 8667
    0x0000,  // 8668
    0x0000,  // 8669
    0x0000,  // 866a
    0x0000,  // 866b
    0x0000,  // 866c
    0x0000,  // 866d
    0x0000,  // 866e
    0x0000,  // 866f
    0x0000,  // 8670
    0x0000,  // 8671
    0x0000,  // 8672
    0x0000,  // 8673
    0x0000,  // 8674
    0x0000,  // 8675
    0x0000,  // 8676
    0x0000,  // 8677
    0x0000,  // 8678
    0x0000,  // 8679
    0x0000,  // 867a
    0x0000,  // 867b
    0x0000,  // 867c
    0x0000,  // 867d
    0x0000,  // 867e
    0x0000,  // 867f
    0x0000,  // 8680
    0x0000,  // 8681
    0x0000,  // 8682
    0x0000,  // 8683
    0x0000,  // 8684
    0x0000,  // 8685
    0x0000,  // 8686
    0x0000,  // 8687
    0x0000,  // 8688
    0x0000,  // 8689
    0x0000,  // 868a
    0x0000,  // 868b
    0x0000,  // 868c
    0x0000,  // 868d
    0x0000,  // 868e
    0x0000,  // 868f
    0x0000,  // 8690
    0x0000,  // 8691
    0x0000,  // 8692
    0x0000,  // 8693
    0x0000,  // 8694
    0x0000,  // 8695
    0x0000,  // 8696
    0x0000,  // 8697
    0x0000,  // 8698
    0x0000,  // 8699
    0x0000,  // 869a
    0x0000,  // 869b
    0x0000,  // 869c
    0x0000,  // 869d
    0x0000,  // 869e
    0x0000,  // 869f
    0x0000,  // 86a0
    0x0000,  // 86a1
    0x0000,  // 86a2
    0x0000,  // 86a3
    0x0000,  // 86a4
    0x0000,  // 86a5
    0x0000,  // 86a6
    0x0000,  // 86a7
    0x0000,  // 86a8
    0x0000,  // 86a9
    0x0000,  // 86aa
    0x0000,  // 86ab
    0x0000,  // 86ac
    0x0000,  // 86ad
    0x0000,  // 86ae
    0x0000,  // 86af
    0x0000,  // 86b0
    0x0000,  // 86b1
    0x0000,  // 86b2
    0x0000,  // 86b3
    0x0000,  // 86b4
    0x0000,  // 86b5
    0x0000,  // 86b6
    0x0000,  // 86b7
    0x0000,  // 86b8
    0x0000,  // 86b9
    0x0000,  // 86ba
    0x0000,  // 86bb
    0x0000,  // 86bc
    0x0000,  // 86bd
    0x0000,  // 86be
    0x0000,  // 86bf
    0x0000,  // 86c0
    0x0000,  // 86c1
    0x0000,  // 86c2
    0x0000,  // 86c3
    0x0000,  // 86c4
    0x0000,  // 86c5
    0x0000,  // 86c6
    0x0000,  // 86c7
    0x0000,  // 86c8
    0x0000,  // 86c9
    0x0000,  // 86ca
    0x0000,  // 86cb
    0x0000,  // 86cc
    0x0000,  // 86cd
    0x0000,  // 86ce
    0x0000,  // 86cf
    0x0000,  // 86d0
    0x0000,  // 86d1
    0x0000,  // 86d2
    0x0000,  // 86d3
    0x0000,  // 86d4
    0x0000,  // 86d5
    0x0000,  // 86d6
    0x0000,  // 86d7
    0x0000,  // 86d8
    0x0000,  // 86d9
    0x0000,  // 86da
    0x0000,  // 86db
    0x0000,  // 86dc
    0x0000,  // 86dd
    0x0000,  // 86de
    0x0000,  // 86df
    0x0000,  // 86e0
    0x0000,  // 86e1
    0x0000,  // 86e2
    0x0000,  // 86e3
    0x0000,  // 86e4
    0x0000,  // 86e5
    0x0000,  // 86e6
    0x0000,  // 86e7
    0x0000,  // 86e8
    0x0000,  // 86e9
    0x0000,  // 86ea
    0x0000,  // 86eb
    0x0000,  // 86ec
    0x0000,  // 86ed
    0x0000,  // 86ee
    0x0000,  // 86ef
    0x0000,  // 86f0
    0x0000,  // 86f1
    0x0000,  // 86f2
    0x0000,  // 86f3
    0x0000,  // 86f4
    0x0000,  // 86f5
    0x0000,  // 86f6
    0x0000,  // 86f7
    0x0000,  // 86f8
    0x0000,  // 86f9
    0x0000,  // 86fa
    0x0000,  // 86fb
    0x0000,  // 86fc
    0x2460,  // 8740
    0x2461,  // 8741
    0x2462,  // 8742
    0x2463,  // 8743
    0x2464,  // 8744
    0x2465,  // 8745
    0x2466,  // 8746
    0x2467,  // 8747
    0x2468,  // 8748
    0x2469,  // 8749
    0x246a,  // 874a
    0x246b,  // 874b
    0x246c,  // 874c
    0x246d,  // 874d
    0x246e,  // 874e
    0x246f,  // 874f
    0x2470,  // 8750
    0x2471,  // 8751
    0x2472,  // 8752
    0x2473,  // 8753
    0x2160,  // 8754
    0x2161,  // 8755
    0x2162,  // 8756
    0x2163,  // 8757
    0x2164,  // 8758
    0x2165,  // 8759
    0x2166,  // 875a
    0x2167,  // 875b
    0x2168,  // 875c
    0x2169,  // 875d
    0x0000,  // 875e
    0x3349,  // 875f
    0x3314,  // 8760
    0x3322,  // 8761
    0x334d,  // 8762
    0x3318,  // 8763
    0x3327,  // 8764
    0x3303,  // 8765
    0x3336,  // 8766
    0x3351,  // 8767
    0x3357,  // 8768
    0x330d,  // 8769
    0x3326,  // 876a
    0x3323,  // 876b
    0x332b,  // 876c
    0x334a,  // 876d
    0x333b,  // 876e
    0x339c,  // 876f
    0x339d,  // 8770
    0x339e,  // 8771
    0x338e,  // 8772
    0x338f,  // 8773
    0x33c4,  // 8774
    0x33a1,  // 8775
    0x0000,  // 8776
    0x0000,  // 8777
    0x0000,  // 8778
    0x0000,  // 8779
    0x0000,  // 877a
    0x0000,  // 877b
    0x0000,  // 877c
    0x0000,  // 877d
    0x337b,  // 877e
    0x0000,  // 877f
    0x301d,  // 8780
    0x301f,  // 8781
    0x2116,  // 8782
    0x33cd,  // 8783
    0x2121,  // 8784
    0x32a4,  // 8785
    0x32a5,  // 8786
    0x32a6,  // 8787
    0x32a7,  // 8788
    0x32a8,  // 8789
    0x3231,  // 878a
    0x3232,  // 878b
    0x3239,  // 878c
    0x337e,  // 878d
    0x337d,  // 878e
    0x337c,  // 878f
    0x2252,  // 8790
    0x2261,  // 8791
    0x222b,  // 8792
    0x222e,  // 8793
    0x2211,  // 8794
    0x221a,  // 8795
    0x22a5,  // 8796
    0x2220,  // 8797
    0x221f,  // 8798
    0x22bf,  // 8799
    0x2235,  // 879a
    0x2229,  // 879b
    0x222a,  // 879c
    0x0000,  // 879d
    0x0000,  // 879e
    0x0000,  // 879f
    0x0000,  // 87a0
    0x0000,  // 87a1
    0x0000,  // 87a2
    0x0000,  // 87a3
    0x0000,  // 87a4
    0x0000,  // 87a5
    0x0000,  // 87a6
    0x0000,  // 87a7
    0x0000,  // 87a8
    0x0000,  // 87a9
    0x0000,  // 87aa
    0x0000,  // 87ab
    0x0000,  // 87ac
    0x0000,  // 87ad
    0x0000,  // 87ae
    0x0000,  // 87af
    0x0000,  // 87b0
    0x0000,  // 87b1
    0x0000,  // 87b2
    0x0000,  // 87b3
    0x0000,  // 87b4
    0x0000,  // 87b5
    0x0000,  // 87b6
    0x0000,  // 87b7
    0x0000,  // 87b8
    0x0000,  // 87b9
    0x0000,  // 87ba
    0x0000,  // 87bb
    0x0000,  // 87bc
    0x0000,  // 87bd
    0x0000,  // 87be
    0x0000,  // 87bf
    0x0000,  // 87c0
    0x0000,  // 87c1
    0x0000,  // 87c2
    0x0000,  // 87c3
    0x0000,  // 87c4
    0x0000,  // 87c5
    0x0000,  // 87c6
    0x0000,  // 87c7
    0x0000,  // 87c8
    0x0000,  // 87c9
    0x0000,  // 87ca
    0x0000,  // 87cb
    0x0000,  // 87cc
    0x0000,  // 87cd
    0x0000,  // 87ce
    0x0000,  // 87cf
    0x0000,  // 87d0
    0x0000,  // 87d1
    0x0000,  // 87d2
    0x0000,  // 87d3
    0x0000,  // 87d4
    0x0000,  // 87d5
    0x0000,  // 87d6
    0x0000,  // 87d7
    0x0000,  // 87d8
    0x0000,  // 87d9
    0x0000,  // 87da
    0x0000,  // 87db
    0x0000,  // 87dc
    0x0000,  // 87dd
    0x0000,  // 87de
    0x0000,  // 87df
    0x0000,  // 87e0
    0x0000,  // 87e1
    0x0000,  // 87e2
    0x0000,  // 87e3
    0x0000,  // 87e4
    0x0000,  // 87e5
    0x0000,  // 87e6
    0x0000,  // 87e7
    0x0000,  // 87e8
    0x0000,  // 87e9
    0x0000,  // 87ea
    0x0000,  // 87eb
    0x0000,  // 87ec
    0x0000,  // 87ed
    0x0000,  // 87ee
    0x0000,  // 87ef
    0x0000,  // 87f0
    0x0000,  // 87f1
    0x0000,  // 87f2
    0x0000,  // 87f3
    0x0000,  // 87f4
    0x0000,  // 87f5
    0x0000,  // 87f6
    0x0000,  // 87f7
    0x0000,  // 87f8
    0x0000,  // 87f9
    0x0000,  // 87fa
    0x0000,  // 87fb
    0x0000,  // 87fc
    0x0000,  // 8840
    0x0000,  // 8841
    0x0000,  // 8842
    0x0000,  // 8843
    0x0000,  // 8844
    0x0000,  // 8845
    0x0000,  // 8846
    0x0000,  // 8847
    0x0000,  // 8848
    0x0000,  // 8849
    0x0000,  // 884a
    0x0000,  // 884b
    0x0000,  // 884c
    0x0000,  // 884d
    0x0000,  // 884e
    0x0000,  // 884f
    0x0000,  // 8850
    0x0000,  // 8851
    0x0000,  // 8852
    0x0000,  // 8853
    0x0000,  // 8854
    0x0000,  // 8855
    0x0000,  // 8856
    0x0000,  // 8857
    0x0000,  // 8858
    0x0000,  // 8859
    0x0000,  // 885a
    0x0000,  // 885b
    0x0000,  // 885c
    0x0000,  // 885d
    0x0000,  // 885e
    0x0000,  // 885f
    0x0000,  // 8860
    0x0000,  // 8861
    0x0000,  // 8862
    0x0000,  // 8863
    0x0000,  // 8864
    0x0000,  // 8865
    0x0000,  // 8866
    0x0000,  // 8867
    0x0000,  // 8868
    0x0000,  // 8869
    0x0000,  // 886a
    0x0000,  // 886b
    0x0000,  // 886c
    0x0000,  // 886d
    0x0000,  // 886e
    0x0000,  // 886f
    0x0000,  // 8870
    0x0000,  // 8871
    0x0000,  // 8872
    0x0000,  // 8873
    0x0000,  // 8874
    0x0000,  // 8875
    0x0000,  // 8876
    0x0000,  // 8877
    0x0000,  // 8878
    0x0000,  // 8879
    0x0000,  // 887a
    0x0000,  // 887b
    0x0000,  // 887c
    0x0000,  // 887d
    0x0000,  // 887e
    0x0000,  // 887f
    0x0000,  // 8880
    0x0000,  // 8881
    0x0000,  // 8882
    0x0000,  // 8883
    0x0000,  // 8884
    0x0000,  // 8885
    0x0000,  // 8886
    0x0000,  // 8887
    0x0000,  // 8888
    0x0000,  // 8889
    0x0000,  // 888a
    0x0000,  // 888b
    0x0000,  // 888c
    0x0000,  // 888d
    0x0000,  // 888e
    0x0000,  // 888f
    0x0000,  // 8890
    0x0000,  // 8891
    0x0000,  // 8892
    0x0000,  // 8893
    0x0000,  // 8894
    0x0000,  // 8895
    0x0000,  // 8896
    0x0000,  // 8897
    0x0000,  // 8898
    0x0000,  // 8899
    0x0000,  // 889a
    0x0000,  // 889b
    0x0000,  // 889c
    0x0000,  // 889d
    0x0000,  // 889e
    0x4e9c,  // 889f
    0x5516,  // 88a0
    0x5a03,  // 88a1
    0x963f,  // 88a2
    0x54c0,  // 88a3
    0x611b,  // 88a4
    0x6328,  // 88a5
    0x59f6,  // 88a6
    0x9022,  // 88a7
    0x8475,  // 88a8
    0x831c,  // 88a9
    0x7a50,  // 88aa
    0x60aa,  // 88ab
    0x63e1,  // 88ac
    0x6e25,  // 88ad
    0x65ed,  // 88ae
    0x8466,  // 88af
    0x82a6,  // 88b0
    0x9bf5,  // 88b1
    0x6893,  // 88b2
    0x5727,  // 88b3
    0x65a1,  // 88b4
    0x6271,  // 88b5
    0x5b9b,  // 88b6
    0x59d0,  // 88b7
    0x867b,  // 88b8
    0x98f4,  // 88b9
    0x7d62,  // 88ba
    0x7dbe,  // 88bb
    0x9b8e,  // 88bc
    0x6216,  // 88bd
    0x7c9f,  // 88be
    0x88b7,  // 88bf
    0x5b89,  // 88c0
    0x5eb5,  // 88c1
    0x6309,  // 88c2
    0x6697,  // 88c3
    0x6848,  // 88c4
    0x95c7,  // 88c5
    0x978d,  // 88c6
    0x674f,  // 88c7
    0x4ee5,  // 88c8
    0x4f0a,  // 88c9
    0x4f4d,  // 88ca
    0x4f9d,  // 88cb
    0x5049,  // 88cc
    0x56f2,  // 88cd
    0x5937,  // 88ce
    0x59d4,  // 88cf
    0x5a01,  // 88d0
    0x5c09,  // 88d1
    0x60df,  // 88d2
    0x610f,  // 88d3
    0x6170,  // 88d4
    0x6613,  // 88d5
    0x6905,  // 88d6
    0x70ba,  // 88d7
    0x754f,  // 88d8
    0x7570,  // 88d9
    0x79fb,  // 88da
    0x7dad,  // 88db
    0x7def,  // 88dc
    0x80c3,  // 88dd
    0x840e,  // 88de
    0x8863,  // 88df
    0x8b02,  // 88e0
    0x9055,  // 88e1
    0x907a,  // 88e2
    0x533b,  // 88e3
    0x4e95,  // 88e4
    0x4ea5,  // 88e5
    0x57df,  // 88e6
    0x80b2,  // 88e7
    0x90c1,  // 88e8
    0x78ef,  // 88e9
    0x4e00,  // 88ea
    0x58f1,  // 88eb
    0x6ea2,  // 88ec
    0x9038,  // 88ed
    0x7a32,  // 88ee
    0x8328,  // 88ef
    0x828b,  // 88f0
    0x9c2f,  // 88f1
    0x5141,  // 88f2
    0x5370,  // 88f3
    0x54bd,  // 88f4
    0x54e1,  // 88f5
    0x56e0,  // 88f6
    0x59fb,  // 88f7
    0x5f15,  // 88f8
    0x98f2,  // 88f9
    0x6deb,  // 88fa
    0x80e4,  // 88fb
    0x852d,  // 88fc
    0x9662,  // 8940
    0x9670,  // 8941
    0x96a0,  // 8942
    0x97fb,  // 8943
    0x540b,  // 8944
    0x53f3,  // 8945
    0x5b87,  // 8946
    0x70cf,  // 8947
    0x7fbd,  // 8948
    0x8fc2,  // 8949
    0x96e8,  // 894a
    0x536f,  // 894b
    0x9d5c,  // 894c
    0x7aba,  // 894d
    0x4e11,  // 894e
    0x7893,  // 894f
    0x81fc,  // 8950
    0x6e26,  // 8951
    0x5618,  // 8952
    0x5504,  // 8953
    0x6b1d,  // 8954
    0x851a,  // 8955
    0x9c3b,  // 8956
    0x59e5,  // 8957
    0x53a9,  // 8958
    0x6d66,  // 8959
    0x74dc,  // 895a
    0x958f,  // 895b
    0x5642,  // 895c
    0x4e91,  // 895d
    0x904b,  // 895e
    0x96f2,  // 895f
    0x834f,  // 8960
    0x990c,  // 8961
    0x53e1,  // 8962
    0x55b6,  // 8963
    0x5b30,  // 8964
    0x5f71,  // 8965
    0x6620,  // 8966
    0x66f3,  // 8967
    0x6804,  // 8968
    0x6c38,  // 8969
    0x6cf3,  // 896a
    0x6d29,  // 896b
    0x745b,  // 896c
    0x76c8,  // 896d
    0x7a4e,  // 896e
    0x9834,  // 896f
    0x82f1,  // 8970
    0x885b,  // 8971
    0x8a60,  // 8972
    0x92ed,  // 8973
    0x6db2,  // 8974
    0x75ab,  // 8975
    0x76ca,  // 8976
    0x99c5,  // 8977
    0x60a6,  // 8978
    0x8b01,  // 8979
    0x8d8a,  // 897a
    0x95b2,  // 897b
    0x698e,  // 897c
    0x53ad,  // 897d
    0x5186,  // 897e
    0x0000,  // 897f
    0x5712,  // 8980
    0x5830,  // 8981
    0x5944,  // 8982
    0x5bb4,  // 8983
    0x5ef6,  // 8984
    0x6028,  // 8985
    0x63a9,  // 8986
    0x63f4,  // 8987
    0x6cbf,  // 8988
    0x6f14,  // 8989
    0x708e,  // 898a
    0x7114,  // 898b
    0x7159,  // 898c
    0x71d5,  // 898d
    0x733f,  // 898e
    0x7e01,  // 898f
    0x8276,  // 8990
    0x82d1,  // 8991
    0x8597,  // 8992
    0x9060,  // 8993
    0x925b,  // 8994
    0x9d1b,  // 8995
    0x5869,  // 8996
    0x65bc,  // 8997
    0x6c5a,  // 8998
    0x7525,  // 8999
    0x51f9,  // 899a
    0x592e,  // 899b
    0x5965,  // 899c
    0x5f80,  // 899d
    0x5fdc,  // 899e
    0x62bc,  // 899f
    0x65fa,  // 89a0
    0x6a2a,  // 89a1
    0x6b27,  // 89a2
    0x6bb4,  // 89a3
    0x738b,  // 89a4
    0x7fc1,  // 89a5
    0x8956,  // 89a6
    0x9d2c,  // 89a7
    0x9d0e,  // 89a8
    0x9ec4,  // 89a9
    0x5ca1,  // 89aa
    0x6c96,  // 89ab
    0x837b,  // 89ac
    0x5104,  // 89ad
    0x5c4b,  // 89ae
    0x61b6,  // 89af
    0x81c6,  // 89b0
    0x6876,  // 89b1
    0x7261,  // 89b2
    0x4e59,  // 89b3
    0x4ffa,  // 89b4
    0x5378,  // 89b5
    0x6069,  // 89b6
    0x6e29,  // 89b7
    0x7a4f,  // 89b8
    0x97f3,  // 89b9
    0x4e0b,  // 89ba
    0x5316,  // 89bb
    0x4eee,  // 89bc
    0x4f55,  // 89bd
    0x4f3d,  // 89be
    0x4fa1,  // 89bf
    0x4f73,  // 89c0
    0x52a0,  // 89c1
    0x53ef,  // 89c2
    0x5609,  // 89c3
    0x590f,  // 89c4
    0x5ac1,  // 89c5
    0x5bb6,  // 89c6
    0x5be1,  // 89c7
    0x79d1,  // 89c8
    0x6687,  // 89c9
    0x679c,  // 89ca
    0x67b6,  // 89cb
    0x6b4c,  // 89cc
    0x6cb3,  // 89cd
    0x706b,  // 89ce
    0x73c2,  // 89cf
    0x798d,  // 89d0
    0x79be,  // 89d1
    0x7a3c,  // 89d2
    0x7b87,  // 89d3
    0x82b1,  // 89d4
    0x82db,  // 89d5
    0x8304,  // 89d6
    0x8377,  // 89d7
    0x83ef,  // 89d8
    0x83d3,  // 89d9
    0x8766,  // 89da
    0x8ab2,  // 89db
    0x5629,  // 89dc
    0x8ca8,  // 89dd
    0x8fe6,  // 89de
    0x904e,  // 89df
    0x971e,  // 89e0
    0x868a,  // 89e1
    0x4fc4,  // 89e2
    0x5ce8,  // 89e3
    0x6211,  // 89e4
    0x7259,  // 89e5
    0x753b,  // 89e6
    0x81e5,  // 89e7
    0x82bd,  // 89e8
    0x86fe,  // 89e9
    0x8cc0,  // 89ea
    0x96c5,  // 89eb
    0x9913,  // 89ec
    0x99d5,  // 89ed
    0x4ecb,  // 89ee
    0x4f1a,  // 89ef
    0x89e3,  // 89f0
    0x56de,  // 89f1
    0x584a,  // 89f2
    0x58ca,  // 89f3
    0x5efb,  // 89f4
    0x5feb,  // 89f5
    0x602a,  // 89f6
    0x6094,  // 89f7
    0x6062,  // 89f8
    0x61d0,  // 89f9
    0x6212,  // 89fa
    0x62d0,  // 89fb
    0x6539,  // 89fc
    0x9b41,  // 8a40
    0x6666,  // 8a41
    0x68b0,  // 8a42
    0x6d77,  // 8a43
    0x7070,  // 8a44
    0x754c,  // 8a45
    0x7686,  // 8a46
    0x7d75,  // 8a47
    0x82a5,  // 8a48
    0x87f9,  // 8a49
    0x958b,  // 8a4a
    0x968e,  // 8a4b
    0x8c9d,  // 8a4c
    0x51f1,  // 8a4d
    0x52be,  // 8a4e
    0x5916,  // 8a4f
    0x54b3,  // 8a50
    0x5bb3,  // 8a51
    0x5d16,  // 8a52
    0x6168,  // 8a53
    0x6982,  // 8a54
    0x6daf,  // 8a55
    0x788d,  // 8a56
    0x84cb,  // 8a57
    0x8857,  // 8a58
    0x8a72,  // 8a59
    0x93a7,  // 8a5a
    0x9ab8,  // 8a5b
    0x6d6c,  // 8a5c
    0x99a8,  // 8a5d
    0x86d9,  // 8a5e
    0x57a3,  // 8a5f
    0x67ff,  // 8a60
    0x86ce,  // 8a61
    0x920e,  // 8a62
    0x5283,  // 8a63
    0x5687,  // 8a64
    0x5404,  // 8a65
    0x5ed3,  // 8a66
    0x62e1,  // 8a67
    0x64b9,  // 8a68
    0x683c,  // 8a69
    0x6838,  // 8a6a
    0x6bbb,  // 8a6b
    0x7372,  // 8a6c
    0x78ba,  // 8a6d
    0x7a6b,  // 8a6e
    0x899a,  // 8a6f
    0x89d2,  // 8a70
    0x8d6b,  // 8a71
    0x8f03,  // 8a72
    0x90ed,  // 8a73
    0x95a3,  // 8a74
    0x9694,  // 8a75
    0x9769,  // 8a76
    0x5b66,  // 8a77
    0x5cb3,  // 8a78
    0x697d,  // 8a79
    0x984d,  // 8a7a
    0x984e,  // 8a7b
    0x639b,  // 8a7c
    0x7b20,  // 8a7d
    0x6a2b,  // 8a7e
    0x0000,  // 8a7f
    0x6a7f,  // 8a80
    0x68b6,  // 8a81
    0x9c0d,  // 8a82
    0x6f5f,  // 8a83
    0x5272,  // 8a84
    0x559d,  // 8a85
    0x6070,  // 8a86
    0x62ec,  // 8a87
    0x6d3b,  // 8a88
    0x6e07,  // 8a89
    0x6ed1,  // 8a8a
    0x845b,  // 8a8b
    0x8910,  // 8a8c
    0x8f44,  // 8a8d
    0x4e14,  // 8a8e
    0x9c39,  // 8a8f
    0x53f6,  // 8a90
    0x691b,  // 8a91
    0x6a3a,  // 8a92
    0x9784,  // 8a93
    0x682a,  // 8a94
    0x515c,  // 8a95
    0x7ac3,  // 8a96
    0x84b2,  // 8a97
    0x91dc,  // 8a98
    0x938c,  // 8a99
    0x565b,  // 8a9a
    0x9d28,  // 8a9b
    0x6822,  // 8a9c
    0x8305,  // 8a9d
    0x8431,  // 8a9e
    0x7ca5,  // 8a9f
    0x5208,  // 8aa0
    0x82c5,  // 8aa1
    0x74e6,  // 8aa2
    0x4e7e,  // 8aa3
    0x4f83,  // 8aa4
    0x51a0,  // 8aa5
    0x5bd2,  // 8aa6
    0x520a,  // 8aa7
    0x52d8,  // 8aa8
    0x52e7,  // 8aa9
    0x5dfb,  // 8aaa
    0x559a,  // 8aab
    0x582a,  // 8aac
    0x59e6,  // 8aad
    0x5b8c,  // 8aae
    0x5b98,  // 8aaf
    0x5bdb,  // 8ab0
    0x5e72,  // 8ab1
    0x5e79,  // 8ab2
    0x60a3,  // 8ab3
    0x611f,  // 8ab4
    0x6163,  // 8ab5
    0x61be,  // 8ab6
    0x63db,  // 8ab7
    0x6562,  // 8ab8
    0x67d1,  // 8ab9
    0x6853,  // 8aba
    0x68fa,  // 8abb
    0x6b3e,  // 8abc
    0x6b53,  // 8abd
    0x6c57,  // 8abe
    0x6f22,  // 8abf
    0x6f97,  // 8ac0
    0x6f45,  // 8ac1
    0x74b0,  // 8ac2
    0x7518,  // 8ac3
    0x76e3,  // 8ac4
    0x770b,  // 8ac5
    0x7aff,  // 8ac6
    0x7ba1,  // 8ac7
    0x7c21,  // 8ac8
    0x7de9,  // 8ac9
    0x7f36,  // 8aca
    0x7ff0,  // 8acb
    0x809d,  // 8acc
    0x8266,  // 8acd
    0x839e,  // 8ace
    0x89b3,  // 8acf
    0x8acc,  // 8ad0
    0x8cab,  // 8ad1
    0x9084,  // 8ad2
    0x9451,  // 8ad3
    0x9593,  // 8ad4
    0x9591,  // 8ad5
    0x95a2,  // 8ad6
    0x9665,  // 8ad7
    0x97d3,  // 8ad8
    0x9928,  // 8ad9
    0x8218,  // 8ada
    0x4e38,  // 8adb
    0x542b,  // 8adc
    0x5cb8,  // 8add
    0x5dcc,  // 8ade
    0x73a9,  // 8adf
    0x764c,  // 8ae0
    0x773c,  // 8ae1
    0x5ca9,  // 8ae2
    0x7feb,  // 8ae3
    0x8d0b,  // 8ae4
    0x96c1,  // 8ae5
    0x9811,  // 8ae6
    0x9854,  // 8ae7
    0x9858,  // 8ae8
    0x4f01,  // 8ae9
    0x4f0e,  // 8aea
    0x5371,  // 8aeb
    0x559c,  // 8aec
    0x5668,  // 8aed
    0x57fa,  // 8aee
    0x5947,  // 8aef
    0x5b09,  // 8af0
    0x5bc4,  // 8af1
    0x5c90,  // 8af2
    0x5e0c,  // 8af3
    0x5e7e,  // 8af4
    0x5fcc,  // 8af5
    0x63ee,  // 8af6
    0x673a,  // 8af7
    0x65d7,  // 8af8
    0x65e2,  // 8af9
    0x671f,  // 8afa
    0x68cb,  // 8afb
    0x68c4,  // 8afc
    0x6a5f,  // 8b40
    0x5e30,  // 8b41
    0x6bc5,  // 8b42
    0x6c17,  // 8b43
    0x6c7d,  // 8b44
    0x757f,  // 8b45
    0x7948,  // 8b46
    0x5b63,  // 8b47
    0x7a00,  // 8b48
    0x7d00,  // 8b49
    0x5fbd,  // 8b4a
    0x898f,  // 8b4b
    0x8a18,  // 8b4c
    0x8cb4,  // 8b4d
    0x8d77,  // 8b4e
    0x8ecc,  // 8b4f
    0x8f1d,  // 8b50
    0x98e2,  // 8b51
    0x9a0e,  // 8b52
    0x9b3c,  // 8b53
    0x4e80,  // 8b54
    0x507d,  // 8b55
    0x5100,  // 8b56
    0x5993,  // 8b57
    0x5b9c,  // 8b58
    0x622f,  // 8b59
    0x6280,  // 8b5a
    0x64ec,  // 8b5b
    0x6b3a,  // 8b5c
    0x72a0,  // 8b5d
    0x7591,  // 8b5e
    0x7947,  // 8b5f
    0x7fa9,  // 8b60
    0x87fb,  // 8b61
    0x8abc,  // 8b62
    0x8b70,  // 8b63
    0x63ac,  // 8b64
    0x83ca,  // 8b65
    0x97a0,  // 8b66
    0x5409,  // 8b67
    0x5403,  // 8b68
    0x55ab,  // 8b69
    0x6854,  // 8b6a
    0x6a58,  // 8b6b
    0x8a70,  // 8b6c
    0x7827,  // 8b6d
    0x6775,  // 8b6e
    0x9ecd,  // 8b6f
    0x5374,  // 8b70
    0x5ba2,  // 8b71
    0x811a,  // 8b72
    0x8650,  // 8b73
    0x9006,  // 8b74
    0x4e18,  // 8b75
    0x4e45,  // 8b76
    0x4ec7,  // 8b77
    0x4f11,  // 8b78
    0x53ca,  // 8b79
    0x5438,  // 8b7a
    0x5bae,  // 8b7b
    0x5f13,  // 8b7c
    0x6025,  // 8b7d
    0x6551,  // 8b7e
    0x0000,  // 8b7f
    0x673d,  // 8b80
    0x6c42,  // 8b81
    0x6c72,  // 8b82
    0x6ce3,  // 8b83
    0x7078,  // 8b84
    0x7403,  // 8b85
    0x7a76,  // 8b86
    0x7aae,  // 8b87
    0x7b08,  // 8b88
    0x7d1a,  // 8b89
    0x7cfe,  // 8b8a
    0x7d66,  // 8b8b
    0x65e7,  // 8b8c
    0x725b,  // 8b8d
    0x53bb,  // 8b8e
    0x5c45,  // 8b8f
    0x5de8,  // 8b90
    0x62d2,  // 8b91
    0x62e0,  // 8b92
    0x6319,  // 8b93
    0x6e20,  // 8b94
    0x865a,  // 8b95
    0x8a31,  // 8b96
    0x8ddd,  // 8b97
    0x92f8,  // 8b98
    0x6f01,  // 8b99
    0x79a6,  // 8b9a
    0x9b5a,  // 8b9b
    0x4ea8,  // 8b9c
    0x4eab,  // 8b9d
    0x4eac,  // 8b9e
    0x4f9b,  // 8b9f
    0x4fa0,  // 8ba0
    0x50d1,  // 8ba1
    0x5147,  // 8ba2
    0x7af6,  // 8ba3
    0x5171,  // 8ba4
    0x51f6,  // 8ba5
    0x5354,  // 8ba6
    0x5321,  // 8ba7
    0x537f,  // 8ba8
    0x53eb,  // 8ba9
    0x55ac,  // 8baa
    0x5883,  // 8bab
    0x5ce1,  // 8bac
    0x5f37,  // 8bad
    0x5f4a,  // 8bae
    0x602f,  // 8baf
    0x6050,  // 8bb0
    0x606d,  // 8bb1
    0x631f,  // 8bb2
    0x6559,  // 8bb3
    0x6a4b,  // 8bb4
    0x6cc1,  // 8bb5
    0x72c2,  // 8bb6
    0x72ed,  // 8bb7
    0x77ef,  // 8bb8
    0x80f8,  // 8bb9
    0x8105,  // 8bba
    0x8208,  // 8bbb
    0x854e,  // 8bbc
    0x90f7,  // 8bbd
    0x93e1,  // 8bbe
    0x97ff,  // 8bbf
    0x9957,  // 8bc0
    0x9a5a,  // 8bc1
    0x4ef0,  // 8bc2
    0x51dd,  // 8bc3
    0x5c2d,  // 8bc4
    0x6681,  // 8bc5
    0x696d,  // 8bc6
    0x5c40,  // 8bc7
    0x66f2,  // 8bc8
    0x6975,  // 8bc9
    0x7389,  // 8bca
    0x6850,  // 8bcb
    0x7c81,  // 8bcc
    0x50c5,  // 8bcd
    0x52e4,  // 8bce
    0x5747,  // 8bcf
    0x5dfe,  // 8bd0
    0x9326,  // 8bd1
    0x65a4,  // 8bd2
    0x6b23,  // 8bd3
    0x6b3d,  // 8bd4
    0x7434,  // 8bd5
    0x7981,  // 8bd6
    0x79bd,  // 8bd7
    0x7b4b,  // 8bd8
    0x7dca,  // 8bd9
    0x82b9,  // 8bda
    0x83cc,  // 8bdb
    0x887f,  // 8bdc
    0x895f,  // 8bdd
    0x8b39,  // 8bde
    0x8fd1,  // 8bdf
    0x91d1,  // 8be0
    0x541f,  // 8be1
    0x9280,  // 8be2
    0x4e5d,  // 8be3
    0x5036,  // 8be4
    0x53e5,  // 8be5
    0x533a,  // 8be6
    0x72d7,  // 8be7
    0x7396,  // 8be8
    0x77e9,  // 8be9
    0x82e6,  // 8bea
    0x8eaf,  // 8beb
    0x99c6,  // 8bec
    0x99c8,  // 8bed
    0x99d2,  // 8bee
    0x5177,  // 8bef
    0x611a,  // 8bf0
    0x865e,  // 8bf1
    0x55b0,  // 8bf2
    0x7a7a,  // 8bf3
    0x5076,  // 8bf4
    0x5bd3,  // 8bf5
    0x9047,  // 8bf6
    0x9685,  // 8bf7
    0x4e32,  // 8bf8
    0x6adb,  // 8bf9
    0x91e7,  // 8bfa
    0x5c51,  // 8bfb
    0x5c48,  // 8bfc
    0x6398,  // 8c40
    0x7a9f,  // 8c41
    0x6c93,  // 8c42
    0x9774,  // 8c43
    0x8f61,  // 8c44
    0x7aaa,  // 8c45
    0x718a,  // 8c46
    0x9688,  // 8c47
    0x7c82,  // 8c48
    0x6817,  // 8c49
    0x7e70,  // 8c4a
    0x6851,  // 8c4b
    0x936c,  // 8c4c
    0x52f2,  // 8c4d
    0x541b,  // 8c4e
    0x85ab,  // 8c4f
    0x8a13,  // 8c50
    0x7fa4,  // 8c51
    0x8ecd,  // 8c52
    0x90e1,  // 8c53
    0x5366,  // 8c54
    0x8888,  // 8c55
    0x7941,  // 8c56
    0x4fc2,  // 8c57
    0x50be,  // 8c58
    0x5211,  // 8c59
    0x5144,  // 8c5a
    0x5553,  // 8c5b
    0x572d,  // 8c5c
    0x73ea,  // 8c5d
    0x578b,  // 8c5e
    0x5951,  // 8c5f
    0x5f62,  // 8c60
    0x5f84,  // 8c61
    0x6075,  // 8c62
    0x6176,  // 8c63
    0x6167,  // 8c64
    0x61a9,  // 8c65
    0x63b2,  // 8c66
    0x643a,  // 8c67
    0x656c,  // 8c68
    0x666f,  // 8c69
    0x6842,  // 8c6a
    0x6e13,  // 8c6b
    0x7566,  // 8c6c
    0x7a3d,  // 8c6d
    0x7cfb,  // 8c6e
    0x7d4c,  // 8c6f
    0x7d99,  // 8c70
    0x7e4b,  // 8c71
    0x7f6b,  // 8c72
    0x830e,  // 8c73
    0x834a,  // 8c74
    0x86cd,  // 8c75
    0x8a08,  // 8c76
    0x8a63,  // 8c77
    0x8b66,  // 8c78
    0x8efd,  // 8c79
    0x981a,  // 8c7a
    0x9d8f,  // 8c7b
    0x82b8,  // 8c7c
    0x8fce,  // 8c7d
    0x9be8,  // 8c7e
    0x0000,  // 8c7f
    0x5287,  // 8c80
    0x621f,  // 8c81
    0x6483,  // 8c82
    0x6fc0,  // 8c83
    0x9699,  // 8c84
    0x6841,  // 8c85
    0x5091,  // 8c86
    0x6b20,  // 8c87
    0x6c7a,  // 8c88
    0x6f54,  // 8c89
    0x7a74,  // 8c8a
    0x7d50,  // 8c8b
    0x8840,  // 8c8c
    0x8a23,  // 8c8d
    0x6708,  // 8c8e
    0x4ef6,  // 8c8f
    0x5039,  // 8c90
    0x5026,  // 8c91
    0x5065,  // 8c92
    0x517c,  // 8c93
    0x5238,  // 8c94
    0x5263,  // 8c95
    0x55a7,  // 8c96
    0x570f,  // 8c97
    0x5805,  // 8c98
    0x5acc,  // 8c99
    0x5efa,  // 8c9a
    0x61b2,  // 8c9b
    0x61f8,  // 8c9c
    0x62f3,  // 8c9d
    0x6372,  // 8c9e
    0x691c,  // 8c9f
    0x6a29,  // 8ca0
    0x727d,  // 8ca1
    0x72ac,  // 8ca2
    0x732e,  // 8ca3
    0x7814,  // 8ca4
    0x786f,  // 8ca5
    0x7d79,  // 8ca6
    0x770c,  // 8ca7
    0x80a9,  // 8ca8
    0x898b,  // 8ca9
    0x8b19,  // 8caa
    0x8ce2,  // 8cab
    0x8ed2,  // 8cac
    0x9063,  // 8cad
    0x9375,  // 8cae
    0x967a,  // 8caf
    0x9855,  // 8cb0
    0x9a13,  // 8cb1
    0x9e78,  // 8cb2
    0x5143,  // 8cb3
    0x539f,  // 8cb4
    0x53b3,  // 8cb5
    0x5e7b,  // 8cb6
    0x5f26,  // 8cb7
    0x6e1b,  // 8cb8
    0x6e90,  // 8cb9
    0x7384,  // 8cba
    0x73fe,  // 8cbb
    0x7d43,  // 8cbc
    0x8237,  // 8cbd
    0x8a00,  // 8cbe
    0x8afa,  // 8cbf
    0x9650,  // 8cc0
    0x4e4e,  // 8cc1
    0x500b,  // 8cc2
    0x53e4,  // 8cc3
    0x547c,  // 8cc4
    0x56fa,  // 8cc5
    0x59d1,  // 8cc6
    0x5b64,  // 8cc7
    0x5df1,  // 8cc8
    0x5eab,  // 8cc9
    0x5f27,  // 8cca
    0x6238,  // 8ccb
    0x6545,  // 8ccc
    0x67af,  // 8ccd
    0x6e56,  // 8cce
    0x72d0,  // 8ccf
    0x7cca,  // 8cd0
    0x88b4,  // 8cd1
    0x80a1,  // 8cd2
    0x80e1,  // 8cd3
    0x83f0,  // 8cd4
    0x864e,  // 8cd5
    0x8a87,  // 8cd6
    0x8de8,  // 8cd7
    0x9237,  // 8cd8
    0x96c7,  // 8cd9
    0x9867,  // 8cda
    0x9f13,  // 8cdb
    0x4e94,  // 8cdc
    0x4e92,  // 8cdd
    0x4f0d,  // 8cde
    0x5348,  // 8cdf
    0x5449,  // 8ce0
    0x543e,  // 8ce1
    0x5a2f,  // 8ce2
    0x5f8c,  // 8ce3
    0x5fa1,  // 8ce4
    0x609f,  // 8ce5
    0x68a7,  // 8ce6
    0x6a8e,  // 8ce7
    0x745a,  // 8ce8
    0x7881,  // 8ce9
    0x8a9e,  // 8cea
    0x8aa4,  // 8ceb
    0x8b77,  // 8cec
    0x9190,  // 8ced
    0x4e5e,  // 8cee
    0x9bc9,  // 8cef
    0x4ea4,  // 8cf0
    0x4f7c,  // 8cf1
    0x4faf,  // 8cf2
    0x5019,  // 8cf3
    0x5016,  // 8cf4
    0x5149,  // 8cf5
    0x516c,  // 8cf6
    0x529f,  // 8cf7
    0x52b9,  // 8cf8
    0x52fe,  // 8cf9
    0x539a,  // 8cfa
    0x53e3,  // 8cfb
    0x5411,  // 8cfc
    0x540e,  // 8d40
    0x5589,  // 8d41
    0x5751,  // 8d42
    0x57a2,  // 8d43
    0x597d,  // 8d44
    0x5b54,  // 8d45
    0x5b5d,  // 8d46
    0x5b8f,  // 8d47
    0x5de5,  // 8d48
    0x5de7,  // 8d49
    0x5df7,  // 8d4a
    0x5e78,  // 8d4b
    0x5e83,  // 8d4c
    0x5e9a,  // 8d4d
    0x5eb7,  // 8d4e
    0x5f18,  // 8d4f
    0x6052,  // 8d50
    0x614c,  // 8d51
    0x6297,  // 8d52
    0x62d8,  // 8d53
    0x63a7,  // 8d54
    0x653b,  // 8d55
    0x6602,  // 8d56
    0x6643,  // 8d57
    0x66f4,  // 8d58
    0x676d,  // 8d59
    0x6821,  // 8d5a
    0x6897,  // 8d5b
    0x69cb,  // 8d5c
    0x6c5f,  // 8d5d
    0x6d2a,  // 8d5e
    0x6d69,  // 8d5f
    0x6e2f,  // 8d60
    0x6e9d,  // 8d61
    0x7532,  // 8d62
    0x7687,  // 8d63
    0x786c,  // 8d64
    0x7a3f,  // 8d65
    0x7ce0,  // 8d66
    0x7d05,  // 8d67
    0x7d18,  // 8d68
    0x7d5e,  // 8d69
    0x7db1,  // 8d6a
    0x8015,  // 8d6b
    0x8003,  // 8d6c
    0x80af,  // 8d6d
    0x80b1,  // 8d6e
    0x8154,  // 8d6f
    0x818f,  // 8d70
    0x822a,  // 8d71
    0x8352,  // 8d72
    0x884c,  // 8d73
    0x8861,  // 8d74
    0x8b1b,  // 8d75
    0x8ca2,  // 8d76
    0x8cfc,  // 8d77
    0x90ca,  // 8d78
    0x9175,  // 8d79
    0x9271,  // 8d7a
    0x783f,  // 8d7b
    0x92fc,  // 8d7c
    0x95a4,  // 8d7d
    0x964d,  // 8d7e
    0x0000,  // 8d7f
    0x9805,  // 8d80
    0x9999,  // 8d81
    0x9ad8,  // 8d82
    0x9d3b,  // 8d83
    0x525b,  // 8d84
    0x52ab,  // 8d85
    0x53f7,  // 8d86
    0x5408,  // 8d87
    0x58d5,  // 8d88
    0x62f7,  // 8d89
    0x6fe0,  // 8d8a
    0x8c6a,  // 8d8b
    0x8f5f,  // 8d8c
    0x9eb9,  // 8d8d
    0x514b,  // 8d8e
    0x523b,  // 8d8f
    0x544a,  // 8d90
    0x56fd,  // 8d91
    0x7a40,  // 8d92
    0x9177,  // 8d93
    0x9d60,  // 8d94
    0x9ed2,  // 8d95
    0x7344,  // 8d96
    0x6f09,  // 8d97
    0x8170,  // 8d98
    0x7511,  // 8d99
    0x5ffd,  // 8d9a
    0x60da,  // 8d9b
    0x9aa8,  // 8d9c
    0x72db,  // 8d9d
    0x8fbc,  // 8d9e
    0x6b64,  // 8d9f
    0x9803,  // 8da0
    0x4eca,  // 8da1
    0x56f0,  // 8da2
    0x5764,  // 8da3
    0x58be,  // 8da4
    0x5a5a,  // 8da5
    0x6068,  // 8da6
    0x61c7,  // 8da7
    0x660f,  // 8da8
    0x6606,  // 8da9
    0x6839,  // 8daa
    0x68b1,  // 8dab
    0x6df7,  // 8dac
    0x75d5,  // 8dad
    0x7d3a,  // 8dae
    0x826e,  // 8daf
    0x9b42,  // 8db0
    0x4e9b,  // 8db1
    0x4f50,  // 8db2
    0x53c9,  // 8db3
    0x5506,  // 8db4
    0x5d6f,  // 8db5
    0x5de6,  // 8db6
    0x5dee,  // 8db7
    0x67fb,  // 8db8
    0x6c99,  // 8db9
    0x7473,  // 8dba
    0x7802,  // 8dbb
    0x8a50,  // 8dbc
    0x9396,  // 8dbd
    0x88df,  // 8dbe
    0x5750,  // 8dbf
    0x5ea7,  // 8dc0
    0x632b,  // 8dc1
    0x50b5,  // 8dc2
    0x50ac,  // 8dc3
    0x518d,  // 8dc4
    0x6700,  // 8dc5
    0x54c9,  // 8dc6
    0x585e,  // 8dc7
    0x59bb,  // 8dc8
    0x5bb0,  // 8dc9
    0x5f69,  // 8dca
    0x624d,  // 8dcb
    0x63a1,  // 8dcc
    0x683d,  // 8dcd
    0x6b73,  // 8dce
    0x6e08,  // 8dcf
    0x707d,  // 8dd0
    0x91c7,  // 8dd1
    0x7280,  // 8dd2
    0x7815,  // 8dd3
    0x7826,  // 8dd4
    0x796d,  // 8dd5
    0x658e,  // 8dd6
    0x7d30,  // 8dd7
    0x83dc,  // 8dd8
    0x88c1,  // 8dd9
    0x8f09,  // 8dda
    0x969b,  // 8ddb
    0x5264,  // 8ddc
    0x5728,  // 8ddd
    0x6750,  // 8dde
    0x7f6a,  // 8ddf
    0x8ca1,  // 8de0
    0x51b4,  // 8de1
    0x5742,  // 8de2
    0x962a,  // 8de3
    0x583a,  // 8de4
    0x698a,  // 8de5
    0x80b4,  // 8de6
    0x54b2,  // 8de7
    0x5d0e,  // 8de8
    0x57fc,  // 8de9
    0x7895,  // 8dea
    0x9dfa,  // 8deb
    0x4f5c,  // 8dec
    0x524a,  // 8ded
    0x548b,  // 8dee
    0x643e,  // 8def
    0x6628,  // 8df0
    0x6714,  // 8df1
    0x67f5,  // 8df2
    0x7a84,  // 8df3
    0x7b56,  // 8df4
    0x7d22,  // 8df5
    0x932f,  // 8df6
    0x685c,  // 8df7
    0x9bad,  // 8df8
    0x7b39,  // 8df9
    0x5319,  // 8dfa
    0x518a,  // 8dfb
    0x5237,  // 8dfc
    0x5bdf,  // 8e40
    0x62f6,  // 8e41
    0x64ae,  // 8e42
    0x64e6,  // 8e43
    0x672d,  // 8e44
    0x6bba,  // 8e45
    0x85a9,  // 8e46
    0x96d1,  // 8e47
    0x7690,  // 8e48
    0x9bd6,  // 8e49
    0x634c,  // 8e4a
    0x9306,  // 8e4b
    0x9bab,  // 8e4c
    0x76bf,  // 8e4d
    0x6652,  // 8e4e
    0x4e09,  // 8e4f
    0x5098,  // 8e50
    0x53c2,  // 8e51
    0x5c71,  // 8e52
    0x60e8,  // 8e53
    0x6492,  // 8e54
    0x6563,  // 8e55
    0x685f,  // 8e56
    0x71e6,  // 8e57
    0x73ca,  // 8e58
    0x7523,  // 8e59
    0x7b97,  // 8e5a
    0x7e82,  // 8e5b
    0x8695,  // 8e5c
    0x8b83,  // 8e5d
    0x8cdb,  // 8e5e
    0x9178,  // 8e5f
    0x9910,  // 8e60
    0x65ac,  // 8e61
    0x66ab,  // 8e62
    0x6b8b,  // 8e63
    0x4ed5,  // 8e64
    0x4ed4,  // 8e65
    0x4f3a,  // 8e66
    0x4f7f,  // 8e67
    0x523a,  // 8e68
    0x53f8,  // 8e69
    0x53f2,  // 8e6a
    0x55e3,  // 8e6b
    0x56db,  // 8e6c
    0x58eb,  // 8e6d
    0x59cb,  // 8e6e
    0x59c9,  // 8e6f
    0x59ff,  // 8e70
    0x5b50,  // 8e71
    0x5c4d,  // 8e72
    0x5e02,  // 8e73
    0x5e2b,  // 8e74
    0x5fd7,  // 8e75
    0x601d,  // 8e76
    0x6307,  // 8e77
    0x652f,  // 8e78
    0x5b5c,  // 8e79
    0x65af,  // 8e7a
    0x65bd,  // 8e7b
    0x65e8,  // 8e7c
    0x679d,  // 8e7d
    0x6b62,  // 8e7e
    0x0000,  // 8e7f
    0x6b7b,  // 8e80
    0x6c0f,  // 8e81
    0x7345,  // 8e82
    0x7949,  // 8e83
    0x79c1,  // 8e84
    0x7cf8,  // 8e85
    0x7d19,  // 8e86
    0x7d2b,  // 8e87
    0x80a2,  // 8e88
    0x8102,  // 8e89
    0x81f3,  // 8e8a
    0x8996,  // 8e8b
    0x8a5e,  // 8e8c
    0x8a69,  // 8e8d
    0x8a66,  // 8e8e
    0x8a8c,  // 8e8f
    0x8aee,  // 8e90
    0x8cc7,  // 8e91
    0x8cdc,  // 8e92
    0x96cc,  // 8e93
    0x98fc,  // 8e94
    0x6b6f,  // 8e95
    0x4e8b,  // 8e96
    0x4f3c,  // 8e97
    0x4f8d,  // 8e98
    0x5150,  // 8e99
    0x5b57,  // 8e9a
    0x5bfa,  // 8e9b
    0x6148,  // 8e9c
    0x6301,  // 8e9d
    0x6642,  // 8e9e
    0x6b21,  // 8e9f
    0x6ecb,  // 8ea0
    0x6cbb,  // 8ea1
    0x723e,  // 8ea2
    0x74bd,  // 8ea3
    0x75d4,  // 8ea4
    0x78c1,  // 8ea5
    0x793a,  // 8ea6
    0x800c,  // 8ea7
    0x8033,  // 8ea8
    0x81ea,  // 8ea9
    0x8494,  // 8eaa
    0x8f9e,  // 8eab
    0x6c50,  // 8eac
    0x9e7f,  // 8ead
    0x5f0f,  // 8eae
    0x8b58,  // 8eaf
    0x9d2b,  // 8eb0
    0x7afa,  // 8eb1
    0x8ef8,  // 8eb2
    0x5b8d,  // 8eb3
    0x96eb,  // 8eb4
    0x4e03,  // 8eb5
    0x53f1,  // 8eb6
    0x57f7,  // 8eb7
    0x5931,  // 8eb8
    0x5ac9,  // 8eb9
    0x5ba4,  // 8eba
    0x6089,  // 8ebb
    0x6e7f,  // 8ebc
    0x6f06,  // 8ebd
    0x75be,  // 8ebe
    0x8cea,  // 8ebf
    0x5b9f,  // 8ec0
    0x8500,  // 8ec1
    0x7be0,  // 8ec2
    0x5072,  // 8ec3
    0x67f4,  // 8ec4
    0x829d,  // 8ec5
    0x5c61,  // 8ec6
    0x854a,  // 8ec7
    0x7e1e,  // 8ec8
    0x820e,  // 8ec9
    0x5199,  // 8eca
    0x5c04,  // 8ecb
    0x6368,  // 8ecc
    0x8d66,  // 8ecd
    0x659c,  // 8ece
    0x716e,  // 8ecf
    0x793e,  // 8ed0
    0x7d17,  // 8ed1
    0x8005,  // 8ed2
    0x8b1d,  // 8ed3
    0x8eca,  // 8ed4
    0x906e,  // 8ed5
    0x86c7,  // 8ed6
    0x90aa,  // 8ed7
    0x501f,  // 8ed8
    0x52fa,  // 8ed9
    0x5c3a,  // 8eda
    0x6753,  // 8edb
    0x707c,  // 8edc
    0x7235,  // 8edd
    0x914c,  // 8ede
    0x91c8,  // 8edf
    0x932b,  // 8ee0
    0x82e5,  // 8ee1
    0x5bc2,  // 8ee2
    0x5f31,  // 8ee3
    0x60f9,  // 8ee4
    0x4e3b,  // 8ee5
    0x53d6,  // 8ee6
    0x5b88,  // 8ee7
    0x624b,  // 8ee8
    0x6731,  // 8ee9
    0x6b8a,  // 8eea
    0x72e9,  // 8eeb
    0x73e0,  // 8eec
    0x7a2e,  // 8eed
    0x816b,  // 8eee
    0x8da3,  // 8eef
    0x9152,  // 8ef0
    0x9996,  // 8ef1
    0x5112,  // 8ef2
    0x53d7,  // 8ef3
    0x546a,  // 8ef4
    0x5bff,  // 8ef5
    0x6388,  // 8ef6
    0x6a39,  // 8ef7
    0x7dac,  // 8ef8
    0x9700,  // 8ef9
    0x56da,  // 8efa
    0x53ce,  // 8efb
    0x5468,  // 8efc
    0x5b97,  // 8f40
    0x5c31,  // 8f41
    0x5dde,  // 8f42
    0x4fee,  // 8f43
    0x6101,  // 8f44
    0x62fe,  // 8f45
    0x6d32,  // 8f46
    0x79c0,  // 8f47
    0x79cb,  // 8f48
    0x7d42,  // 8f49
    0x7e4d,  // 8f4a
    0x7fd2,  // 8f4b
    0x81ed,  // 8f4c
    0x821f,  // 8f4d
    0x8490,  // 8f4e
    0x8846,  // 8f4f
    0x8972,  // 8f50
    0x8b90,  // 8f51
    0x8e74,  // 8f52
    0x8f2f,  // 8f53
    0x9031,  // 8f54
    0x914b,  // 8f55
    0x916c,  // 8f56
    0x96c6,  // 8f57
    0x919c,  // 8f58
    0x4ec0,  // 8f59
    0x4f4f,  // 8f5a
    0x5145,  // 8f5b
    0x5341,  // 8f5c
    0x5f93,  // 8f5d
    0x620e,  // 8f5e
    0x67d4,  // 8f5f
    0x6c41,  // 8f60
    0x6e0b,  // 8f61
    0x7363,  // 8f62
    0x7e26,  // 8f63
    0x91cd,  // 8f64
    0x9283,  // 8f65
    0x53d4,  // 8f66
    0x5919,  // 8f67
    0x5bbf,  // 8f68
    0x6dd1,  // 8f69
    0x795d,  // 8f6a
    0x7e2e,  // 8f6b
    0x7c9b,  // 8f6c
    0x587e,  // 8f6d
    0x719f,  // 8f6e
    0x51fa,  // 8f6f
    0x8853,  // 8f70
    0x8ff0,  // 8f71
    0x4fca,  // 8f72
    0x5cfb,  // 8f73
    0x6625,  // 8f74
    0x77ac,  // 8f75
    0x7ae3,  // 8f76
    0x821c,  // 8f77
    0x99ff,  // 8f78
    0x51c6,  // 8f79
    0x5faa,  // 8f7a
    0x65ec,  // 8f7b
    0x696f,  // 8f7c
    0x6b89,  // 8f7d
    0x6df3,  // 8f7e
    0x0000,  // 8f7f
    0x6e96,  // 8f80
    0x6f64,  // 8f81
    0x76fe,  // 8f82
    0x7d14,  // 8f83
    0x5de1,  // 8f84
    0x9075,  // 8f85
    0x9187,  // 8f86
    0x9806,  // 8f87
    0x51e6,  // 8f88
    0x521d,  // 8f89
    0x6240,  // 8f8a
    0x6691,  // 8f8b
    0x66d9,  // 8f8c
    0x6e1a,  // 8f8d
    0x5eb6,  // 8f8e
    0x7dd2,  // 8f8f
    0x7f72,  // 8f90
    0x66f8,  // 8f91
    0x85af,  // 8f92
    0x85f7,  // 8f93
    0x8af8,  // 8f94
    0x52a9,  // 8f95
    0x53d9,  // 8f96
    0x5973,  // 8f97
    0x5e8f,  // 8f98
    0x5f90,  // 8f99
    0x6055,  // 8f9a
    0x92e4,  // 8f9b
    0x9664,  // 8f9c
    0x50b7,  // 8f9d
    0x511f,  // 8f9e
    0x52dd,  // 8f9f
    0x5320,  // 8fa0
    0x5347,  // 8fa1
    0x53ec,  // 8fa2
    0x54e8,  // 8fa3
    0x5546,  // 8fa4
    0x5531,  // 8fa5
    0x5617,  // 8fa6
    0x5968,  // 8fa7
    0x59be,  // 8fa8
    0x5a3c,  // 8fa9
    0x5bb5,  // 8faa
    0x5c06,  // 8fab
    0x5c0f,  // 8fac
    0x5c11,  // 8fad
    0x5c1a,  // 8fae
    0x5e84,  // 8faf
    0x5e8a,  // 8fb0
    0x5ee0,  // 8fb1
    0x5f70,  // 8fb2
    0x627f,  // 8fb3
    0x6284,  // 8fb4
    0x62db,  // 8fb5
    0x638c,  // 8fb6
    0x6377,  // 8fb7
    0x6607,  // 8fb8
    0x660c,  // 8fb9
    0x662d,  // 8fba
    0x6676,  // 8fbb
    0x677e,  // 8fbc
    0x68a2,  // 8fbd
    0x6a1f,  // 8fbe
    0x6a35,  // 8fbf
    0x6cbc,  // 8fc0
    0x6d88,  // 8fc1
    0x6e09,  // 8fc2
    0x6e58,  // 8fc3
    0x713c,  // 8fc4
    0x7126,  // 8fc5
    0x7167,  // 8fc6
    0x75c7,  // 8fc7
    0x7701,  // 8fc8
    0x785d,  // 8fc9
    0x7901,  // 8fca
    0x7965,  // 8fcb
    0x79f0,  // 8fcc
    0x7ae0,  // 8fcd
    0x7b11,  // 8fce
    0x7ca7,  // 8fcf
    0x7d39,  // 8fd0
    0x8096,  // 8fd1
    0x83d6,  // 8fd2
    0x848b,  // 8fd3
    0x8549,  // 8fd4
    0x885d,  // 8fd5
    0x88f3,  // 8fd6
    0x8a1f,  // 8fd7
    0x8a3c,  // 8fd8
    0x8a54,  // 8fd9
    0x8a73,  // 8fda
    0x8c61,  // 8fdb
    0x8cde,  // 8fdc
    0x91a4,  // 8fdd
    0x9266,  // 8fde
    0x937e,  // 8fdf
    0x9418,  // 8fe0
    0x969c,  // 8fe1
    0x9798,  // 8fe2
    0x4e0a,  // 8fe3
    0x4e08,  // 8fe4
    0x4e1e,  // 8fe5
    0x4e57,  // 8fe6
    0x5197,  // 8fe7
    0x5270,  // 8fe8
    0x57ce,  // 8fe9
    0x5834,  // 8fea
    0x58cc,  // 8feb
    0x5b22,  // 8fec
    0x5e38,  // 8fed
    0x60c5,  // 8fee
    0x64fe,  // 8fef
    0x6761,  // 8ff0
    0x6756,  // 8ff1
    0x6d44,  // 8ff2
    0x72b6,  // 8ff3
    0x7573,  // 8ff4
    0x7a63,  // 8ff5
    0x84b8,  // 8ff6
    0x8b72,  // 8ff7
    0x91b8,  // 8ff8
    0x9320,  // 8ff9
    0x5631,  // 8ffa
    0x57f4,  // 8ffb
    0x98fe,  // 8ffc
    0x62ed,  // 9040
    0x690d,  // 9041
    0x6b96,  // 9042
    0x71ed,  // 9043
    0x7e54,  // 9044
    0x8077,  // 9045
    0x8272,  // 9046
    0x89e6,  // 9047
    0x98df,  // 9048
    0x8755,  // 9049
    0x8fb1,  // 904a
    0x5c3b,  // 904b
    0x4f38,  // 904c
    0x4fe1,  // 904d
    0x4fb5,  // 904e
    0x5507,  // 904f
    0x5a20,  // 9050
    0x5bdd,  // 9051
    0x5be9,  // 9052
    0x5fc3,  // 9053
    0x614e,  // 9054
    0x632f,  // 9055
    0x65b0,  // 9056
    0x664b,  // 9057
    0x68ee,  // 9058
    0x699b,  // 9059
    0x6d78,  // 905a
    0x6df1,  // 905b
    0x7533,  // 905c
    0x75b9,  // 905d
    0x771f,  // 905e
    0x795e,  // 905f
    0x79e6,  // 9060
    0x7d33,  // 9061
    0x81e3,  // 9062
    0x82af,  // 9063
    0x85aa,  // 9064
    0x89aa,  // 9065
    0x8a3a,  // 9066
    0x8eab,  // 9067
    0x8f9b,  // 9068
    0x9032,  // 9069
    0x91dd,  // 906a
    0x9707,  // 906b
    0x4eba,  // 906c
    0x4ec1,  // 906d
    0x5203,  // 906e
    0x5875,  // 906f
    0x58ec,  // 9070
    0x5c0b,  // 9071
    0x751a,  // 9072
    0x5c3d,  // 9073
    0x814e,  // 9074
    0x8a0a,  // 9075
    0x8fc5,  // 9076
    0x9663,  // 9077
    0x976d,  // 9078
    0x7b25,  // 9079
    0x8acf,  // 907a
    0x9808,  // 907b
    0x9162,  // 907c
    0x56f3,  // 907d
    0x53a8,  // 907e
    0x0000,  // 907f
    0x9017,  // 9080
    0x5439,  // 9081
    0x5782,  // 9082
    0x5e25,  // 9083
    0x63a8,  // 9084
    0x6c34,  // 9085
    0x708a,  // 9086
    0x7761,  // 9087
    0x7c8b,  // 9088
    0x7fe0,  // 9089
    0x8870,  // 908a
    0x9042,  // 908b
    0x9154,  // 908c
    0x9310,  // 908d
    0x9318,  // 908e
    0x968f,  // 908f
    0x745e,  // 9090
    0x9ac4,  // 9091
    0x5d07,  // 9092
    0x5d69,  // 9093
    0x6570,  // 9094
    0x67a2,  // 9095
    0x8da8,  // 9096
    0x96db,  // 9097
    0x636e,  // 9098
    0x6749,  // 9099
    0x6919,  // 909a
    0x83c5,  // 909b
    0x9817,  // 909c
    0x96c0,  // 909d
    0x88fe,  // 909e
    0x6f84,  // 909f
    0x647a,  // 90a0
    0x5bf8,  // 90a1
    0x4e16,  // 90a2
    0x702c,  // 90a3
    0x755d,  // 90a4
    0x662f,  // 90a5
    0x51c4,  // 90a6
    0x5236,  // 90a7
    0x52e2,  // 90a8
    0x59d3,  // 90a9
    0x5f81,  // 90aa
    0x6027,  // 90ab
    0x6210,  // 90ac
    0x653f,  // 90ad
    0x6574,  // 90ae
    0x661f,  // 90af
    0x6674,  // 90b0
    0x68f2,  // 90b1
    0x6816,  // 90b2
    0x6b63,  // 90b3
    0x6e05,  // 90b4
    0x7272,  // 90b5
    0x751f,  // 90b6
    0x76db,  // 90b7
    0x7cbe,  // 90b8
    0x8056,  // 90b9
    0x58f0,  // 90ba
    0x88fd,  // 90bb
    0x897f,  // 90bc
    0x8aa0,  // 90bd
    0x8a93,  // 90be
    0x8acb,  // 90bf
    0x901d,  // 90c0
    0x9192,  // 90c1
    0x9752,  // 90c2
    0x9759,  // 90c3
    0x6589,  // 90c4
    0x7a0e,  // 90c5
    0x8106,  // 90c6
    0x96bb,  // 90c7
    0x5e2d,  // 90c8
    0x60dc,  // 90c9
    0x621a,  // 90ca
    0x65a5,  // 90cb
    0x6614,  // 90cc
    0x6790,  // 90cd
    0x77f3,  // 90ce
    0x7a4d,  // 90cf
    0x7c4d,  // 90d0
    0x7e3e,  // 90d1
    0x810a,  // 90d2
    0x8cac,  // 90d3
    0x8d64,  // 90d4
    0x8de1,  // 90d5
    0x8e5f,  // 90d6
    0x78a9,  // 90d7
    0x5207,  // 90d8
    0x62d9,  // 90d9
    0x63a5,  // 90da
    0x6442,  // 90db
    0x6298,  // 90dc
    0x8a2d,  // 90dd
    0x7a83,  // 90de
    0x7bc0,  // 90df
    0x8aac,  // 90e0
    0x96ea,  // 90e1
    0x7d76,  // 90e2
    0x820c,  // 90e3
    0x8749,  // 90e4
    0x4ed9,  // 90e5
    0x5148,  // 90e6
    0x5343,  // 90e7
    0x5360,  // 90e8
    0x5ba3,  // 90e9
    0x5c02,  // 90ea
    0x5c16,  // 90eb
    0x5ddd,  // 90ec
    0x6226,  // 90ed
    0x6247,  // 90ee
    0x64b0,  // 90ef
    0x6813,  // 90f0
    0x6834,  // 90f1
    0x6cc9,  // 90f2
    0x6d45,  // 90f3
    0x6d17,  // 90f4
    0x67d3,  // 90f5
    0x6f5c,  // 90f6
    0x714e,  // 90f7
    0x717d,  // 90f8
    0x65cb,  // 90f9
    0x7a7f,  // 90fa
    0x7bad,  // 90fb
    0x7dda,  // 90fc
    0x7e4a,  // 9140
    0x7fa8,  // 9141
    0x817a,  // 9142
    0x821b,  // 9143
    0x8239,  // 9144
    0x85a6,  // 9145
    0x8a6e,  // 9146
    0x8cce,  // 9147
    0x8df5,  // 9148
    0x9078,  // 9149
    0x9077,  // 914a
    0x92ad,  // 914b
    0x9291,  // 914c
    0x9583,  // 914d
    0x9bae,  // 914e
    0x524d,  // 914f
    0x5584,  // 9150
    0x6f38,  // 9151
    0x7136,  // 9152
    0x5168,  // 9153
    0x7985,  // 9154
    0x7e55,  // 9155
    0x81b3,  // 9156
    0x7cce,  // 9157
    0x564c,  // 9158
    0x5851,  // 9159
    0x5ca8,  // 915a
    0x63aa,  // 915b
    0x66fe,  // 915c
    0x66fd,  // 915d
    0x695a,  // 915e
    0x72d9,  // 915f
    0x758f,  // 9160
    0x758e,  // 9161
    0x790e,  // 9162
    0x7956,  // 9163
    0x79df,  // 9164
    0x7c97,  // 9165
    0x7d20,  // 9166
    0x7d44,  // 9167
    0x8607,  // 9168
    0x8a34,  // 9169
    0x963b,  // 916a
    0x9061,  // 916b
    0x9f20,  // 916c
    0x50e7,  // 916d
    0x5275,  // 916e
    0x53cc,  // 916f
    0x53e2,  // 9170
    0x5009,  // 9171
    0x55aa,  // 9172
    0x58ee,  // 9173
    0x594f,  // 9174
    0x723d,  // 9175
    0x5b8b,  // 9176
    0x5c64,  // 9177
    0x531d,  // 9178
    0x60e3,  // 9179
    0x60f3,  // 917a
    0x635c,  // 917b
    0x6383,  // 917c
    0x633f,  // 917d
    0x63bb,  // 917e
    0x0000,  // 917f
    0x64cd,  // 9180
    0x65e9,  // 9181
    0x66f9,  // 9182
    0x5de3,  // 9183
    0x69cd,  // 9184
    0x69fd,  // 9185
    0x6f15,  // 9186
    0x71e5,  // 9187
    0x4e89,  // 9188
    0x75e9,  // 9189
    0x76f8,  // 918a
    0x7a93,  // 918b
    0x7cdf,  // 918c
    0x7dcf,  // 918d
    0x7d9c,  // 918e
    0x8061,  // 918f
    0x8349,  // 9190
    0x8358,  // 9191
    0x846c,  // 9192
    0x84bc,  // 9193
    0x85fb,  // 9194
    0x88c5,  // 9195
    0x8d70,  // 9196
    0x9001,  // 9197
    0x906d,  // 9198
    0x9397,  // 9199
    0x971c,  // 919a
    0x9a12,  // 919b
    0x50cf,  // 919c
    0x5897,  // 919d
    0x618e,  // 919e
    0x81d3,  // 919f
    0x8535,  // 91a0
    0x8d08,  // 91a1
    0x9020,  // 91a2
    0x4fc3,  // 91a3
    0x5074,  // 91a4
    0x5247,  // 91a5
    0x5373,  // 91a6
    0x606f,  // 91a7
    0x6349,  // 91a8
    0x675f,  // 91a9
    0x6e2c,  // 91aa
    0x8db3,  // 91ab
    0x901f,  // 91ac
    0x4fd7,  // 91ad
    0x5c5e,  // 91ae
    0x8cca,  // 91af
    0x65cf,  // 91b0
    0x7d9a,  // 91b1
    0x5352,  // 91b2
    0x8896,  // 91b3
    0x5176,  // 91b4
    0x63c3,  // 91b5
    0x5b58,  // 91b6
    0x5b6b,  // 91b7
    0x5c0a,  // 91b8
    0x640d,  // 91b9
    0x6751,  // 91ba
    0x905c,  // 91bb
    0x4ed6,  // 91bc
    0x591a,  // 91bd
    0x592a,  // 91be
    0x6c70,  // 91bf
    0x8a51,  // 91c0
    0x553e,  // 91c1
    0x5815,  // 91c2
    0x59a5,  // 91c3
    0x60f0,  // 91c4
    0x6253,  // 91c5
    0x67c1,  // 91c6
    0x8235,  // 91c7
    0x6955,  // 91c8
    0x9640,  // 91c9
    0x99c4,  // 91ca
    0x9a28,  // 91cb
    0x4f53,  // 91cc
    0x5806,  // 91cd
    0x5bfe,  // 91ce
    0x8010,  // 91cf
    0x5cb1,  // 91d0
    0x5e2f,  // 91d1
    0x5f85,  // 91d2
    0x6020,  // 91d3
    0x614b,  // 91d4
    0x6234,  // 91d5
    0x66ff,  // 91d6
    0x6cf0,  // 91d7
    0x6ede,  // 91d8
    0x80ce,  // 91d9
    0x817f,  // 91da
    0x82d4,  // 91db
    0x888b,  // 91dc
    0x8cb8,  // 91dd
    0x9000,  // 91de
    0x902e,  // 91df
    0x968a,  // 91e0
    0x9edb,  // 91e1
    0x9bdb,  // 91e2
    0x4ee3,  // 91e3
    0x53f0,  // 91e4
    0x5927,  // 91e5
    0x7b2c,  // 91e6
    0x918d,  // 91e7
    0x984c,  // 91e8
    0x9df9,  // 91e9
    0x6edd,  // 91ea
    0x7027,  // 91eb
    0x5353,  // 91ec
    0x5544,  // 91ed
    0x5b85,  // 91ee
    0x6258,  // 91ef
    0x629e,  // 91f0
    0x62d3,  // 91f1
    0x6ca2,  // 91f2
    0x6fef,  // 91f3
    0x7422,  // 91f4
    0x8a17,  // 91f5
    0x9438,  // 91f6
    0x6fc1,  // 91f7
    0x8afe,  // 91f8
    0x8338,  // 91f9
    0x51e7,  // 91fa
    0x86f8,  // 91fb
    0x53ea,  // 91fc
    0x53e9,  // 9240
    0x4f46,  // 9241
    0x9054,  // 9242
    0x8fb0,  // 9243
    0x596a,  // 9244
    0x8131,  // 9245
    0x5dfd,  // 9246
    0x7aea,  // 9247
    0x8fbf,  // 9248
    0x68da,  // 9249
    0x8c37,  // 924a
    0x72f8,  // 924b
    0x9c48,  // 924c
    0x6a3d,  // 924d
    0x8ab0,  // 924e
    0x4e39,  // 924f
    0x5358,  // 9250
    0x5606,  // 9251
    0x5766,  // 9252
    0x62c5,  // 9253
    0x63a2,  // 9254
    0x65e6,  // 9255
    0x6b4e,  // 9256
    0x6de1,  // 9257
    0x6e5b,  // 9258
    0x70ad,  // 9259
    0x77ed,  // 925a
    0x7aef,  // 925b
    0x7baa,  // 925c
    0x7dbb,  // 925d
    0x803d,  // 925e
    0x80c6,  // 925f
    0x86cb,  // 9260
    0x8a95,  // 9261
    0x935b,  // 9262
    0x56e3,  // 9263
    0x58c7,  // 9264
    0x5f3e,  // 9265
    0x65ad,  // 9266
    0x6696,  // 9267
    0x6a80,  // 9268
    0x6bb5,  // 9269
    0x7537,  // 926a
    0x8ac7,  // 926b
    0x5024,  // 926c
    0x77e5,  // 926d
    0x5730,  // 926e
    0x5f1b,  // 926f
    0x6065,  // 9270
    0x667a,  // 9271
    0x6c60,  // 9272
    0x75f4,  // 9273
    0x7a1a,  // 9274
    0x7f6e,  // 9275
    0x81f4,  // 9276
    0x8718,  // 9277
    0x9045,  // 9278
    0x99b3,  // 9279
    0x7bc9,  // 927a
    0x755c,  // 927b
    0x7af9,  // 927c
    0x7b51,  // 927d
    0x84c4,  // 927e
    0x0000,  // 927f
    0x9010,  // 9280
    0x79e9,  // 9281
    0x7a92,  // 9282
    0x8336,  // 9283
    0x5ae1,  // 9284
    0x7740,  // 9285
    0x4e2d,  // 9286
    0x4ef2,  // 9287
    0x5b99,  // 9288
    0x5fe0,  // 9289
    0x62bd,  // 928a
    0x663c,  // 928b
    0x67f1,  // 928c
    0x6ce8,  // 928d
    0x866b,  // 928e
    0x8877,  // 928f
    0x8a3b,  // 9290
    0x914e,  // 9291
    0x92f3,  // 9292
    0x99d0,  // 9293
    0x6a17,  // 9294
    0x7026,  // 9295
    0x732a,  // 9296
    0x82e7,  // 9297
    0x8457,  // 9298
    0x8caf,  // 9299
    0x4e01,  // 929a
    0x5146,  // 929b
    0x51cb,  // 929c
    0x558b,  // 929d
    0x5bf5,  // 929e
    0x5e16,  // 929f
    0x5e33,  // 92a0
    0x5e81,  // 92a1
    0x5f14,  // 92a2
    0x5f35,  // 92a3
    0x5f6b,  // 92a4
    0x5fb4,  // 92a5
    0x61f2,  // 92a6
    0x6311,  // 92a7
    0x66a2,  // 92a8
    0x671d,  // 92a9
    0x6f6e,  // 92aa
    0x7252,  // 92ab
    0x753a,  // 92ac
    0x773a,  // 92ad
    0x8074,  // 92ae
    0x8139,  // 92af
    0x8178,  // 92b0
    0x8776,  // 92b1
    0x8abf,  // 92b2
    0x8adc,  // 92b3
    0x8d85,  // 92b4
    0x8df3,  // 92b5
    0x929a,  // 92b6
    0x9577,  // 92b7
    0x9802,  // 92b8
    0x9ce5,  // 92b9
    0x52c5,  // 92ba
    0x6357,  // 92bb
    0x76f4,  // 92bc
    0x6715,  // 92bd
    0x6c88,  // 92be
    0x73cd,  // 92bf
    0x8cc3,  // 92c0
    0x93ae,  // 92c1
    0x9673,  // 92c2
    0x6d25,  // 92c3
    0x589c,  // 92c4
    0x690e,  // 92c5
    0x69cc,  // 92c6
    0x8ffd,  // 92c7
    0x939a,  // 92c8
    0x75db,  // 92c9
    0x901a,  // 92ca
    0x585a,  // 92cb
    0x6802,  // 92cc
    0x63b4,  // 92cd
    0x69fb,  // 92ce
    0x4f43,  // 92cf
    0x6f2c,  // 92d0
    0x67d8,  // 92d1
    0x8fbb,  // 92d2
    0x8526,  // 92d3
    0x7db4,  // 92d4
    0x9354,  // 92d5
    0x693f,  // 92d6
    0x6f70,  // 92d7
    0x576a,  // 92d8
    0x58f7,  // 92d9
    0x5b2c,  // 92da
    0x7d2c,  // 92db
    0x722a,  // 92dc
    0x540a,  // 92dd
    0x91e3,  // 92de
    0x9db4,  // 92df
    0x4ead,  // 92e0
    0x4f4e,  // 92e1
    0x505c,  // 92e2
    0x5075,  // 92e3
    0x5243,  // 92e4
    0x8c9e,  // 92e5
    0x5448,  // 92e6
    0x5824,  // 92e7
    0x5b9a,  // 92e8
    0x5e1d,  // 92e9
    0x5e95,  // 92ea
    0x5ead,  // 92eb
    0x5ef7,  // 92ec
    0x5f1f,  // 92ed
    0x608c,  // 92ee
    0x62b5,  // 92ef
    0x633a,  // 92f0
    0x63d0,  // 92f1
    0x68af,  // 92f2
    0x6c40,  // 92f3
    0x7887,  // 92f4
    0x798e,  // 92f5
    0x7a0b,  // 92f6
    0x7de0,  // 92f7
    0x8247,  // 92f8
    0x8a02,  // 92f9
    0x8ae6,  // 92fa
    0x8e44,  // 92fb
    0x9013,  // 92fc
    0x90b8,  // 9340
    0x912d,  // 9341
    0x91d8,  // 9342
    0x9f0e,  // 9343
    0x6ce5,  // 9344
    0x6458,  // 9345
    0x64e2,  // 9346
    0x6575,  // 9347
    0x6ef4,  // 9348
    0x7684,  // 9349
    0x7b1b,  // 934a
    0x9069,  // 934b
    0x93d1,  // 934c
    0x6eba,  // 934d
    0x54f2,  // 934e
    0x5fb9,  // 934f
    0x64a4,  // 9350
    0x8f4d,  // 9351
    0x8fed,  // 9352
    0x9244,  // 9353
    0x5178,  // 9354
    0x586b,  // 9355
    0x5929,  // 9356
    0x5c55,  // 9357
    0x5e97,  // 9358
    0x6dfb,  // 9359
    0x7e8f,  // 935a
    0x751c,  // 935b
    0x8cbc,  // 935c
    0x8ee2,  // 935d
    0x985b,  // 935e
    0x70b9,  // 935f
    0x4f1d,  // 9360
    0x6bbf,  // 9361
    0x6fb1,  // 9362
    0x7530,  // 9363
    0x96fb,  // 9364
    0x514e,  // 9365
    0x5410,  // 9366
    0x5835,  // 9367
    0x5857,  // 9368
    0x59ac,  // 9369
    0x5c60,  // 936a
    0x5f92,  // 936b
    0x6597,  // 936c
    0x675c,  // 936d
    0x6e21,  // 936e
    0x767b,  // 936f
    0x83df,  // 9370
    0x8ced,  // 9371
    0x9014,  // 9372
    0x90fd,  // 9373
    0x934d,  // 9374
    0x7825,  // 9375
    0x783a,  // 9376
    0x52aa,  // 9377
    0x5ea6,  // 9378
    0x571f,  // 9379
    0x5974,  // 937a
    0x6012,  // 937b
    0x5012,  // 937c
    0x515a,  // 937d
    0x51ac,  // 937e
    0x0000,  // 937f
    0x51cd,  // 9380
    0x5200,  // 9381
    0x5510,  // 9382
    0x5854,  // 9383
    0x5858,  // 9384
    0x5957,  // 9385
    0x5b95,  // 9386
    0x5cf6,  // 9387
    0x5d8b,  // 9388
    0x60bc,  // 9389
    0x6295,  // 938a
    0x642d,  // 938b
    0x6771,  // 938c
    0x6843,  // 938d
    0x68bc,  // 938e
    0x68df,  // 938f
    0x76d7,  // 9390
    0x6dd8,  // 9391
    0x6e6f,  // 9392
    0x6d9b,  // 9393
    0x706f,  // 9394
    0x71c8,  // 9395
    0x5f53,  // 9396
    0x75d8,  // 9397
    0x7977,  // 9398
    0x7b49,  // 9399
    0x7b54,  // 939a
    0x7b52,  // 939b
    0x7cd6,  // 939c
    0x7d71,  // 939d
    0x5230,  // 939e
    0x8463,  // 939f
    0x8569,  // 93a0
    0x85e4,  // 93a1
    0x8a0e,  // 93a2
    0x8b04,  // 93a3
    0x8c46,  // 93a4
    0x8e0f,  // 93a5
    0x9003,  // 93a6
    0x900f,  // 93a7
    0x9419,  // 93a8
    0x9676,  // 93a9
    0x982d,  // 93aa
    0x9a30,  // 93ab
    0x95d8,  // 93ac
    0x50cd,  // 93ad
    0x52d5,  // 93ae
    0x540c,  // 93af
    0x5802,  // 93b0
    0x5c0e,  // 93b1
    0x61a7,  // 93b2
    0x649e,  // 93b3
    0x6d1e,  // 93b4
    0x77b3,  // 93b5
    0x7ae5,  // 93b6
    0x80f4,  // 93b7
    0x8404,  // 93b8
    0x9053,  // 93b9
    0x9285,  // 93ba
    0x5ce0,  // 93bb
    0x9d07,  // 93bc
    0x533f,  // 93bd
    0x5f97,  // 93be
    0x5fb3,  // 93bf
    0x6d9c,  // 93c0
    0x7279,  // 93c1
    0x7763,  // 93c2
    0x79bf,  // 93c3
    0x7be4,  // 93c4
    0x6bd2,  // 93c5
    0x72ec,  // 93c6
    0x8aad,  // 93c7
    0x6803,  // 93c8
    0x6a61,  // 93c9
    0x51f8,  // 93ca
    0x7a81,  // 93cb
    0x6934,  // 93cc
    0x5c4a,  // 93cd
    0x9cf6,  // 93ce
    0x82eb,  // 93cf
    0x5bc5,  // 93d0
    0x9149,  // 93d1
    0x701e,  // 93d2
    0x5678,  // 93d3
    0x5c6f,  // 93d4
    0x60c7,  // 93d5
    0x6566,  // 93d6
    0x6c8c,  // 93d7
    0x8c5a,  // 93d8
    0x9041,  // 93d9
    0x9813,  // 93da
    0x5451,  // 93db
    0x66c7,  // 93dc
    0x920d,  // 93dd
    0x5948,  // 93de
    0x90a3,  // 93df
    0x5185,  // 93e0
    0x4e4d,  // 93e1
    0x51ea,  // 93e2
    0x8599,  // 93e3
    0x8b0e,  // 93e4
    0x7058,  // 93e5
    0x637a,  // 93e6
    0x934b,  // 93e7
    0x6962,  // 93e8
    0x99b4,  // 93e9
    0x7e04,  // 93ea
    0x7577,  // 93eb
    0x5357,  // 93ec
    0x6960,  // 93ed
    0x8edf,  // 93ee
    0x96e3,  // 93ef
    0x6c5d,  // 93f0
    0x4e8c,  // 93f1
    0x5c3c,  // 93f2
    0x5f10,  // 93f3
    0x8fe9,  // 93f4
    0x5302,  // 93f5
    0x8cd1,  // 93f6
    0x8089,  // 93f7
    0x8679,  // 93f8
    0x5eff,  // 93f9
    0x65e5,  // 93fa
    0x4e73,  // 93fb
    0x5165,  // 93fc
    0x5982,  // 9440
    0x5c3f,  // 9441
    0x97ee,  // 9442
    0x4efb,  // 9443
    0x598a,  // 9444
    0x5fcd,  // 9445
    0x8a8d,  // 9446
    0x6fe1,  // 9447
    0x79b0,  // 9448
    0x7962,  // 9449
    0x5be7,  // 944a
    0x8471,  // 944b
    0x732b,  // 944c
    0x71b1,  // 944d
    0x5e74,  // 944e
    0x5ff5,  // 944f
    0x637b,  // 9450
    0x649a,  // 9451
    0x71c3,  // 9452
    0x7c98,  // 9453
    0x4e43,  // 9454
    0x5efc,  // 9455
    0x4e4b,  // 9456
    0x57dc,  // 9457
    0x56a2,  // 9458
    0x60a9,  // 9459
    0x6fc3,  // 945a
    0x7d0d,  // 945b
    0x80fd,  // 945c
    0x8133,  // 945d
    0x81bf,  // 945e
    0x8fb2,  // 945f
    0x8997,  // 9460
    0x86a4,  // 9461
    0x5df4,  // 9462
    0x628a,  // 9463
    0x64ad,  // 9464
    0x8987,  // 9465
    0x6777,  // 9466
    0x6ce2,  // 9467
    0x6d3e,  // 9468
    0x7436,  // 9469
    0x7834,  // 946a
    0x5a46,  // 946b
    0x7f75,  // 946c
    0x82ad,  // 946d
    0x99ac,  // 946e
    0x4ff3,  // 946f
    0x5ec3,  // 9470
    0x62dd,  // 9471
    0x6392,  // 9472
    0x6557,  // 9473
    0x676f,  // 9474
    0x76c3,  // 9475
    0x724c,  // 9476
    0x80cc,  // 9477
    0x80ba,  // 9478
    0x8f29,  // 9479
    0x914d,  // 947a
    0x500d,  // 947b
    0x57f9,  // 947c
    0x5a92,  // 947d
    0x6885,  // 947e
    0x0000,  // 947f
    0x6973,  // 9480
    0x7164,  // 9481
    0x72fd,  // 9482
    0x8cb7,  // 9483
    0x58f2,  // 9484
    0x8ce0,  // 9485
    0x966a,  // 9486
    0x9019,  // 9487
    0x877f,  // 9488
    0x79e4,  // 9489
    0x77e7,  // 948a
    0x8429,  // 948b
    0x4f2f,  // 948c
    0x5265,  // 948d
    0x535a,  // 948e
    0x62cd,  // 948f
    0x67cf,  // 9490
    0x6cca,  // 9491
    0x767d,  // 9492
    0x7b94,  // 9493
    0x7c95,  // 9494
    0x8236,  // 9495
    0x8584,  // 9496
    0x8feb,  // 9497
    0x66dd,  // 9498
    0x6f20,  // 9499
    0x7206,  // 949a
    0x7e1b,  // 949b
    0x83ab,  // 949c
    0x99c1,  // 949d
    0x9ea6,  // 949e
    0x51fd,  // 949f
    0x7bb1,  // 94a0
    0x7872,  // 94a1
    0x7bb8,  // 94a2
    0x8087,  // 94a3
    0x7b48,  // 94a4
    0x6ae8,  // 94a5
    0x5e61,  // 94a6
    0x808c,  // 94a7
    0x7551,  // 94a8
    0x7560,  // 94a9
    0x516b,  // 94aa
    0x9262,  // 94ab
    0x6e8c,  // 94ac
    0x767a,  // 94ad
    0x9197,  // 94ae
    0x9aea,  // 94af
    0x4f10,  // 94b0
    0x7f70,  // 94b1
    0x629c,  // 94b2
    0x7b4f,  // 94b3
    0x95a5,  // 94b4
    0x9ce9,  // 94b5
    0x567a,  // 94b6
    0x5859,  // 94b7
    0x86e4,  // 94b8
    0x96bc,  // 94b9
    0x4f34,  // 94ba
    0x5224,  // 94bb
    0x534a,  // 94bc
    0x53cd,  // 94bd
    0x53db,  // 94be
    0x5e06,  // 94bf
    0x642c,  // 94c0
    0x6591,  // 94c1
    0x677f,  // 94c2
    0x6c3e,  // 94c3
    0x6c4e,  // 94c4
    0x7248,  // 94c5
    0x72af,  // 94c6
    0x73ed,  // 94c7
    0x7554,  // 94c8
    0x7e41,  // 94c9
    0x822c,  // 94ca
    0x85e9,  // 94cb
    0x8ca9,  // 94cc
    0x7bc4,  // 94cd
    0x91c6,  // 94ce
    0x7169,  // 94cf
    0x9812,  // 94d0
    0x98ef,  // 94d1
    0x633d,  // 94d2
    0x6669,  // 94d3
    0x756a,  // 94d4
    0x76e4,  // 94d5
    0x78d0,  // 94d6
    0x8543,  // 94d7
    0x86ee,  // 94d8
    0x532a,  // 94d9
    0x5351,  // 94da
    0x5426,  // 94db
    0x5983,  // 94dc
    0x5e87,  // 94dd
    0x5f7c,  // 94de
    0x60b2,  // 94df
    0x6249,  // 94e0
    0x6279,  // 94e1
    0x62ab,  // 94e2
    0x6590,  // 94e3
    0x6bd4,  // 94e4
    0x6ccc,  // 94e5
    0x75b2,  // 94e6
    0x76ae,  // 94e7
    0x7891,  // 94e8
    0x79d8,  // 94e9
    0x7dcb,  // 94ea
    0x7f77,  // 94eb
    0x80a5,  // 94ec
    0x88ab,  // 94ed
    0x8ab9,  // 94ee
    0x8cbb,  // 94ef
    0x907f,  // 94f0
    0x975e,  // 94f1
    0x98db,  // 94f2
    0x6a0b,  // 94f3
    0x7c38,  // 94f4
    0x5099,  // 94f5
    0x5c3e,  // 94f6
    0x5fae,  // 94f7
    0x6787,  // 94f8
    0x6bd8,  // 94f9
    0x7435,  // 94fa
    0x7709,  // 94fb
    0x7f8e,  // 94fc
    0x9f3b,  // 9540
    0x67ca,  // 9541
    0x7a17,  // 9542
    0x5339,  // 9543
    0x758b,  // 9544
    0x9aed,  // 9545
    0x5f66,  // 9546
    0x819d,  // 9547
    0x83f1,  // 9548
    0x8098,  // 9549
    0x5f3c,  // 954a
    0x5fc5,  // 954b
    0x7562,  // 954c
    0x7b46,  // 954d
    0x903c,  // 954e
    0x6867,  // 954f
    0x59eb,  // 9550
    0x5a9b,  // 9551
    0x7d10,  // 9552
    0x767e,  // 9553
    0x8b2c,  // 9554
    0x4ff5,  // 9555
    0x5f6a,  // 9556
    0x6a19,  // 9557
    0x6c37,  // 9558
    0x6f02,  // 9559
    0x74e2,  // 955a
    0x7968,  // 955b
    0x8868,  // 955c
    0x8a55,  // 955d
    0x8c79,  // 955e
    0x5edf,  // 955f
    0x63cf,  // 9560
    0x75c5,  // 9561
    0x79d2,  // 9562
    0x82d7,  // 9563
    0x9328,  // 9564
    0x92f2,  // 9565
    0x849c,  // 9566
    0x86ed,  // 9567
    0x9c2d,  // 9568
    0x54c1,  // 9569
    0x5f6c,  // 956a
    0x658c,  // 956b
    0x6d5c,  // 956c
    0x7015,  // 956d
    0x8ca7,  // 956e
    0x8cd3,  // 956f
    0x983b,  // 9570
    0x654f,  // 9571
    0x74f6,  // 9572
    0x4e0d,  // 9573
    0x4ed8,  // 9574
    0x57e0,  // 9575
    0x592b,  // 9576
    0x5a66,  // 9577
    0x5bcc,  // 9578
    0x51a8,  // 9579
    0x5e03,  // 957a
    0x5e9c,  // 957b
    0x6016,  // 957c
    0x6276,  // 957d
    0x6577,  // 957e
    0x0000,  // 957f
    0x65a7,  // 9580
    0x666e,  // 9581
    0x6d6e,  // 9582
    0x7236,  // 9583
    0x7b26,  // 9584
    0x8150,  // 9585
    0x819a,  // 9586
    0x8299,  // 9587
    0x8b5c,  // 9588
    0x8ca0,  // 9589
    0x8ce6,  // 958a
    0x8d74,  // 958b
    0x961c,  // 958c
    0x9644,  // 958d
    0x4fae,  // 958e
    0x64ab,  // 958f
    0x6b66,  // 9590
    0x821e,  // 9591
    0x8461,  // 9592
    0x856a,  // 9593
    0x90e8,  // 9594
    0x5c01,  // 9595
    0x6953,  // 9596
    0x98a8,  // 9597
    0x847a,  // 9598
    0x8557,  // 9599
    0x4f0f,  // 959a
    0x526f,  // 959b
    0x5fa9,  // 959c
    0x5e45,  // 959d
    0x670d,  // 959e
    0x798f,  // 959f
    0x8179,  // 95a0
    0x8907,  // 95a1
    0x8986,  // 95a2
    0x6df5,  // 95a3
    0x5f17,  // 95a4
    0x6255,  // 95a5
    0x6cb8,  // 95a6
    0x4ecf,  // 95a7
    0x7269,  // 95a8
    0x9b92,  // 95a9
    0x5206,  // 95aa
    0x543b,  // 95ab
    0x5674,  // 95ac
    0x58b3,  // 95ad
    0x61a4,  // 95ae
    0x626e,  // 95af
    0x711a,  // 95b0
    0x596e,  // 95b1
    0x7c89,  // 95b2
    0x7cde,  // 95b3
    0x7d1b,  // 95b4
    0x96f0,  // 95b5
    0x6587,  // 95b6
    0x805e,  // 95b7
    0x4e19,  // 95b8
    0x4f75,  // 95b9
    0x5175,  // 95ba
    0x5840,  // 95bb
    0x5e63,  // 95bc
    0x5e73,  // 95bd
    0x5f0a,  // 95be
    0x67c4,  // 95bf
    0x4e26,  // 95c0
    0x853d,  // 95c1
    0x9589,  // 95c2
    0x965b,  // 95c3
    0x7c73,  // 95c4
    0x9801,  // 95c5
    0x50fb,  // 95c6
    0x58c1,  // 95c7
    0x7656,  // 95c8
    0x78a7,  // 95c9
    0x5225,  // 95ca
    0x77a5,  // 95cb
    0x8511,  // 95cc
    0x7b86,  // 95cd
    0x504f,  // 95ce
    0x5909,  // 95cf
    0x7247,  // 95d0
    0x7bc7,  // 95d1
    0x7de8,  // 95d2
    0x8fba,  // 95d3
    0x8fd4,  // 95d4
    0x904d,  // 95d5
    0x4fbf,  // 95d6
    0x52c9,  // 95d7
    0x5a29,  // 95d8
    0x5f01,  // 95d9
    0x97ad,  // 95da
    0x4fdd,  // 95db
    0x8217,  // 95dc
    0x92ea,  // 95dd
    0x5703,  // 95de
    0x6355,  // 95df
    0x6b69,  // 95e0
    0x752b,  // 95e1
    0x88dc,  // 95e2
    0x8f14,  // 95e3
    0x7a42,  // 95e4
    0x52df,  // 95e5
    0x5893,  // 95e6
    0x6155,  // 95e7
    0x620a,  // 95e8
    0x66ae,  // 95e9
    0x6bcd,  // 95ea
    0x7c3f,  // 95eb
    0x83e9,  // 95ec
    0x5023,  // 95ed
    0x4ff8,  // 95ee
    0x5305,  // 95ef
    0x5446,  // 95f0
    0x5831,  // 95f1
    0x5949,  // 95f2
    0x5b9d,  // 95f3
    0x5cf0,  // 95f4
    0x5cef,  // 95f5
    0x5d29,  // 95f6
    0x5e96,  // 95f7
    0x62b1,  // 95f8
    0x6367,  // 95f9
    0x653e,  // 95fa
    0x65b9,  // 95fb
    0x670b,  // 95fc
    0x6cd5,  // 9640
    0x6ce1,  // 9641
    0x70f9,  // 9642
    0x7832,  // 9643
    0x7e2b,  // 9644
    0x80de,  // 9645
    0x82b3,  // 9646
    0x840c,  // 9647
    0x84ec,  // 9648
    0x8702,  // 9649
    0x8912,  // 964a
    0x8a2a,  // 964b
    0x8c4a,  // 964c
    0x90a6,  // 964d
    0x92d2,  // 964e
    0x98fd,  // 964f
    0x9cf3,  // 9650
    0x9d6c,  // 9651
    0x4e4f,  // 9652
    0x4ea1,  // 9653
    0x508d,  // 9654
    0x5256,  // 9655
    0x574a,  // 9656
    0x59a8,  // 9657
    0x5e3d,  // 9658
    0x5fd8,  // 9659
    0x5fd9,  // 965a
    0x623f,  // 965b
    0x66b4,  // 965c
    0x671b,  // 965d
    0x67d0,  // 965e
    0x68d2,  // 965f
    0x5192,  // 9660
    0x7d21,  // 9661
    0x80aa,  // 9662
    0x81a8,  // 9663
    0x8b00,  // 9664
    0x8c8c,  // 9665
    0x8cbf,  // 9666
    0x927e,  // 9667
    0x9632,  // 9668
    0x5420,  // 9669
    0x982c,  // 966a
    0x5317,  // 966b
    0x50d5,  // 966c
    0x535c,  // 966d
    0x58a8,  // 966e
    0x64b2,  // 966f
    0x6734,  // 9670
    0x7267,  // 9671
    0x7766,  // 9672
    0x7a46,  // 9673
    0x91e6,  // 9674
    0x52c3,  // 9675
    0x6ca1,  // 9676
    0x6b86,  // 9677
    0x5800,  // 9678
    0x5e4c,  // 9679
    0x5954,  // 967a
    0x672c,  // 967b
    0x7ffb,  // 967c
    0x51e1,  // 967d
    0x76c6,  // 967e
    0x0000,  // 967f
    0x6469,  // 9680
    0x78e8,  // 9681
    0x9b54,  // 9682
    0x9ebb,  // 9683
    0x57cb,  // 9684
    0x59b9,  // 9685
    0x6627,  // 9686
    0x679a,  // 9687
    0x6bce,  // 9688
    0x54e9,  // 9689
    0x69d9,  // 968a
    0x5e55,  // 968b
    0x819c,  // 968c
    0x6795,  // 968d
    0x9baa,  // 968e
    0x67fe,  // 968f
    0x9c52,  // 9690
    0x685d,  // 9691
    0x4ea6,  // 9692
    0x4fe3,  // 9693
    0x53c8,  // 9694
    0x62b9,  // 9695
    0x672b,  // 9696
    0x6cab,  // 9697
    0x8fc4,  // 9698
    0x4fad,  // 9699
    0x7e6d,  // 969a
    0x9ebf,  // 969b
    0x4e07,  // 969c
    0x6162,  // 969d
    0x6e80,  // 969e
    0x6f2b,  // 969f
    0x8513,  // 96a0
    0x5473,  // 96a1
    0x672a,  // 96a2
    0x9b45,  // 96a3
    0x5df3,  // 96a4
    0x7b95,  // 96a5
    0x5cac,  // 96a6
    0x5bc6,  // 96a7
    0x871c,  // 96a8
    0x6e4a,  // 96a9
    0x84d1,  // 96aa
    0x7a14,  // 96ab
    0x8108,  // 96ac
    0x5999,  // 96ad
    0x7c8d,  // 96ae
    0x6c11,  // 96af
    0x7720,  // 96b0
    0x52d9,  // 96b1
    0x5922,  // 96b2
    0x7121,  // 96b3
    0x725f,  // 96b4
    0x77db,  // 96b5
    0x9727,  // 96b6
    0x9d61,  // 96b7
    0x690b,  // 96b8
    0x5a7f,  // 96b9
    0x5a18,  // 96ba
    0x51a5,  // 96bb
    0x540d,  // 96bc
    0x547d,  // 96bd
    0x660e,  // 96be
    0x76df,  // 96bf
    0x8ff7,  // 96c0
    0x9298,  // 96c1
    0x9cf4,  // 96c2
    0x59ea,  // 96c3
    0x725d,  // 96c4
    0x6ec5,  // 96c5
    0x514d,  // 96c6
    0x68c9,  // 96c7
    0x7dbf,  // 96c8
    0x7dec,  // 96c9
    0x9762,  // 96ca
    0x9eba,  // 96cb
    0x6478,  // 96cc
    0x6a21,  // 96cd
    0x8302,  // 96ce
    0x5984,  // 96cf
    0x5b5f,  // 96d0
    0x6bdb,  // 96d1
    0x731b,  // 96d2
    0x76f2,  // 96d3
    0x7db2,  // 96d4
    0x8017,  // 96d5
    0x8499,  // 96d6
    0x5132,  // 96d7
    0x6728,  // 96d8
    0x9ed9,  // 96d9
    0x76ee,  // 96da
    0x6762,  // 96db
    0x52ff,  // 96dc
    0x9905,  // 96dd
    0x5c24,  // 96de
    0x623b,  // 96df
    0x7c7e,  // 96e0
    0x8cb0,  // 96e1
    0x554f,  // 96e2
    0x60b6,  // 96e3
    0x7d0b,  // 96e4
    0x9580,  // 96e5
    0x5301,  // 96e6
    0x4e5f,  // 96e7
    0x51b6,  // 96e8
    0x591c,  // 96e9
    0x723a,  // 96ea
    0x8036,  // 96eb
    0x91ce,  // 96ec
    0x5f25,  // 96ed
    0x77e2,  // 96ee
    0x5384,  // 96ef
    0x5f79,  // 96f0
    0x7d04,  // 96f1
    0x85ac,  // 96f2
    0x8a33,  // 96f3
    0x8e8d,  // 96f4
    0x9756,  // 96f5
    0x67f3,  // 96f6
    0x85ae,  // 96f7
    0x9453,  // 96f8
    0x6109,  // 96f9
    0x6108,  // 96fa
    0x6cb9,  // 96fb
    0x7652,  // 96fc
    0x8aed,  // 9740
    0x8f38,  // 9741
    0x552f,  // 9742
    0x4f51,  // 9743
    0x512a,  // 9744
    0x52c7,  // 9745
    0x53cb,  // 9746
    0x5ba5,  // 9747
    0x5e7d,  // 9748
    0x60a0,  // 9749
    0x6182,  // 974a
    0x63d6,  // 974b
    0x6709,  // 974c
    0x67da,  // 974d
    0x6e67,  // 974e
    0x6d8c,  // 974f
    0x7336,  // 9750
    0x7337,  // 9751
    0x7531,  // 9752
    0x7950,  // 9753
    0x88d5,  // 9754
    0x8a98,  // 9755
    0x904a,  // 9756
    0x9091,  // 9757
    0x90f5,  // 9758
    0x96c4,  // 9759
    0x878d,  // 975a
    0x5915,  // 975b
    0x4e88,  // 975c
    0x4f59,  // 975d
    0x4e0e,  // 975e
    0x8a89,  // 975f
    0x8f3f,  // 9760
    0x9810,  // 9761
    0x50ad,  // 9762
    0x5e7c,  // 9763
    0x5996,  // 9764
    0x5bb9,  // 9765
    0x5eb8,  // 9766
    0x63da,  // 9767
    0x63fa,  // 9768
    0x64c1,  // 9769
    0x66dc,  // 976a
    0x694a,  // 976b
    0x69d8,  // 976c
    0x6d0b,  // 976d
    0x6eb6,  // 976e
    0x7194,  // 976f
    0x7528,  // 9770
    0x7aaf,  // 9771
    0x7f8a,  // 9772
    0x8000,  // 9773
    0x8449,  // 9774
    0x84c9,  // 9775
    0x8981,  // 9776
    0x8b21,  // 9777
    0x8e0a,  // 9778
    0x9065,  // 9779
    0x967d,  // 977a
    0x990a,  // 977b
    0x617e,  // 977c
    0x6291,  // 977d
    0x6b32,  // 977e
    0x0000,  // 977f
    0x6c83,  // 9780
    0x6d74,  // 9781
    0x7fcc,  // 9782
    0x7ffc,  // 9783
    0x6dc0,  // 9784
    0x7f85,  // 9785
    0x87ba,  // 9786
    0x88f8,  // 9787
    0x6765,  // 9788
    0x83b1,  // 9789
    0x983c,  // 978a
    0x96f7,  // 978b
    0x6d1b,  // 978c
    0x7d61,  // 978d
    0x843d,  // 978e
    0x916a,  // 978f
    0x4e71,  // 9790
    0x5375,  // 9791
    0x5d50,  // 9792
    0x6b04,  // 9793
    0x6feb,  // 9794
    0x85cd,  // 9795
    0x862d,  // 9796
    0x89a7,  // 9797
    0x5229,  // 9798
    0x540f,  // 9799
    0x5c65,  // 979a
    0x674e,  // 979b
    0x68a8,  // 979c
    0x7406,  // 979d
    0x7483,  // 979e
    0x75e2,  // 979f
    0x88cf,  // 97a0
    0x88e1,  // 97a1
    0x91cc,  // 97a2
    0x96e2,  // 97a3
    0x9678,  // 97a4
    0x5f8b,  // 97a5
    0x7387,  // 97a6
    0x7acb,  // 97a7
    0x844e,  // 97a8
    0x63a0,  // 97a9
    0x7565,  // 97aa
    0x5289,  // 97ab
    0x6d41,  // 97ac
    0x6e9c,  // 97ad
    0x7409,  // 97ae
    0x7559,  // 97af
    0x786b,  // 97b0
    0x7c92,  // 97b1
    0x9686,  // 97b2
    0x7adc,  // 97b3
    0x9f8d,  // 97b4
    0x4fb6,  // 97b5
    0x616e,  // 97b6
    0x65c5,  // 97b7
    0x865c,  // 97b8
    0x4e86,  // 97b9
    0x4eae,  // 97ba
    0x50da,  // 97bb
    0x4e21,  // 97bc
    0x51cc,  // 97bd
    0x5bee,  // 97be
    0x6599,  // 97bf
    0x6881,  // 97c0
    0x6dbc,  // 97c1
    0x731f,  // 97c2
    0x7642,  // 97c3
    0x77ad,  // 97c4
    0x7a1c,  // 97c5
    0x7ce7,  // 97c6
    0x826f,  // 97c7
    0x8ad2,  // 97c8
    0x907c,  // 97c9
    0x91cf,  // 97ca
    0x9675,  // 97cb
    0x9818,  // 97cc
    0x529b,  // 97cd
    0x7dd1,  // 97ce
    0x502b,  // 97cf
    0x5398,  // 97d0
    0x6797,  // 97d1
    0x6dcb,  // 97d2
    0x71d0,  // 97d3
    0x7433,  // 97d4
    0x81e8,  // 97d5
    0x8f2a,  // 97d6
    0x96a3,  // 97d7
    0x9c57,  // 97d8
    0x9e9f,  // 97d9
    0x7460,  // 97da
    0x5841,  // 97db
    0x6d99,  // 97dc
    0x7d2f,  // 97dd
    0x985e,  // 97de
    0x4ee4,  // 97df
    0x4f36,  // 97e0
    0x4f8b,  // 97e1
    0x51b7,  // 97e2
    0x52b1,  // 97e3
    0x5dba,  // 97e4
    0x601c,  // 97e5
    0x73b2,  // 97e6
    0x793c,  // 97e7
    0x82d3,  // 97e8
    0x9234,  // 97e9
    0x96b7,  // 97ea
    0x96f6,  // 97eb
    0x970a,  // 97ec
    0x9e97,  // 97ed
    0x9f62,  // 97ee
    0x66a6,  // 97ef
    0x6b74,  // 97f0
    0x5217,  // 97f1
    0x52a3,  // 97f2
    0x70c8,  // 97f3
    0x88c2,  // 97f4
    0x5ec9,  // 97f5
    0x604b,  // 97f6
    0x6190,  // 97f7
    0x6f23,  // 97f8
    0x7149,  // 97f9
    0x7c3e,  // 97fa
    0x7df4,  // 97fb
    0x806f,  // 97fc
    0x84ee,  // 9840
    0x9023,  // 9841
    0x932c,  // 9842
    0x5442,  // 9843
    0x9b6f,  // 9844
    0x6ad3,  // 9845
    0x7089,  // 9846
    0x8cc2,  // 9847
    0x8def,  // 9848
    0x9732,  // 9849
    0x52b4,  // 984a
    0x5a41,  // 984b
    0x5eca,  // 984c
    0x5f04,  // 984d
    0x6717,  // 984e
    0x697c,  // 984f
    0x6994,  // 9850
    0x6d6a,  // 9851
    0x6f0f,  // 9852
    0x7262,  // 9853
    0x72fc,  // 9854
    0x7bed,  // 9855
    0x8001,  // 9856
    0x807e,  // 9857
    0x874b,  // 9858
    0x90ce,  // 9859
    0x516d,  // 985a
    0x9e93,  // 985b
    0x7984,  // 985c
    0x808b,  // 985d
    0x9332,  // 985e
    0x8ad6,  // 985f
    0x502d,  // 9860
    0x548c,  // 9861
    0x8a71,  // 9862
    0x6b6a,  // 9863
    0x8cc4,  // 9864
    0x8107,  // 9865
    0x60d1,  // 9866
    0x67a0,  // 9867
    0x9df2,  // 9868
    0x4e99,  // 9869
    0x4e98,  // 986a
    0x9c10,  // 986b
    0x8a6b,  // 986c
    0x85c1,  // 986d
    0x8568,  // 986e
    0x6900,  // 986f
    0x6e7e,  // 9870
    0x7897,  // 9871
    0x8155,  // 9872
    0x0000,  // 9873
    0x0000,  // 9874
    0x0000,  // 9875
    0x0000,  // 9876
    0x0000,  // 9877
    0x0000,  // 9878
    0x0000,  // 9879
    0x0000,  // 987a
    0x0000,  // 987b
    0x0000,  // 987c
    0x0000,  // 987d
    0x0000,  // 987e
    0x0000,  // 987f
    0x0000,  // 9880
    0x0000,  // 9881
    0x0000,  // 9882
    0x0000,  // 9883
    0x0000,  // 9884
    0x0000,  // 9885
    0x0000,  // 9886
    0x0000,  // 9887
    0x0000,  // 9888
    0x0000,  // 9889
    0x0000,  // 988a
    0x0000,  // 988b
    0x0000,  // 988c
    0x0000,  // 988d
    0x0000,  // 988e
    0x0000,  // 988f
    0x0000,  // 9890
    0x0000,  // 9891
    0x0000,  // 9892
    0x0000,  // 9893
    0x0000,  // 9894
    0x0000,  // 9895
    0x0000,  // 9896
    0x0000,  // 9897
    0x0000,  // 9898
    0x0000,  // 9899
    0x0000,  // 989a
    0x0000,  // 989b
    0x0000,  // 989c
    0x0000,  // 989d
    0x0000,  // 989e
    0x5f0c,  // 989f
    0x4e10,  // 98a0
    0x4e15,  // 98a1
    0x4e2a,  // 98a2
    0x4e31,  // 98a3
    0x4e36,  // 98a4
    0x4e3c,  // 98a5
    0x4e3f,  // 98a6
    0x4e42,  // 98a7
    0x4e56,  // 98a8
    0x4e58,  // 98a9
    0x4e82,  // 98aa
    0x4e85,  // 98ab
    0x8c6b,  // 98ac
    0x4e8a,  // 98ad
    0x8212,  // 98ae
    0x5f0d,  // 98af
    0x4e8e,  // 98b0
    0x4e9e,  // 98b1
    0x4e9f,  // 98b2
    0x4ea0,  // 98b3
    0x4ea2,  // 98b4
    0x4eb0,  // 98b5
    0x4eb3,  // 98b6
    0x4eb6,  // 98b7
    0x4ece,  // 98b8
    0x4ecd,  // 98b9
    0x4ec4,  // 98ba
    0x4ec6,  // 98bb
    0x4ec2,  // 98bc
    0x4ed7,  // 98bd
    0x4ede,  // 98be
    0x4eed,  // 98bf
    0x4edf,  // 98c0
    0x4ef7,  // 98c1
    0x4f09,  // 98c2
    0x4f5a,  // 98c3
    0x4f30,  // 98c4
    0x4f5b,  // 98c5
    0x4f5d,  // 98c6
    0x4f57,  // 98c7
    0x4f47,  // 98c8
    0x4f76,  // 98c9
    0x4f88,  // 98ca
    0x4f8f,  // 98cb
    0x4f98,  // 98cc
    0x4f7b,  // 98cd
    0x4f69,  // 98ce
    0x4f70,  // 98cf
    0x4f91,  // 98d0
    0x4f6f,  // 98d1
    0x4f86,  // 98d2
    0x4f96,  // 98d3
    0x5118,  // 98d4
    0x4fd4,  // 98d5
    0x4fdf,  // 98d6
    0x4fce,  // 98d7
    0x4fd8,  // 98d8
    0x4fdb,  // 98d9
    0x4fd1,  // 98da
    0x4fda,  // 98db
    0x4fd0,  // 98dc
    0x4fe4,  // 98dd
    0x4fe5,  // 98de
    0x501a,  // 98df
    0x5028,  // 98e0
    0x5014,  // 98e1
    0x502a,  // 98e2
    0x5025,  // 98e3
    0x5005,  // 98e4
    0x4f1c,  // 98e5
    0x4ff6,  // 98e6
    0x5021,  // 98e7
    0x5029,  // 98e8
    0x502c,  // 98e9
    0x4ffe,  // 98ea
    0x4fef,  // 98eb
    0x5011,  // 98ec
    0x5006,  // 98ed
    0x5043,  // 98ee
    0x5047,  // 98ef
    0x6703,  // 98f0
    0x5055,  // 98f1
    0x5050,  // 98f2
    0x5048,  // 98f3
    0x505a,  // 98f4
    0x5056,  // 98f5
    0x506c,  // 98f6
    0x5078,  // 98f7
    0x5080,  // 98f8
    0x509a,  // 98f9
    0x5085,  // 98fa
    0x50b4,  // 98fb
    0x50b2,  // 98fc
    0x50c9,  // 9940
    0x50ca,  // 9941
    0x50b3,  // 9942
    0x50c2,  // 9943
    0x50d6,  // 9944
    0x50de,  // 9945
    0x50e5,  // 9946
    0x50ed,  // 9947
    0x50e3,  // 9948
    0x50ee,  // 9949
    0x50f9,  // 994a
    0x50f5,  // 994b
    0x5109,  // 994c
    0x5101,  // 994d
    0x5102,  // 994e
    0x5116,  // 994f
    0x5115,  // 9950
    0x5114,  // 9951
    0x511a,  // 9952
    0x5121,  // 9953
    0x513a,  // 9954
    0x5137,  // 9955
    0x513c,  // 9956
    0x513b,  // 9957
    0x513f,  // 9958
    0x5140,  // 9959
    0x5152,  // 995a
    0x514c,  // 995b
    0x5154,  // 995c
    0x5162,  // 995d
    0x7af8,  // 995e
    0x5169,  // 995f
    0x516a,  // 9960
    0x516e,  // 9961
    0x5180,  // 9962
    0x5182,  // 9963
    0x56d8,  // 9964
    0x518c,  // 9965
    0x5189,  // 9966
    0x518f,  // 9967
    0x5191,  // 9968
    0x5193,  // 9969
    0x5195,  // 996a
    0x5196,  // 996b
    0x51a4,  // 996c
    0x51a6,  // 996d
    0x51a2,  // 996e
    0x51a9,  // 996f
    0x51aa,  // 9970
    0x51ab,  // 9971
    0x51b3,  // 9972
    0x51b1,  // 9973
    0x51b2,  // 9974
    0x51b0,  // 9975
    0x51b5,  // 9976
    0x51bd,  // 9977
    0x51c5,  // 9978
    0x51c9,  // 9979
    0x51db,  // 997a
    0x51e0,  // 997b
    0x8655,  // 997c
    0x51e9,  // 997d
    0x51ed,  // 997e
    0x0000,  // 997f
    0x51f0,  // 9980
    0x51f5,  // 9981
    0x51fe,  // 9982
    0x5204,  // 9983
    0x520b,  // 9984
    0x5214,  // 9985
    0x520e,  // 9986
    0x5227,  // 9987
    0x522a,  // 9988
    0x522e,  // 9989
    0x5233,  // 998a
    0x5239,  // 998b
    0x524f,  // 998c
    0x5244,  // 998d
    0x524b,  // 998e
    0x524c,  // 998f
    0x525e,  // 9990
    0x5254,  // 9991
    0x526a,  // 9992
    0x5274,  // 9993
    0x5269,  // 9994
    0x5273,  // 9995
    0x527f,  // 9996
    0x527d,  // 9997
    0x528d,  // 9998
    0x5294,  // 9999
    0x5292,  // 999a
    0x5271,  // 999b
    0x5288,  // 999c
    0x5291,  // 999d
    0x8fa8,  // 999e
    0x8fa7,  // 999f
    0x52ac,  // 99a0
    0x52ad,  // 99a1
    0x52bc,  // 99a2
    0x52b5,  // 99a3
    0x52c1,  // 99a4
    0x52cd,  // 99a5
    0x52d7,  // 99a6
    0x52de,  // 99a7
    0x52e3,  // 99a8
    0x52e6,  // 99a9
    0x98ed,  // 99aa
    0x52e0,  // 99ab
    0x52f3,  // 99ac
    0x52f5,  // 99ad
    0x52f8,  // 99ae
    0x52f9,  // 99af
    0x5306,  // 99b0
    0x5308,  // 99b1
    0x7538,  // 99b2
    0x530d,  // 99b3
    0x5310,  // 99b4
    0x530f,  // 99b5
    0x5315,  // 99b6
    0x531a,  // 99b7
    0x5323,  // 99b8
    0x532f,  // 99b9
    0x5331,  // 99ba
    0x5333,  // 99bb
    0x5338,  // 99bc
    0x5340,  // 99bd
    0x5346,  // 99be
    0x5345,  // 99bf
    0x4e17,  // 99c0
    0x5349,  // 99c1
    0x534d,  // 99c2
    0x51d6,  // 99c3
    0x535e,  // 99c4
    0x5369,  // 99c5
    0x536e,  // 99c6
    0x5918,  // 99c7
    0x537b,  // 99c8
    0x5377,  // 99c9
    0x5382,  // 99ca
    0x5396,  // 99cb
    0x53a0,  // 99cc
    0x53a6,  // 99cd
    0x53a5,  // 99ce
    0x53ae,  // 99cf
    0x53b0,  // 99d0
    0x53b6,  // 99d1
    0x53c3,  // 99d2
    0x7c12,  // 99d3
    0x96d9,  // 99d4
    0x53df,  // 99d5
    0x66fc,  // 99d6
    0x71ee,  // 99d7
    0x53ee,  // 99d8
    0x53e8,  // 99d9
    0x53ed,  // 99da
    0x53fa,  // 99db
    0x5401,  // 99dc
    0x543d,  // 99dd
    0x5440,  // 99de
    0x542c,  // 99df
    0x542d,  // 99e0
    0x543c,  // 99e1
    0x542e,  // 99e2
    0x5436,  // 99e3
    0x5429,  // 99e4
    0x541d,  // 99e5
    0x544e,  // 99e6
    0x548f,  // 99e7
    0x5475,  // 99e8
    0x548e,  // 99e9
    0x545f,  // 99ea
    0x5471,  // 99eb
    0x5477,  // 99ec
    0x5470,  // 99ed
    0x5492,  // 99ee
    0x547b,  // 99ef
    0x5480,  // 99f0
    0x5476,  // 99f1
    0x5484,  // 99f2
    0x5490,  // 99f3
    0x5486,  // 99f4
    0x54c7,  // 99f5
    0x54a2,  // 99f6
    0x54b8,  // 99f7
    0x54a5,  // 99f8
    0x54ac,  // 99f9
    0x54c4,  // 99fa
    0x54c8,  // 99fb
    0x54a8,  // 99fc
    0x54ab,  // 9a40
    0x54c2,  // 9a41
    0x54a4,  // 9a42
    0x54be,  // 9a43
    0x54bc,  // 9a44
    0x54d8,  // 9a45
    0x54e5,  // 9a46
    0x54e6,  // 9a47
    0x550f,  // 9a48
    0x5514,  // 9a49
    0x54fd,  // 9a4a
    0x54ee,  // 9a4b
    0x54ed,  // 9a4c
    0x54fa,  // 9a4d
    0x54e2,  // 9a4e
    0x5539,  // 9a4f
    0x5540,  // 9a50
    0x5563,  // 9a51
    0x554c,  // 9a52
    0x552e,  // 9a53
    0x555c,  // 9a54
    0x5545,  // 9a55
    0x5556,  // 9a56
    0x5557,  // 9a57
    0x5538,  // 9a58
    0x5533,  // 9a59
    0x555d,  // 9a5a
    0x5599,  // 9a5b
    0x5580,  // 9a5c
    0x54af,  // 9a5d
    0x558a,  // 9a5e
    0x559f,  // 9a5f
    0x557b,  // 9a60
    0x557e,  // 9a61
    0x5598,  // 9a62
    0x559e,  // 9a63
    0x55ae,  // 9a64
    0x557c,  // 9a65
    0x5583,  // 9a66
    0x55a9,  // 9a67
    0x5587,  // 9a68
    0x55a8,  // 9a69
    0x55da,  // 9a6a
    0x55c5,  // 9a6b
    0x55df,  // 9a6c
    0x55c4,  // 9a6d
    0x55dc,  // 9a6e
    0x55e4,  // 9a6f
    0x55d4,  // 9a70
    0x5614,  // 9a71
    0x55f7,  // 9a72
    0x5616,  // 9a73
    0x55fe,  // 9a74
    0x55fd,  // 9a75
    0x561b,  // 9a76
    0x55f9,  // 9a77
    0x564e,  // 9a78
    0x5650,  // 9a79
    0x71df,  // 9a7a
    0x5634,  // 9a7b
    0x5636,  // 9a7c
    0x5632,  // 9a7d
    0x5638,  // 9a7e
    0x0000,  // 9a7f
    0x566b,  // 9a80
    0x5664,  // 9a81
    0x562f,  // 9a82
    0x566c,  // 9a83
    0x566a,  // 9a84
    0x5686,  // 9a85
    0x5680,  // 9a86
    0x568a,  // 9a87
    0x56a0,  // 9a88
    0x5694,  // 9a89
    0x568f,  // 9a8a
    0x56a5,  // 9a8b
    0x56ae,  // 9a8c
    0x56b6,  // 9a8d
    0x56b4,  // 9a8e
    0x56c2,  // 9a8f
    0x56bc,  // 9a90
    0x56c1,  // 9a91
    0x56c3,  // 9a92
    0x56c0,  // 9a93
    0x56c8,  // 9a94
    0x56ce,  // 9a95
    0x56d1,  // 9a96
    0x56d3,  // 9a97
    0x56d7,  // 9a98
    0x56ee,  // 9a99
    0x56f9,  // 9a9a
    0x5700,  // 9a9b
    0x56ff,  // 9a9c
    0x5704,  // 9a9d
    0x5709,  // 9a9e
    0x5708,  // 9a9f
    0x570b,  // 9aa0
    0x570d,  // 9aa1
    0x5713,  // 9aa2
    0x5718,  // 9aa3
    0x5716,  // 9aa4
    0x55c7,  // 9aa5
    0x571c,  // 9aa6
    0x5726,  // 9aa7
    0x5737,  // 9aa8
    0x5738,  // 9aa9
    0x574e,  // 9aaa
    0x573b,  // 9aab
    0x5740,  // 9aac
    0x574f,  // 9aad
    0x5769,  // 9aae
    0x57c0,  // 9aaf
    0x5788,  // 9ab0
    0x5761,  // 9ab1
    0x577f,  // 9ab2
    0x5789,  // 9ab3
    0x5793,  // 9ab4
    0x57a0,  // 9ab5
    0x57b3,  // 9ab6
    0x57a4,  // 9ab7
    0x57aa,  // 9ab8
    0x57b0,  // 9ab9
    0x57c3,  // 9aba
    0x57c6,  // 9abb
    0x57d4,  // 9abc
    0x57d2,  // 9abd
    0x57d3,  // 9abe
    0x580a,  // 9abf
    0x57d6,  // 9ac0
    0x57e3,  // 9ac1
    0x580b,  // 9ac2
    0x5819,  // 9ac3
    0x581d,  // 9ac4
    0x5872,  // 9ac5
    0x5821,  // 9ac6
    0x5862,  // 9ac7
    0x584b,  // 9ac8
    0x5870,  // 9ac9
    0x6bc0,  // 9aca
    0x5852,  // 9acb
    0x583d,  // 9acc
    0x5879,  // 9acd
    0x5885,  // 9ace
    0x58b9,  // 9acf
    0x589f,  // 9ad0
    0x58ab,  // 9ad1
    0x58ba,  // 9ad2
    0x58de,  // 9ad3
    0x58bb,  // 9ad4
    0x58b8,  // 9ad5
    0x58ae,  // 9ad6
    0x58c5,  // 9ad7
    0x58d3,  // 9ad8
    0x58d1,  // 9ad9
    0x58d7,  // 9ada
    0x58d9,  // 9adb
    0x58d8,  // 9adc
    0x58e5,  // 9add
    0x58dc,  // 9ade
    0x58e4,  // 9adf
    0x58df,  // 9ae0
    0x58ef,  // 9ae1
    0x58fa,  // 9ae2
    0x58f9,  // 9ae3
    0x58fb,  // 9ae4
    0x58fc,  // 9ae5
    0x58fd,  // 9ae6
    0x5902,  // 9ae7
    0x590a,  // 9ae8
    0x5910,  // 9ae9
    0x591b,  // 9aea
    0x68a6,  // 9aeb
    0x5925,  // 9aec
    0x592c,  // 9aed
    0x592d,  // 9aee
    0x5932,  // 9aef
    0x5938,  // 9af0
    0x593e,  // 9af1
    0x7ad2,  // 9af2
    0x5955,  // 9af3
    0x5950,  // 9af4
    0x594e,  // 9af5
    0x595a,  // 9af6
    0x5958,  // 9af7
    0x5962,  // 9af8
    0x5960,  // 9af9
    0x5967,  // 9afa
    0x596c,  // 9afb
    0x5969,  // 9afc
    0x5978,  // 9b40
    0x5981,  // 9b41
    0x599d,  // 9b42
    0x4f5e,  // 9b43
    0x4fab,  // 9b44
    0x59a3,  // 9b45
    0x59b2,  // 9b46
    0x59c6,  // 9b47
    0x59e8,  // 9b48
    0x59dc,  // 9b49
    0x598d,  // 9b4a
    0x59d9,  // 9b4b
    0x59da,  // 9b4c
    0x5a25,  // 9b4d
    0x5a1f,  // 9b4e
    0x5a11,  // 9b4f
    0x5a1c,  // 9b50
    0x5a09,  // 9b51
    0x5a1a,  // 9b52
    0x5a40,  // 9b53
    0x5a6c,  // 9b54
    0x5a49,  // 9b55
    0x5a35,  // 9b56
    0x5a36,  // 9b57
    0x5a62,  // 9b58
    0x5a6a,  // 9b59
    0x5a9a,  // 9b5a
    0x5abc,  // 9b5b
    0x5abe,  // 9b5c
    0x5acb,  // 9b5d
    0x5ac2,  // 9b5e
    0x5abd,  // 9b5f
    0x5ae3,  // 9b60
    0x5ad7,  // 9b61
    0x5ae6,  // 9b62
    0x5ae9,  // 9b63
    0x5ad6,  // 9b64
    0x5afa,  // 9b65
    0x5afb,  // 9b66
    0x5b0c,  // 9b67
    0x5b0b,  // 9b68
    0x5b16,  // 9b69
    0x5b32,  // 9b6a
    0x5ad0,  // 9b6b
    0x5b2a,  // 9b6c
    0x5b36,  // 9b6d
    0x5b3e,  // 9b6e
    0x5b43,  // 9b6f
    0x5b45,  // 9b70
    0x5b40,  // 9b71
    0x5b51,  // 9b72
    0x5b55,  // 9b73
    0x5b5a,  // 9b74
    0x5b5b,  // 9b75
    0x5b65,  // 9b76
    0x5b69,  // 9b77
    0x5b70,  // 9b78
    0x5b73,  // 9b79
    0x5b75,  // 9b7a
    0x5b78,  // 9b7b
    0x6588,  // 9b7c
    0x5b7a,  // 9b7d
    0x5b80,  // 9b7e
    0x0000,  // 9b7f
    0x5b83,  // 9b80
    0x5ba6,  // 9b81
    0x5bb8,  // 9b82
    0x5bc3,  // 9b83
    0x5bc7,  // 9b84
    0x5bc9,  // 9b85
    0x5bd4,  // 9b86
    0x5bd0,  // 9b87
    0x5be4,  // 9b88
    0x5be6,  // 9b89
    0x5be2,  // 9b8a
    0x5bde,  // 9b8b
    0x5be5,  // 9b8c
    0x5beb,  // 9b8d
    0x5bf0,  // 9b8e
    0x5bf6,  // 9b8f
    0x5bf3,  // 9b90
    0x5c05,  // 9b91
    0x5c07,  // 9b92
    0x5c08,  // 9b93
    0x5c0d,  // 9b94
    0x5c13,  // 9b95
    0x5c20,  // 9b96
    0x5c22,  // 9b97
    0x5c28,  // 9b98
    0x5c38,  // 9b99
    0x5c39,  // 9b9a
    0x5c41,  // 9b9b
    0x5c46,  // 9b9c
    0x5c4e,  // 9b9d
    0x5c53,  // 9b9e
    0x5c50,  // 9b9f
    0x5c4f,  // 9ba0
    0x5b71,  // 9ba1
    0x5c6c,  // 9ba2
    0x5c6e,  // 9ba3
    0x4e62,  // 9ba4
    0x5c76,  // 9ba5
    0x5c79,  // 9ba6
    0x5c8c,  // 9ba7
    0x5c91,  // 9ba8
    0x5c94,  // 9ba9
    0x599b,  // 9baa
    0x5cab,  // 9bab
    0x5cbb,  // 9bac
    0x5cb6,  // 9bad
    0x5cbc,  // 9bae
    0x5cb7,  // 9baf
    0x5cc5,  // 9bb0
    0x5cbe,  // 9bb1
    0x5cc7,  // 9bb2
    0x5cd9,  // 9bb3
    0x5ce9,  // 9bb4
    0x5cfd,  // 9bb5
    0x5cfa,  // 9bb6
    0x5ced,  // 9bb7
    0x5d8c,  // 9bb8
    0x5cea,  // 9bb9
    0x5d0b,  // 9bba
    0x5d15,  // 9bbb
    0x5d17,  // 9bbc
    0x5d5c,  // 9bbd
    0x5d1f,  // 9bbe
    0x5d1b,  // 9bbf
    0x5d11,  // 9bc0
    0x5d14,  // 9bc1
    0x5d22,  // 9bc2
    0x5d1a,  // 9bc3
    0x5d19,  // 9bc4
    0x5d18,  // 9bc5
    0x5d4c,  // 9bc6
    0x5d52,  // 9bc7
    0x5d4e,  // 9bc8
    0x5d4b,  // 9bc9
    0x5d6c,  // 9bca
    0x5d73,  // 9bcb
    0x5d76,  // 9bcc
    0x5d87,  // 9bcd
    0x5d84,  // 9bce
    0x5d82,  // 9bcf
    0x5da2,  // 9bd0
    0x5d9d,  // 9bd1
    0x5dac,  // 9bd2
    0x5dae,  // 9bd3
    0x5dbd,  // 9bd4
    0x5d90,  // 9bd5
    0x5db7,  // 9bd6
    0x5dbc,  // 9bd7
    0x5dc9,  // 9bd8
    0x5dcd,  // 9bd9
    0x5dd3,  // 9bda
    0x5dd2,  // 9bdb
    0x5dd6,  // 9bdc
    0x5ddb,  // 9bdd
    0x5deb,  // 9bde
    0x5df2,  // 9bdf
    0x5df5,  // 9be0
    0x5e0b,  // 9be1
    0x5e1a,  // 9be2
    0x5e19,  // 9be3
    0x5e11,  // 9be4
    0x5e1b,  // 9be5
    0x5e36,  // 9be6
    0x5e37,  // 9be7
    0x5e44,  // 9be8
    0x5e43,  // 9be9
    0x5e40,  // 9bea
    0x5e4e,  // 9beb
    0x5e57,  // 9bec
    0x5e54,  // 9bed
    0x5e5f,  // 9bee
    0x5e62,  // 9bef
    0x5e64,  // 9bf0
    0x5e47,  // 9bf1
    0x5e75,  // 9bf2
    0x5e76,  // 9bf3
    0x5e7a,  // 9bf4
    0x9ebc,  // 9bf5
    0x5e7f,  // 9bf6
    0x5ea0,  // 9bf7
    0x5ec1,  // 9bf8
    0x5ec2,  // 9bf9
    0x5ec8,  // 9bfa
    0x5ed0,  // 9bfb
    0x5ecf,  // 9bfc
    0x5ed6,  // 9c40
    0x5ee3,  // 9c41
    0x5edd,  // 9c42
    0x5eda,  // 9c43
    0x5edb,  // 9c44
    0x5ee2,  // 9c45
    0x5ee1,  // 9c46
    0x5ee8,  // 9c47
    0x5ee9,  // 9c48
    0x5eec,  // 9c49
    0x5ef1,  // 9c4a
    0x5ef3,  // 9c4b
    0x5ef0,  // 9c4c
    0x5ef4,  // 9c4d
    0x5ef8,  // 9c4e
    0x5efe,  // 9c4f
    0x5f03,  // 9c50
    0x5f09,  // 9c51
    0x5f5d,  // 9c52
    0x5f5c,  // 9c53
    0x5f0b,  // 9c54
    0x5f11,  // 9c55
    0x5f16,  // 9c56
    0x5f29,  // 9c57
    0x5f2d,  // 9c58
    0x5f38,  // 9c59
    0x5f41,  // 9c5a
    0x5f48,  // 9c5b
    0x5f4c,  // 9c5c
    0x5f4e,  // 9c5d
    0x5f2f,  // 9c5e
    0x5f51,  // 9c5f
    0x5f56,  // 9c60
    0x5f57,  // 9c61
    0x5f59,  // 9c62
    0x5f61,  // 9c63
    0x5f6d,  // 9c64
    0x5f73,  // 9c65
    0x5f77,  // 9c66
    0x5f83,  // 9c67
    0x5f82,  // 9c68
    0x5f7f,  // 9c69
    0x5f8a,  // 9c6a
    0x5f88,  // 9c6b
    0x5f91,  // 9c6c
    0x5f87,  // 9c6d
    0x5f9e,  // 9c6e
    0x5f99,  // 9c6f
    0x5f98,  // 9c70
    0x5fa0,  // 9c71
    0x5fa8,  // 9c72
    0x5fad,  // 9c73
    0x5fbc,  // 9c74
    0x5fd6,  // 9c75
    0x5ffb,  // 9c76
    0x5fe4,  // 9c77
    0x5ff8,  // 9c78
    0x5ff1,  // 9c79
    0x5fdd,  // 9c7a
    0x60b3,  // 9c7b
    0x5fff,  // 9c7c
    0x6021,  // 9c7d
    0x6060,  // 9c7e
    0x0000,  // 9c7f
    0x6019,  // 9c80
    0x6010,  // 9c81
    0x6029,  // 9c82
    0x600e,  // 9c83
    0x6031,  // 9c84
    0x601b,  // 9c85
    0x6015,  // 9c86
    0x602b,  // 9c87
    0x6026,  // 9c88
    0x600f,  // 9c89
    0x603a,  // 9c8a
    0x605a,  // 9c8b
    0x6041,  // 9c8c
    0x606a,  // 9c8d
    0x6077,  // 9c8e
    0x605f,  // 9c8f
    0x604a,  // 9c90
    0x6046,  // 9c91
    0x604d,  // 9c92
    0x6063,  // 9c93
    0x6043,  // 9c94
    0x6064,  // 9c95
    0x6042,  // 9c96
    0x606c,  // 9c97
    0x606b,  // 9c98
    0x6059,  // 9c99
    0x6081,  // 9c9a
    0x608d,  // 9c9b
    0x60e7,  // 9c9c
    0x6083,  // 9c9d
    0x609a,  // 9c9e
    0x6084,  // 9c9f
    0x609b,  // 9ca0
    0x6096,  // 9ca1
    0x6097,  // 9ca2
    0x6092,  // 9ca3
    0x60a7,  // 9ca4
    0x608b,  // 9ca5
    0x60e1,  // 9ca6
    0x60b8,  // 9ca7
    0x60e0,  // 9ca8
    0x60d3,  // 9ca9
    0x60b4,  // 9caa
    0x5ff0,  // 9cab
    0x60bd,  // 9cac
    0x60c6,  // 9cad
    0x60b5,  // 9cae
    0x60d8,  // 9caf
    0x614d,  // 9cb0
    0x6115,  // 9cb1
    0x6106,  // 9cb2
    0x60f6,  // 9cb3
    0x60f7,  // 9cb4
    0x6100,  // 9cb5
    0x60f4,  // 9cb6
    0x60fa,  // 9cb7
    0x6103,  // 9cb8
    0x6121,  // 9cb9
    0x60fb,  // 9cba
    0x60f1,  // 9cbb
    0x610d,  // 9cbc
    0x610e,  // 9cbd
    0x6147,  // 9cbe
    0x613e,  // 9cbf
    0x6128,  // 9cc0
    0x6127,  // 9cc1
    0x614a,  // 9cc2
    0x613f,  // 9cc3
    0x613c,  // 9cc4
    0x612c,  // 9cc5
    0x6134,  // 9cc6
    0x613d,  // 9cc7
    0x6142,  // 9cc8
    0x6144,  // 9cc9
    0x6173,  // 9cca
    0x6177,  // 9ccb
    0x6158,  // 9ccc
    0x6159,  // 9ccd
    0x615a,  // 9cce
    0x616b,  // 9ccf
    0x6174,  // 9cd0
    0x616f,  // 9cd1
    0x6165,  // 9cd2
    0x6171,  // 9cd3
    0x615f,  // 9cd4
    0x615d,  // 9cd5
    0x6153,  // 9cd6
    0x6175,  // 9cd7
    0x6199,  // 9cd8
    0x6196,  // 9cd9
    0x6187,  // 9cda
    0x61ac,  // 9cdb
    0x6194,  // 9cdc
    0x619a,  // 9cdd
    0x618a,  // 9cde
    0x6191,  // 9cdf
    0x61ab,  // 9ce0
    0x61ae,  // 9ce1
    0x61cc,  // 9ce2
    0x61ca,  // 9ce3
    0x61c9,  // 9ce4
    0x61f7,  // 9ce5
    0x61c8,  // 9ce6
    0x61c3,  // 9ce7
    0x61c6,  // 9ce8
    0x61ba,  // 9ce9
    0x61cb,  // 9cea
    0x7f79,  // 9ceb
    0x61cd,  // 9cec
    0x61e6,  // 9ced
    0x61e3,  // 9cee
    0x61f6,  // 9cef
    0x61fa,  // 9cf0
    0x61f4,  // 9cf1
    0x61ff,  // 9cf2
    0x61fd,  // 9cf3
    0x61fc,  // 9cf4
    0x61fe,  // 9cf5
    0x6200,  // 9cf6
    0x6208,  // 9cf7
    0x6209,  // 9cf8
    0x620d,  // 9cf9
    0x620c,  // 9cfa
    0x6214,  // 9cfb
    0x621b,  // 9cfc
    0x621e,  // 9d40
    0x6221,  // 9d41
    0x622a,  // 9d42
    0x622e,  // 9d43
    0x6230,  // 9d44
    0x6232,  // 9d45
    0x6233,  // 9d46
    0x6241,  // 9d47
    0x624e,  // 9d48
    0x625e,  // 9d49
    0x6263,  // 9d4a
    0x625b,  // 9d4b
    0x6260,  // 9d4c
    0x6268,  // 9d4d
    0x627c,  // 9d4e
    0x6282,  // 9d4f
    0x6289,  // 9d50
    0x627e,  // 9d51
    0x6292,  // 9d52
    0x6293,  // 9d53
    0x6296,  // 9d54
    0x62d4,  // 9d55
    0x6283,  // 9d56
    0x6294,  // 9d57
    0x62d7,  // 9d58
    0x62d1,  // 9d59
    0x62bb,  // 9d5a
    0x62cf,  // 9d5b
    0x62ff,  // 9d5c
    0x62c6,  // 9d5d
    0x64d4,  // 9d5e
    0x62c8,  // 9d5f
    0x62dc,  // 9d60
    0x62cc,  // 9d61
    0x62ca,  // 9d62
    0x62c2,  // 9d63
    0x62c7,  // 9d64
    0x629b,  // 9d65
    0x62c9,  // 9d66
    0x630c,  // 9d67
    0x62ee,  // 9d68
    0x62f1,  // 9d69
    0x6327,  // 9d6a
    0x6302,  // 9d6b
    0x6308,  // 9d6c
    0x62ef,  // 9d6d
    0x62f5,  // 9d6e
    0x6350,  // 9d6f
    0x633e,  // 9d70
    0x634d,  // 9d71
    0x641c,  // 9d72
    0x634f,  // 9d73
    0x6396,  // 9d74
    0x638e,  // 9d75
    0x6380,  // 9d76
    0x63ab,  // 9d77
    0x6376,  // 9d78
    0x63a3,  // 9d79
    0x638f,  // 9d7a
    0x6389,  // 9d7b
    0x639f,  // 9d7c
    0x63b5,  // 9d7d
    0x636b,  // 9d7e
    0x0000,  // 9d7f
    0x6369,  // 9d80
    0x63be,  // 9d81
    0x63e9,  // 9d82
    0x63c0,  // 9d83
    0x63c6,  // 9d84
    0x63e3,  // 9d85
    0x63c9,  // 9d86
    0x63d2,  // 9d87
    0x63f6,  // 9d88
    0x63c4,  // 9d89
    0x6416,  // 9d8a
    0x6434,  // 9d8b
    0x6406,  // 9d8c
    0x6413,  // 9d8d
    0x6426,  // 9d8e
    0x6436,  // 9d8f
    0x651d,  // 9d90
    0x6417,  // 9d91
    0x6428,  // 9d92
    0x640f,  // 9d93
    0x6467,  // 9d94
    0x646f,  // 9d95
    0x6476,  // 9d96
    0x644e,  // 9d97
    0x652a,  // 9d98
    0x6495,  // 9d99
    0x6493,  // 9d9a
    0x64a5,  // 9d9b
    0x64a9,  // 9d9c
    0x6488,  // 9d9d
    0x64bc,  // 9d9e
    0x64da,  // 9d9f
    0x64d2,  // 9da0
    0x64c5,  // 9da1
    0x64c7,  // 9da2
    0x64bb,  // 9da3
    0x64d8,  // 9da4
    0x64c2,  // 9da5
    0x64f1,  // 9da6
    0x64e7,  // 9da7
    0x8209,  // 9da8
    0x64e0,  // 9da9
    0x64e1,  // 9daa
    0x62ac,  // 9dab
    0x64e3,  // 9dac
    0x64ef,  // 9dad
    0x652c,  // 9dae
    0x64f6,  // 9daf
    0x64f4,  // 9db0
    0x64f2,  // 9db1
    0x64fa,  // 9db2
    0x6500,  // 9db3
    0x64fd,  // 9db4
    0x6518,  // 9db5
    0x651c,  // 9db6
    0x6505,  // 9db7
    0x6524,  // 9db8
    0x6523,  // 9db9
    0x652b,  // 9dba
    0x6534,  // 9dbb
    0x6535,  // 9dbc
    0x6537,  // 9dbd
    0x6536,  // 9dbe
    0x6538,  // 9dbf
    0x754b,  // 9dc0
    0x6548,  // 9dc1
    0x6556,  // 9dc2
    0x6555,  // 9dc3
    0x654d,  // 9dc4
    0x6558,  // 9dc5
    0x655e,  // 9dc6
    0x655d,  // 9dc7
    0x6572,  // 9dc8
    0x6578,  // 9dc9
    0x6582,  // 9dca
    0x6583,  // 9dcb
    0x8b8a,  // 9dcc
    0x659b,  // 9dcd
    0x659f,  // 9dce
    0x65ab,  // 9dcf
    0x65b7,  // 9dd0
    0x65c3,  // 9dd1
    0x65c6,  // 9dd2
    0x65c1,  // 9dd3
    0x65c4,  // 9dd4
    0x65cc,  // 9dd5
    0x65d2,  // 9dd6
    0x65db,  // 9dd7
    0x65d9,  // 9dd8
    0x65e0,  // 9dd9
    0x65e1,  // 9dda
    0x65f1,  // 9ddb
    0x6772,  // 9ddc
    0x660a,  // 9ddd
    0x6603,  // 9dde
    0x65fb,  // 9ddf
    0x6773,  // 9de0
    0x6635,  // 9de1
    0x6636,  // 9de2
    0x6634,  // 9de3
    0x661c,  // 9de4
    0x664f,  // 9de5
    0x6644,  // 9de6
    0x6649,  // 9de7
    0x6641,  // 9de8
    0x665e,  // 9de9
    0x665d,  // 9dea
    0x6664,  // 9deb
    0x6667,  // 9dec
    0x6668,  // 9ded
    0x665f,  // 9dee
    0x6662,  // 9def
    0x6670,  // 9df0
    0x6683,  // 9df1
    0x6688,  // 9df2
    0x668e,  // 9df3
    0x6689,  // 9df4
    0x6684,  // 9df5
    0x6698,  // 9df6
    0x669d,  // 9df7
    0x66c1,  // 9df8
    0x66b9,  // 9df9
    0x66c9,  // 9dfa
    0x66be,  // 9dfb
    0x66bc,  // 9dfc
    0x66c4,  // 9e40
    0x66b8,  // 9e41
    0x66d6,  // 9e42
    0x66da,  // 9e43
    0x66e0,  // 9e44
    0x663f,  // 9e45
    0x66e6,  // 9e46
    0x66e9,  // 9e47
    0x66f0,  // 9e48
    0x66f5,  // 9e49
    0x66f7,  // 9e4a
    0x670f,  // 9e4b
    0x6716,  // 9e4c
    0x671e,  // 9e4d
    0x6726,  // 9e4e
    0x6727,  // 9e4f
    0x9738,  // 9e50
    0x672e,  // 9e51
    0x673f,  // 9e52
    0x6736,  // 9e53
    0x6741,  // 9e54
    0x6738,  // 9e55
    0x6737,  // 9e56
    0x6746,  // 9e57
    0x675e,  // 9e58
    0x6760,  // 9e59
    0x6759,  // 9e5a
    0x6763,  // 9e5b
    0x6764,  // 9e5c
    0x6789,  // 9e5d
    0x6770,  // 9e5e
    0x67a9,  // 9e5f
    0x677c,  // 9e60
    0x676a,  // 9e61
    0x678c,  // 9e62
    0x678b,  // 9e63
    0x67a6,  // 9e64
    0x67a1,  // 9e65
    0x6785,  // 9e66
    0x67b7,  // 9e67
    0x67ef,  // 9e68
    0x67b4,  // 9e69
    0x67ec,  // 9e6a
    0x67b3,  // 9e6b
    0x67e9,  // 9e6c
    0x67b8,  // 9e6d
    0x67e4,  // 9e6e
    0x67de,  // 9e6f
    0x67dd,  // 9e70
    0x67e2,  // 9e71
    0x67ee,  // 9e72
    0x67b9,  // 9e73
    0x67ce,  // 9e74
    0x67c6,  // 9e75
    0x67e7,  // 9e76
    0x6a9c,  // 9e77
    0x681e,  // 9e78
    0x6846,  // 9e79
    0x6829,  // 9e7a
    0x6840,  // 9e7b
    0x684d,  // 9e7c
    0x6832,  // 9e7d
    0x684e,  // 9e7e
    0x0000,  // 9e7f
    0x68b3,  // 9e80
    0x682b,  // 9e81
    0x6859,  // 9e82
    0x6863,  // 9e83
    0x6877,  // 9e84
    0x687f,  // 9e85
    0x689f,  // 9e86
    0x688f,  // 9e87
    0x68ad,  // 9e88
    0x6894,  // 9e89
    0x689d,  // 9e8a
    0x689b,  // 9e8b
    0x6883,  // 9e8c
    0x6aae,  // 9e8d
    0x68b9,  // 9e8e
    0x6874,  // 9e8f
    0x68b5,  // 9e90
    0x68a0,  // 9e91
    0x68ba,  // 9e92
    0x690f,  // 9e93
    0x688d,  // 9e94
    0x687e,  // 9e95
    0x6901,  // 9e96
    0x68ca,  // 9e97
    0x6908,  // 9e98
    0x68d8,  // 9e99
    0x6922,  // 9e9a
    0x6926,  // 9e9b
    0x68e1,  // 9e9c
    0x690c,  // 9e9d
    0x68cd,  // 9e9e
    0x68d4,  // 9e9f
    0x68e7,  // 9ea0
    0x68d5,  // 9ea1
    0x6936,  // 9ea2
    0x6912,  // 9ea3
    0x6904,  // 9ea4
    0x68d7,  // 9ea5
    0x68e3,  // 9ea6
    0x6925,  // 9ea7
    0x68f9,  // 9ea8
    0x68e0,  // 9ea9
    0x68ef,  // 9eaa
    0x6928,  // 9eab
    0x692a,  // 9eac
    0x691a,  // 9ead
    0x6923,  // 9eae
    0x6921,  // 9eaf
    0x68c6,  // 9eb0
    0x6979,  // 9eb1
    0x6977,  // 9eb2
    0x695c,  // 9eb3
    0x6978,  // 9eb4
    0x696b,  // 9eb5
    0x6954,  // 9eb6
    0x697e,  // 9eb7
    0x696e,  // 9eb8
    0x6939,  // 9eb9
    0x6974,  // 9eba
    0x693d,  // 9ebb
    0x6959,  // 9ebc
    0x6930,  // 9ebd
    0x6961,  // 9ebe
    0x695e,  // 9ebf
    0x695d,  // 9ec0
    0x6981,  // 9ec1
    0x696a,  // 9ec2
    0x69b2,  // 9ec3
    0x69ae,  // 9ec4
    0x69d0,  // 9ec5
    0x69bf,  // 9ec6
    0x69c1,  // 9ec7
    0x69d3,  // 9ec8
    0x69be,  // 9ec9
    0x69ce,  // 9eca
    0x5be8,  // 9ecb
    0x69ca,  // 9ecc
    0x69dd,  // 9ecd
    0x69bb,  // 9ece
    0x69c3,  // 9ecf
    0x69a7,  // 9ed0
    0x6a2e,  // 9ed1
    0x6991,  // 9ed2
    0x69a0,  // 9ed3
    0x699c,  // 9ed4
    0x6995,  // 9ed5
    0x69b4,  // 9ed6
    0x69de,  // 9ed7
    0x69e8,  // 9ed8
    0x6a02,  // 9ed9
    0x6a1b,  // 9eda
    0x69ff,  // 9edb
    0x6b0a,  // 9edc
    0x69f9,  // 9edd
    0x69f2,  // 9ede
    0x69e7,  // 9edf
    0x6a05,  // 9ee0
    0x69b1,  // 9ee1
    0x6a1e,  // 9ee2
    0x69ed,  // 9ee3
    0x6a14,  // 9ee4
    0x69eb,  // 9ee5
    0x6a0a,  // 9ee6
    0x6a12,  // 9ee7
    0x6ac1,  // 9ee8
    0x6a23,  // 9ee9
    0x6a13,  // 9eea
    0x6a44,  // 9eeb
    0x6a0c,  // 9eec
    0x6a72,  // 9eed
    0x6a36,  // 9eee
    0x6a78,  // 9eef
    0x6a47,  // 9ef0
    0x6a62,  // 9ef1
    0x6a59,  // 9ef2
    0x6a66,  // 9ef3
    0x6a48,  // 9ef4
    0x6a38,  // 9ef5
    0x6a22,  // 9ef6
    0x6a90,  // 9ef7
    0x6a8d,  // 9ef8
    0x6aa0,  // 9ef9
    0x6a84,  // 9efa
    0x6aa2,  // 9efb
    0x6aa3,  // 9efc
    0x6a97,  // 9f40
    0x8617,  // 9f41
    0x6abb,  // 9f42
    0x6ac3,  // 9f43
    0x6ac2,  // 9f44
    0x6ab8,  // 9f45
    0x6ab3,  // 9f46
    0x6aac,  // 9f47
    0x6ade,  // 9f48
    0x6ad1,  // 9f49
    0x6adf,  // 9f4a
    0x6aaa,  // 9f4b
    0x6ada,  // 9f4c
    0x6aea,  // 9f4d
    0x6afb,  // 9f4e
    0x6b05,  // 9f4f
    0x8616,  // 9f50
    0x6afa,  // 9f51
    0x6b12,  // 9f52
    0x6b16,  // 9f53
    0x9b31,  // 9f54
    0x6b1f,  // 9f55
    0x6b38,  // 9f56
    0x6b37,  // 9f57
    0x76dc,  // 9f58
    0x6b39,  // 9f59
    0x98ee,  // 9f5a
    0x6b47,  // 9f5b
    0x6b43,  // 9f5c
    0x6b49,  // 9f5d
    0x6b50,  // 9f5e
    0x6b59,  // 9f5f
    0x6b54,  // 9f60
    0x6b5b,  // 9f61
    0x6b5f,  // 9f62
    0x6b61,  // 9f63
    0x6b78,  // 9f64
    0x6b79,  // 9f65
    0x6b7f,  // 9f66
    0x6b80,  // 9f67
    0x6b84,  // 9f68
    0x6b83,  // 9f69
    0x6b8d,  // 9f6a
    0x6b98,  // 9f6b
    0x6b95,  // 9f6c
    0x6b9e,  // 9f6d
    0x6ba4,  // 9f6e
    0x6baa,  // 9f6f
    0x6bab,  // 9f70
    0x6baf,  // 9f71
    0x6bb2,  // 9f72
    0x6bb1,  // 9f73
    0x6bb3,  // 9f74
    0x6bb7,  // 9f75
    0x6bbc,  // 9f76
    0x6bc6,  // 9f77
    0x6bcb,  // 9f78
    0x6bd3,  // 9f79
    0x6bdf,  // 9f7a
    0x6bec,  // 9f7b
    0x6beb,  // 9f7c
    0x6bf3,  // 9f7d
    0x6bef,  // 9f7e
    0x0000,  // 9f7f
    0x9ebe,  // 9f80
    0x6c08,  // 9f81
    0x6c13,  // 9f82
    0x6c14,  // 9f83
    0x6c1b,  // 9f84
    0x6c24,  // 9f85
    0x6c23,  // 9f86
    0x6c5e,  // 9f87
    0x6c55,  // 9f88
    0x6c62,  // 9f89
    0x6c6a,  // 9f8a
    0x6c82,  // 9f8b
    0x6c8d,  // 9f8c
    0x6c9a,  // 9f8d
    0x6c81,  // 9f8e
    0x6c9b,  // 9f8f
    0x6c7e,  // 9f90
    0x6c68,  // 9f91
    0x6c73,  // 9f92
    0x6c92,  // 9f93
    0x6c90,  // 9f94
    0x6cc4,  // 9f95
    0x6cf1,  // 9f96
    0x6cd3,  // 9f97
    0x6cbd,  // 9f98
    0x6cd7,  // 9f99
    0x6cc5,  // 9f9a
    0x6cdd,  // 9f9b
    0x6cae,  // 9f9c
    0x6cb1,  // 9f9d
    0x6cbe,  // 9f9e
    0x6cba,  // 9f9f
    0x6cdb,  // 9fa0
    0x6cef,  // 9fa1
    0x6cd9,  // 9fa2
    0x6cea,  // 9fa3
    0x6d1f,  // 9fa4
    0x884d,  // 9fa5
    0x6d36,  // 9fa6
    0x6d2b,  // 9fa7
    0x6d3d,  // 9fa8
    0x6d38,  // 9fa9
    0x6d19,  // 9faa
    0x6d35,  // 9fab
    0x6d33,  // 9fac
    0x6d12,  // 9fad
    0x6d0c,  // 9fae
    0x6d63,  // 9faf
    0x6d93,  // 9fb0
    0x6d64,  // 9fb1
    0x6d5a,  // 9fb2
    0x6d79,  // 9fb3
    0x6d59,  // 9fb4
    0x6d8e,  // 9fb5
    0x6d95,  // 9fb6
    0x6fe4,  // 9fb7
    0x6d85,  // 9fb8
    0x6df9,  // 9fb9
    0x6e15,  // 9fba
    0x6e0a,  // 9fbb
    0x6db5,  // 9fbc
    0x6dc7,  // 9fbd
    0x6de6,  // 9fbe
    0x6db8,  // 9fbf
    0x6dc6,  // 9fc0
    0x6dec,  // 9fc1
    0x6dde,  // 9fc2
    0x6dcc,  // 9fc3
    0x6de8,  // 9fc4
    0x6dd2,  // 9fc5
    0x6dc5,  // 9fc6
    0x6dfa,  // 9fc7
    0x6dd9,  // 9fc8
    0x6de4,  // 9fc9
    0x6dd5,  // 9fca
    0x6dea,  // 9fcb
    0x6dee,  // 9fcc
    0x6e2d,  // 9fcd
    0x6e6e,  // 9fce
    0x6e2e,  // 9fcf
    0x6e19,  // 9fd0
    0x6e72,  // 9fd1
    0x6e5f,  // 9fd2
    0x6e3e,  // 9fd3
    0x6e23,  // 9fd4
    0x6e6b,  // 9fd5
    0x6e2b,  // 9fd6
    0x6e76,  // 9fd7
    0x6e4d,  // 9fd8
    0x6e1f,  // 9fd9
    0x6e43,  // 9fda
    0x6e3a,  // 9fdb
    0x6e4e,  // 9fdc
    0x6e24,  // 9fdd
    0x6eff,  // 9fde
    0x6e1d,  // 9fdf
    0x6e38,  // 9fe0
    0x6e82,  // 9fe1
    0x6eaa,  // 9fe2
    0x6e98,  // 9fe3
    0x6ec9,  // 9fe4
    0x6eb7,  // 9fe5
    0x6ed3,  // 9fe6
    0x6ebd,  // 9fe7
    0x6eaf,  // 9fe8
    0x6ec4,  // 9fe9
    0x6eb2,  // 9fea
    0x6ed4,  // 9feb
    0x6ed5,  // 9fec
    0x6e8f,  // 9fed
    0x6ea5,  // 9fee
    0x6ec2,  // 9fef
    0x6e9f,  // 9ff0
    0x6f41,  // 9ff1
    0x6f11,  // 9ff2
    0x704c,  // 9ff3
    0x6eec,  // 9ff4
    0x6ef8,  // 9ff5
    0x6efe,  // 9ff6
    0x6f3f,  // 9ff7
    0x6ef2,  // 9ff8
    0x6f31,  // 9ff9
    0x6eef,  // 9ffa
    0x6f32,  // 9ffb
    0x6ecc,  // 9ffc
};

const unsigned short CP932Table::codemap_e0[] = {
    0x6f3e,  // e040
    0x6f13,  // e041
    0x6ef7,  // e042
    0x6f86,  // e043
    0x6f7a,  // e044
    0x6f78,  // e045
    0x6f81,  // e046
    0x6f80,  // e047
    0x6f6f,  // e048
    0x6f5b,  // e049
    0x6ff3,  // e04a
    0x6f6d,  // e04b
    0x6f82,  // e04c
    0x6f7c,  // e04d
    0x6f58,  // e04e
    0x6f8e,  // e04f
    0x6f91,  // e050
    0x6fc2,  // e051
    0x6f66,  // e052
    0x6fb3,  // e053
    0x6fa3,  // e054
    0x6fa1,  // e055
    0x6fa4,  // e056
    0x6fb9,  // e057
    0x6fc6,  // e058
    0x6faa,  // e059
    0x6fdf,  // e05a
    0x6fd5,  // e05b
    0x6fec,  // e05c
    0x6fd4,  // e05d
    0x6fd8,  // e05e
    0x6ff1,  // e05f
    0x6fee,  // e060
    0x6fdb,  // e061
    0x7009,  // e062
    0x700b,  // e063
    0x6ffa,  // e064
    0x7011,  // e065
    0x7001,  // e066
    0x700f,  // e067
    0x6ffe,  // e068
    0x701b,  // e069
    0x701a,  // e06a
    0x6f74,  // e06b
    0x701d,  // e06c
    0x7018,  // e06d
    0x701f,  // e06e
    0x7030,  // e06f
    0x703e,  // e070
    0x7032,  // e071
    0x7051,  // e072
    0x7063,  // e073
    0x7099,  // e074
    0x7092,  // e075
    0x70af,  // e076
    0x70f1,  // e077
    0x70ac,  // e078
    0x70b8,  // e079
    0x70b3,  // e07a
    0x70ae,  // e07b
    0x70df,  // e07c
    0x70cb,  // e07d
    0x70dd,  // e07e
    0x0000,  // e07f
    0x70d9,  // e080
    0x7109,  // e081
    0x70fd,  // e082
    0x711c,  // e083
    0x7119,  // e084
    0x7165,  // e085
    0x7155,  // e086
    0x7188,  // e087
    0x7166,  // e088
    0x7162,  // e089
    0x714c,  // e08a
    0x7156,  // e08b
    0x716c,  // e08c
    0x718f,  // e08d
    0x71fb,  // e08e
    0x7184,  // e08f
    0x7195,  // e090
    0x71a8,  // e091
    0x71ac,  // e092
    0x71d7,  // e093
    0x71b9,  // e094
    0x71be,  // e095
    0x71d2,  // e096
    0x71c9,  // e097
    0x71d4,  // e098
    0x71ce,  // e099
    0x71e0,  // e09a
    0x71ec,  // e09b
    0x71e7,  // e09c
    0x71f5,  // e09d
    0x71fc,  // e09e
    0x71f9,  // e09f
    0x71ff,  // e0a0
    0x720d,  // e0a1
    0x7210,  // e0a2
    0x721b,  // e0a3
    0x7228,  // e0a4
    0x722d,  // e0a5
    0x722c,  // e0a6
    0x7230,  // e0a7
    0x7232,  // e0a8
    0x723b,  // e0a9
    0x723c,  // e0aa
    0x723f,  // e0ab
    0x7240,  // e0ac
    0x7246,  // e0ad
    0x724b,  // e0ae
    0x7258,  // e0af
    0x7274,  // e0b0
    0x727e,  // e0b1
    0x7282,  // e0b2
    0x7281,  // e0b3
    0x7287,  // e0b4
    0x7292,  // e0b5
    0x7296,  // e0b6
    0x72a2,  // e0b7
    0x72a7,  // e0b8
    0x72b9,  // e0b9
    0x72b2,  // e0ba
    0x72c3,  // e0bb
    0x72c6,  // e0bc
    0x72c4,  // e0bd
    0x72ce,  // e0be
    0x72d2,  // e0bf
    0x72e2,  // e0c0
    0x72e0,  // e0c1
    0x72e1,  // e0c2
    0x72f9,  // e0c3
    0x72f7,  // e0c4
    0x500f,  // e0c5
    0x7317,  // e0c6
    0x730a,  // e0c7
    0x731c,  // e0c8
    0x7316,  // e0c9
    0x731d,  // e0ca
    0x7334,  // e0cb
    0x732f,  // e0cc
    0x7329,  // e0cd
    0x7325,  // e0ce
    0x733e,  // e0cf
    0x734e,  // e0d0
    0x734f,  // e0d1
    0x9ed8,  // e0d2
    0x7357,  // e0d3
    0x736a,  // e0d4
    0x7368,  // e0d5
    0x7370,  // e0d6
    0x7378,  // e0d7
    0x7375,  // e0d8
    0x737b,  // e0d9
    0x737a,  // e0da
    0x73c8,  // e0db
    0x73b3,  // e0dc
    0x73ce,  // e0dd
    0x73bb,  // e0de
    0x73c0,  // e0df
    0x73e5,  // e0e0
    0x73ee,  // e0e1
    0x73de,  // e0e2
    0x74a2,  // e0e3
    0x7405,  // e0e4
    0x746f,  // e0e5
    0x7425,  // e0e6
    0x73f8,  // e0e7
    0x7432,  // e0e8
    0x743a,  // e0e9
    0x7455,  // e0ea
    0x743f,  // e0eb
    0x745f,  // e0ec
    0x7459,  // e0ed
    0x7441,  // e0ee
    0x745c,  // e0ef
    0x7469,  // e0f0
    0x7470,  // e0f1
    0x7463,  // e0f2
    0x746a,  // e0f3
    0x7476,  // e0f4
    0x747e,  // e0f5
    0x748b,  // e0f6
    0x749e,  // e0f7
    0x74a7,  // e0f8
    0x74ca,  // e0f9
    0x74cf,  // e0fa
    0x74d4,  // e0fb
    0x73f1,  // e0fc
    0x74e0,  // e140
    0x74e3,  // e141
    0x74e7,  // e142
    0x74e9,  // e143
    0x74ee,  // e144
    0x74f2,  // e145
    0x74f0,  // e146
    0x74f1,  // e147
    0x74f8,  // e148
    0x74f7,  // e149
    0x7504,  // e14a
    0x7503,  // e14b
    0x7505,  // e14c
    0x750c,  // e14d
    0x750e,  // e14e
    0x750d,  // e14f
    0x7515,  // e150
    0x7513,  // e151
    0x751e,  // e152
    0x7526,  // e153
    0x752c,  // e154
    0x753c,  // e155
    0x7544,  // e156
    0x754d,  // e157
    0x754a,  // e158
    0x7549,  // e159
    0x755b,  // e15a
    0x7546,  // e15b
    0x755a,  // e15c
    0x7569,  // e15d
    0x7564,  // e15e
    0x7567,  // e15f
    0x756b,  // e160
    0x756d,  // e161
    0x7578,  // e162
    0x7576,  // e163
    0x7586,  // e164
    0x7587,  // e165
    0x7574,  // e166
    0x758a,  // e167
    0x7589,  // e168
    0x7582,  // e169
    0x7594,  // e16a
    0x759a,  // e16b
    0x759d,  // e16c
    0x75a5,  // e16d
    0x75a3,  // e16e
    0x75c2,  // e16f
    0x75b3,  // e170
    0x75c3,  // e171
    0x75b5,  // e172
    0x75bd,  // e173
    0x75b8,  // e174
    0x75bc,  // e175
    0x75b1,  // e176
    0x75cd,  // e177
    0x75ca,  // e178
    0x75d2,  // e179
    0x75d9,  // e17a
    0x75e3,  // e17b
    0x75de,  // e17c
    0x75fe,  // e17d
    0x75ff,  // e17e
    0x0000,  // e17f
    0x75fc,  // e180
    0x7601,  // e181
    0x75f0,  // e182
    0x75fa,  // e183
    0x75f2,  // e184
    0x75f3,  // e185
    0x760b,  // e186
    0x760d,  // e187
    0x7609,  // e188
    0x761f,  // e189
    0x7627,  // e18a
    0x7620,  // e18b
    0x7621,  // e18c
    0x7622,  // e18d
    0x7624,  // e18e
    0x7634,  // e18f
    0x7630,  // e190
    0x763b,  // e191
    0x7647,  // e192
    0x7648,  // e193
    0x7646,  // e194
    0x765c,  // e195
    0x7658,  // e196
    0x7661,  // e197
    0x7662,  // e198
    0x7668,  // e199
    0x7669,  // e19a
    0x766a,  // e19b
    0x7667,  // e19c
    0x766c,  // e19d
    0x7670,  // e19e
    0x7672,  // e19f
    0x7676,  // e1a0
    0x7678,  // e1a1
    0x767c,  // e1a2
    0x7680,  // e1a3
    0x7683,  // e1a4
    0x7688,  // e1a5
    0x768b,  // e1a6
    0x768e,  // e1a7
    0x7696,  // e1a8
    0x7693,  // e1a9
    0x7699,  // e1aa
    0x769a,  // e1ab
    0x76b0,  // e1ac
    0x76b4,  // e1ad
    0x76b8,  // e1ae
    0x76b9,  // e1af
    0x76ba,  // e1b0
    0x76c2,  // e1b1
    0x76cd,  // e1b2
    0x76d6,  // e1b3
    0x76d2,  // e1b4
    0x76de,  // e1b5
    0x76e1,  // e1b6
    0x76e5,  // e1b7
    0x76e7,  // e1b8
    0x76ea,  // e1b9
    0x862f,  // e1ba
    0x76fb,  // e1bb
    0x7708,  // e1bc
    0x7707,  // e1bd
    0x7704,  // e1be
    0x7729,  // e1bf
    0x7724,  // e1c0
    0x771e,  // e1c1
    0x7725,  // e1c2
    0x7726,  // e1c3
    0x771b,  // e1c4
    0x7737,  // e1c5
    0x7738,  // e1c6
    0x7747,  // e1c7
    0x775a,  // e1c8
    0x7768,  // e1c9
    0x776b,  // e1ca
    0x775b,  // e1cb
    0x7765,  // e1cc
    0x777f,  // e1cd
    0x777e,  // e1ce
    0x7779,  // e1cf
    0x778e,  // e1d0
    0x778b,  // e1d1
    0x7791,  // e1d2
    0x77a0,  // e1d3
    0x779e,  // e1d4
    0x77b0,  // e1d5
    0x77b6,  // e1d6
    0x77b9,  // e1d7
    0x77bf,  // e1d8
    0x77bc,  // e1d9
    0x77bd,  // e1da
    0x77bb,  // e1db
    0x77c7,  // e1dc
    0x77cd,  // e1dd
    0x77d7,  // e1de
    0x77da,  // e1df
    0x77dc,  // e1e0
    0x77e3,  // e1e1
    0x77ee,  // e1e2
    0x77fc,  // e1e3
    0x780c,  // e1e4
    0x7812,  // e1e5
    0x7926,  // e1e6
    0x7820,  // e1e7
    0x792a,  // e1e8
    0x7845,  // e1e9
    0x788e,  // e1ea
    0x7874,  // e1eb
    0x7886,  // e1ec
    0x787c,  // e1ed
    0x789a,  // e1ee
    0x788c,  // e1ef
    0x78a3,  // e1f0
    0x78b5,  // e1f1
    0x78aa,  // e1f2
    0x78af,  // e1f3
    0x78d1,  // e1f4
    0x78c6,  // e1f5
    0x78cb,  // e1f6
    0x78d4,  // e1f7
    0x78be,  // e1f8
    0x78bc,  // e1f9
    0x78c5,  // e1fa
    0x78ca,  // e1fb
    0x78ec,  // e1fc
    0x78e7,  // e240
    0x78da,  // e241
    0x78fd,  // e242
    0x78f4,  // e243
    0x7907,  // e244
    0x7912,  // e245
    0x7911,  // e246
    0x7919,  // e247
    0x792c,  // e248
    0x792b,  // e249
    0x7940,  // e24a
    0x7960,  // e24b
    0x7957,  // e24c
    0x795f,  // e24d
    0x795a,  // e24e
    0x7955,  // e24f
    0x7953,  // e250
    0x797a,  // e251
    0x797f,  // e252
    0x798a,  // e253
    0x799d,  // e254
    0x79a7,  // e255
    0x9f4b,  // e256
    0x79aa,  // e257
    0x79ae,  // e258
    0x79b3,  // e259
    0x79b9,  // e25a
    0x79ba,  // e25b
    0x79c9,  // e25c
    0x79d5,  // e25d
    0x79e7,  // e25e
    0x79ec,  // e25f
    0x79e1,  // e260
    0x79e3,  // e261
    0x7a08,  // e262
    0x7a0d,  // e263
    0x7a18,  // e264
    0x7a19,  // e265
    0x7a20,  // e266
    0x7a1f,  // e267
    0x7980,  // e268
    0x7a31,  // e269
    0x7a3b,  // e26a
    0x7a3e,  // e26b
    0x7a37,  // e26c
    0x7a43,  // e26d
    0x7a57,  // e26e
    0x7a49,  // e26f
    0x7a61,  // e270
    0x7a62,  // e271
    0x7a69,  // e272
    0x9f9d,  // e273
    0x7a70,  // e274
    0x7a79,  // e275
    0x7a7d,  // e276
    0x7a88,  // e277
    0x7a97,  // e278
    0x7a95,  // e279
    0x7a98,  // e27a
    0x7a96,  // e27b
    0x7aa9,  // e27c
    0x7ac8,  // e27d
    0x7ab0,  // e27e
    0x0000,  // e27f
    0x7ab6,  // e280
    0x7ac5,  // e281
    0x7ac4,  // e282
    0x7abf,  // e283
    0x9083,  // e284
    0x7ac7,  // e285
    0x7aca,  // e286
    0x7acd,  // e287
    0x7acf,  // e288
    0x7ad5,  // e289
    0x7ad3,  // e28a
    0x7ad9,  // e28b
    0x7ada,  // e28c
    0x7add,  // e28d
    0x7ae1,  // e28e
    0x7ae2,  // e28f
    0x7ae6,  // e290
    0x7aed,  // e291
    0x7af0,  // e292
    0x7b02,  // e293
    0x7b0f,  // e294
    0x7b0a,  // e295
    0x7b06,  // e296
    0x7b33,  // e297
    0x7b18,  // e298
    0x7b19,  // e299
    0x7b1e,  // e29a
    0x7b35,  // e29b
    0x7b28,  // e29c
    0x7b36,  // e29d
    0x7b50,  // e29e
    0x7b7a,  // e29f
    0x7b04,  // e2a0
    0x7b4d,  // e2a1
    0x7b0b,  // e2a2
    0x7b4c,  // e2a3
    0x7b45,  // e2a4
    0x7b75,  // e2a5
    0x7b65,  // e2a6
    0x7b74,  // e2a7
    0x7b67,  // e2a8
    0x7b70,  // e2a9
    0x7b71,  // e2aa
    0x7b6c,  // e2ab
    0x7b6e,  // e2ac
    0x7b9d,  // e2ad
    0x7b98,  // e2ae
    0x7b9f,  // e2af
    0x7b8d,  // e2b0
    0x7b9c,  // e2b1
    0x7b9a,  // e2b2
    0x7b8b,  // e2b3
    0x7b92,  // e2b4
    0x7b8f,  // e2b5
    0x7b5d,  // e2b6
    0x7b99,  // e2b7
    0x7bcb,  // e2b8
    0x7bc1,  // e2b9
    0x7bcc,  // e2ba
    0x7bcf,  // e2bb
    0x7bb4,  // e2bc
    0x7bc6,  // e2bd
    0x7bdd,  // e2be
    0x7be9,  // e2bf
    0x7c11,  // e2c0
    0x7c14,  // e2c1
    0x7be6,  // e2c2
    0x7be5,  // e2c3
    0x7c60,  // e2c4
    0x7c00,  // e2c5
    0x7c07,  // e2c6
    0x7c13,  // e2c7
    0x7bf3,  // e2c8
    0x7bf7,  // e2c9
    0x7c17,  // e2ca
    0x7c0d,  // e2cb
    0x7bf6,  // e2cc
    0x7c23,  // e2cd
    0x7c27,  // e2ce
    0x7c2a,  // e2cf
    0x7c1f,  // e2d0
    0x7c37,  // e2d1
    0x7c2b,  // e2d2
    0x7c3d,  // e2d3
    0x7c4c,  // e2d4
    0x7c43,  // e2d5
    0x7c54,  // e2d6
    0x7c4f,  // e2d7
    0x7c40,  // e2d8
    0x7c50,  // e2d9
    0x7c58,  // e2da
    0x7c5f,  // e2db
    0x7c64,  // e2dc
    0x7c56,  // e2dd
    0x7c65,  // e2de
    0x7c6c,  // e2df
    0x7c75,  // e2e0
    0x7c83,  // e2e1
    0x7c90,  // e2e2
    0x7ca4,  // e2e3
    0x7cad,  // e2e4
    0x7ca2,  // e2e5
    0x7cab,  // e2e6
    0x7ca1,  // e2e7
    0x7ca8,  // e2e8
    0x7cb3,  // e2e9
    0x7cb2,  // e2ea
    0x7cb1,  // e2eb
    0x7cae,  // e2ec
    0x7cb9,  // e2ed
    0x7cbd,  // e2ee
    0x7cc0,  // e2ef
    0x7cc5,  // e2f0
    0x7cc2,  // e2f1
    0x7cd8,  // e2f2
    0x7cd2,  // e2f3
    0x7cdc,  // e2f4
    0x7ce2,  // e2f5
    0x9b3b,  // e2f6
    0x7cef,  // e2f7
    0x7cf2,  // e2f8
    0x7cf4,  // e2f9
    0x7cf6,  // e2fa
    0x7cfa,  // e2fb
    0x7d06,  // e2fc
    0x7d02,  // e340
    0x7d1c,  // e341
    0x7d15,  // e342
    0x7d0a,  // e343
    0x7d45,  // e344
    0x7d4b,  // e345
    0x7d2e,  // e346
    0x7d32,  // e347
    0x7d3f,  // e348
    0x7d35,  // e349
    0x7d46,  // e34a
    0x7d73,  // e34b
    0x7d56,  // e34c
    0x7d4e,  // e34d
    0x7d72,  // e34e
    0x7d68,  // e34f
    0x7d6e,  // e350
    0x7d4f,  // e351
    0x7d63,  // e352
    0x7d93,  // e353
    0x7d89,  // e354
    0x7d5b,  // e355
    0x7d8f,  // e356
    0x7d7d,  // e357
    0x7d9b,  // e358
    0x7dba,  // e359
    0x7dae,  // e35a
    0x7da3,  // e35b
    0x7db5,  // e35c
    0x7dc7,  // e35d
    0x7dbd,  // e35e
    0x7dab,  // e35f
    0x7e3d,  // e360
    0x7da2,  // e361
    0x7daf,  // e362
    0x7ddc,  // e363
    0x7db8,  // e364
    0x7d9f,  // e365
    0x7db0,  // e366
    0x7dd8,  // e367
    0x7ddd,  // e368
    0x7de4,  // e369
    0x7dde,  // e36a
    0x7dfb,  // e36b
    0x7df2,  // e36c
    0x7de1,  // e36d
    0x7e05,  // e36e
    0x7e0a,  // e36f
    0x7e23,  // e370
    0x7e21,  // e371
    0x7e12,  // e372
    0x7e31,  // e373
    0x7e1f,  // e374
    0x7e09,  // e375
    0x7e0b,  // e376
    0x7e22,  // e377
    0x7e46,  // e378
    0x7e66,  // e379
    0x7e3b,  // e37a
    0x7e35,  // e37b
    0x7e39,  // e37c
    0x7e43,  // e37d
    0x7e37,  // e37e
    0x0000,  // e37f
    0x7e32,  // e380
    0x7e3a,  // e381
    0x7e67,  // e382
    0x7e5d,  // e383
    0x7e56,  // e384
    0x7e5e,  // e385
    0x7e59,  // e386
    0x7e5a,  // e387
    0x7e79,  // e388
    0x7e6a,  // e389
    0x7e69,  // e38a
    0x7e7c,  // e38b
    0x7e7b,  // e38c
    0x7e83,  // e38d
    0x7dd5,  // e38e
    0x7e7d,  // e38f
    0x8fae,  // e390
    0x7e7f,  // e391
    0x7e88,  // e392
    0x7e89,  // e393
    0x7e8c,  // e394
    0x7e92,  // e395
    0x7e90,  // e396
    0x7e93,  // e397
    0x7e94,  // e398
    0x7e96,  // e399
    0x7e8e,  // e39a
    0x7e9b,  // e39b
    0x7e9c,  // e39c
    0x7f38,  // e39d
    0x7f3a,  // e39e
    0x7f45,  // e39f
    0x7f4c,  // e3a0
    0x7f4d,  // e3a1
    0x7f4e,  // e3a2
    0x7f50,  // e3a3
    0x7f51,  // e3a4
    0x7f55,  // e3a5
    0x7f54,  // e3a6
    0x7f58,  // e3a7
    0x7f5f,  // e3a8
    0x7f60,  // e3a9
    0x7f68,  // e3aa
    0x7f69,  // e3ab
    0x7f67,  // e3ac
    0x7f78,  // e3ad
    0x7f82,  // e3ae
    0x7f86,  // e3af
    0x7f83,  // e3b0
    0x7f88,  // e3b1
    0x7f87,  // e3b2
    0x7f8c,  // e3b3
    0x7f94,  // e3b4
    0x7f9e,  // e3b5
    0x7f9d,  // e3b6
    0x7f9a,  // e3b7
    0x7fa3,  // e3b8
    0x7faf,  // e3b9
    0x7fb2,  // e3ba
    0x7fb9,  // e3bb
    0x7fae,  // e3bc
    0x7fb6,  // e3bd
    0x7fb8,  // e3be
    0x8b71,  // e3bf
    0x7fc5,  // e3c0
    0x7fc6,  // e3c1
    0x7fca,  // e3c2
    0x7fd5,  // e3c3
    0x7fd4,  // e3c4
    0x7fe1,  // e3c5
    0x7fe6,  // e3c6
    0x7fe9,  // e3c7
    0x7ff3,  // e3c8
    0x7ff9,  // e3c9
    0x98dc,  // e3ca
    0x8006,  // e3cb
    0x8004,  // e3cc
    0x800b,  // e3cd
    0x8012,  // e3ce
    0x8018,  // e3cf
    0x8019,  // e3d0
    0x801c,  // e3d1
    0x8021,  // e3d2
    0x8028,  // e3d3
    0x803f,  // e3d4
    0x803b,  // e3d5
    0x804a,  // e3d6
    0x8046,  // e3d7
    0x8052,  // e3d8
    0x8058,  // e3d9
    0x805a,  // e3da
    0x805f,  // e3db
    0x8062,  // e3dc
    0x8068,  // e3dd
    0x8073,  // e3de
    0x8072,  // e3df
    0x8070,  // e3e0
    0x8076,  // e3e1
    0x8079,  // e3e2
    0x807d,  // e3e3
    0x807f,  // e3e4
    0x8084,  // e3e5
    0x8086,  // e3e6
    0x8085,  // e3e7
    0x809b,  // e3e8
    0x8093,  // e3e9
    0x809a,  // e3ea
    0x80ad,  // e3eb
    0x5190,  // e3ec
    0x80ac,  // e3ed
    0x80db,  // e3ee
    0x80e5,  // e3ef
    0x80d9,  // e3f0
    0x80dd,  // e3f1
    0x80c4,  // e3f2
    0x80da,  // e3f3
    0x80d6,  // e3f4
    0x8109,  // e3f5
    0x80ef,  // e3f6
    0x80f1,  // e3f7
    0x811b,  // e3f8
    0x8129,  // e3f9
    0x8123,  // e3fa
    0x812f,  // e3fb
    0x814b,  // e3fc
    0x968b,  // e440
    0x8146,  // e441
    0x813e,  // e442
    0x8153,  // e443
    0x8151,  // e444
    0x80fc,  // e445
    0x8171,  // e446
    0x816e,  // e447
    0x8165,  // e448
    0x8166,  // e449
    0x8174,  // e44a
    0x8183,  // e44b
    0x8188,  // e44c
    0x818a,  // e44d
    0x8180,  // e44e
    0x8182,  // e44f
    0x81a0,  // e450
    0x8195,  // e451
    0x81a4,  // e452
    0x81a3,  // e453
    0x815f,  // e454
    0x8193,  // e455
    0x81a9,  // e456
    0x81b0,  // e457
    0x81b5,  // e458
    0x81be,  // e459
    0x81b8,  // e45a
    0x81bd,  // e45b
    0x81c0,  // e45c
    0x81c2,  // e45d
    0x81ba,  // e45e
    0x81c9,  // e45f
    0x81cd,  // e460
    0x81d1,  // e461
    0x81d9,  // e462
    0x81d8,  // e463
    0x81c8,  // e464
    0x81da,  // e465
    0x81df,  // e466
    0x81e0,  // e467
    0x81e7,  // e468
    0x81fa,  // e469
    0x81fb,  // e46a
    0x81fe,  // e46b
    0x8201,  // e46c
    0x8202,  // e46d
    0x8205,  // e46e
    0x8207,  // e46f
    0x820a,  // e470
    0x820d,  // e471
    0x8210,  // e472
    0x8216,  // e473
    0x8229,  // e474
    0x822b,  // e475
    0x8238,  // e476
    0x8233,  // e477
    0x8240,  // e478
    0x8259,  // e479
    0x8258,  // e47a
    0x825d,  // e47b
    0x825a,  // e47c
    0x825f,  // e47d
    0x8264,  // e47e
    0x0000,  // e47f
    0x8262,  // e480
    0x8268,  // e481
    0x826a,  // e482
    0x826b,  // e483
    0x822e,  // e484
    0x8271,  // e485
    0x8277,  // e486
    0x8278,  // e487
    0x827e,  // e488
    0x828d,  // e489
    0x8292,  // e48a
    0x82ab,  // e48b
    0x829f,  // e48c
    0x82bb,  // e48d
    0x82ac,  // e48e
    0x82e1,  // e48f
    0x82e3,  // e490
    0x82df,  // e491
    0x82d2,  // e492
    0x82f4,  // e493
    0x82f3,  // e494
    0x82fa,  // e495
    0x8393,  // e496
    0x8303,  // e497
    0x82fb,  // e498
    0x82f9,  // e499
    0x82de,  // e49a
    0x8306,  // e49b
    0x82dc,  // e49c
    0x8309,  // e49d
    0x82d9,  // e49e
    0x8335,  // e49f
    0x8334,  // e4a0
    0x8316,  // e4a1
    0x8332,  // e4a2
    0x8331,  // e4a3
    0x8340,  // e4a4
    0x8339,  // e4a5
    0x8350,  // e4a6
    0x8345,  // e4a7
    0x832f,  // e4a8
    0x832b,  // e4a9
    0x8317,  // e4aa
    0x8318,  // e4ab
    0x8385,  // e4ac
    0x839a,  // e4ad
    0x83aa,  // e4ae
    0x839f,  // e4af
    0x83a2,  // e4b0
    0x8396,  // e4b1
    0x8323,  // e4b2
    0x838e,  // e4b3
    0x8387,  // e4b4
    0x838a,  // e4b5
    0x837c,  // e4b6
    0x83b5,  // e4b7
    0x8373,  // e4b8
    0x8375,  // e4b9
    0x83a0,  // e4ba
    0x8389,  // e4bb
    0x83a8,  // e4bc
    0x83f4,  // e4bd
    0x8413,  // e4be
    0x83eb,  // e4bf
    0x83ce,  // e4c0
    0x83fd,  // e4c1
    0x8403,  // e4c2
    0x83d8,  // e4c3
    0x840b,  // e4c4
    0x83c1,  // e4c5
    0x83f7,  // e4c6
    0x8407,  // e4c7
    0x83e0,  // e4c8
    0x83f2,  // e4c9
    0x840d,  // e4ca
    0x8422,  // e4cb
    0x8420,  // e4cc
    0x83bd,  // e4cd
    0x8438,  // e4ce
    0x8506,  // e4cf
    0x83fb,  // e4d0
    0x846d,  // e4d1
    0x842a,  // e4d2
    0x843c,  // e4d3
    0x855a,  // e4d4
    0x8484,  // e4d5
    0x8477,  // e4d6
    0x846b,  // e4d7
    0x84ad,  // e4d8
    0x846e,  // e4d9
    0x8482,  // e4da
    0x8469,  // e4db
    0x8446,  // e4dc
    0x842c,  // e4dd
    0x846f,  // e4de
    0x8479,  // e4df
    0x8435,  // e4e0
    0x84ca,  // e4e1
    0x8462,  // e4e2
    0x84b9,  // e4e3
    0x84bf,  // e4e4
    0x849f,  // e4e5
    0x84d9,  // e4e6
    0x84cd,  // e4e7
    0x84bb,  // e4e8
    0x84da,  // e4e9
    0x84d0,  // e4ea
    0x84c1,  // e4eb
    0x84c6,  // e4ec
    0x84d6,  // e4ed
    0x84a1,  // e4ee
    0x8521,  // e4ef
    0x84ff,  // e4f0
    0x84f4,  // e4f1
    0x8517,  // e4f2
    0x8518,  // e4f3
    0x852c,  // e4f4
    0x851f,  // e4f5
    0x8515,  // e4f6
    0x8514,  // e4f7
    0x84fc,  // e4f8
    0x8540,  // e4f9
    0x8563,  // e4fa
    0x8558,  // e4fb
    0x8548,  // e4fc
    0x8541,  // e540
    0x8602,  // e541
    0x854b,  // e542
    0x8555,  // e543
    0x8580,  // e544
    0x85a4,  // e545
    0x8588,  // e546
    0x8591,  // e547
    0x858a,  // e548
    0x85a8,  // e549
    0x856d,  // e54a
    0x8594,  // e54b
    0x859b,  // e54c
    0x85ea,  // e54d
    0x8587,  // e54e
    0x859c,  // e54f
    0x8577,  // e550
    0x857e,  // e551
    0x8590,  // e552
    0x85c9,  // e553
    0x85ba,  // e554
    0x85cf,  // e555
    0x85b9,  // e556
    0x85d0,  // e557
    0x85d5,  // e558
    0x85dd,  // e559
    0x85e5,  // e55a
    0x85dc,  // e55b
    0x85f9,  // e55c
    0x860a,  // e55d
    0x8613,  // e55e
    0x860b,  // e55f
    0x85fe,  // e560
    0x85fa,  // e561
    0x8606,  // e562
    0x8622,  // e563
    0x861a,  // e564
    0x8630,  // e565
    0x863f,  // e566
    0x864d,  // e567
    0x4e55,  // e568
    0x8654,  // e569
    0x865f,  // e56a
    0x8667,  // e56b
    0x8671,  // e56c
    0x8693,  // e56d
    0x86a3,  // e56e
    0x86a9,  // e56f
    0x86aa,  // e570
    0x868b,  // e571
    0x868c,  // e572
    0x86b6,  // e573
    0x86af,  // e574
    0x86c4,  // e575
    0x86c6,  // e576
    0x86b0,  // e577
    0x86c9,  // e578
    0x8823,  // e579
    0x86ab,  // e57a
    0x86d4,  // e57b
    0x86de,  // e57c
    0x86e9,  // e57d
    0x86ec,  // e57e
    0x0000,  // e57f
    0x86df,  // e580
    0x86db,  // e581
    0x86ef,  // e582
    0x8712,  // e583
    0x8706,  // e584
    0x8708,  // e585
    0x8700,  // e586
    0x8703,  // e587
    0x86fb,  // e588
    0x8711,  // e589
    0x8709,  // e58a
    0x870d,  // e58b
    0x86f9,  // e58c
    0x870a,  // e58d
    0x8734,  // e58e
    0x873f,  // e58f
    0x8737,  // e590
    0x873b,  // e591
    0x8725,  // e592
    0x8729,  // e593
    0x871a,  // e594
    0x8760,  // e595
    0x875f,  // e596
    0x8778,  // e597
    0x874c,  // e598
    0x874e,  // e599
    0x8774,  // e59a
    0x8757,  // e59b
    0x8768,  // e59c
    0x876e,  // e59d
    0x8759,  // e59e
    0x8753,  // e59f
    0x8763,  // e5a0
    0x876a,  // e5a1
    0x8805,  // e5a2
    0x87a2,  // e5a3
    0x879f,  // e5a4
    0x8782,  // e5a5
    0x87af,  // e5a6
    0x87cb,  // e5a7
    0x87bd,  // e5a8
    0x87c0,  // e5a9
    0x87d0,  // e5aa
    0x96d6,  // e5ab
    0x87ab,  // e5ac
    0x87c4,  // e5ad
    0x87b3,  // e5ae
    0x87c7,  // e5af
    0x87c6,  // e5b0
    0x87bb,  // e5b1
    0x87ef,  // e5b2
    0x87f2,  // e5b3
    0x87e0,  // e5b4
    0x880f,  // e5b5
    0x880d,  // e5b6
    0x87fe,  // e5b7
    0x87f6,  // e5b8
    0x87f7,  // e5b9
    0x880e,  // e5ba
    0x87d2,  // e5bb
    0x8811,  // e5bc
    0x8816,  // e5bd
    0x8815,  // e5be
    0x8822,  // e5bf
    0x8821,  // e5c0
    0x8831,  // e5c1
    0x8836,  // e5c2
    0x8839,  // e5c3
    0x8827,  // e5c4
    0x883b,  // e5c5
    0x8844,  // e5c6
    0x8842,  // e5c7
    0x8852,  // e5c8
    0x8859,  // e5c9
    0x885e,  // e5ca
    0x8862,  // e5cb
    0x886b,  // e5cc
    0x8881,  // e5cd
    0x887e,  // e5ce
    0x889e,  // e5cf
    0x8875,  // e5d0
    0x887d,  // e5d1
    0x88b5,  // e5d2
    0x8872,  // e5d3
    0x8882,  // e5d4
    0x8897,  // e5d5
    0x8892,  // e5d6
    0x88ae,  // e5d7
    0x8899,  // e5d8
    0x88a2,  // e5d9
    0x888d,  // e5da
    0x88a4,  // e5db
    0x88b0,  // e5dc
    0x88bf,  // e5dd
    0x88b1,  // e5de
    0x88c3,  // e5df
    0x88c4,  // e5e0
    0x88d4,  // e5e1
    0x88d8,  // e5e2
    0x88d9,  // e5e3
    0x88dd,  // e5e4
    0x88f9,  // e5e5
    0x8902,  // e5e6
    0x88fc,  // e5e7
    0x88f4,  // e5e8
    0x88e8,  // e5e9
    0x88f2,  // e5ea
    0x8904,  // e5eb
    0x890c,  // e5ec
    0x890a,  // e5ed
    0x8913,  // e5ee
    0x8943,  // e5ef
    0x891e,  // e5f0
    0x8925,  // e5f1
    0x892a,  // e5f2
    0x892b,  // e5f3
    0x8941,  // e5f4
    0x8944,  // e5f5
    0x893b,  // e5f6
    0x8936,  // e5f7
    0x8938,  // e5f8
    0x894c,  // e5f9
    0x891d,  // e5fa
    0x8960,  // e5fb
    0x895e,  // e5fc
    0x8966,  // e640
    0x8964,  // e641
    0x896d,  // e642
    0x896a,  // e643
    0x896f,  // e644
    0x8974,  // e645
    0x8977,  // e646
    0x897e,  // e647
    0x8983,  // e648
    0x8988,  // e649
    0x898a,  // e64a
    0x8993,  // e64b
    0x8998,  // e64c
    0x89a1,  // e64d
    0x89a9,  // e64e
    0x89a6,  // e64f
    0x89ac,  // e650
    0x89af,  // e651
    0x89b2,  // e652
    0x89ba,  // e653
    0x89bd,  // e654
    0x89bf,  // e655
    0x89c0,  // e656
    0x89da,  // e657
    0x89dc,  // e658
    0x89dd,  // e659
    0x89e7,  // e65a
    0x89f4,  // e65b
    0x89f8,  // e65c
    0x8a03,  // e65d
    0x8a16,  // e65e
    0x8a10,  // e65f
    0x8a0c,  // e660
    0x8a1b,  // e661
    0x8a1d,  // e662
    0x8a25,  // e663
    0x8a36,  // e664
    0x8a41,  // e665
    0x8a5b,  // e666
    0x8a52,  // e667
    0x8a46,  // e668
    0x8a48,  // e669
    0x8a7c,  // e66a
    0x8a6d,  // e66b
    0x8a6c,  // e66c
    0x8a62,  // e66d
    0x8a85,  // e66e
    0x8a82,  // e66f
    0x8a84,  // e670
    0x8aa8,  // e671
    0x8aa1,  // e672
    0x8a91,  // e673
    0x8aa5,  // e674
    0x8aa6,  // e675
    0x8a9a,  // e676
    0x8aa3,  // e677
    0x8ac4,  // e678
    0x8acd,  // e679
    0x8ac2,  // e67a
    0x8ada,  // e67b
    0x8aeb,  // e67c
    0x8af3,  // e67d
    0x8ae7,  // e67e
    0x0000,  // e67f
    0x8ae4,  // e680
    0x8af1,  // e681
    0x8b14,  // e682
    0x8ae0,  // e683
    0x8ae2,  // e684
    0x8af7,  // e685
    0x8ade,  // e686
    0x8adb,  // e687
    0x8b0c,  // e688
    0x8b07,  // e689
    0x8b1a,  // e68a
    0x8ae1,  // e68b
    0x8b16,  // e68c
    0x8b10,  // e68d
    0x8b17,  // e68e
    0x8b20,  // e68f
    0x8b33,  // e690
    0x97ab,  // e691
    0x8b26,  // e692
    0x8b2b,  // e693
    0x8b3e,  // e694
    0x8b28,  // e695
    0x8b41,  // e696
    0x8b4c,  // e697
    0x8b4f,  // e698
    0x8b4e,  // e699
    0x8b49,  // e69a
    0x8b56,  // e69b
    0x8b5b,  // e69c
    0x8b5a,  // e69d
    0x8b6b,  // e69e
    0x8b5f,  // e69f
    0x8b6c,  // e6a0
    0x8b6f,  // e6a1
    0x8b74,  // e6a2
    0x8b7d,  // e6a3
    0x8b80,  // e6a4
    0x8b8c,  // e6a5
    0x8b8e,  // e6a6
    0x8b92,  // e6a7
    0x8b93,  // e6a8
    0x8b96,  // e6a9
    0x8b99,  // e6aa
    0x8b9a,  // e6ab
    0x8c3a,  // e6ac
    0x8c41,  // e6ad
    0x8c3f,  // e6ae
    0x8c48,  // e6af
    0x8c4c,  // e6b0
    0x8c4e,  // e6b1
    0x8c50,  // e6b2
    0x8c55,  // e6b3
    0x8c62,  // e6b4
    0x8c6c,  // e6b5
    0x8c78,  // e6b6
    0x8c7a,  // e6b7
    0x8c82,  // e6b8
    0x8c89,  // e6b9
    0x8c85,  // e6ba
    0x8c8a,  // e6bb
    0x8c8d,  // e6bc
    0x8c8e,  // e6bd
    0x8c94,  // e6be
    0x8c7c,  // e6bf
    0x8c98,  // e6c0
    0x621d,  // e6c1
    0x8cad,  // e6c2
    0x8caa,  // e6c3
    0x8cbd,  // e6c4
    0x8cb2,  // e6c5
    0x8cb3,  // e6c6
    0x8cae,  // e6c7
    0x8cb6,  // e6c8
    0x8cc8,  // e6c9
    0x8cc1,  // e6ca
    0x8ce4,  // e6cb
    0x8ce3,  // e6cc
    0x8cda,  // e6cd
    0x8cfd,  // e6ce
    0x8cfa,  // e6cf
    0x8cfb,  // e6d0
    0x8d04,  // e6d1
    0x8d05,  // e6d2
    0x8d0a,  // e6d3
    0x8d07,  // e6d4
    0x8d0f,  // e6d5
    0x8d0d,  // e6d6
    0x8d10,  // e6d7
    0x9f4e,  // e6d8
    0x8d13,  // e6d9
    0x8ccd,  // e6da
    0x8d14,  // e6db
    0x8d16,  // e6dc
    0x8d67,  // e6dd
    0x8d6d,  // e6de
    0x8d71,  // e6df
    0x8d73,  // e6e0
    0x8d81,  // e6e1
    0x8d99,  // e6e2
    0x8dc2,  // e6e3
    0x8dbe,  // e6e4
    0x8dba,  // e6e5
    0x8dcf,  // e6e6
    0x8dda,  // e6e7
    0x8dd6,  // e6e8
    0x8dcc,  // e6e9
    0x8ddb,  // e6ea
    0x8dcb,  // e6eb
    0x8dea,  // e6ec
    0x8deb,  // e6ed
    0x8ddf,  // e6ee
    0x8de3,  // e6ef
    0x8dfc,  // e6f0
    0x8e08,  // e6f1
    0x8e09,  // e6f2
    0x8dff,  // e6f3
    0x8e1d,  // e6f4
    0x8e1e,  // e6f5
    0x8e10,  // e6f6
    0x8e1f,  // e6f7
    0x8e42,  // e6f8
    0x8e35,  // e6f9
    0x8e30,  // e6fa
    0x8e34,  // e6fb
    0x8e4a,  // e6fc
    0x8e47,  // e740
    0x8e49,  // e741
    0x8e4c,  // e742
    0x8e50,  // e743
    0x8e48,  // e744
    0x8e59,  // e745
    0x8e64,  // e746
    0x8e60,  // e747
    0x8e2a,  // e748
    0x8e63,  // e749
    0x8e55,  // e74a
    0x8e76,  // e74b
    0x8e72,  // e74c
    0x8e7c,  // e74d
    0x8e81,  // e74e
    0x8e87,  // e74f
    0x8e85,  // e750
    0x8e84,  // e751
    0x8e8b,  // e752
    0x8e8a,  // e753
    0x8e93,  // e754
    0x8e91,  // e755
    0x8e94,  // e756
    0x8e99,  // e757
    0x8eaa,  // e758
    0x8ea1,  // e759
    0x8eac,  // e75a
    0x8eb0,  // e75b
    0x8ec6,  // e75c
    0x8eb1,  // e75d
    0x8ebe,  // e75e
    0x8ec5,  // e75f
    0x8ec8,  // e760
    0x8ecb,  // e761
    0x8edb,  // e762
    0x8ee3,  // e763
    0x8efc,  // e764
    0x8efb,  // e765
    0x8eeb,  // e766
    0x8efe,  // e767
    0x8f0a,  // e768
    0x8f05,  // e769
    0x8f15,  // e76a
    0x8f12,  // e76b
    0x8f19,  // e76c
    0x8f13,  // e76d
    0x8f1c,  // e76e
    0x8f1f,  // e76f
    0x8f1b,  // e770
    0x8f0c,  // e771
    0x8f26,  // e772
    0x8f33,  // e773
    0x8f3b,  // e774
    0x8f39,  // e775
    0x8f45,  // e776
    0x8f42,  // e777
    0x8f3e,  // e778
    0x8f4c,  // e779
    0x8f49,  // e77a
    0x8f46,  // e77b
    0x8f4e,  // e77c
    0x8f57,  // e77d
    0x8f5c,  // e77e
    0x0000,  // e77f
    0x8f62,  // e780
    0x8f63,  // e781
    0x8f64,  // e782
    0x8f9c,  // e783
    0x8f9f,  // e784
    0x8fa3,  // e785
    0x8fad,  // e786
    0x8faf,  // e787
    0x8fb7,  // e788
    0x8fda,  // e789
    0x8fe5,  // e78a
    0x8fe2,  // e78b
    0x8fea,  // e78c
    0x8fef,  // e78d
    0x9087,  // e78e
    0x8ff4,  // e78f
    0x9005,  // e790
    0x8ff9,  // e791
    0x8ffa,  // e792
    0x9011,  // e793
    0x9015,  // e794
    0x9021,  // e795
    0x900d,  // e796
    0x901e,  // e797
    0x9016,  // e798
    0x900b,  // e799
    0x9027,  // e79a
    0x9036,  // e79b
    0x9035,  // e79c
    0x9039,  // e79d
    0x8ff8,  // e79e
    0x904f,  // e79f
    0x9050,  // e7a0
    0x9051,  // e7a1
    0x9052,  // e7a2
    0x900e,  // e7a3
    0x9049,  // e7a4
    0x903e,  // e7a5
    0x9056,  // e7a6
    0x9058,  // e7a7
    0x905e,  // e7a8
    0x9068,  // e7a9
    0x906f,  // e7aa
    0x9076,  // e7ab
    0x96a8,  // e7ac
    0x9072,  // e7ad
    0x9082,  // e7ae
    0x907d,  // e7af
    0x9081,  // e7b0
    0x9080,  // e7b1
    0x908a,  // e7b2
    0x9089,  // e7b3
    0x908f,  // e7b4
    0x90a8,  // e7b5
    0x90af,  // e7b6
    0x90b1,  // e7b7
    0x90b5,  // e7b8
    0x90e2,  // e7b9
    0x90e4,  // e7ba
    0x6248,  // e7bb
    0x90db,  // e7bc
    0x9102,  // e7bd
    0x9112,  // e7be
    0x9119,  // e7bf
    0x9132,  // e7c0
    0x9130,  // e7c1
    0x914a,  // e7c2
    0x9156,  // e7c3
    0x9158,  // e7c4
    0x9163,  // e7c5
    0x9165,  // e7c6
    0x9169,  // e7c7
    0x9173,  // e7c8
    0x9172,  // e7c9
    0x918b,  // e7ca
    0x9189,  // e7cb
    0x9182,  // e7cc
    0x91a2,  // e7cd
    0x91ab,  // e7ce
    0x91af,  // e7cf
    0x91aa,  // e7d0
    0x91b5,  // e7d1
    0x91b4,  // e7d2
    0x91ba,  // e7d3
    0x91c0,  // e7d4
    0x91c1,  // e7d5
    0x91c9,  // e7d6
    0x91cb,  // e7d7
    0x91d0,  // e7d8
    0x91d6,  // e7d9
    0x91df,  // e7da
    0x91e1,  // e7db
    0x91db,  // e7dc
    0x91fc,  // e7dd
    0x91f5,  // e7de
    0x91f6,  // e7df
    0x921e,  // e7e0
    0x91ff,  // e7e1
    0x9214,  // e7e2
    0x922c,  // e7e3
    0x9215,  // e7e4
    0x9211,  // e7e5
    0x925e,  // e7e6
    0x9257,  // e7e7
    0x9245,  // e7e8
    0x9249,  // e7e9
    0x9264,  // e7ea
    0x9248,  // e7eb
    0x9295,  // e7ec
    0x923f,  // e7ed
    0x924b,  // e7ee
    0x9250,  // e7ef
    0x929c,  // e7f0
    0x9296,  // e7f1
    0x9293,  // e7f2
    0x929b,  // e7f3
    0x925a,  // e7f4
    0x92cf,  // e7f5
    0x92b9,  // e7f6
    0x92b7,  // e7f7
    0x92e9,  // e7f8
    0x930f,  // e7f9
    0x92fa,  // e7fa
    0x9344,  // e7fb
    0x932e,  // e7fc
    0x9319,  // e840
    0x9322,  // e841
    0x931a,  // e842
    0x9323,  // e843
    0x933a,  // e844
    0x9335,  // e845
    0x933b,  // e846
    0x935c,  // e847
    0x9360,  // e848
    0x937c,  // e849
    0x936e,  // e84a
    0x9356,  // e84b
    0x93b0,  // e84c
    0x93ac,  // e84d
    0x93ad,  // e84e
    0x9394,  // e84f
    0x93b9,  // e850
    0x93d6,  // e851
    0x93d7,  // e852
    0x93e8,  // e853
    0x93e5,  // e854
    0x93d8,  // e855
    0x93c3,  // e856
    0x93dd,  // e857
    0x93d0,  // e858
    0x93c8,  // e859
    0x93e4,  // e85a
    0x941a,  // e85b
    0x9414,  // e85c
    0x9413,  // e85d
    0x9403,  // e85e
    0x9407,  // e85f
    0x9410,  // e860
    0x9436,  // e861
    0x942b,  // e862
    0x9435,  // e863
    0x9421,  // e864
    0x943a,  // e865
    0x9441,  // e866
    0x9452,  // e867
    0x9444,  // e868
    0x945b,  // e869
    0x9460,  // e86a
    0x9462,  // e86b
    0x945e,  // e86c
    0x946a,  // e86d
    0x9229,  // e86e
    0x9470,  // e86f
    0x9475,  // e870
    0x9477,  // e871
    0x947d,  // e872
    0x945a,  // e873
    0x947c,  // e874
    0x947e,  // e875
    0x9481,  // e876
    0x947f,  // e877
    0x9582,  // e878
    0x9587,  // e879
    0x958a,  // e87a
    0x9594,  // e87b
    0x9596,  // e87c
    0x9598,  // e87d
    0x9599,  // e87e
    0x0000,  // e87f
    0x95a0,  // e880
    0x95a8,  // e881
    0x95a7,  // e882
    0x95ad,  // e883
    0x95bc,  // e884
    0x95bb,  // e885
    0x95b9,  // e886
    0x95be,  // e887
    0x95ca,  // e888
    0x6ff6,  // e889
    0x95c3,  // e88a
    0x95cd,  // e88b
    0x95cc,  // e88c
    0x95d5,  // e88d
    0x95d4,  // e88e
    0x95d6,  // e88f
    0x95dc,  // e890
    0x95e1,  // e891
    0x95e5,  // e892
    0x95e2,  // e893
    0x9621,  // e894
    0x9628,  // e895
    0x962e,  // e896
    0x962f,  // e897
    0x9642,  // e898
    0x964c,  // e899
    0x964f,  // e89a
    0x964b,  // e89b
    0x9677,  // e89c
    0x965c,  // e89d
    0x965e,  // e89e
    0x965d,  // e89f
    0x965f,  // e8a0
    0x9666,  // e8a1
    0x9672,  // e8a2
    0x966c,  // e8a3
    0x968d,  // e8a4
    0x9698,  // e8a5
    0x9695,  // e8a6
    0x9697,  // e8a7
    0x96aa,  // e8a8
    0x96a7,  // e8a9
    0x96b1,  // e8aa
    0x96b2,  // e8ab
    0x96b0,  // e8ac
    0x96b4,  // e8ad
    0x96b6,  // e8ae
    0x96b8,  // e8af
    0x96b9,  // e8b0
    0x96ce,  // e8b1
    0x96cb,  // e8b2
    0x96c9,  // e8b3
    0x96cd,  // e8b4
    0x894d,  // e8b5
    0x96dc,  // e8b6
    0x970d,  // e8b7
    0x96d5,  // e8b8
    0x96f9,  // e8b9
    0x9704,  // e8ba
    0x9706,  // e8bb
    0x9708,  // e8bc
    0x9713,  // e8bd
    0x970e,  // e8be
    0x9711,  // e8bf
    0x970f,  // e8c0
    0x9716,  // e8c1
    0x9719,  // e8c2
    0x9724,  // e8c3
    0x972a,  // e8c4
    0x9730,  // e8c5
    0x9739,  // e8c6
    0x973d,  // e8c7
    0x973e,  // e8c8
    0x9744,  // e8c9
    0x9746,  // e8ca
    0x9748,  // e8cb
    0x9742,  // e8cc
    0x9749,  // e8cd
    0x975c,  // e8ce
    0x9760,  // e8cf
    0x9764,  // e8d0
    0x9766,  // e8d1
    0x9768,  // e8d2
    0x52d2,  // e8d3
    0x976b,  // e8d4
    0x9771,  // e8d5
    0x9779,  // e8d6
    0x9785,  // e8d7
    0x977c,  // e8d8
    0x9781,  // e8d9
    0x977a,  // e8da
    0x9786,  // e8db
    0x978b,  // e8dc
    0x978f,  // e8dd
    0x9790,  // e8de
    0x979c,  // e8df
    0x97a8,  // e8e0
    0x97a6,  // e8e1
    0x97a3,  // e8e2
    0x97b3,  // e8e3
    0x97b4,  // e8e4
    0x97c3,  // e8e5
    0x97c6,  // e8e6
    0x97c8,  // e8e7
    0x97cb,  // e8e8
    0x97dc,  // e8e9
    0x97ed,  // e8ea
    0x9f4f,  // e8eb
    0x97f2,  // e8ec
    0x7adf,  // e8ed
    0x97f6,  // e8ee
    0x97f5,  // e8ef
    0x980f,  // e8f0
    0x980c,  // e8f1
    0x9838,  // e8f2
    0x9824,  // e8f3
    0x9821,  // e8f4
    0x9837,  // e8f5
    0x983d,  // e8f6
    0x9846,  // e8f7
    0x984f,  // e8f8
    0x984b,  // e8f9
    0x986b,  // e8fa
    0x986f,  // e8fb
    0x9870,  // e8fc
    0x9871,  // e940
    0x9874,  // e941
    0x9873,  // e942
    0x98aa,  // e943
    0x98af,  // e944
    0x98b1,  // e945
    0x98b6,  // e946
    0x98c4,  // e947
    0x98c3,  // e948
    0x98c6,  // e949
    0x98e9,  // e94a
    0x98eb,  // e94b
    0x9903,  // e94c
    0x9909,  // e94d
    0x9912,  // e94e
    0x9914,  // e94f
    0x9918,  // e950
    0x9921,  // e951
    0x991d,  // e952
    0x991e,  // e953
    0x9924,  // e954
    0x9920,  // e955
    0x992c,  // e956
    0x992e,  // e957
    0x993d,  // e958
    0x993e,  // e959
    0x9942,  // e95a
    0x9949,  // e95b
    0x9945,  // e95c
    0x9950,  // e95d
    0x994b,  // e95e
    0x9951,  // e95f
    0x9952,  // e960
    0x994c,  // e961
    0x9955,  // e962
    0x9997,  // e963
    0x9998,  // e964
    0x99a5,  // e965
    0x99ad,  // e966
    0x99ae,  // e967
    0x99bc,  // e968
    0x99df,  // e969
    0x99db,  // e96a
    0x99dd,  // e96b
    0x99d8,  // e96c
    0x99d1,  // e96d
    0x99ed,  // e96e
    0x99ee,  // e96f
    0x99f1,  // e970
    0x99f2,  // e971
    0x99fb,  // e972
    0x99f8,  // e973
    0x9a01,  // e974
    0x9a0f,  // e975
    0x9a05,  // e976
    0x99e2,  // e977
    0x9a19,  // e978
    0x9a2b,  // e979
    0x9a37,  // e97a
    0x9a45,  // e97b
    0x9a42,  // e97c
    0x9a40,  // e97d
    0x9a43,  // e97e
    0x0000,  // e97f
    0x9a3e,  // e980
    0x9a55,  // e981
    0x9a4d,  // e982
    0x9a5b,  // e983
    0x9a57,  // e984
    0x9a5f,  // e985
    0x9a62,  // e986
    0x9a65,  // e987
    0x9a64,  // e988
    0x9a69,  // e989
    0x9a6b,  // e98a
    0x9a6a,  // e98b
    0x9aad,  // e98c
    0x9ab0,  // e98d
    0x9abc,  // e98e
    0x9ac0,  // e98f
    0x9acf,  // e990
    0x9ad1,  // e991
    0x9ad3,  // e992
    0x9ad4,  // e993
    0x9ade,  // e994
    0x9adf,  // e995
    0x9ae2,  // e996
    0x9ae3,  // e997
    0x9ae6,  // e998
    0x9aef,  // e999
    0x9aeb,  // e99a
    0x9aee,  // e99b
    0x9af4,  // e99c
    0x9af1,  // e99d
    0x9af7,  // e99e
    0x9afb,  // e99f
    0x9b06,  // e9a0
    0x9b18,  // e9a1
    0x9b1a,  // e9a2
    0x9b1f,  // e9a3
    0x9b22,  // e9a4
    0x9b23,  // e9a5
    0x9b25,  // e9a6
    0x9b27,  // e9a7
    0x9b28,  // e9a8
    0x9b29,  // e9a9
    0x9b2a,  // e9aa
    0x9b2e,  // e9ab
    0x9b2f,  // e9ac
    0x9b32,  // e9ad
    0x9b44,  // e9ae
    0x9b43,  // e9af
    0x9b4f,  // e9b0
    0x9b4d,  // e9b1
    0x9b4e,  // e9b2
    0x9b51,  // e9b3
    0x9b58,  // e9b4
    0x9b74,  // e9b5
    0x9b93,  // e9b6
    0x9b83,  // e9b7
    0x9b91,  // e9b8
    0x9b96,  // e9b9
    0x9b97,  // e9ba
    0x9b9f,  // e9bb
    0x9ba0,  // e9bc
    0x9ba8,  // e9bd
    0x9bb4,  // e9be
    0x9bc0,  // e9bf
    0x9bca,  // e9c0
    0x9bb9,  // e9c1
    0x9bc6,  // e9c2
    0x9bcf,  // e9c3
    0x9bd1,  // e9c4
    0x9bd2,  // e9c5
    0x9be3,  // e9c6
    0x9be2,  // e9c7
    0x9be4,  // e9c8
    0x9bd4,  // e9c9
    0x9be1,  // e9ca
    0x9c3a,  // e9cb
    0x9bf2,  // e9cc
    0x9bf1,  // e9cd
    0x9bf0,  // e9ce
    0x9c15,  // e9cf
    0x9c14,  // e9d0
    0x9c09,  // e9d1
    0x9c13,  // e9d2
    0x9c0c,  // e9d3
    0x9c06,  // e9d4
    0x9c08,  // e9d5
    0x9c12,  // e9d6
    0x9c0a,  // e9d7
    0x9c04,  // e9d8
    0x9c2e,  // e9d9
    0x9c1b,  // e9da
    0x9c25,  // e9db
    0x9c24,  // e9dc
    0x9c21,  // e9dd
    0x9c30,  // e9de
    0x9c47,  // e9df
    0x9c32,  // e9e0
    0x9c46,  // e9e1
    0x9c3e,  // e9e2
    0x9c5a,  // e9e3
    0x9c60,  // e9e4
    0x9c67,  // e9e5
    0x9c76,  // e9e6
    0x9c78,  // e9e7
    0x9ce7,  // e9e8
    0x9cec,  // e9e9
    0x9cf0,  // e9ea
    0x9d09,  // e9eb
    0x9d08,  // e9ec
    0x9ceb,  // e9ed
    0x9d03,  // e9ee
    0x9d06,  // e9ef
    0x9d2a,  // e9f0
    0x9d26,  // e9f1
    0x9daf,  // e9f2
    0x9d23,  // e9f3
    0x9d1f,  // e9f4
    0x9d44,  // e9f5
    0x9d15,  // e9f6
    0x9d12,  // e9f7
    0x9d41,  // e9f8
    0x9d3f,  // e9f9
    0x9d3e,  // e9fa
    0x9d46,  // e9fb
    0x9d48,  // e9fc
    0x9d5d,  // ea40
    0x9d5e,  // ea41
    0x9d64,  // ea42
    0x9d51,  // ea43
    0x9d50,  // ea44
    0x9d59,  // ea45
    0x9d72,  // ea46
    0x9d89,  // ea47
    0x9d87,  // ea48
    0x9dab,  // ea49
    0x9d6f,  // ea4a
    0x9d7a,  // ea4b
    0x9d9a,  // ea4c
    0x9da4,  // ea4d
    0x9da9,  // ea4e
    0x9db2,  // ea4f
    0x9dc4,  // ea50
    0x9dc1,  // ea51
    0x9dbb,  // ea52
    0x9db8,  // ea53
    0x9dba,  // ea54
    0x9dc6,  // ea55
    0x9dcf,  // ea56
    0x9dc2,  // ea57
    0x9dd9,  // ea58
    0x9dd3,  // ea59
    0x9df8,  // ea5a
    0x9de6,  // ea5b
    0x9ded,  // ea5c
    0x9def,  // ea5d
    0x9dfd,  // ea5e
    0x9e1a,  // ea5f
    0x9e1b,  // ea60
    0x9e1e,  // ea61
    0x9e75,  // ea62
    0x9e79,  // ea63
    0x9e7d,  // ea64
    0x9e81,  // ea65
    0x9e88,  // ea66
    0x9e8b,  // ea67
    0x9e8c,  // ea68
    0x9e92,  // ea69
    0x9e95,  // ea6a
    0x9e91,  // ea6b
    0x9e9d,  // ea6c
    0x9ea5,  // ea6d
    0x9ea9,  // ea6e
    0x9eb8,  // ea6f
    0x9eaa,  // ea70
    0x9ead,  // ea71
    0x9761,  // ea72
    0x9ecc,  // ea73
    0x9ece,  // ea74
    0x9ecf,  // ea75
    0x9ed0,  // ea76
    0x9ed4,  // ea77
    0x9edc,  // ea78
    0x9ede,  // ea79
    0x9edd,  // ea7a
    0x9ee0,  // ea7b
    0x9ee5,  // ea7c
    0x9ee8,  // ea7d
    0x9eef,  // ea7e
    0x0000,  // ea7f
    0x9ef4,  // ea80
    0x9ef6,  // ea81
    0x9ef7,  // ea82
    0x9ef9,  // ea83
    0x9efb,  // ea84
    0x9efc,  // ea85
    0x9efd,  // ea86
    0x9f07,  // ea87
    0x9f08,  // ea88
    0x76b7,  // ea89
    0x9f15,  // ea8a
    0x9f21,  // ea8b
    0x9f2c,  // ea8c
    0x9f3e,  // ea8d
    0x9f4a,  // ea8e
    0x9f52,  // ea8f
    0x9f54,  // ea90
    0x9f63,  // ea91
    0x9f5f,  // ea92
    0x9f60,  // ea93
    0x9f61,  // ea94
    0x9f66,  // ea95
    0x9f67,  // ea96
    0x9f6c,  // ea97
    0x9f6a,  // ea98
    0x9f77,  // ea99
    0x9f72,  // ea9a
    0x9f76,  // ea9b
    0x9f95,  // ea9c
    0x9f9c,  // ea9d
    0x9fa0,  // ea9e
    0x582f,  // ea9f
    0x69c7,  // eaa0
    0x9059,  // eaa1
    0x7464,  // eaa2
    0x51dc,  // eaa3
    0x7199,  // eaa4
    0x0000,  // eaa5
    0x0000,  // eaa6
    0x0000,  // eaa7
    0x0000,  // eaa8
    0x0000,  // eaa9
    0x0000,  // eaaa
    0x0000,  // eaab
    0x0000,  // eaac
    0x0000,  // eaad
    0x0000,  // eaae
    0x0000,  // eaaf
    0x0000,  // eab0
    0x0000,  // eab1
    0x0000,  // eab2
    0x0000,  // eab3
    0x0000,  // eab4
    0x0000,  // eab5
    0x0000,  // eab6
    0x0000,  // eab7
    0x0000,  // eab8
    0x0000,  // eab9
    0x0000,  // eaba
    0x0000,  // eabb
    0x0000,  // eabc
    0x0000,  // eabd
    0x0000,  // eabe
    0x0000,  // eabf
    0x0000,  // eac0
    0x0000,  // eac1
    0x0000,  // eac2
    0x0000,  // eac3
    0x0000,  // eac4
    0x0000,  // eac5
    0x0000,  // eac6
    0x0000,  // eac7
    0x0000,  // eac8
    0x0000,  // eac9
    0x0000,  // eaca
    0x0000,  // eacb
    0x0000,  // eacc
    0x0000,  // eacd
    0x0000,  // eace
    0x0000,  // eacf
    0x0000,  // ead0
    0x0000,  // ead1
    0x0000,  // ead2
    0x0000,  // ead3
    0x0000,  // ead4
    0x0000,  // ead5
    0x0000,  // ead6
    0x0000,  // ead7
    0x0000,  // ead8
    0x0000,  // ead9
    0x0000,  // eada
    0x0000,  // eadb
    0x0000,  // eadc
    0x0000,  // eadd
    0x0000,  // eade
    0x0000,  // eadf
    0x0000,  // eae0
    0x0000,  // eae1
    0x0000,  // eae2
    0x0000,  // eae3
    0x0000,  // eae4
    0x0000,  // eae5
    0x0000,  // eae6
    0x0000,  // eae7
    0x0000,  // eae8
    0x0000,  // eae9
    0x0000,  // eaea
    0x0000,  // eaeb
    0x0000,  // eaec
    0x0000,  // eaed
    0x0000,  // eaee
    0x0000,  // eaef
    0x0000,  // eaf0
    0x0000,  // eaf1
    0x0000,  // eaf2
    0x0000,  // eaf3
    0x0000,  // eaf4
    0x0000,  // eaf5
    0x0000,  // eaf6
    0x0000,  // eaf7
    0x0000,  // eaf8
    0x0000,  // eaf9
    0x0000,  // eafa
    0x0000,  // eafb
    0x0000,  // eafc
};

const unsigned short CP932Table::codemap_ed[] = {
    0x7e8a,  // ed40
    0x891c,  // ed41
    0x9348,  // ed42
    0x9288,  // ed43
    0x84dc,  // ed44
    0x4fc9,  // ed45
    0x70bb,  // ed46
    0x6631,  // ed47
    0x68c8,  // ed48
    0x92f9,  // ed49
    0x66fb,  // ed4a
    0x5f45,  // ed4b
    0x4e28,  // ed4c
    0x4ee1,  // ed4d
    0x4efc,  // ed4e
    0x4f00,  // ed4f
    0x4f03,  // ed50
    0x4f39,  // ed51
    0x4f56,  // ed52
    0x4f92,  // ed53
    0x4f8a,  // ed54
    0x4f9a,  // ed55
    0x4f94,  // ed56
    0x4fcd,  // ed57
    0x5040,  // ed58
    0x5022,  // ed59
    0x4fff,  // ed5a
    0x501e,  // ed5b
    0x5046,  // ed5c
    0x5070,  // ed5d
    0x5042,  // ed5e
    0x5094,  // ed5f
    0x50f4,  // ed60
    0x50d8,  // ed61
    0x514a,  // ed62
    0x5164,  // ed63
    0x519d,  // ed64
    0x51be,  // ed65
    0x51ec,  // ed66
    0x5215,  // ed67
    0x529c,  // ed68
    0x52a6,  // ed69
    0x52c0,  // ed6a
    0x52db,  // ed6b
    0x5300,  // ed6c
    0x5307,  // ed6d
    0x5324,  // ed6e
    0x5372,  // ed6f
    0x5393,  // ed70
    0x53b2,  // ed71
    0x53dd,  // ed72
    0xfa0e,  // ed73
    0x549c,  // ed74
    0x548a,  // ed75
    0x54a9,  // ed76
    0x54ff,  // ed77
    0x5586,  // ed78
    0x5759,  // ed79
    0x5765,  // ed7a
    0x57ac,  // ed7b
    0x57c8,  // ed7c
    0x57c7,  // ed7d
    0xfa0f,  // ed7e
    0x0000,  // ed7f
    0xfa10,  // ed80
    0x589e,  // ed81
    0x58b2,  // ed82
    0x590b,  // ed83
    0x5953,  // ed84
    0x595b,  // ed85
    0x595d,  // ed86
    0x5963,  // ed87
    0x59a4,  // ed88
    0x59ba,  // ed89
    0x5b56,  // ed8a
    0x5bc0,  // ed8b
    0x752f,  // ed8c
    0x5bd8,  // ed8d
    0x5bec,  // ed8e
    0x5c1e,  // ed8f
    0x5ca6,  // ed90
    0x5cba,  // ed91
    0x5cf5,  // ed92
    0x5d27,  // ed93
    0x5d53,  // ed94
    0xfa11,  // ed95
    0x5d42,  // ed96
    0x5d6d,  // ed97
    0x5db8,  // ed98
    0x5db9,  // ed99
    0x5dd0,  // ed9a
    0x5f21,  // ed9b
    0x5f34,  // ed9c
    0x5f67,  // ed9d
    0x5fb7,  // ed9e
    0x5fde,  // ed9f
    0x605d,  // eda0
    0x6085,  // eda1
    0x608a,  // eda2
    0x60de,  // eda3
    0x60d5,  // eda4
    0x6120,  // eda5
    0x60f2,  // eda6
    0x6111,  // eda7
    0x6137,  // eda8
    0x6130,  // eda9
    0x6198,  // edaa
    0x6213,  // edab
    0x62a6,  // edac
    0x63f5,  // edad
    0x6460,  // edae
    0x649d,  // edaf
    0x64ce,  // edb0
    0x654e,  // edb1
    0x6600,  // edb2
    0x6615,  // edb3
    0x663b,  // edb4
    0x6609,  // edb5
    0x662e,  // edb6
    0x661e,  // edb7
    0x6624,  // edb8
    0x6665,  // edb9
    0x6657,  // edba
    0x6659,  // edbb
    0xfa12,  // edbc
    0x6673,  // edbd
    0x6699,  // edbe
    0x66a0,  // edbf
    0x66b2,  // edc0
    0x66bf,  // edc1
    0x66fa,  // edc2
    0x670e,  // edc3
    0xf929,  // edc4
    0x6766,  // edc5
    0x67bb,  // edc6
    0x6852,  // edc7
    0x67c0,  // edc8
    0x6801,  // edc9
    0x6844,  // edca
    0x68cf,  // edcb
    0xfa13,  // edcc
    0x6968,  // edcd
    0xfa14,  // edce
    0x6998,  // edcf
    0x69e2,  // edd0
    0x6a30,  // edd1
    0x6a6b,  // edd2
    0x6a46,  // edd3
    0x6a73,  // edd4
    0x6a7e,  // edd5
    0x6ae2,  // edd6
    0x6ae4,  // edd7
    0x6bd6,  // edd8
    0x6c3f,  // edd9
    0x6c5c,  // edda
    0x6c86,  // eddb
    0x6c6f,  // eddc
    0x6cda,  // eddd
    0x6d04,  // edde
    0x6d87,  // eddf
    0x6d6f,  // ede0
    0x6d96,  // ede1
    0x6dac,  // ede2
    0x6dcf,  // ede3
    0x6df8,  // ede4
    0x6df2,  // ede5
    0x6dfc,  // ede6
    0x6e39,  // ede7
    0x6e5c,  // ede8
    0x6e27,  // ede9
    0x6e3c,  // edea
    0x6ebf,  // edeb
    0x6f88,  // edec
    0x6fb5,  // eded
    0x6ff5,  // edee
    0x7005,  // edef
    0x7007,  // edf0
    0x7028,  // edf1
    0x7085,  // edf2
    0x70ab,  // edf3
    0x710f,  // edf4
    0x7104,  // edf5
    0x715c,  // edf6
    0x7146,  // edf7
    0x7147,  // edf8
    0xfa15,  // edf9
    0x71c1,  // edfa
    0x71fe,  // edfb
    0x72b1,  // edfc
    0x72be,  // ee40
    0x7324,  // ee41
    0xfa16,  // ee42
    0x7377,  // ee43
    0x73bd,  // ee44
    0x73c9,  // ee45
    0x73d6,  // ee46
    0x73e3,  // ee47
    0x73d2,  // ee48
    0x7407,  // ee49
    0x73f5,  // ee4a
    0x7426,  // ee4b
    0x742a,  // ee4c
    0x7429,  // ee4d
    0x742e,  // ee4e
    0x7462,  // ee4f
    0x7489,  // ee50
    0x749f,  // ee51
    0x7501,  // ee52
    0x756f,  // ee53
    0x7682,  // ee54
    0x769c,  // ee55
    0x769e,  // ee56
    0x769b,  // ee57
    0x76a6,  // ee58
    0xfa17,  // ee59
    0x7746,  // ee5a
    0x52af,  // ee5b
    0x7821,  // ee5c
    0x784e,  // ee5d
    0x7864,  // ee5e
    0x787a,  // ee5f
    0x7930,  // ee60
    0xfa18,  // ee61
    0xfa19,  // ee62
    0xfa1a,  // ee63
    0x7994,  // ee64
    0xfa1b,  // ee65
    0x799b,  // ee66
    0x7ad1,  // ee67
    0x7ae7,  // ee68
    0xfa1c,  // ee69
    0x7aeb,  // ee6a
    0x7b9e,  // ee6b
    0xfa1d,  // ee6c
    0x7d48,  // ee6d
    0x7d5c,  // ee6e
    0x7db7,  // ee6f
    0x7da0,  // ee70
    0x7dd6,  // ee71
    0x7e52,  // ee72
    0x7f47,  // ee73
    0x7fa1,  // ee74
    0xfa1e,  // ee75
    0x8301,  // ee76
    0x8362,  // ee77
    0x837f,  // ee78
    0x83c7,  // ee79
    0x83f6,  // ee7a
    0x8448,  // ee7b
    0x84b4,  // ee7c
    0x8553,  // ee7d
    0x8559,  // ee7e
    0x0000,  // ee7f
    0x856b,  // ee80
    0xfa1f,  // ee81
    0x85b0,  // ee82
    0xfa20,  // ee83
    0xfa21,  // ee84
    0x8807,  // ee85
    0x88f5,  // ee86
    0x8a12,  // ee87
    0x8a37,  // ee88
    0x8a79,  // ee89
    0x8aa7,  // ee8a
    0x8abe,  // ee8b
    0x8adf,  // ee8c
    0xfa22,  // ee8d
    0x8af6,  // ee8e
    0x8b53,  // ee8f
    0x8b7f,  // ee90
    0x8cf0,  // ee91
    0x8cf4,  // ee92
    0x8d12,  // ee93
    0x8d76,  // ee94
    0xfa23,  // ee95
    0x8ecf,  // ee96
    0xfa24,  // ee97
    0xfa25,  // ee98
    0x9067,  // ee99
    0x90de,  // ee9a
    0xfa26,  // ee9b
    0x9115,  // ee9c
    0x9127,  // ee9d
    0x91da,  // ee9e
    0x91d7,  // ee9f
    0x91de,  // eea0
    0x91ed,  // eea1
    0x91ee,  // eea2
    0x91e4,  // eea3
    0x91e5,  // eea4
    0x9206,  // eea5
    0x9210,  // eea6
    0x920a,  // eea7
    0x923a,  // eea8
    0x9240,  // eea9
    0x923c,  // eeaa
    0x924e,  // eeab
    0x9259,  // eeac
    0x9251,  // eead
    0x9239,  // eeae
    0x9267,  // eeaf
    0x92a7,  // eeb0
    0x9277,  // eeb1
    0x9278,  // eeb2
    0x92e7,  // eeb3
    0x92d7,  // eeb4
    0x92d9,  // eeb5
    0x92d0,  // eeb6
    0xfa27,  // eeb7
    0x92d5,  // eeb8
    0x92e0,  // eeb9
    0x92d3,  // eeba
    0x9325,  // eebb
    0x9321,  // eebc
    0x92fb,  // eebd
    0xfa28,  // eebe
    0x931e,  // eebf
    0x92ff,  // eec0
    0x931d,  // eec1
    0x9302,  // eec2
    0x9370,  // eec3
    0x9357,  // eec4
    0x93a4,  // eec5
    0x93c6,  // eec6
    0x93de,  // eec7
    0x93f8,  // eec8
    0x9431,  // eec9
    0x9445,  // eeca
    0x9448,  // eecb
    0x9592,  // eecc
    0xf9dc,  // eecd
    0xfa29,  // eece
    0x969d,  // eecf
    0x96af,  // eed0
    0x9733,  // eed1
    0x973b,  // eed2
    0x9743,  // eed3
    0x974d,  // eed4
    0x974f,  // eed5
    0x9751,  // eed6
    0x9755,  // eed7
    0x9857,  // eed8
    0x9865,  // eed9
    0xfa2a,  // eeda
    0xfa2b,  // eedb
    0x9927,  // eedc
    0xfa2c,  // eedd
    0x999e,  // eede
    0x9a4e,  // eedf
    0x9ad9,  // eee0
    0x9adc,  // eee1
    0x9b75,  // eee2
    0x9b72,  // eee3
    0x9b8f,  // eee4
    0x9bb1,  // eee5
    0x9bbb,  // eee6
    0x9c00,  // eee7
    0x9d70,  // eee8
    0x9d6b,  // eee9
    0xfa2d,  // eeea
    0x9e19,  // eeeb
    0x9ed1,  // eeec
    0x0000,  // eeed
    0x0000,  // eeee
    0x2170,  // eeef
    0x2171,  // eef0
    0x2172,  // eef1
    0x2173,  // eef2
    0x2174,  // eef3
    0x2175,  // eef4
    0x2176,  // eef5
    0x2177,  // eef6
    0x2178,  // eef7
    0x2179,  // eef8
    0xffe2,  // eef9
    0xffe4,  // eefa
    0xff07,  // eefb
    0xff02,  // eefc
};

const unsigned short CP932Table::codemap_fa[] = {
    0x2170,  // fa40
    0x2171,  // fa41
    0x2172,  // fa42
    0x2173,  // fa43
    0x2174,  // fa44
    0x2175,  // fa45
    0x2176,  // fa46
    0x2177,  // fa47
    0x2178,  // fa48
    0x2179,  // fa49
    0x2160,  // fa4a
    0x2161,  // fa4b
    0x2162,  // fa4c
    0x2163,  // fa4d
    0x2164,  // fa4e
    0x2165,  // fa4f
    0x2166,  // fa50
    0x2167,  // fa51
    0x2168,  // fa52
    0x2169,  // fa53
    0xffe2,  // fa54
    0xffe4,  // fa55
    0xff07,  // fa56
    0xff02,  // fa57
    0x3231,  // fa58
    0x2116,  // fa59
    0x2121,  // fa5a
    0x2235,  // fa5b
    0x7e8a,  // fa5c
    0x891c,  // fa5d
    0x9348,  // fa5e
    0x9288,  // fa5f
    0x84dc,  // fa60
    0x4fc9,  // fa61
    0x70bb,  // fa62
    0x6631,  // fa63
    0x68c8,  // fa64
    0x92f9,  // fa65
    0x66fb,  // fa66
    0x5f45,  // fa67
    0x4e28,  // fa68
    0x4ee1,  // fa69
    0x4efc,  // fa6a
    0x4f00,  // fa6b
    0x4f03,  // fa6c
    0x4f39,  // fa6d
    0x4f56,  // fa6e
    0x4f92,  // fa6f
    0x4f8a,  // fa70
    0x4f9a,  // fa71
    0x4f94,  // fa72
    0x4fcd,  // fa73
    0x5040,  // fa74
    0x5022,  // fa75
    0x4fff,  // fa76
    0x501e,  // fa77
    0x5046,  // fa78
    0x5070,  // fa79
    0x5042,  // fa7a
    0x5094,  // fa7b
    0x50f4,  // fa7c
    0x50d8,  // fa7d
    0x514a,  // fa7e
    0x0000,  // fa7f
    0x5164,  // fa80
    0x519d,  // fa81
    0x51be,  // fa82
    0x51ec,  // fa83
    0x5215,  // fa84
    0x529c,  // fa85
    0x52a6,  // fa86
    0x52c0,  // fa87
    0x52db,  // fa88
    0x5300,  // fa89
    0x5307,  // fa8a
    0x5324,  // fa8b
    0x5372,  // fa8c
    0x5393,  // fa8d
    0x53b2,  // fa8e
    0x53dd,  // fa8f
    0xfa0e,  // fa90
    0x549c,  // fa91
    0x548a,  // fa92
    0x54a9,  // fa93
    0x54ff,  // fa94
    0x5586,  // fa95
    0x5759,  // fa96
    0x5765,  // fa97
    0x57ac,  // fa98
    0x57c8,  // fa99
    0x57c7,  // fa9a
    0xfa0f,  // fa9b
    0xfa10,  // fa9c
    0x589e,  // fa9d
    0x58b2,  // fa9e
    0x590b,  // fa9f
    0x5953,  // faa0
    0x595b,  // faa1
    0x595d,  // faa2
    0x5963,  // faa3
    0x59a4,  // faa4
    0x59ba,  // faa5
    0x5b56,  // faa6
    0x5bc0,  // faa7
    0x752f,  // faa8
    0x5bd8,  // faa9
    0x5bec,  // faaa
    0x5c1e,  // faab
    0x5ca6,  // faac
    0x5cba,  // faad
    0x5cf5,  // faae
    0x5d27,  // faaf
    0x5d53,  // fab0
    0xfa11,  // fab1
    0x5d42,  // fab2
    0x5d6d,  // fab3
    0x5db8,  // fab4
    0x5db9,  // fab5
    0x5dd0,  // fab6
    0x5f21,  // fab7
    0x5f34,  // fab8
    0x5f67,  // fab9
    0x5fb7,  // faba
    0x5fde,  // fabb
    0x605d,  // fabc
    0x6085,  // fabd
    0x608a,  // fabe
    0x60de,  // fabf
    0x60d5,  // fac0
    0x6120,  // fac1
    0x60f2,  // fac2
    0x6111,  // fac3
    0x6137,  // fac4
    0x6130,  // fac5
    0x6198,  // fac6
    0x6213,  // fac7
    0x62a6,  // fac8
    0x63f5,  // fac9
    0x6460,  // faca
    0x649d,  // facb
    0x64ce,  // facc
    0x654e,  // facd
    0x6600,  // face
    0x6615,  // facf
    0x663b,  // fad0
    0x6609,  // fad1
    0x662e,  // fad2
    0x661e,  // fad3
    0x6624,  // fad4
    0x6665,  // fad5
    0x6657,  // fad6
    0x6659,  // fad7
    0xfa12,  // fad8
    0x6673,  // fad9
    0x6699,  // fada
    0x66a0,  // fadb
    0x66b2,  // fadc
    0x66bf,  // fadd
    0x66fa,  // fade
    0x670e,  // fadf
    0xf929,  // fae0
    0x6766,  // fae1
    0x67bb,  // fae2
    0x6852,  // fae3
    0x67c0,  // fae4
    0x6801,  // fae5
    0x6844,  // fae6
    0x68cf,  // fae7
    0xfa13,  // fae8
    0x6968,  // fae9
    0xfa14,  // faea
    0x6998,  // faeb
    0x69e2,  // faec
    0x6a30,  // faed
    0x6a6b,  // faee
    0x6a46,  // faef
    0x6a73,  // faf0
    0x6a7e,  // faf1
    0x6ae2,  // faf2
    0x6ae4,  // faf3
    0x6bd6,  // faf4
    0x6c3f,  // faf5
    0x6c5c,  // faf6
    0x6c86,  // faf7
    0x6c6f,  // faf8
    0x6cda,  // faf9
    0x6d04,  // fafa
    0x6d87,  // fafb
    0x6d6f,  // fafc
    0x6d96,  // fb40
    0x6dac,  // fb41
    0x6dcf,  // fb42
    0x6df8,  // fb43
    0x6df2,  // fb44
    0x6dfc,  // fb45
    0x6e39,  // fb46
    0x6e5c,  // fb47
    0x6e27,  // fb48
    0x6e3c,  // fb49
    0x6ebf,  // fb4a
    0x6f88,  // fb4b
    0x6fb5,  // fb4c
    0x6ff5,  // fb4d
    0x7005,  // fb4e
    0x7007,  // fb4f
    0x7028,  // fb50
    0x7085,  // fb51
    0x70ab,  // fb52
    0x710f,  // fb53
    0x7104,  // fb54
    0x715c,  // fb55
    0x7146,  // fb56
    0x7147,  // fb57
    0xfa15,  // fb58
    0x71c1,  // fb59
    0x71fe,  // fb5a
    0x72b1,  // fb5b
    0x72be,  // fb5c
    0x7324,  // fb5d
    0xfa16,  // fb5e
    0x7377,  // fb5f
    0x73bd,  // fb60
    0x73c9,  // fb61
    0x73d6,  // fb62
    0x73e3,  // fb63
    0x73d2,  // fb64
    0x7407,  // fb65
    0x73f5,  // fb66
    0x7426,  // fb67
    0x742a,  // fb68
    0x7429,  // fb69
    0x742e,  // fb6a
    0x7462,  // fb6b
    0x7489,  // fb6c
    0x749f,  // fb6d
    0x7501,  // fb6e
    0x756f,  // fb6f
    0x7682,  // fb70
    0x769c,  // fb71
    0x769e,  // fb72
    0x769b,  // fb73
    0x76a6,  // fb74
    0xfa17,  // fb75
    0x7746,  // fb76
    0x52af,  // fb77
    0x7821,  // fb78
    0x784e,  // fb79
    0x7864,  // fb7a
    0x787a,  // fb7b
    0x7930,  // fb7c
    0xfa18,  // fb7d
    0xfa19,  // fb7e
    0x0000,  // fb7f
    0xfa1a,  // fb80
    0x7994,  // fb81
    0xfa1b,  // fb82
    0x799b,  // fb83
    0x7ad1,  // fb84
    0x7ae7,  // fb85
    0xfa1c,  // fb86
    0x7aeb,  // fb87
    0x7b9e,  // fb88
    0xfa1d,  // fb89
    0x7d48,  // fb8a
    0x7d5c,  // fb8b
    0x7db7,  // fb8c
    0x7da0,  // fb8d
    0x7dd6,  // fb8e
    0x7e52,  // fb8f
    0x7f47,  // fb90
    0x7fa1,  // fb91
    0xfa1e,  // fb92
    0x8301,  // fb93
    0x8362,  // fb94
    0x837f,  // fb95
    0x83c7,  // fb96
    0x83f6,  // fb97
    0x8448,  // fb98
    0x84b4,  // fb99
    0x8553,  // fb9a
    0x8559,  // fb9b
    0x856b,  // fb9c
    0xfa1f,  // fb9d
    0x85b0,  // fb9e
    0xfa20,  // fb9f
    0xfa21,  // fba0
    0x8807,  // fba1
    0x88f5,  // fba2
    0x8a12,  // fba3
    0x8a37,  // fba4
    0x8a79,  // fba5
    0x8aa7,  // fba6
    0x8abe,  // fba7
    0x8adf,  // fba8
    0xfa22,  // fba9
    0x8af6,  // fbaa
    0x8b53,  // fbab
    0x8b7f,  // fbac
    0x8cf0,  // fbad
    0x8cf4,  // fbae
    0x8d12,  // fbaf
    0x8d76,  // fbb0
    0xfa23,  // fbb1
    0x8ecf,  // fbb2
    0xfa24,  // fbb3
    0xfa25,  // fbb4
    0x9067,  // fbb5
    0x90de,  // fbb6
    0xfa26,  // fbb7
    0x9115,  // fbb8
    0x9127,  // fbb9
    0x91da,  // fbba
    0x91d7,  // fbbb
    0x91de,  // fbbc
    0x91ed,  // fbbd
    0x91ee,  // fbbe
    0x91e4,  // fbbf
    0x91e5,  // fbc0
    0x9206,  // fbc1
    0x9210,  // fbc2
    0x920a,  // fbc3
    0x923a,  // fbc4
    0x9240,  // fbc5
    0x923c,  // fbc6
    0x924e,  // fbc7
    0x9259,  // fbc8
    0x9251,  // fbc9
    0x9239,  // fbca
    0x9267,  // fbcb
    0x92a7,  // fbcc
    0x9277,  // fbcd
    0x9278,  // fbce
    0x92e7,  // fbcf
    0x92d7,  // fbd0
    0x92d9,  // fbd1
    0x92d0,  // fbd2
    0xfa27,  // fbd3
    0x92d5,  // fbd4
    0x92e0,  // fbd5
    0x92d3,  // fbd6
    0x9325,  // fbd7
    0x9321,  // fbd8
    0x92fb,  // fbd9
    0xfa28,  // fbda
    0x931e,  // fbdb
    0x92ff,  // fbdc
    0x931d,  // fbdd
    0x9302,  // fbde
    0x9370,  // fbdf
    0x9357,  // fbe0
    0x93a4,  // fbe1
    0x93c6,  // fbe2
    0x93de,  // fbe3
    0x93f8,  // fbe4
    0x9431,  // fbe5
    0x9445,  // fbe6
    0x9448,  // fbe7
    0x9592,  // fbe8
    0xf9dc,  // fbe9
    0xfa29,  // fbea
    0x969d,  // fbeb
    0x96af,  // fbec
    0x9733,  // fbed
    0x973b,  // fbee
    0x9743,  // fbef
    0x974d,  // fbf0
    0x974f,  // fbf1
    0x9751,  // fbf2
    0x9755,  // fbf3
    0x9857,  // fbf4
    0x9865,  // fbf5
    0xfa2a,  // fbf6
    0xfa2b,  // fbf7
    0x9927,  // fbf8
    0xfa2c,  // fbf9
    0x999e,  // fbfa
    0x9a4e,  // fbfb
    0x9ad9,  // fbfc
    0x9adc,  // fc40
    0x9b75,  // fc41
    0x9b72,  // fc42
    0x9b8f,  // fc43
    0x9bb1,  // fc44
    0x9bbb,  // fc45
    0x9c00,  // fc46
    0x9d70,  // fc47
    0x9d6b,  // fc48
    0xfa2d,  // fc49
    0x9e19,  // fc4a
    0x9ed1,  // fc4b
    0x0000,  // fc4c
    0x0000,  // fc4d
    0x0000,  // fc4e
    0x0000,  // fc4f
    0x0000,  // fc50
    0x0000,  // fc51
    0x0000,  // fc52
    0x0000,  // fc53
    0x0000,  // fc54
    0x0000,  // fc55
    0x0000,  // fc56
    0x0000,  // fc57
    0x0000,  // fc58
    0x0000,  // fc59
    0x0000,  // fc5a
    0x0000,  // fc5b
    0x0000,  // fc5c
    0x0000,  // fc5d
    0x0000,  // fc5e
    0x0000,  // fc5f
    0x0000,  // fc60
    0x0000,  // fc61
    0x0000,  // fc62
    0x0000,  // fc63
    0x0000,  // fc64
    0x0000,  // fc65
    0x0000,  // fc66
    0x0000,  // fc67
    0x0000,  // fc68
    0x0000,  // fc69
    0x0000,  // fc6a
    0x0000,  // fc6b
    0x0000,  // fc6c
    0x0000,  // fc6d
    0x0000,  // fc6e
    0x0000,  // fc6f
    0x0000,  // fc70
    0x0000,  // fc71
    0x0000,  // fc72
    0x0000,  // fc73
    0x0000,  // fc74
    0x0000,  // fc75
    0x0000,  // fc76
    0x0000,  // fc77
    0x0000,  // fc78
    0x0000,  // fc79
    0x0000,  // fc7a
    0x0000,  // fc7b
    0x0000,  // fc7c
    0x0000,  // fc7d
    0x0000,  // fc7e
    0x0000,  // fc7f
    0x0000,  // fc80
    0x0000,  // fc81
    0x0000,  // fc82
    0x0000,  // fc83
    0x0000,  // fc84
    0x0000,  // fc85
    0x0000,  // fc86
    0x0000,  // fc87
    0x0000,  // fc88
    0x0000,  // fc89
    0x0000,  // fc8a
    0x0000,  // fc8b
    0x0000,  // fc8c
    0x0000,  // fc8d
    0x0000,  // fc8e
    0x0000,  // fc8f
    0x0000,  // fc90
    0x0000,  // fc91
    0x0000,  // fc92
    0x0000,  // fc93
    0x0000,  // fc94
    0x0000,  // fc95
    0x0000,  // fc96
    0x0000,  // fc97
    0x0000,  // fc98
    0x0000,  // fc99
    0x0000,  // fc9a
    0x0000,  // fc9b
    0x0000,  // fc9c
    0x0000,  // fc9d
    0x0000,  // fc9e
    0x0000,  // fc9f
    0x0000,  // fca0
    0x0000,  // fca1
    0x0000,  // fca2
    0x0000,  // fca3
    0x0000,  // fca4
    0x0000,  // fca5
    0x0000,  // fca6
    0x0000,  // fca7
    0x0000,  // fca8
    0x0000,  // fca9
    0x0000,  // fcaa
    0x0000,  // fcab
    0x0000,  // fcac
    0x0000,  // fcad
    0x0000,  // fcae
    0x0000,  // fcaf
    0x0000,  // fcb0
    0x0000,  // fcb1
    0x0000,  // fcb2
    0x0000,  // fcb3
    0x0000,  // fcb4
    0x0000,  // fcb5
    0x0000,  // fcb6
    0x0000,  // fcb7
    0x0000,  // fcb8
    0x0000,  // fcb9
    0x0000,  // fcba
    0x0000,  // fcbb
    0x0000,  // fcbc
    0x0000,  // fcbd
    0x0000,  // fcbe
    0x0000,  // fcbf
    0x0000,  // fcc0
    0x0000,  // fcc1
    0x0000,  // fcc2
    0x0000,  // fcc3
    0x0000,  // fcc4
    0x0000,  // fcc5
    0x0000,  // fcc6
    0x0000,  // fcc7
    0x0000,  // fcc8
    0x0000,  // fcc9
    0x0000,  // fcca
    0x0000,  // fccb
    0x0000,  // fccc
    0x0000,  // fccd
    0x0000,  // fcce
    0x0000,  // fccf
    0x0000,  // fcd0
    0x0000,  // fcd1
    0x0000,  // fcd2
    0x0000,  // fcd3
    0x0000,  // fcd4
    0x0000,  // fcd5
    0x0000,  // fcd6
    0x0000,  // fcd7
    0x0000,  // fcd8
    0x0000,  // fcd9
    0x0000,  // fcda
    0x0000,  // fcdb
    0x0000,  // fcdc
    0x0000,  // fcdd
    0x0000,  // fcde
    0x0000,  // fcdf
    0x0000,  // fce0
    0x0000,  // fce1
    0x0000,  // fce2
    0x0000,  // fce3
    0x0000,  // fce4
    0x0000,  // fce5
    0x0000,  // fce6
    0x0000,  // fce7
    0x0000,  // fce8
    0x0000,  // fce9
    0x0000,  // fcea
    0x0000,  // fceb
    0x0000,  // fcec
    0x0000,  // fced
    0x0000,  // fcee
    0x0000,  // fcef
    0x0000,  // fcf0
    0x0000,  // fcf1
    0x0000,  // fcf2
    0x0000,  // fcf3
    0x0000,  // fcf4
    0x0000,  // fcf5
    0x0000,  // fcf6
    0x0000,  // fcf7
    0x0000,  // fcf8
    0x0000,  // fcf9
    0x0000,  // fcfa
    0x0000,  // fcfb
    0x0000,  // fcfc
};

const unsigned short CP932Table::codemap_a1[] = {
    0xff61,  // a1
    0xff62,  // a2
    0xff63,  // a3
    0xff64,  // a4
    0xff65,  // a5
    0xff66,  // a6
    0xff67,  // a7
    0xff68,  // a8
    0xff69,  // a9
    0xff6a,  // aa
    0xff6b,  // ab
    0xff6c,  // ac
    0xff6d,  // ad
    0xff6e,  // ae
    0xff6f,  // af
    0xff70,  // b0
    0xff71,  // b1
    0xff72,  // b2
    0xff73,  // b3
    0xff74,  // b4
    0xff75,  // b5
    0xff76,  // b6
    0xff77,  // b7
    0xff78,  // b8
    0xff79,  // b9
    0xff7a,  // ba
    0xff7b,  // bb
    0xff7c,  // bc
    0xff7d,  // bd
    0xff7e,  // be
    0xff7f,  // bf
    0xff80,  // c0
    0xff81,  // c1
    0xff82,  // c2
    0xff83,  // c3
    0xff84,  // c4
    0xff85,  // c5
    0xff86,  // c6
    0xff87,  // c7
    0xff88,  // c8
    0xff89,  // c9
    0xff8a,  // ca
    0xff8b,  // cb
    0xff8c,  // cc
    0xff8d,  // cd
    0xff8e,  // ce
    0xff8f,  // cf
    0xff90,  // d0
    0xff91,  // d1
    0xff92,  // d2
    0xff93,  // d3
    0xff94,  // d4
    0xff95,  // d5
    0xff96,  // d6
    0xff97,  // d7
    0xff98,  // d8
    0xff99,  // d9
    0xff9a,  // da
    0xff9b,  // db
    0xff9c,  // dc
    0xff9d,  // dd
    0xff9e,  // de
    0xff9f,  // df
};


} // namespace convert

} // namespace dialektos
