/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CP932_TABLE_HXX
#define CP932_TABLE_HXX

namespace dialektos {

namespace convert {


struct CP932Table {
  CP932Table();
  unsigned short to_bmp(unsigned char ch) {
    if (ch >= 0xa1 && ch <= 0xdf)
      return codemap_a1[index_a1(ch)];
    return 0;
  }
  unsigned short to_bmp(unsigned char ch1, unsigned char ch2) {
    if (ch1 >= 0x81 && ch1 <= 0x9f) {
      const int index = index_81(ch1, ch2);
      return index == -1 ? 0 : codemap_81[index];
    } else if (ch1 >= 0xe0 && ch1 <= 0xea) {
      const int index = index_e0(ch1, ch2);
      return index == -1 ? 0 : codemap_e0[index];
    } else if (ch1 >= 0xed && ch1 <= 0xee) {
      const int index = index_ed(ch1, ch2);
      return index == -1 ? 0 : codemap_ed[index];
    } else if (ch1 >= 0xfa && ch1 <= 0xfc) {
      const int index = index_fa(ch1, ch2);
      return index == -1 ? 0 : codemap_fa[index];
    }
    return 0;
  }
private:
  int index_81(unsigned char ku, unsigned char ten) {
    if (ku >= 0x81 && ku <= 0x9f && ten >= 0x40 && ten <= 0xfc) {
      // from 1 ku to 62 ku.
      return (ku-0x81)*(0xfc-0x40+1) + (ten-0x40);
    }
    return -1;
  }

  int index_e0(unsigned char ku, unsigned char ten) {
    if (ku >= 0xe0 && ku <= 0xea && ten >= 0x40 && ten <= 0xfc) {
      // from 63 ku to 84 ku.
      return (ku-0xe0)*(0xfc-0x40+1) + (ten-0x40);
    }
    return -1;
  }

  int index_ed(unsigned char ku, unsigned char ten) {
    if (ku >= 0xed && ku <= 0xee && ten >= 0x40 && ten <= 0xfc) {
      // from 63 ku to 84 ku.
      return (ku-0xed)*(0xfc-0x40+1) + (ten-0x40);
    }
    return -1;
  }

  int index_fa(unsigned char ku, unsigned char ten) {
    if (ku >= 0xfa && ku <= 0xfc && ten >= 0x40 && ten <= 0xfc) {
      return (ku-0xfa)*(0xfc-0x40+1) + (ten-0x40);
    }
    return -1;
  }

  int index_a1(unsigned char ch) {
    if (ch >= 0xa1 && ch <= 0xdf) {
      return ch - 0xa1;
    }
    return -1;
  }

  static const unsigned short codemap_81[(0xa0-0x81)*(0xfd-0x40)];
  static const unsigned short codemap_e0[(0xeb-0xe0)*(0xfd-0x40)];
  static const unsigned short codemap_ed[(0xef-0xed)*(0xfd-0x40)];
  static const unsigned short codemap_fa[(0xfd-0xfa)*(0xfd-0x40)];
  static const unsigned short codemap_a1[0xe0-0xa1];
};


} // namespace convert

} // namespace dialektos

#endif
