/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HISTORY_DATA_HXX
#define HISTORY_DATA_HXX

#include <boost/unordered_map.hpp>
#include <boost/filesystem/path.hpp>
#include <string>
#include <map>
#include "history_item.hxx"


namespace dialektos {

namespace history {


class Data {
  typedef std::string UriType;
  typedef boost::unordered_map<UriType, Item> MapType;
public:
  Data();
  ~Data();
  void set_writable() { writable_ = true; }

  void from_xml(const boost::filesystem::path& xml);
  void to_xml(const boost::filesystem::path& xml) const;

  void push(const Item::UriType& uri, const Item::NameType& name);
  void erase(const Item::UriType& uri);

  std::vector<Item> get_recent() const;

private:
  MapType map_;
  bool writable_;
};


} // namespace history

} // namespace dialektos

#endif
