/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef HTTP_DATE_HXX
#define HTTP_DATE_HXX


#include <boost/date_time/posix_time/posix_time.hpp>
#include <string>


namespace dialektos {

struct HTTPDateError : public std::exception {
  virtual const char* what() const throw() { return "HTTPDate Error."; }
};

boost::posix_time::ptime rfc1123_to_ptime(const std::string& rfc1123);

} // namespace dialektos


#endif
