/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef HTTP_RESPONSE_HXX
#define HTTP_RESPONSE_HXX

#include <string>
#include "http_status_line.hxx"
#include "http_header.hxx"


namespace dialektos {

namespace http {


struct Response {
  Response() {}
  Response(const StatusLine& status,
      const Header& header, const std::string& content) :
    status_(status),
    header_(header),
    content_(content) {}

  const StatusLine& get_status_line() const { return status_; }
  const Header& get_header() const { return header_; }
  const std::string& get_content() const { return content_; }

private:
  const StatusLine status_;
  const Header header_;
  const std::string content_;
};


} // namespace http

} // namespace dialektos


#endif
