/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_element_id.hxx"

#include <pangomm/font.h>
#include <glibmm/refptr.h>
#include <gdkmm/gc.h>
#include <gtkmm/enums.h>

#include "text_element_id_map.hxx"
#include "text_view_drawing_set.hxx"


namespace dialektos {

namespace text_element {


void ID::do_draw_glyphs(text_view::DrawingSet& set,
    const Pango::Item& item, const Pango::GlyphString& glyphs,
    double x, double y, bool in_selection) const {

  Glib::RefPtr<const Gdk::GC> gc;
  if (in_selection) gc = set.style->get_text_gc(Gtk::STATE_SELECTED);
  else {
    const int count = id_map_->get_count(href_);
    if (count < 2) gc = set.style->get_text_gc(Gtk::STATE_NORMAL);
    else {
      Gdk::Color color;
      if (count > 4) color.set_rgb(0xffff, 0, 0);
      else if (count > 1) color.set_rgb(0, 0, 0xffff);
      Glib::RefPtr<Gdk::GC> _gc = Gdk::GC::create(set.window);
      _gc->set_rgb_fg_color(color);
      gc = _gc;
    }
  }

  set.window->draw_glyphs(gc, item.get_analysis().get_font(),
      std::ceil(x),
      y - set.adj_value + get_metrics().get_ascent() / Pango::SCALE, glyphs);

  do_draw_underline(set, gc, double(glyphs.get_width()) / Pango::SCALE, x, y);
}


} // namespace text_element

} // namespace dialektos
