/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_ELEMENT_ID_MAP_HXX_
#define TEXT_ELEMENT_ID_MAP_HXX_

#include <glibmm/ustring.h>
#include <boost/unordered_map.hpp>
#include <boost/unordered_set.hpp>
#include <vector>


namespace Glib { size_t hash_value(const Glib::ustring&); }


namespace dialektos {


namespace text_element {


class IDMap {
  typedef boost::unordered_map<Glib::ustring, boost::unordered_set<int> >
    IDMapType;
public:
  void add(const Glib::ustring& id, int res_num);
  size_t get_count(const Glib::ustring& id) const;
  std::vector<int> get_res_num_list(const Glib::ustring& id) const;
private:
  IDMapType map_;
};


} // namespace text_element

} // namespace dialektos


#endif /* TEXT_ELEMENT_ID_MAP_HXX_ */
