/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_ELEMENT_RES_NUM_HXX
#define TEXT_ELEMENT_RES_NUM_HXX

#include <glibmm/ustring.h>
#include <pangomm/item.h>
#include <pangomm/glyphstring.h>
#include <boost/lexical_cast.hpp>
#include <boost/shared_ptr.hpp>
#include "text_element_anchor.hxx"


namespace dialektos {

namespace text_element {

class ResNumMap;


/*! @brief text element class for ResNum. */
class ResNum: public Anchor {
public:

  /*! @brief Constructor.
   *
   * @param res_num is the number of res.
   * @param bold is whether or not the text is bold.
   * @param res_num_map is the res num map.
   */
  ResNum(int res_num, bool bold, boost::shared_ptr<const ResNumMap> res_num_map) :
    Anchor(boost::lexical_cast<Glib::ustring>(res_num),
        bold, Glib::ustring("")), res_num_(res_num),
        res_num_map_(res_num_map) {

  }
  virtual ~ResNum() {}

  /*! @brief return the number of res. */
  size_t get_res_num() const { return res_num_; }
protected:

  virtual void do_draw_glyphs(text_view::DrawingSet&, const Pango::Item&,
      const Pango::GlyphString&, double x, double y,
      bool in_selection) const;

private:
  virtual ResNum* do_clone() const { return new ResNum(*this); }

  int res_num_;
  boost::shared_ptr<const ResNumMap> res_num_map_;
};


} // namespace text_element

} // namespace dialektos

#endif
