/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_LINE_HXX
#define TEXT_LINE_HXX

#include <boost/ptr_container/ptr_vector.hpp>
#include <glibmm/ustring.h>
#include <glibmm/refptr.h>
#include <pangomm/context.h>
#include <pangomm/fontmetrics.h>


namespace dialektos {


namespace text_view {
  class DrawingSet;
  class LayoutSet;
  class GetSelectedSet;
}

namespace text_element {
  class Plain;
};

class TextLine {
  typedef boost::ptr_vector<text_element::Plain> ElementListType;
public:
  explicit TextLine(int res_num, int left_margin);
  explicit TextLine(const TextLine& rhs);
  ~TextLine();
  void add_element(text_element::Plain* element);
  void trim_right();
  void itemize(const Glib::RefPtr<Pango::Context>&, const Pango::FontMetrics&);
  bool empty() const;
  bool includes(const text_element::Plain&) const;
  Glib::ustring get_selected_text(const text_view::GetSelectedSet& set) const;
  void layout(text_view::LayoutSet&);
  void draw(text_view::DrawingSet&) const;
  double get_height() const { return height_; }
  /* return y position on the adjustment. */
  double get_y() const { return y_; }
  double get_btm_y() const { return y_ + height_; }
  const text_element::Plain* get_text_element(double x, double y) const;
  const text_element::Plain* get_nearest_text_element(
      double& x, double& y) const;
  int get_res_num() const { return res_num_; }
private:
  const int res_num_;
  ElementListType element_list_;
  double height_;
  double y_;  // y on the adjustment.
  int width_;
  int left_margin_;
  int right_margin_;

  Pango::FontMetrics metrics_;
};


} // namespace dialektos

#endif
