/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_view.hxx"

#include <boost/foreach.hpp>

#include "text_line.hxx"
#include "text_element_anchor.hxx"


namespace dialektos {


namespace text_view {


TextView::TextView(): SuperClass() {}

TextView::~TextView() {
}

int TextView::get_displayed_res_num() const {
  if (const TextLine* line = get_text_line(adjustment_.get_value()))
    return line->get_res_num();
  return 0;
}

void TextView::jump_to_res_num(const int res_num) {
  if (res_num < 1 || res_num > get_res_num()) return;

  BOOST_FOREACH(TextLine& line, line_list_) {
    const int res = line.get_res_num();
    if (res_num == res) {
      adjustment_.set_value(line.get_y());
      break;
    }
  }
}

void TextView::on_anchor_click_event(const text_element::Anchor& elem) {
  const std::string uri = elem.get_href();
  if (uri.empty()) return;
  sig_uri_clicked_(uri);
}


} // namespace text_view

} // namespace dialektos
