/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_view_popup.hxx"

#include <gdkmm/rectangle.h>
#include <gtkmm/window.h>
#include <boost/foreach.hpp>
#include <boost/shared_ptr.hpp>
#include "text_element_id_map.hxx"
#include "text_element_res_num.hxx"
#include "text_line.hxx"


namespace dialektos {


namespace text_view {


Popup::Popup(const LineListType& line_list,
    const LineListType& original_line_list,
    const text_element::Anchor& element,
    boost::shared_ptr<text_element::IDMap> id_map,
    boost::shared_ptr<text_element::ResNumMap> res_num_map):
      Gtk::Window(Gtk::WINDOW_POPUP),
  text_view_(original_line_list),
  scrolled_(text_view_.get_adjustment()),
  element_origin_(element) {

  const int BORDER_WIDTH = 1;
  set_property("border_width", BORDER_WIDTH);

  text_view_.set_id_map(id_map);
  text_view_.set_res_num_map(res_num_map);

  scrolled_.add(text_view_);
  add(scrolled_);

  text_view_.show();

  text_view_.size_allocate(Gdk::Rectangle(0, 0, 300, 200));
  text_view_.get_adjustment().set_page_size(200);

  BOOST_FOREACH(const TextLine& line, line_list) {
    text_view_.add_line(new TextLine(line));
  }

  text_view_.relayout();
  text_view_.queue_draw();

  text_view_.size_allocate(Gdk::Rectangle(0, 0, 300,
      std::min(200.0, std::ceil(text_view_.get_adjustment().get_upper()))));
  set_default_size(300, text_view_.get_height()+BORDER_WIDTH*2);

}

bool Popup::is_same_origin(const text_element::Anchor& rhs) const {
  return &element_origin_ == &rhs;
}

bool Popup::on_the_child() const {
  return text_view_.is_pointer_on_the_popup();
}


} // namespace text_view


} // namespace dialektos
