/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_view_scrollable.hxx"

#include <gtkmm/drawingarea.h>
#include <sigc++/functors/mem_fun.h>


namespace dialektos {


namespace text_view {


Scrollable::Scrollable(): adjustment_(0, 0, 0) {
    adjustment_.signal_value_changed().connect(
        sigc::mem_fun(*this, &Scrollable::on_adjustment_value_changed));
    adjustment_.signal_changed().connect(
        sigc::mem_fun(*this, &Scrollable::on_adjustment_changed));
}

Scrollable::~Scrollable() {}

void Scrollable::on_adjustment_changed() {
  const gdouble value = adjustment_.get_value();
  const gdouble lower = adjustment_.get_lower();
  const gdouble upper = adjustment_.get_upper();
  const gdouble page_size = adjustment_.get_page_size();
  adjustment_.set_value(std::min(upper-page_size, std::max(value, lower)));
}

void Scrollable::on_adjustment_value_changed() {
  const gdouble value = adjustment_.get_value();
  const gdouble lower = adjustment_.get_lower();
  const gdouble upper = adjustment_.get_upper();
  const gdouble page_size = adjustment_.get_page_size();
  adjustment_.set_value(std::min(upper-page_size, std::max(value, lower)));
  queue_draw();
}

bool Scrollable::on_configure_event(GdkEventConfigure* event) {
    const int height = event->height;
    adjustment_.set_page_size(height);
    adjustment_.set_page_increment(height);
    adjustment_.set_step_increment(height*0.1);
    return Gtk::DrawingArea::on_configure_event(event);
}



} // namespace text_view

} // namespace dialektos
