/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_SCROLLABLE_HXX
#define TEXT_VIEW_SCROLLABLE_HXX

#include <gtkmm/drawingarea.h>
#include <gtkmm/adjustment.h>


namespace dialektos {


namespace text_view {


class Scrollable: public Gtk::DrawingArea {
public:
  Scrollable();
  virtual ~Scrollable();
  Gtk::Adjustment& get_adjustment() { return adjustment_; }
  const Gtk::Adjustment& get_adjustment() const { return adjustment_; }
protected:
  virtual bool on_configure_event(GdkEventConfigure*);
private:
  void on_adjustment_value_changed();
  void on_adjustment_changed();

protected:
  Gtk::Adjustment adjustment_;
};


} // namespace text_view


} // namepsace dialektos


#endif
