/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "thread_idx.hxx"

#include <boost/archive/xml_iarchive.hpp>
#include <boost/archive/xml_oarchive.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/format.hpp>
#include <boost/filesystem.hpp>
#include <fstream>
#include <string>
#include <iostream>
#include "misc.hxx"


namespace dialektos {

ThreadIdx::ThreadIdx() : title_(), line_count_(0), last_modified_(), etag_()
{}

void ThreadIdx::to_xml(const boost::filesystem::path& xml) {
  if (!misc::create_directories(xml.parent_path())) return;
  std::ofstream ofs(xml.file_string().c_str());
  try {
    boost::archive::xml_oarchive oa(ofs);
    oa << boost::serialization::make_nvp("ThreadIdx", *this);
    boost::filesystem::last_write_time(xml.parent_path(),
        boost::filesystem::last_write_time(xml));
  } catch (const boost::archive::archive_exception& e) {
    std::cerr << e.what() << " " << xml.file_string() << std::endl;
  }
  ofs.close();
}

ThreadIdx ThreadIdx::from_xml(const boost::filesystem::path& xml) {
  ThreadIdx idx;

  if (!boost::filesystem::exists(xml) ||
      !boost::filesystem::is_regular_file(xml))
    return idx;

  std::ifstream ifs(xml.file_string().c_str());
  try {
    boost::archive::xml_iarchive ia(ifs);
    ia >> boost::serialization::make_nvp("ThreadIdx", idx);
  } catch (const boost::archive::archive_exception& e) {
    std::cerr << e.what() << " " << xml.file_string() << std::endl;
    return ThreadIdx();
  }
  ifs.close();

  return idx;
}


} // namespace dialektos
