/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef THREAD_WINDOW_STATE_HXX
#define THREAD_WINDOW_STATE_HXX

#include <boost/serialization/access.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/filesystem/path.hpp>


namespace dialektos {


struct ThreadWindowState {
  ThreadWindowState();

  int width;
  int height;
  int displayed_res_num;
  bool menubar;
  bool toolbar;
  bool statusbar;

  void from_xml(const boost::filesystem::path& xml);
  void to_xml(const boost::filesystem::path& xml);

private:
  friend class boost::serialization::access;
  template <typename ArchiveType>
  void serialize(ArchiveType& ar, const unsigned int version) {
    ar & boost::serialization::make_nvp("WindowWidth", width);
    ar & boost::serialization::make_nvp("WindowHeight", height);
    ar & boost::serialization::make_nvp("DisplayedResNum", displayed_res_num);
    ar & boost::serialization::make_nvp("MenubarVisible", menubar);
    ar & boost::serialization::make_nvp("ToolbarVisible", toolbar);
    ar & boost::serialization::make_nvp("StatusbarVisible", statusbar);
  }
};


} // namespace dialektos


#endif
