/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.proxy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.httpclient.contrib.proxy.ProxyDetectionException;

public class PluginProxyTestApplet
extends JApplet {
    private JTextField urlTextField = new JTextField();
    private JPanel grid = null;
    private JLabel hostLabel = null;
    private JLabel portLabel = null;

    public void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.grid = this.getPanel(new GridLayout(2, 3, 2, 2));
        this.grid.add(this.getHeaderLabel("URL"));
        this.grid.add(this.getHeaderLabel("Proxy Host"));
        this.grid.add(this.getHeaderLabel("Proxy Port"));
        this.grid.add(this.urlTextField);
        this.hostLabel = this.getLabel("");
        this.portLabel = this.getLabel("");
        this.grid.add(this.hostLabel);
        this.grid.add(this.portLabel);
        this.grid.validate();
        container.add((Component)this.grid, "Center");
        JPanel jPanel = this.getPanel(new FlowLayout());
        JButton jButton = new JButton("Detect Proxy");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PluginProxyTestApplet.this.detectProxy();
                    }
                });
            }
        });
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        JPanel jPanel2 = this.getPanel(new FlowLayout());
        String string = System.getProperty("java.runtime.version");
        JLabel jLabel = this.getLabel("Java Version: " + string);
        jPanel2.add(jLabel);
        container.add((Component)jPanel2, "North");
        this.validate();
        super.setSize(400, 100);
    }

    private JPanel getPanel(LayoutManager layoutManager) {
        JPanel jPanel = new JPanel(layoutManager);
        return jPanel;
    }

    private JLabel getHeaderLabel(String string) {
        JLabel jLabel = new JLabel("<html><u><b>" + string + "</b></u></html>");
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    private JLabel getLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    private void detectProxy() {
        String string = this.urlTextField.getText();
        if (string == null || "".equals(string)) {
            JOptionPane.showMessageDialog(super.getRootPane(), "URL can't be empty", "Missing URL", 0);
            return;
        }
        if (!string.startsWith("http://")) {
            string = "http://" + string;
        }
        try {
            URL uRL = new URL(string);
            ProxyHost proxyHost = PluginProxyUtil.detectProxy(uRL);
            if (proxyHost != null) {
                this.hostLabel.setText(proxyHost.getHostName());
                this.portLabel.setText("" + proxyHost.getPort());
            } else {
                this.hostLabel.setText("none");
                this.portLabel.setText("none");
            }
            this.grid.validate();
        }
        catch (ProxyDetectionException proxyDetectionException) {
            JOptionPane.showMessageDialog(this.getRootPane(), proxyDetectionException.getMessage(), "Proxy Detection Failed", 0);
            proxyDetectionException.printStackTrace();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getRootPane(), exception.getMessage(), "Unexpected Exception", 0);
            exception.printStackTrace();
        }
    }

    public String getProxyHost(String string) {
        String string2 = string;
        try {
            URL uRL = new URL(string);
            ProxyHost proxyHost = PluginProxyUtil.detectProxy(uRL);
            if (proxyHost != null) {
                string2 = proxyHost.getHostName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public int getProxyPort(String string) {
        int n = 80;
        try {
            URL uRL = new URL(string);
            ProxyHost proxyHost = PluginProxyUtil.detectProxy(uRL);
            if (proxyHost != null) {
                n = proxyHost.getPort();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }
}

