/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.internal.FileHandler;

public class TemporaryFilesystem {
    private static final Set<File> temporaryFiles = new CopyOnWriteArraySet<File>();
    private static final File baseDir = new File(System.getProperty("java.io.tmpdir"));
    private static final Thread shutdownHook = new Thread(){

        public void run() {
            TemporaryFilesystem.deleteTemporaryFiles();
        }
    };

    private TemporaryFilesystem() {
    }

    public static File createTempDir(String prefix, String suffix) {
        try {
            File file = File.createTempFile(prefix, suffix, baseDir);
            file.delete();
            File dir = new File(file.getAbsolutePath());
            if (dir == null || !dir.mkdirs()) {
                throw new WebDriverException("Cannot create profile directory at " + dir.getAbsolutePath());
            }
            FileHandler.createDir(dir);
            temporaryFiles.add(dir);
            return dir;
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to create temporary file at " + baseDir.getAbsolutePath());
        }
    }

    public static void deleteTempDir(File file) {
        if (!TemporaryFilesystem.shouldReap()) {
            return;
        }
        if (temporaryFiles.remove(file)) {
            FileHandler.delete(file);
        }
    }

    public static void deleteTemporaryFiles() {
        if (!TemporaryFilesystem.shouldReap()) {
            return;
        }
        try {
            for (File file : temporaryFiles) {
                FileHandler.delete(file);
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    private static boolean shouldReap() {
        String reap = System.getProperty("webdriver.firefox.reap_profile", "true");
        return Boolean.valueOf(reap);
    }

    static {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        if (!baseDir.exists()) {
            throw new WebDriverException("Unable to find tmp dir: " + baseDir.getAbsolutePath());
        }
        if (!baseDir.canWrite()) {
            throw new WebDriverException("Unable to write to tmp dir: " + baseDir.getAbsolutePath());
        }
    }
}

