/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.StreamHandlerFactory;
import com.google.appengine.tools.info.SdkInfo;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.BindException;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DevAppServerImpl
implements DevAppServer {
    private Map<String, String> serviceProperties;
    private ServerState serverState = ServerState.INITIALIZING;
    private ContainerService container = null;

    public DevAppServerImpl(File appDir) {
        this(appDir, "127.0.0.1", 8080);
    }

    public DevAppServerImpl(File appDir, String address, int port) {
        this(appDir, null, null, address, port);
    }

    public DevAppServerImpl(File appDir, String webXmlLocation, AppEngineWebXmlReader appEngineWebXmlReader, String address, int port) {
        String serverInfo = "Google App Engine Development/" + SdkInfo.getLocalVersion().getRelease();
        StreamHandlerFactory.install();
        this.container = this.loadContainer();
        this.container.configure(serverInfo, appDir, webXmlLocation, appEngineWebXmlReader, address, port);
    }

    @Override
    public void setServiceProperties(Map<String, String> properties) {
        if (this.serverState != ServerState.INITIALIZING) {
            String msg = "Cannot set service properties after the server has been started.";
            throw new IllegalStateException(msg);
        }
        this.serviceProperties = properties;
    }

    private ContainerService loadContainer() {
        Iterator containerLoader = Service.providers(ContainerService.class, (ClassLoader)DevAppServerImpl.class.getClassLoader());
        String containerClazz = System.getProperty("devappserver.container");
        ContainerService result = null;
        while (containerLoader.hasNext()) {
            ContainerService container = (ContainerService)containerLoader.next();
            if (containerClazz == null || containerClazz.length() == 0) {
                if (result == null) {
                    result = container;
                    continue;
                }
                System.err.println("Warning: Found more than one servlet container providers: " + result.getClass() + ", " + container.getClass() + ". And the first one will be used!");
                break;
            }
            if (!container.getClass().getName().endsWith(containerClazz)) continue;
            result = container;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot load any servlet container.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (this.serverState != ServerState.INITIALIZING) {
            throw new IllegalStateException("Cannot start a server that has already been started.");
        }
        this.initializeLogging();
        ApiProxyLocalFactory factory = new ApiProxyLocalFactory();
        factory.setApplicationDirectory(this.container.getAppDirectory());
        ApiProxyLocal localImpl = factory.create();
        localImpl.setProperties(this.serviceProperties);
        ApiProxy.setDelegate((ApiProxy.Delegate)localImpl);
        TimeZone currentTimeZone = null;
        try {
            currentTimeZone = this.setServerTimeZone();
            this.container.startup();
        }
        catch (BindException ex) {
            System.err.println();
            System.err.println("************************************************");
            System.err.println("Could not open the requested socket: " + ex.getMessage());
            System.err.println("Try overriding --address and/or --port.");
            System.exit(2);
        }
        finally {
            ApiProxy.clearEnvironmentForCurrentThread();
            this.restoreLocalTimeZone(currentTimeZone);
        }
        this.serverState = ServerState.RUNNING;
        String prettyAddress = this.container.getAddress();
        if (prettyAddress.equals("0.0.0.0") || prettyAddress.equals("127.0.0.1")) {
            prettyAddress = "localhost";
        }
        System.out.println("The server is running at http://" + prettyAddress + ":" + this.container.getPort() + "/");
    }

    private TimeZone setServerTimeZone() {
        String sysTimeZone = System.getProperty("user.timezone");
        if (sysTimeZone != null && sysTimeZone.trim().length() > 0) {
            return null;
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        assert (utc.getID().equals("UTC")) : "Unable to retrieve the UTC TimeZone";
        try {
            Field f = TimeZone.class.getDeclaredField("defaultZoneTL");
            f.setAccessible(true);
            ThreadLocal tl = (ThreadLocal)f.get(null);
            Method getZone = ThreadLocal.class.getMethod("get", new Class[0]);
            TimeZone previousZone = (TimeZone)getZone.invoke((Object)tl, new Object[0]);
            Method setZone = ThreadLocal.class.getMethod("set", Object.class);
            setZone.invoke((Object)tl, utc);
            return previousZone;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set the TimeZone to UTC", e);
        }
    }

    private void restoreLocalTimeZone(TimeZone timeZone) {
        String sysTimeZone = System.getProperty("user.timezone");
        if (sysTimeZone != null && sysTimeZone.trim().length() > 0) {
            return;
        }
        try {
            Field f = TimeZone.class.getDeclaredField("defaultZoneTL");
            f.setAccessible(true);
            ThreadLocal tl = (ThreadLocal)f.get(null);
            Method setZone = ThreadLocal.class.getMethod("set", Object.class);
            setZone.invoke((Object)tl, timeZone);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to restore the previous TimeZone", e);
        }
    }

    @Override
    public void restart() throws Exception {
        if (this.serverState != ServerState.RUNNING) {
            throw new IllegalStateException("Cannot restart a server that is not currently running.");
        }
        this.container.shutdown();
        this.container.startup();
    }

    @Override
    public void shutdown() throws Exception {
        if (this.serverState != ServerState.RUNNING) {
            throw new IllegalStateException("Cannot shutdown a server that is not currently running.");
        }
        this.container.shutdown();
        this.serverState = ServerState.SHUTDOWN;
    }

    @Override
    public int getPort() {
        return this.container.getPort();
    }

    @Override
    public Object getWebAppContext() {
        return this.container.getWebAppContext();
    }

    @Override
    public void setThrowOnEnvironmentVariableMismatch(boolean throwOnMismatch) {
        this.container.setEnvironmentVariableMismatchSeverity(throwOnMismatch ? ContainerService.EnvironmentVariableMismatchSeverity.ERROR : ContainerService.EnvironmentVariableMismatchSeverity.WARNING);
    }

    private void initializeLogging() {
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(Level.FINEST);
        }
    }

    ServerState getServerState() {
        return this.serverState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ServerState {
        INITIALIZING,
        RUNNING,
        SHUTDOWN;

    }
}

