/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.util.List;
import org.t2framework.commons.exception.InvalidPackageException;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.PackageDesc;
import org.t2framework.commons.meta.impl.AbstractConfigContainer;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;

public class PackageDescImpl
extends AbstractConfigContainer
implements PackageDesc {
    protected String packageName;
    protected Package package_;
    protected List<BeanDesc<?>> beanDescList = CollectionsUtil.newArrayList();
    protected List<Class<?>> classList = CollectionsUtil.newArrayList();
    protected boolean hasPackageInfo = false;

    public PackageDescImpl(BeanDesc<?> beanDesc) {
        Assertion.notNull(beanDesc);
        this.setup(beanDesc);
    }

    protected void setup(BeanDesc<?> beanDesc) {
        Class<?> c = beanDesc.getComponentClass();
        this.packageName = Reflections.PackageUtil.getPackageName(c);
        this.package_ = c.getPackage();
        if (this.package_ != null) {
            this.getConfigSupport().addAllAnnotationConfig(this.package_);
        } else {
            this.setupPackageInfoClass();
        }
        this.beanDescList.add(beanDesc);
        this.classList.add(c);
    }

    protected void setupPackageInfoClass() {
        Class packageInfo = Reflections.ClassUtil.forNameNoException(this.packageName + "package-info");
        if (packageInfo != null) {
            this.getConfigSupport().addAllAnnotationConfig(packageInfo);
        }
    }

    @Override
    public <T> void addBeanDesc(BeanDesc<T> beanDesc) {
        Assertion.notNull(beanDesc);
        Class<T> c = beanDesc.getComponentClass();
        String pName = Reflections.PackageUtil.getPackageName(c);
        if (!this.packageName.equals(pName)) {
            throw new InvalidPackageException(this.packageName, pName);
        }
        this.beanDescList.add(beanDesc);
        this.classList.add(c);
    }

    @Override
    public List<BeanDesc<?>> getBeanDescList() {
        return this.beanDescList;
    }

    @Override
    public List<Class<?>> getClassList() {
        return this.classList;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Package getPackage() {
        return this.package_;
    }

    @Override
    public boolean hasPackageInfo() {
        return this.hasPackageInfo;
    }
}

