/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.t2framework.commons.mock.MockHeaderUtil;
import org.t2framework.commons.mock.MockHttpServletResponse;
import org.t2framework.commons.mock.MockServletOutputStreamImpl;
import org.t2framework.commons.util.CollectionsUtil;

public class MockHttpServletResponseImpl
implements MockHttpServletResponse {
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_LENGTH = "content-type";
    private List<Cookie> cookieList;
    private Map<String, List<String>> headers = CollectionsUtil.newHashMap();
    private boolean committed = false;
    private int status;
    private String message;
    private byte[] buffer = new byte[1024];
    private Locale locale;
    private String characterEncoding;
    private PrintWriter writer = new PrintWriter(new StringWriter());
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private ServletOutputStream outputStream = new MockServletOutputStreamImpl(this.byteArrayOutputStream);
    private boolean getWriterCalled;
    private boolean getOutputStreamCalled;
    protected String redirectPath;

    public MockHttpServletResponseImpl(HttpServletRequest request) {
        this.cookieList = new ArrayList<Cookie>(Arrays.asList(request.getCookies()));
        this.locale = request.getLocale();
        this.characterEncoding = request.getCharacterEncoding();
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectUrl(url);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void sendError(int status, String message) throws IOException {
        this.setStatus(status, message);
    }

    public void sendError(int status) throws IOException {
        this.setStatus(status);
    }

    public void sendRedirect(String path) throws IOException {
        this.redirectPath = path;
    }

    @Override
    public Iterator<String> getHeaders(String name) {
        List<String> values = this.getHeaderList(name);
        if (values != null) {
            return values.iterator();
        }
        return new CollectionsUtil.EmptyIterator<String>();
    }

    @Override
    public String getHeader(String name) {
        List<String> values = this.getHeaderList(name);
        if (values != null) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    public void setDateHeader(String name, long value) {
        this.setHeader(name, MockHeaderUtil.getDateValue(value));
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, MockHeaderUtil.getDateValue(value));
    }

    public void setHeader(String name, String value) {
        List values = CollectionsUtil.newArrayList();
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    public void addHeader(String name, String value) {
        List<String> values = this.getHeaderList(name);
        if (values == null) {
            values = CollectionsUtil.newArrayList();
        }
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    @Override
    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return MockHeaderUtil.getIntValue(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    protected List<String> getHeaderList(String name) {
        name = name.toLowerCase();
        return this.headers.get(name);
    }

    public void setStatus(int status) {
        this.setStatus(status, MockHttpServletResponseImpl.getResponseStatusMessage(status));
    }

    private static String getResponseStatusMessage(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + status;
    }

    @Deprecated
    public void setStatus(int status, String message) {
        this.assertNotCommitted();
        this.status = status;
        this.message = message;
        this.resetBuffer();
    }

    private void assertNotCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getWriterCalled) {
            throw new IllegalStateException();
        }
        if (!this.getOutputStreamCalled) {
            this.getOutputStreamCalled = true;
        }
        return this.outputStream;
    }

    @Override
    public void setOutputStream(ServletOutputStream os) {
        this.getWriterCalled = false;
        this.getOutputStreamCalled = false;
        this.outputStream = os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.getOutputStreamCalled) {
            throw new IllegalStateException();
        }
        if (!this.getWriterCalled) {
            this.getWriterCalled = true;
        }
        return this.writer;
    }

    public void setContentLength(int contentLength) {
        this.setIntHeader("content-type", contentLength);
    }

    @Override
    public int getContentLength() {
        return this.getIntHeader("content-type");
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public void setContentType(String contentType) {
        this.setHeader("content-type", contentType);
    }

    public void setBufferSize(int size) {
        this.assertNotCommitted();
        if (size <= this.buffer.length) {
            return;
        }
        this.buffer = new byte[size];
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
        this.assertNotCommitted();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.committed = false;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public byte[] getResponseBytes() {
        return this.byteArrayOutputStream.toByteArray();
    }

    @Override
    public String getResponseString() {
        return this.writer.toString();
    }

    @Override
    public String getRedirectPath() {
        return this.redirectPath;
    }
}

