/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.mock;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import org.t2framework.commons.mock.MockHttpServletRequest;
import org.t2framework.commons.mock.MockHttpSession;
import org.t2framework.commons.util.CollectionsUtil;

public class MockHttpSessionImpl
implements MockHttpSession,
Serializable {
    private static final long serialVersionUID = 2182279632419560836L;
    protected final long creationTime;
    protected long lastAccessedTime;
    protected ServletContext servletContext;
    protected String id;
    protected boolean new_;
    protected boolean valid;
    protected int maxInactiveInterval;
    protected Map<String, Object> attributes;
    protected MockHttpServletRequest request;

    public MockHttpSessionImpl(ServletContext servletContext, MockHttpServletRequest request) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.new_ = true;
        this.valid = true;
        this.maxInactiveInterval = -1;
        this.attributes = CollectionsUtil.newHashMap();
        this.servletContext = servletContext;
        this.id = UUID.randomUUID().toString();
        this.request = request;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public void access() {
        this.new_ = false;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return new CollectionsUtil.IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    @Deprecated
    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (!this.valid) {
            return;
        }
        this.attributes.clear();
        this.valid = false;
        this.request.clearSession();
    }

    public boolean isNew() {
        return this.new_;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

