/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.mock;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.t2framework.commons.mock.MockHttpServletRequest;
import org.t2framework.commons.mock.MockRequestDispatcher;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.ServletUtil;

public class MockRequestDispatcherImpl
implements MockRequestDispatcher {
    protected String path;

    public MockRequestDispatcherImpl(String path) {
        this.path = path;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        int question = this.path.indexOf(63);
        if (question >= 0) {
            MockHttpServletRequest req = (MockHttpServletRequest)MockHttpServletRequest.class.cast(request);
            Map parameterMap = req.getParameterMap();
            Map originalParameterMap = CollectionsUtil.newHashMap(parameterMap);
            parameterMap.clear();
            Map<String, String[]> map = ServletUtil.parseParameters(this.path.substring(question + 1), req.getCharacterEncoding());
            parameterMap.putAll(map);
            for (String key : originalParameterMap.keySet()) {
                String[] originalValue = (String[])originalParameterMap.get(key);
                String[] curValue = (String[])parameterMap.get(key);
                if (curValue == null) {
                    parameterMap.put(key, originalValue);
                    continue;
                }
                int currentLen = curValue.length;
                int originalLen = originalValue.length;
                String[] newValue = new String[currentLen + originalLen];
                ArrayUtil.copyAll(curValue, newValue);
                ArrayUtil.copy(originalValue, newValue, 0, currentLen, originalLen);
                parameterMap.put(key, newValue);
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

