/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

public class HtmlEscapeUtil {
    private static HtmlEscapeStrategy escapeStrategy = new DefaultHtmlEscapeStrategy();

    private HtmlEscapeUtil() {
    }

    public static HtmlEscapeStrategy getHtmlEscapeStrategy() {
        return escapeStrategy;
    }

    public static void setHtmlEscapeStrategy(HtmlEscapeStrategy htmlEscapeStrategy) {
        escapeStrategy = htmlEscapeStrategy;
    }

    public static String escape(String s) {
        return HtmlEscapeUtil.escape(s, true, true);
    }

    public static String escape(String s, boolean quote, boolean amp) {
        return escapeStrategy.escape(s, quote, amp);
    }

    public static class JapaneseHtmlEscapeStrategy
    extends AbstractHtmlEscapeStrategy {
        @Override
        protected void escapeEach(StringBuffer sb, char c, boolean quote, boolean amp) {
            if (c == '\u00a0') {
                sb.append("&nbsp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (amp && c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (quote && c == '\'') {
                sb.append("&#39;");
            } else if (c == '\u00a5' || c == '\\') {
                sb.append("&yen;");
            } else {
                sb.append(c);
            }
        }
    }

    public static class DefaultHtmlEscapeStrategy
    extends AbstractHtmlEscapeStrategy {
        @Override
        protected void escapeEach(StringBuffer sb, char c, boolean quote, boolean amp) {
            if (c == '\u00a0') {
                sb.append("&nbsp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (amp && c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (quote && c == '\'') {
                sb.append("&#39;");
            } else if (c == '\u00a5') {
                sb.append("&yen;");
            } else {
                sb.append(c);
            }
        }
    }

    public static abstract class AbstractHtmlEscapeStrategy
    implements HtmlEscapeStrategy {
        @Override
        public String escape(String s, boolean quote, boolean amp) {
            char[] chars = s.toCharArray();
            StringBuffer sb = new StringBuffer(s.length() + 64);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                this.escapeEach(sb, c, quote, amp);
            }
            return new String(sb);
        }

        protected abstract void escapeEach(StringBuffer var1, char var2, boolean var3, boolean var4);
    }

    public static interface HtmlEscapeStrategy {
        public String escape(String var1, boolean var2, boolean var3);
    }
}

