/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;

public class XMLSerializer {
    public static String HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
    public static List<Class<?>> simpleTypes = CollectionsUtil.newArrayList();

    public static String serialize(Object target) {
        Assertion.notNull(target);
        StringBuilder builder = new StringBuilder(100);
        builder.append(HEADER);
        XMLSerializer.appendSerializeTarget(builder, target, true);
        return builder.toString();
    }

    private static String serialize(Object target, StringBuilder builder, boolean renderType) {
        Assertion.notNull(target);
        XMLSerializer.appendSerializeTarget(builder, target, renderType);
        return builder.toString();
    }

    private static void appendSerializeTarget(StringBuilder builder, Object target, boolean renderType) {
        if (target == null) {
            builder.append("null");
        } else if (String.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeString(builder, (String)target);
            } else {
                builder.append("<String>");
                XMLSerializer.appendSerializeString(builder, (String)target);
                builder.append("</String>");
            }
        } else if (Boolean.class.isInstance(target) || Integer.class.isInstance(target) || Byte.class.isInstance(target) || Short.class.isInstance(target) || Long.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeSimpleType(builder, target);
            } else {
                String name = Reflections.ClassUtil.getShortClassName(target.getClass());
                builder.append("<");
                builder.append(name);
                builder.append(">");
                XMLSerializer.appendSerializeSimpleType(builder, target);
                builder.append("</");
                builder.append(name);
                builder.append(">");
            }
        } else if (BigDecimal.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeBigDecimal(builder, (BigDecimal)target);
            } else {
                builder.append("<BigDecimal>");
                XMLSerializer.appendSerializeBigDecimal(builder, (BigDecimal)target);
                builder.append("</BigDecimal>");
            }
        } else if (Date.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeDate(builder, (Date)target);
            } else {
                builder.append("<Date>");
                XMLSerializer.appendSerializeDate(builder, (Date)target);
                builder.append("</Date>");
            }
        } else if (Float.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeFloat(builder, (Float)target);
            } else {
                builder.append("<Float>");
                XMLSerializer.appendSerializeFloat(builder, (Float)target);
                builder.append("</Float>");
            }
        } else if (Double.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeDouble(builder, (Double)target);
            } else {
                builder.append("<Float>");
                XMLSerializer.appendSerializeDouble(builder, (Double)target);
                builder.append("</Float>");
            }
        } else if (List.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeList(builder, (List)target, renderType);
            } else {
                builder.append("<List>");
                XMLSerializer.appendSerializeList(builder, (List)target, renderType);
                builder.append("</List>");
            }
        } else if (Map.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeMap(builder, (Map)target, renderType);
            } else {
                builder.append("<Map>");
                XMLSerializer.appendSerializeMap(builder, (Map)target, renderType);
                builder.append("</Map>");
            }
        } else if (Enum.class.isInstance(target)) {
            if (!renderType) {
                XMLSerializer.appendSerializeString(builder, ((Enum)target).name());
            } else {
                builder.append("<Enum>");
                XMLSerializer.appendSerializeString(builder, ((Enum)target).name());
                builder.append("</Enum>");
            }
        } else if (target.getClass().isArray()) {
            if (!renderType) {
                XMLSerializer.appendSerializeArray(builder, target, renderType);
            } else {
                builder.append("<Array>");
                XMLSerializer.appendSerializeArray(builder, target, renderType);
                builder.append("</Array>");
            }
        } else {
            XMLSerializer.appendSerializeObject(builder, target);
        }
    }

    private static void appendSerializeBigDecimal(StringBuilder builder, BigDecimal target) {
        builder.append(target.toPlainString());
    }

    private static void appendSerializeObject(StringBuilder builder, Object target) {
        BeanDesc<Object> beanDesc = BeanDescFactory.getBeanDesc(target);
        String className = Reflections.ClassUtil.getSimpleClassName(target.getClass());
        int index = className.indexOf("$");
        if (index > 0) {
            className = className.substring(index + 1);
        }
        builder.append("<" + className + ">");
        for (PropertyDesc<Object> pd : beanDesc.getAllPropertyDesc()) {
            boolean isSimpleType;
            String name = pd.getPropertyName();
            Class<?> type = pd.getPropertyType();
            boolean bl = isSimpleType = simpleTypes.contains(type) || List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type);
            if (isSimpleType) {
                builder.append("<" + name + ">");
            }
            XMLSerializer.appendSerializeTarget(builder, pd.getValue(target), false);
            if (!isSimpleType) continue;
            builder.append("</" + name + ">");
        }
        builder.append("</" + className + ">");
    }

    private static void appendSerializeDate(StringBuilder builder, Date target) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        builder.append(formatter.format(target));
    }

    private static void appendSerializeArray(StringBuilder builder, Object target, boolean renderType) {
        int len = Array.getLength(target);
        for (int i = 0; i < len; ++i) {
            Object o = Array.get(target, i);
            XMLSerializer.serialize(o, builder, renderType);
        }
    }

    private static void appendSerializeMap(StringBuilder builder, Map<?, ?> target, boolean renderType) {
        for (Map.Entry<?, ?> entry : target.entrySet()) {
            if (renderType) {
                builder.append("<Entry>");
                builder.append("<Key>");
            }
            XMLSerializer.serialize(entry.getKey(), builder, renderType);
            if (renderType) {
                builder.append("</Key>");
                builder.append("<Value>");
            } else {
                builder.append("=");
            }
            XMLSerializer.serialize(entry.getValue(), builder, renderType);
            if (renderType) {
                builder.append("</Value>");
                builder.append("</Entry>");
                continue;
            }
            builder.append(", ");
        }
        if (!renderType) {
            builder.setLength(builder.length() - 2);
        }
    }

    private static void appendSerializeString(StringBuilder builder, String str) {
        builder.append(XMLSerializer.quote(str));
    }

    private static void appendSerializeList(StringBuilder builder, List<?> target, boolean renderType) {
        for (Object o : target) {
            XMLSerializer.serialize(o, builder, renderType);
            if (renderType) continue;
            builder.append(", ");
        }
        if (!renderType) {
            builder.setLength(builder.length() - 2);
        }
    }

    private static void appendSerializeSimpleType(StringBuilder builder, Object simpleObj) {
        builder.append(simpleObj.toString());
    }

    private static void appendSerializeFloat(StringBuilder builder, Float f) {
        if (f.isNaN() || f.isInfinite()) {
            throw new IllegalArgumentException(f.toString());
        }
        XMLSerializer.appendSerializeSimpleType(builder, f);
    }

    private static void appendSerializeDouble(StringBuilder builder, Double d) {
        if (d.isNaN() || d.isInfinite()) {
            throw new IllegalArgumentException(d.toString());
        }
        XMLSerializer.appendSerializeSimpleType(builder, d);
    }

    private static String quote(String target) {
        char current = '\u0000';
        int len = target.length();
        StringBuilder strbuilder = new StringBuilder();
        block8: for (int i = 0; i < len; ++i) {
            current = target.charAt(i);
            switch (current) {
                case '\"': 
                case '/': 
                case '\\': {
                    strbuilder.append('\\');
                    strbuilder.append(current);
                    continue block8;
                }
                case '\b': {
                    strbuilder.append("\\b");
                    continue block8;
                }
                case '\t': {
                    strbuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    strbuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    strbuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    strbuilder.append("\\r");
                    continue block8;
                }
                default: {
                    if (current < ' ') {
                        String t = "000" + Integer.toHexString(current);
                        strbuilder.append("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    strbuilder.append(current);
                }
            }
        }
        return strbuilder.toString();
    }

    static {
        simpleTypes.add(String.class);
        simpleTypes.add(Float.class);
        simpleTypes.add(Float.TYPE);
        simpleTypes.add(Double.class);
        simpleTypes.add(Double.TYPE);
        simpleTypes.add(Integer.class);
        simpleTypes.add(Integer.TYPE);
        simpleTypes.add(Boolean.class);
        simpleTypes.add(Boolean.TYPE);
        simpleTypes.add(Byte.class);
        simpleTypes.add(Byte.TYPE);
        simpleTypes.add(Short.class);
        simpleTypes.add(Short.TYPE);
        simpleTypes.add(Long.class);
        simpleTypes.add(Long.TYPE);
        simpleTypes.add(BigDecimal.class);
        simpleTypes.add(Date.class);
    }
}

