/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Transaction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.PrimitiveArrays;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.RuntimeExceptionWrappingIterable;
import org.datanucleus.store.appengine.query.StreamingQueryResult;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreQuery
implements Serializable {
    static final Expression.Operator GROUP_BY_OP = new Expression.Operator("GROUP BY", Integer.MAX_VALUE);
    static final Expression.Operator HAVING_OP = new Expression.Operator("HAVING", Integer.MAX_VALUE);
    static final Expression.Operator JOIN_OP = new Expression.Operator("JOIN", Integer.MAX_VALUE);
    static final Set<Expression.Operator> UNSUPPORTED_OPERATORS = Utils.newHashSet(Expression.OP_ADD, Expression.OP_BETWEEN, Expression.OP_COM, Expression.OP_CONCAT, Expression.OP_DIV, Expression.OP_IS, Expression.OP_ISNOT, Expression.OP_LIKE, Expression.OP_MOD, Expression.OP_NEG, Expression.OP_MUL, Expression.OP_NOT, Expression.OP_OR, Expression.OP_SUB);
    private static final Map<Expression.Operator, Query.FilterOperator> DATANUCLEUS_OP_TO_APPENGINE_OP = DatastoreQuery.buildNewOpMap();
    static final String QUERY_CACHE_PROPERTY = "datanucleus.query.cached";
    private final AbstractJavaQuery query;
    private transient com.google.appengine.api.datastore.Query latestDatastoreQuery;

    private static Map<Expression.Operator, Query.FilterOperator> buildNewOpMap() {
        HashMap<Expression.Operator, Query.FilterOperator> map = new HashMap<Expression.Operator, Query.FilterOperator>();
        map.put((Expression.Operator)Expression.OP_EQ, Query.FilterOperator.EQUAL);
        map.put((Expression.Operator)Expression.OP_GT, Query.FilterOperator.GREATER_THAN);
        map.put((Expression.Operator)Expression.OP_GTEQ, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_LT, Query.FilterOperator.LESS_THAN);
        map.put((Expression.Operator)Expression.OP_LTEQ, Query.FilterOperator.LESS_THAN_OR_EQUAL);
        return map;
    }

    public DatastoreQuery(AbstractJavaQuery query) {
        this.query = query;
    }

    public List<?> performExecute(Localiser localiser, QueryCompilation compilation, long fromInclNo, long toExclNo, Map<String, ?> parameters) {
        ObjectManager om = this.getObjectManager();
        DatastoreManager storeMgr = (DatastoreManager)om.getStoreManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(this.query.getCandidateClass(), clr);
        if (acmd == null) {
            throw new NucleusUserException("No meta data for " + this.query.getCandidateClass().getName() + ".  Perhaps you need to run the enhancer on this class?").setFatal();
        }
        storeMgr.validateMetaDataForClass(acmd, clr);
        DatastoreTable table = storeMgr.getDatastoreClass(acmd.getFullClassName(), clr);
        QueryData qd = this.validate(compilation, parameters, acmd, table, clr);
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)localiser.msg("021046", (Object)"DATASTORE", (Object)this.query.getSingleStringQuery(), null));
        }
        if (toExclNo == 0L || this.rangeValueIsSet(toExclNo) && this.rangeValueIsSet(fromInclNo) && toExclNo - fromInclNo <= 0L) {
            return Collections.emptyList();
        }
        this.addFilters(qd);
        this.addSorts(qd);
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService();
        if (qd.batchGetKeys != null) {
            return this.fulfillBatchGetQuery(ds, qd);
        }
        this.latestDatastoreQuery = qd.datastoreQuery;
        PreparedQuery preparedQuery = ds.prepare(qd.datastoreQuery);
        FetchOptions opts = this.buildFetchOptions(fromInclNo, toExclNo);
        if (qd.isCountQuery) {
            return this.fulfillCountQuery(preparedQuery, opts);
        }
        return this.fulfillEntityQuery(preparedQuery, opts, qd.resultTransformer);
    }

    private List<?> fulfillBatchGetQuery(DatastoreService ds, QueryData qd) {
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(this.getObjectManager());
        Transaction innerTxn = txn == null ? null : txn.getInnerTxn();
        Collection<Entity> entities = ds.get(innerTxn, (Iterable)qd.batchGetKeys).values();
        if (qd.isCountQuery) {
            return Collections.singletonList(entities.size());
        }
        return this.newStreamingQueryResultForEntities(entities, qd.resultTransformer);
    }

    private List<Integer> fulfillCountQuery(PreparedQuery preparedQuery, FetchOptions opts) {
        if (opts != null) {
            throw new UnsupportedOperationException("The datastore does not support using count() in conjunction with offset and/or limit.  You can get the answer to this query by issuing the query without count() and then counting the size of the result set.");
        }
        return Collections.singletonList(preparedQuery.countEntities());
    }

    private List<?> fulfillEntityQuery(PreparedQuery preparedQuery, FetchOptions opts, Utils.Function<Entity, Object> resultTransformer) {
        Iterable entities = opts != null ? preparedQuery.asIterable(opts) : preparedQuery.asIterable();
        return this.newStreamingQueryResultForEntities(entities, resultTransformer);
    }

    private List<?> newStreamingQueryResultForEntities(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer) {
        return new StreamingQueryResult((Query)this.query, new RuntimeExceptionWrappingIterable(entities), resultTransformer);
    }

    private boolean rangeValueIsSet(long rangeVal) {
        return rangeVal != Long.MAX_VALUE;
    }

    FetchOptions buildFetchOptions(long fromInclNo, long toExclNo) {
        FetchOptions opts = null;
        Integer offset = null;
        if (fromInclNo != 0L && this.rangeValueIsSet(fromInclNo)) {
            offset = (int)Math.min(Integer.MAX_VALUE, fromInclNo);
            opts = FetchOptions.Builder.withOffset((int)offset);
        }
        if (this.rangeValueIsSet(toExclNo)) {
            int intExclNo = (int)Math.min(Integer.MAX_VALUE, toExclNo);
            if (opts == null) {
                opts = FetchOptions.Builder.withLimit((int)intExclNo);
            } else {
                opts.limit(intExclNo - offset);
            }
        }
        return opts;
    }

    private Object entityToPojo(Entity entity, AbstractClassMetaData acmd, ClassLoaderResolver clr, DatastoreManager storeMgr) {
        return DatastoreQuery.entityToPojo(entity, acmd, clr, storeMgr, this.getObjectManager(), this.query.getIgnoreCache());
    }

    public static Object entityToPojo(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, final DatastoreManager storeMgr, ObjectManager om, boolean ignoreCache) {
        storeMgr.validateMetaDataForClass(acmd, clr);
        FieldValues fv = new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        };
        Object pojo = om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), fv, ignoreCache, true);
        StateManager stateMgr = om.findStateManager(pojo);
        DatastorePersistenceHandler handler = storeMgr.getPersistenceHandler();
        handler.setAssociatedEntity(stateMgr, EntityUtils.getCurrentTransaction(om), entity);
        storeMgr.getPersistenceHandler().fetchObject(stateMgr, acmd.getAllMemberPositions());
        return pojo;
    }

    private QueryData validate(QueryCompilation compilation, Map<String, ?> parameters, final AbstractClassMetaData acmd, DatastoreTable table, final ClassLoaderResolver clr) {
        if (this.query.getCandidateClass() == null) {
            throw new NucleusUserException("Candidate class could not be found: " + this.query.getSingleStringQuery()).setFatal();
        }
        if (this.query.getGrouping() != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), GROUP_BY_OP);
        }
        if (this.query.getHaving() != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), HAVING_OP);
        }
        if (compilation.getExprFrom() != null) {
            for (Expression fromExpr : compilation.getExprFrom()) {
                this.checkNotJoin(fromExpr);
            }
        }
        ArrayList<Object> projectionFieldNums = Utils.newArrayList(new Object[0]);
        boolean isCountQuery = this.validateResultExpression(compilation, acmd, projectionFieldNums);
        String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
        Utils.Function<Entity, Object> resultTransformer = new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return DatastoreQuery.this.entityToPojo(from, acmd, clr, DatastoreQuery.this.getDatastoreManager());
            }
        };
        if (!projectionFieldNums.isEmpty()) {
            resultTransformer = this.newProjectionResultTransformer(projectionFieldNums, resultTransformer);
        }
        return new QueryData(parameters, acmd, table, compilation, new com.google.appengine.api.datastore.Query(kind), isCountQuery, resultTransformer);
    }

    private boolean validateResultExpression(QueryCompilation compilation, AbstractClassMetaData acmd, List<Integer> projectionFieldNums) {
        boolean isCountQuery = false;
        if (compilation.getExprResult() != null) {
            for (Expression resultExpr : compilation.getExprResult()) {
                if (resultExpr instanceof InvokeExpression) {
                    InvokeExpression invokeExpr = (InvokeExpression)resultExpr;
                    if (!invokeExpr.getOperation().equals("count")) {
                        Expression.Operator operator = new Expression.Operator(invokeExpr.getOperation(), 0);
                        throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
                    }
                    if (!projectionFieldNums.isEmpty()) {
                        throw this.newAggregateAndRowResultsException();
                    }
                    isCountQuery = true;
                    continue;
                }
                if (resultExpr instanceof PrimaryExpression) {
                    if (isCountQuery) {
                        throw this.newAggregateAndRowResultsException();
                    }
                    PrimaryExpression primaryExpr = (PrimaryExpression)resultExpr;
                    if (primaryExpr.getId().equals(compilation.getCandidateAlias())) continue;
                    AbstractMemberMetaData ammd = this.getMemberMetaData(acmd, this.getTuples(primaryExpr, compilation.getCandidateAlias()));
                    if (ammd == null) {
                        throw this.noMetaDataException(primaryExpr.getId(), acmd.getFullClassName());
                    }
                    if (ammd.getParent() instanceof EmbeddedMetaData) {
                        throw new UnsupportedOperationException("Selecting fields of embedded classes is not yet supported");
                    }
                    projectionFieldNums.add(ammd.getAbsoluteFieldNumber());
                    continue;
                }
                Expression.Operator operator = new Expression.Operator(resultExpr.getClass().getName(), 0);
                throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
            }
        }
        return isCountQuery;
    }

    private UnsupportedDatastoreFeatureException newAggregateAndRowResultsException() {
        return new UnsupportedDatastoreFeatureException("Cannot combine an aggregate results with row results.", this.query.getSingleStringQuery());
    }

    private Utils.Function<Entity, Object> newProjectionResultTransformer(final List<Integer> projectionFieldNums, final Utils.Function<Entity, Object> entityToPojoFunc) {
        return new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                PersistenceCapable pc = (PersistenceCapable)entityToPojoFunc.apply(from);
                StateManager sm = DatastoreQuery.this.getObjectManager().findStateManager((Object)pc);
                ArrayList<Object> values = Utils.newArrayList(new Object[0]);
                Iterator i$ = projectionFieldNums.iterator();
                while (i$.hasNext()) {
                    int fieldNum = (Integer)i$.next();
                    values.add(sm.provideField(fieldNum));
                }
                if (values.size() == 1) {
                    return values.get(0);
                }
                return values.toArray(new Object[values.size()]);
            }
        };
    }

    private void checkNotJoin(Expression expr) {
        if (expr instanceof JoinExpression) {
            throw new UnsupportedDatastoreFeatureException("Cannot fulfill queries with joins.", this.query.getSingleStringQuery());
        }
        if (expr.getLeft() != null) {
            this.checkNotJoin(expr.getLeft());
        }
        if (expr.getRight() != null) {
            this.checkNotJoin(expr.getRight());
        }
    }

    private void addSorts(QueryData qd) {
        Expression[] orderBys = qd.compilation.getExprOrdering();
        if (orderBys == null) {
            return;
        }
        for (Expression expr : orderBys) {
            OrderExpression oe = (OrderExpression)expr;
            Query.SortDirection dir = oe.getSortOrder() == null || oe.getSortOrder().equals("ascending") ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING;
            PrimaryExpression left = (PrimaryExpression)oe.getLeft();
            AbstractMemberMetaData ammd = this.getMemberMetaData(qd.acmd, this.getTuples(left, qd.compilation.getCandidateAlias()));
            if (ammd == null) {
                throw this.noMetaDataException(left.getId(), qd.acmd.getFullClassName());
            }
            if (this.isParentPK(ammd)) {
                throw new UnsupportedDatastoreFeatureException("Cannot sort by parent.", this.query.getSingleStringQuery());
            }
            String sortProp = ammd.isPrimaryKey() ? "__key__" : this.determinePropertyName(ammd);
            if (qd.batchGetKeys != null) {
                this.throwInvalidBatchLookupException();
            }
            qd.datastoreQuery.addSort(sortProp, dir);
        }
    }

    IdentifierFactory getIdentifierFactory() {
        return ((MappedStoreManager)this.getObjectManager().getStoreManager()).getIdentifierFactory();
    }

    private void addFilters(QueryData qd) {
        Expression filter = qd.compilation.getExprFilter();
        this.addExpression(filter, qd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addExpression(Expression expr, QueryData qd) {
        if (expr == null) {
            return;
        }
        this.checkForUnsupportedOperator(expr.getOperator());
        if (expr instanceof DyadicExpression) {
            if (expr.getOperator().equals(Expression.OP_AND)) {
                this.addExpression(expr.getLeft(), qd);
                this.addExpression(expr.getRight(), qd);
                return;
            } else {
                if (DATANUCLEUS_OP_TO_APPENGINE_OP.get(expr.getOperator()) == null) {
                    throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), expr.getOperator());
                }
                if (expr.getLeft() instanceof PrimaryExpression) {
                    this.addLeftPrimaryExpression((PrimaryExpression)expr.getLeft(), expr.getOperator(), expr.getRight(), qd);
                    return;
                } else {
                    this.addExpression(expr.getLeft(), qd);
                    this.addExpression(expr.getRight(), qd);
                }
            }
            return;
        } else if (expr instanceof PrimaryExpression) {
            this.addExpression(expr.getLeft(), qd);
            this.addExpression(expr.getRight(), qd);
            return;
        } else {
            if (!(expr instanceof InvokeExpression)) throw new UnsupportedDatastoreFeatureException("Unexpected expression type while parsing query: " + expr.getClass().getName(), this.query.getSingleStringQuery());
            InvokeExpression invocation = (InvokeExpression)expr;
            if (!invocation.getOperation().equals("contains") || !(expr.getLeft() instanceof PrimaryExpression) || invocation.getParameters().size() != 1) throw this.newUnsupportedQueryMethodException(invocation);
            PrimaryExpression left = (PrimaryExpression)expr.getLeft();
            Expression param = (Expression)invocation.getParameters().get(0);
            param.bind();
            this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_EQ, param, qd);
        }
    }

    private UnsupportedDatastoreFeatureException newUnsupportedQueryMethodException(InvokeExpression invocation) {
        throw new UnsupportedDatastoreFeatureException("Unsupported method <" + invocation.getOperation() + "> while parsing expression: " + invocation, this.query.getSingleStringQuery());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLeftPrimaryExpression(PrimaryExpression left, Expression.Operator operator, Expression right, QueryData qd) {
        void var6_12;
        Query.FilterOperator op = DATANUCLEUS_OP_TO_APPENGINE_OP.get(operator);
        if (op == null) {
            throw new UnsupportedDatastoreFeatureException("Operator " + operator + " does not have a " + "corresponding operator in the datastore api.", this.query.getSingleStringQuery());
        }
        if (right instanceof PrimaryExpression) {
            Object v = qd.parameters.get(((PrimaryExpression)right).getId());
        } else if (right instanceof Literal) {
            Object object = ((Literal)right).getLiteral();
        } else if (right instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)right;
            if (paramExpr.getPosition() != -1 && qd.parameters != null) {
                Object v = qd.parameters.get(paramExpr.getPosition());
            } else {
                Object object = right.getSymbol().getValue();
            }
        } else if (right instanceof DyadicExpression) {
            DyadicExpression dyadic = (DyadicExpression)right;
            if (!(dyadic.getLeft() instanceof Literal) || !(((Literal)dyadic.getLeft()).getLiteral() instanceof Number) || dyadic.getRight() != null || !Expression.OP_NEG.equals(dyadic.getOperator())) throw new UnsupportedDatastoreFeatureException("Right side of expression is composed of unsupported components.  Left: " + dyadic.getLeft().getClass().getName() + ", Op: " + dyadic.getOperator() + ", Right: " + dyadic.getRight(), this.query.getSingleStringQuery());
            Number negateMe = (Number)((Literal)dyadic.getLeft()).getLiteral();
            Object object = this.negateNumber(negateMe);
        } else {
            if (!(right instanceof InvokeExpression)) throw new UnsupportedDatastoreFeatureException("Right side of expression is of unexpected type: " + right.getClass().getName(), this.query.getSingleStringQuery());
            throw this.newUnsupportedQueryMethodException((InvokeExpression)right);
        }
        List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
        AbstractMemberMetaData ammd = this.getMemberMetaData(qd.acmd, tuples);
        if (ammd == null) {
            throw this.noMetaDataException(left.getId(), qd.acmd.getFullClassName());
        }
        JavaTypeMapping mapping = this.getMappingForFieldWithName(tuples, qd);
        if (mapping instanceof PersistenceCapableMapping) {
            this.processPersistenceCapableMapping(qd, op, ammd, var6_12);
            return;
        } else if (this.isParentPK(ammd)) {
            this.addParentFilter(op, this.internalPkToKey(qd.acmd, var6_12), qd);
            return;
        } else {
            void var6_14;
            String datastorePropName;
            if (ammd.isPrimaryKey()) {
                if (var6_12 instanceof Collection) {
                    if (!qd.datastoreQuery.getFilterPredicates().isEmpty()) {
                        this.throwInvalidBatchLookupException();
                    } else if (!op.equals((Object)Query.FilterOperator.EQUAL)) {
                        throw new NucleusUserException("Batch lookup by primary key is only supported with the equality operator.").setFatal();
                    }
                    qd.batchGetKeys = Utils.newHashSet(new Object[0]);
                    for (Object obj : (Collection)var6_12) {
                        qd.batchGetKeys.add(this.internalPkToKey(qd.acmd, obj));
                    }
                    return;
                }
                datastorePropName = "__key__";
                Key key = this.internalPkToKey(qd.acmd, var6_12);
            } else {
                datastorePropName = this.determinePropertyName(ammd);
            }
            if (var6_14 instanceof Collection) {
                throw new NucleusUserException("Collection parameters are only supported when filtering on primary key.").setFatal();
            }
            if (qd.batchGetKeys != null) {
                this.throwInvalidBatchLookupException();
            }
            Object object = this.pojoParamToDatastoreParam(var6_14);
            qd.datastoreQuery.addFilter(datastorePropName, op, object);
        }
    }

    private void throwInvalidBatchLookupException() {
        throw new NucleusUserException("Batch lookup by primary key is only supported if no other filters are defined.").setFatal();
    }

    private List<String> getTuples(PrimaryExpression expr, String alias) {
        List tuples = expr.getTuples();
        if (alias != null && tuples.size() > 1 && alias.equals(tuples.get(0))) {
            tuples = tuples.subList(1, tuples.size());
        }
        return tuples;
    }

    private Object pojoParamToDatastoreParam(Object param) {
        if (param instanceof Enum) {
            param = ((Enum)param).name();
        } else if (param instanceof byte[]) {
            param = new ShortBlob((byte[])param);
        } else if (param instanceof Byte[]) {
            param = new ShortBlob(PrimitiveArrays.toByteArray(Arrays.asList((Byte[])param)));
        } else if (param instanceof BigDecimal) {
            param = ((BigDecimal)param).doubleValue();
        }
        return param;
    }

    private NucleusException noMetaDataException(String member, String fullClassName) {
        return new NucleusUserException("No meta-data for member named " + member + " on class " + fullClassName + ".  Are you sure you provided the correct member name in your query?").setFatal();
    }

    private Object negateNumber(Number negateMe) {
        if (negateMe instanceof BigDecimal) {
            return ((BigDecimal)negateMe).negate().doubleValue();
        }
        if (negateMe instanceof Float) {
            return Float.valueOf(-((Float)negateMe).floatValue());
        }
        if (negateMe instanceof Double) {
            return -((Double)negateMe).doubleValue();
        }
        return -negateMe.longValue();
    }

    private JavaTypeMapping getMappingForFieldWithName(List<String> tuples, QueryData qd) {
        DatastoreManager storeMgr = (DatastoreManager)this.getObjectManager().getStoreManager();
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        AbstractClassMetaData acmd = qd.acmd;
        JavaTypeMapping mapping = null;
        for (String tuple : tuples) {
            DatastoreTable table = (DatastoreTable)qd.tableMap.get(acmd.getFullClassName());
            if (table == null) {
                table = storeMgr.getDatastoreClass(acmd.getFullClassName(), clr);
                qd.tableMap.put(acmd.getFullClassName(), table);
            }
            mapping = table.getMemberMapping(tuple);
            acmd = this.getMetaDataManager().getMetaDataForClass(mapping.getMemberMetaData().getType(), clr);
        }
        return mapping;
    }

    private AbstractMemberMetaData getMemberMetaData(AbstractClassMetaData acmd, List<String> tuples) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(tuples.get(0));
        if (tuples.size() == 1) {
            return ammd;
        }
        EmbeddedMetaData emd = ammd.getEmbeddedMetaData();
        for (String tuple : tuples.subList(1, tuples.size())) {
            if (ammd.getEmbeddedMetaData() == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Can only filter by properties of a sub-object if " + "the sub-object is embedded.").setFatal();
            }
            ammd = this.findMemberMetaDataWithName(tuple, emd.getMemberMetaData());
        }
        return ammd;
    }

    private AbstractMemberMetaData findMemberMetaDataWithName(String name, AbstractMemberMetaData[] ammdList) {
        for (AbstractMemberMetaData embedded : ammdList) {
            if (!embedded.getName().equals(name)) continue;
            return embedded;
        }
        return null;
    }

    private void processPersistenceCapableMapping(QueryData qd, Query.FilterOperator op, AbstractMemberMetaData ammd, Object value) {
        Object jdoPrimaryKey;
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(ammd.getType(), clr);
        if (value instanceof Key || value instanceof String) {
            jdoPrimaryKey = value;
        } else if (value == null) {
            jdoPrimaryKey = null;
        } else {
            ApiAdapter apiAdapter = this.getObjectManager().getApiAdapter();
            jdoPrimaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(value));
            if (jdoPrimaryKey == null) {
                StateManager sm = apiAdapter.newStateManager(this.getObjectManager(), acmd);
                sm.initialiseForHollow(null, null, value.getClass());
                sm.copyFieldsFromObject((PersistenceCapable)value, acmd.getPKMemberPositions());
                jdoPrimaryKey = sm.provideField(acmd.getPKMemberPositions()[0]);
            }
            if (jdoPrimaryKey == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Parameter value " + value + " does not have an id.").setFatal();
            }
        }
        Key valueKey = null;
        if (jdoPrimaryKey != null) {
            valueKey = this.internalPkToKey(qd.acmd, jdoPrimaryKey);
            this.verifyRelatedKeyIsOfProperType(ammd, valueKey, acmd);
        }
        if (!((DatastoreTable)qd.tableMap.get(ammd.getAbstractClassMetaData().getFullClassName())).isParentKeyProvider(ammd)) {
            if (op != Query.FilterOperator.EQUAL) {
                throw new UnsupportedDatastoreFeatureException("Only the equals operator is supported on conditions involving the owning side of a one-to-one.", this.query.getSingleStringQuery());
            }
            if (valueKey == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Cannot query for parents with null children.").setFatal();
            }
            if (valueKey.getParent() == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Key of parameter value does not have a parent.").setFatal();
            }
            qd.datastoreQuery.addFilter("__key__", Query.FilterOperator.EQUAL, (Object)valueKey.getParent());
        } else {
            if (valueKey == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Cannot query for objects with null parents.").setFatal();
            }
            this.addParentFilter(op, valueKey, qd);
        }
    }

    private void verifyRelatedKeyIsOfProperType(AbstractMemberMetaData ammd, Key key, AbstractClassMetaData acmd) {
        String fieldOwnerKind;
        String keyParentKind;
        String fieldKind;
        String keyKind = key.getKind();
        if (!keyKind.equals(fieldKind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName())) {
            throw new NucleusUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " maps to kind " + fieldKind + " but" + " parameter value contains Key of kind " + keyKind).setFatal();
        }
        if (key.getParent() != null && !(keyParentKind = key.getParent().getKind()).equals(fieldOwnerKind = this.getIdentifierFactory().newDatastoreContainerIdentifier(ammd.getAbstractClassMetaData()).getIdentifierName())) {
            throw new NucleusUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " is owned by a class that maps to " + "kind " + fieldOwnerKind + " but" + " parameter value contains Key with parent of kind " + keyParentKind).setFatal();
        }
    }

    private String determinePropertyName(AbstractMemberMetaData ammd) {
        if (ammd.getColumn() != null) {
            return ammd.getColumn();
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length != 0) {
            return ammd.getColumnMetaData()[0].getName();
        }
        return this.getIdentifierFactory().newDatastoreFieldIdentifier(ammd.getName()).getIdentifierName();
    }

    private Key internalPkToKey(AbstractClassMetaData acmd, Object internalPk) {
        Key key;
        if (internalPk instanceof String) {
            try {
                key = KeyFactory.stringToKey((String)((String)internalPk));
            }
            catch (IllegalArgumentException iae) {
                String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
                key = KeyFactory.createKey((String)kind, (String)((String)internalPk));
            }
        } else if (internalPk instanceof Long) {
            String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
            key = KeyFactory.createKey((String)kind, (long)((Long)internalPk));
        } else {
            key = (Key)internalPk;
        }
        return key;
    }

    private void addParentFilter(Query.FilterOperator op, Key key, QueryData qd) {
        if (op != Query.FilterOperator.EQUAL) {
            throw new UnsupportedDatastoreFeatureException("Operator is of type " + op + " but the " + "datastore only supports parent queries using the equality operator.", this.query.getSingleStringQuery());
        }
        qd.datastoreQuery.setAncestor(key);
    }

    private void checkForUnsupportedOperator(Expression.Operator operator) {
        if (UNSUPPORTED_OPERATORS.contains(operator)) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
        }
    }

    private boolean isParentPK(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.parent-pk");
    }

    com.google.appengine.api.datastore.Query getLatestDatastoreQuery() {
        return this.latestDatastoreQuery;
    }

    private ObjectManager getObjectManager() {
        return this.query.getObjectManager();
    }

    private DatastoreManager getDatastoreManager() {
        return (DatastoreManager)this.getObjectManager().getStoreManager();
    }

    private MetaDataManager getMetaDataManager() {
        return this.getObjectManager().getMetaDataManager();
    }

    static class UnsupportedDatastoreFeatureException
    extends UnsupportedOperationException {
        UnsupportedDatastoreFeatureException(String msg, String queryString) {
            super("Problem with query <" + queryString + ">: " + msg);
        }
    }

    static class UnsupportedDatastoreOperatorException
    extends UnsupportedOperationException {
        private final String queryString;
        private final Expression.Operator operator;

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator) {
            super(queryString);
            this.queryString = queryString;
            this.operator = operator;
        }

        public String getMessage() {
            return "Problem with query <" + this.queryString + ">: App Engine datastore does not support operator " + this.operator;
        }

        public Expression.Operator getOperation() {
            return this.operator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryData {
        private final Map parameters;
        private final AbstractClassMetaData acmd;
        private final Map<String, DatastoreTable> tableMap = Utils.newHashMap();
        private final QueryCompilation compilation;
        private final com.google.appengine.api.datastore.Query datastoreQuery;
        private final boolean isCountQuery;
        private final Utils.Function<Entity, Object> resultTransformer;
        private Set<Key> batchGetKeys;

        private QueryData(Map parameters, AbstractClassMetaData acmd, DatastoreTable table, QueryCompilation compilation, com.google.appengine.api.datastore.Query datastoreQuery, boolean isCountQuery, Utils.Function<Entity, Object> resultTransformer) {
            this.parameters = parameters;
            this.acmd = acmd;
            this.tableMap.put(acmd.getFullClassName(), table);
            this.compilation = compilation;
            this.datastoreQuery = datastoreQuery;
            this.isCountQuery = isCountQuery;
            this.resultTransformer = resultTransformer;
        }
    }
}

