/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.Platform;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    private static final NaturalOrdering NATURAL_ORDER = new NaturalOrdering();
    private static final int LEFT_IS_GREATER = 1;
    private static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NATURAL_ORDER;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    public static <T> Ordering<T> givenOrder(List<T> valuesInOrder) {
        return new GivenOrder<T>(valuesInOrder);
    }

    public static <T> Ordering<T> givenOrder(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.givenOrder(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GoogleInternal
    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    protected Ordering() {
    }

    public final <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    public final <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    public final int binarySearch(List<? extends T> sortedList, T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    public final <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> list = Lists.newArrayList(iterable);
        Collections.sort(list, this);
        return list;
    }

    public final boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public final boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public final <E extends T> E max(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return maxSoFar;
    }

    public final <E extends T> E max(E a, E b, E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public final <E extends T> E max(E a, E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public final <E extends T> E min(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return minSoFar;
    }

    public final <E extends T> E min(E a, E b, E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    public final <E extends T> E min(E a, E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsLastOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Ordering<? super T> ordering;
        private static final long serialVersionUID = 0L;

        NullsLastOrdering(Ordering<? super T> ordering) {
            this.ordering = ordering;
        }

        @Override
        public int compare(T left, T right) {
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            return this.ordering.compare(left, right);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof NullsLastOrdering) {
                NullsLastOrdering that = (NullsLastOrdering)object;
                return this.ordering.equals(that.ordering);
            }
            return false;
        }

        public int hashCode() {
            return this.ordering.hashCode() ^ 0xC9177248;
        }

        public String toString() {
            return this.ordering + ".nullsLast()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsFirstOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Ordering<? super T> ordering;
        private static final long serialVersionUID = 0L;

        NullsFirstOrdering(Ordering<? super T> ordering) {
            this.ordering = ordering;
        }

        @Override
        public int compare(T left, T right) {
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            return this.ordering.compare(left, right);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof NullsFirstOrdering) {
                NullsFirstOrdering that = (NullsFirstOrdering)object;
                return this.ordering.equals(that.ordering);
            }
            return false;
        }

        public int hashCode() {
            return this.ordering.hashCode() ^ 0x39153A74;
        }

        public String toString() {
            return this.ordering + ".nullsFirst()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicalOrdering<T>
    extends Ordering<Iterable<T>>
    implements Serializable {
        final Ordering<? super T> elementOrder;
        private static final long serialVersionUID = 0L;

        LexicographicalOrdering(Ordering<? super T> elementOrder) {
            this.elementOrder = elementOrder;
        }

        @Override
        public int compare(Iterable<T> leftIterable, Iterable<T> rightIterable) {
            Iterator<T> left = leftIterable.iterator();
            Iterator<T> right = rightIterable.iterator();
            while (left.hasNext()) {
                if (!right.hasNext()) {
                    return 1;
                }
                int result = this.elementOrder.compare(left.next(), right.next());
                if (result == 0) continue;
                return result;
            }
            if (right.hasNext()) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LexicographicalOrdering) {
                LexicographicalOrdering that = (LexicographicalOrdering)object;
                return this.elementOrder.equals(that.elementOrder);
            }
            return false;
        }

        public int hashCode() {
            return this.elementOrder.hashCode() ^ 0x7BB78CF5;
        }

        public String toString() {
            return this.elementOrder + ".lexicographical()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByFunctionOrdering<F, T>
    extends Ordering<F>
    implements Serializable {
        final Function<F, ? extends T> function;
        final Ordering<T> ordering;
        private static final long serialVersionUID = 0L;

        ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
            this.function = Preconditions.checkNotNull(function);
            this.ordering = Preconditions.checkNotNull(ordering);
        }

        @Override
        public int compare(F left, F right) {
            return this.ordering.compare(this.function.apply(left), this.function.apply(right));
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByFunctionOrdering) {
                ByFunctionOrdering that = (ByFunctionOrdering)object;
                return ((Object)this.function).equals(that.function) && this.ordering.equals(that.ordering);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.function, this.ordering);
        }

        public String toString() {
            return this.ordering + ".onResultOf(" + this.function + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Ordering<? super T> forwardOrder;
        private static final long serialVersionUID = 0L;

        ReverseOrdering(Ordering<? super T> forwardOrder) {
            this.forwardOrder = Preconditions.checkNotNull(forwardOrder);
        }

        @Override
        public int compare(T a, T b) {
            return this.forwardOrder.compare(b, a);
        }

        public int hashCode() {
            return -this.forwardOrder.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ReverseOrdering) {
                ReverseOrdering that = (ReverseOrdering)object;
                return this.forwardOrder.equals(that.forwardOrder);
            }
            return false;
        }

        public String toString() {
            return this.forwardOrder + ".reverse()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final ImmutableList<Comparator<? super T>> comparators;
        private static final long serialVersionUID = 0L;

        CompoundOrdering(Comparator<? super T> primary, Comparator<? super T> secondary) {
            this.comparators = ImmutableList.of(primary, secondary);
        }

        CompoundOrdering(Iterable<? extends Comparator<? super T>> comparators) {
            this.comparators = ImmutableList.copyOf(comparators);
        }

        CompoundOrdering(List<? extends Comparator<? super T>> comparators, Comparator<? super T> lastComparator) {
            this.comparators = new ImmutableList.Builder<Comparator<? super T>>().addAll(comparators).add(lastComparator).build();
        }

        @Override
        public int compare(T left, T right) {
            for (Comparator comparator : this.comparators) {
                int result = comparator.compare(left, right);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CompoundOrdering) {
                CompoundOrdering that = (CompoundOrdering)object;
                return this.comparators.equals(that.comparators);
            }
            return false;
        }

        public int hashCode() {
            return this.comparators.hashCode();
        }

        public String toString() {
            return "Ordering.compound(" + this.comparators + ")";
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new Ordering<Object>(){
            private Map<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeComputingMap(new Function<Object, Integer>(){
                final AtomicInteger counter = new AtomicInteger(0);

                @Override
                public Integer apply(Object from) {
                    return this.counter.getAndIncrement();
                }
            });

            @Override
            public int compare(Object left, Object right) {
                int rightCode;
                if (left == right) {
                    return 0;
                }
                int leftCode = System.identityHashCode(left);
                if (leftCode != (rightCode = System.identityHashCode(right))) {
                    return leftCode < rightCode ? -1 : 1;
                }
                int result = this.uids.get(left).compareTo(this.uids.get(right));
                if (result == 0) {
                    throw new AssertionError();
                }
                return result;
            }
        };

        private ArbitraryOrderingHolder() {
        }
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value) {
            super("Cannot compare value: " + value);
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GivenOrder<T>
    extends Ordering<T>
    implements Serializable {
        final ImmutableMap<T, Integer> rankMap;
        private static final long serialVersionUID = 0L;

        GivenOrder(List<T> valuesInOrder) {
            this.rankMap = GivenOrder.buildRankMap(valuesInOrder);
        }

        @Override
        public int compare(T left, T right) {
            return this.rank(left) - this.rank(right);
        }

        int rank(T value) {
            Integer rank = this.rankMap.get(value);
            if (rank == null) {
                throw new IncomparableValueException(value);
            }
            return rank;
        }

        static <T> ImmutableMap<T, Integer> buildRankMap(List<T> valuesInOrder) {
            ImmutableMap.Builder<T, Integer> builder = ImmutableMap.builder();
            int rank = 0;
            for (T value : valuesInOrder) {
                builder.put(value, rank++);
            }
            return builder.build();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof GivenOrder) {
                GivenOrder that = (GivenOrder)object;
                return this.rankMap.equals(that.rankMap);
            }
            return false;
        }

        public int hashCode() {
            return this.rankMap.hashCode();
        }

        public String toString() {
            return "Ordering.givenOrder(" + this.rankMap.keySet() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComparatorOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Comparator<T> comparator;
        private static final long serialVersionUID = 0L;

        ComparatorOrdering(Comparator<T> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public int compare(T a, T b) {
            return this.comparator.compare(a, b);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ComparatorOrdering) {
                ComparatorOrdering that = (ComparatorOrdering)object;
                return ((Object)this.comparator).equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return this.comparator.hashCode();
        }

        public String toString() {
            return this.comparator.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtCompatible(serializable=true)
    static class NaturalOrdering
    extends Ordering<Comparable>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        NaturalOrdering() {
        }

        @Override
        public int compare(Comparable left, Comparable right) {
            Preconditions.checkNotNull(right);
            if (left == right) {
                return 0;
            }
            int result = left.compareTo(right);
            return result;
        }

        private Object readResolve() {
            return NATURAL_ORDER;
        }

        public String toString() {
            return "Ordering.natural()";
        }
    }
}

