/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.action.ActionAnnotationResolver;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ActionContextBuilder;
import org.t2framework.t2.exception.NoActionMethodFoundRuntimeException;
import org.t2framework.t2.exception.NoDefaultActionMethodFoundRuntimeException;

public class ActionContextBuilderImpl
implements ActionContextBuilder {
    protected Map<Class<? extends Annotation>, ActionAnnotationResolver> annotationResolvers = CollectionsUtil.newHashMap();
    protected ActionAnnotationResolver defaultResolver;

    public ActionContextBuilderImpl(Map<Class<? extends Annotation>, ActionAnnotationResolver> annotationResolvers, ActionAnnotationResolver defaultResolver) {
        this.annotationResolvers = (Map)Assertion.notNull(annotationResolvers);
        this.defaultResolver = (ActionAnnotationResolver)Assertion.notNull((Object)defaultResolver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void build(ActionContext actionContext) throws NoActionMethodFoundRuntimeException {
        Assertion.notNull((Object)actionContext);
        List matchList = null;
        int maxMatchCount = 0;
        Set<String> methodNames = actionContext.getMethodNameSet();
        block0: for (String actionMethod : methodNames) {
            MethodDesc methodDesc = actionContext.getMethodDesc(actionMethod);
            actionContext.setTargetMethodDesc(methodDesc);
            actionContext.clearMatchCount();
            for (Config config : methodDesc) {
                boolean match;
                Annotation annotation;
                ActionAnnotationResolver resolver;
                if (!config.hasAnnotation() || (resolver = this.findAnnotationResolver(annotation = config.getAnnotation())) == null || (match = this.setupActionContextByResolver(resolver, actionContext, annotation))) continue;
                continue block0;
            }
            int matchCount = actionContext.getMatchCount();
            if (matchCount > maxMatchCount) {
                maxMatchCount = matchCount;
                matchList = CollectionsUtil.newArrayList();
                matchList.add(actionContext.getTargetMethodDesc());
                continue;
            }
            if (matchCount != maxMatchCount || matchList == null) continue;
            matchList.add(actionContext.getTargetMethodDesc());
        }
        MethodDesc methodDesc = null;
        if (matchList != null) {
            if (matchList.size() < 1) throw new NoActionMethodFoundRuntimeException(methodNames);
            methodDesc = (MethodDesc)matchList.get(0);
        } else {
            methodDesc = this.findDefaultMethodDesc(actionContext);
        }
        actionContext.setTargetMethodDesc(methodDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setupActionContextByResolver(ActionAnnotationResolver resolver, ActionContext actionContext, Annotation annotation) {
        resolver.preResolve(actionContext, annotation);
        boolean match = false;
        try {
            match = resolver.isMatch(actionContext, annotation);
            if (match) {
                actionContext.incrementMatchCount();
                resolver.resolve(actionContext, annotation);
            }
        }
        finally {
            resolver.postResolve(actionContext, annotation);
        }
        return match;
    }

    protected MethodDesc findDefaultMethodDesc(ActionContext actionContext) {
        if (!actionContext.hasDefaultMethodDesc()) {
            throw new NoDefaultActionMethodFoundRuntimeException();
        }
        Annotation annotation = actionContext.getDefaultAnnotation();
        this.defaultResolver.resolve(actionContext, annotation);
        return actionContext.getDefaultMethodDesc();
    }

    protected ActionAnnotationResolver findAnnotationResolver(Annotation annotation) {
        Assertion.notNull((Object)annotation);
        return this.annotationResolvers.get(annotation.annotationType());
    }

    @Override
    public void setDefaultActionAnnotationResolver(ActionAnnotationResolver defaultResolver) {
        this.defaultResolver = (ActionAnnotationResolver)Assertion.notNull((Object)defaultResolver);
    }

    @Override
    public void addActionAnnotationResolver(Class<? extends Annotation> annotationClass, ActionAnnotationResolver resolver) {
        this.annotationResolvers.put(annotationClass, resolver);
    }
}

