/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.adapter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.impl.ClassDescImpl;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;
import org.t2framework.t2.adapter.AbstractContainerAdapter;
import org.t2framework.t2.exception.ContainerAdapterStartupException;
import org.t2framework.t2.handler.ExceptionHandler;
import org.t2framework.t2.handler.GlobalExceptionHandler;
import org.t2framework.t2.handler.impl.GlobalExceptionHandlerImpl;

public class SimpleContainerAdapter
extends AbstractContainerAdapter<Map<Class<?>, Object>> {
    protected ConcurrentHashMap<Class<?>, Object> map;

    @Override
    public void init() {
        this.map = new ConcurrentHashMap();
    }

    @Override
    public void init(String configPath) {
        this.init();
    }

    @Override
    public <T> BeanDesc<T> getBeanDesc(Class<? super T> componentClass) {
        Assertion.notNull(componentClass);
        this.assertInited();
        if (this.getContainer().containsKey(componentClass)) {
            return BeanDescFactory.getBeanDesc(componentClass);
        }
        return null;
    }

    @Override
    public <T> T getComponent(Class<? super T> componentClass) {
        Assertion.notNull(componentClass);
        this.assertInited();
        return (T)this.getContainer().get(componentClass);
    }

    @Override
    public <T> List<T> getComponents(Class<? super T> componentClass) {
        this.assertInited();
        if (this.getContainer().containsKey(componentClass)) {
            T o = this.getComponent(componentClass);
            return Arrays.asList(o);
        }
        return null;
    }

    @Override
    public <T> boolean hasComponent(Class<T> componentClass) {
        this.assertInited();
        return this.getContainer().get(componentClass) != null;
    }

    @Override
    public <T> T injectDependency(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized <T> void register(Class<? extends T> clazz) {
        Assertion.notNull(clazz);
        this.assertInited();
        Object t = Reflections.ClassUtil.newInstance(clazz);
        this.register(t);
    }

    @Override
    public synchronized <T> void register(T component) {
        Assertion.notNull(component);
        this.assertInited();
        Class<?> clazz = component.getClass();
        ClassDescImpl classDesc = new ClassDescImpl(clazz);
        for (Class c : classDesc.getDependencyClassesList()) {
            this.getContainer().put(c, component);
        }
    }

    @Override
    public Map<Class<?>, Object> getContainer() {
        return this.map;
    }

    @Override
    public List<ExceptionHandler<Throwable, Exception>> createExceptionHandlers() {
        this.assertInited();
        return CollectionsUtil.emptyList();
    }

    @Override
    public GlobalExceptionHandler createGlobalExceptionHandler() {
        this.assertInited();
        return new GlobalExceptionHandlerImpl();
    }

    protected void assertInited() {
        if (this.getContainer() == null) {
            throw new ContainerAdapterStartupException(this.getClass());
        }
    }

    @Override
    public void destroy() {
        this.map.clear();
    }
}

