/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.mvel2.DataConversion;
import org.mvel2.ParserContext;
import org.mvel2.compiler.PropertyVerifier;
import org.mvel2.util.ParseTools;
import org.mvel2.util.ReflectionUtil;

public class PropertyTools {
    public static boolean isEmpty(Object o) {
        if (o != null) {
            if (o instanceof Object[]) {
                return ((Object[])o).length == 0 || ((Object[])o).length == 1 && PropertyTools.isEmpty(((Object[])o)[0]);
            }
            return "".equals(String.valueOf(o)) || "null".equals(String.valueOf(o)) || o instanceof Collection && ((Collection)o).size() == 0 || o instanceof Map && ((Map)o).size() == 0;
        }
        return true;
    }

    public static Method getSetter(Class clazz, String property) {
        property = ReflectionUtil.getSetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 1 || !property.equals(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    public static Method getSetter(Class clazz, String property, Class type) {
        property = ReflectionUtil.getSetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 1 || !property.equals(meth.getName()) || !DataConversion.canConvert(meth.getParameterTypes()[0], type)) continue;
            return meth;
        }
        return null;
    }

    public static boolean hasGetter(Field field) {
        Method meth = PropertyTools.getGetter(field.getDeclaringClass(), field.getName());
        return meth != null && field.getType().isAssignableFrom(meth.getReturnType());
    }

    public static boolean hasSetter(Field field) {
        Method meth = PropertyTools.getSetter(field.getDeclaringClass(), field.getName());
        return meth != null && meth.getParameterTypes().length == 1 && field.getType().isAssignableFrom(meth.getParameterTypes()[0]);
    }

    public static Method getGetter(Class clazz, String property) {
        String isGet = ReflectionUtil.getIsGetter(property);
        property = ReflectionUtil.getGetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 0 || !property.equals(meth.getName()) && !isGet.equals(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    public static Class getReturnType(Class clazz, String property, ParserContext ctx) {
        return new PropertyVerifier(property, ctx, clazz).analyze();
    }

    public static Member getFieldOrAccessor(Class clazz, String property) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName())) continue;
            if ((f.getModifiers() & 1) == 0) break;
            return f;
        }
        return PropertyTools.getGetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property) {
        try {
            Field field = clazz.getField(property);
            if (field != null && Modifier.isPublic(field.getModifiers())) {
                return field;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return PropertyTools.getSetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property, Class type) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName()) || !DataConversion.canConvert(f.getType(), type)) continue;
            return f;
        }
        return PropertyTools.getSetter(clazz, property, type);
    }

    public static boolean contains(Object toCompare, Object testValue) {
        if (toCompare == null) {
            return false;
        }
        if (toCompare instanceof String) {
            return ((String)toCompare).contains(String.valueOf(testValue));
        }
        if (toCompare instanceof Collection) {
            return ((Collection)toCompare).contains(testValue);
        }
        if (toCompare instanceof Map) {
            return ((Map)toCompare).containsKey(testValue);
        }
        if (toCompare.getClass().isArray()) {
            for (Object o : (Object[])toCompare) {
                if (testValue == null && o == null) {
                    return true;
                }
                if (o == null || !o.equals(testValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignable(Class to, Class from) {
        return (to.isPrimitive() ? ParseTools.boxPrimitive(to) : to).isAssignableFrom(from.isPrimitive() ? ParseTools.boxPrimitive(from) : from);
    }
}

