/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy;

import java.util.List;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.DescType;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.lucy.ConfigBindResult;
import org.t2framework.lucy.Lifecycle;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.exception.BehaviorNotFoundException;
import org.t2framework.lucy.spi.Behavior;
import org.t2framework.lucy.spi.ComponentBuilder;
import org.t2framework.lucy.spi.LucyConfiguration;

public class ComponentBuilderFactory {
    public static ComponentBuilder createBuilder(BeanDesc<?> beanDesc, Lucy lucy) {
        return new DefaultComponentBuilderImpl(beanDesc, lucy);
    }

    public static ComponentBuilder createBuilder(BeanDesc<?> beanDesc, Lucy lucy, LucyConfiguration conf) {
        return ComponentBuilderFactory.createBuilder(beanDesc, lucy).loadConfiguration(conf);
    }

    public static class DefaultComponentBuilderImpl
    implements ComponentBuilder {
        protected BeanDesc<?> beanDesc;
        protected Lucy lucy;
        protected LucyConfiguration conf;

        public DefaultComponentBuilderImpl(BeanDesc<?> beanDesc, Lucy lucy) {
            this.beanDesc = beanDesc;
            this.lucy = lucy;
        }

        @Override
        public <T> T build(T t, ConfigBindResult result) {
            Assertion.notNull((Object)result);
            for (Lifecycle current : Lifecycle.getComponentLifecycle()) {
                t = this.processClassDesc(t, result, current);
                this.processMethodAndProperties(t, result, current);
            }
            return t;
        }

        protected <T> T processClassDesc(T t, ConfigBindResult result, Lifecycle current) {
            return this.processBehavior(t, result, current, (DescType)this.beanDesc.getClassDesc());
        }

        protected <T> T processBehavior(T t, ConfigBindResult result, Lifecycle current, DescType desc) {
            List<Behavior> behaviorList = result.getBehaviorList(desc);
            if (behaviorList == null) {
                throw new BehaviorNotFoundException(t, current, desc);
            }
            for (Behavior behavior : behaviorList) {
                if (!behavior.isApplied(current)) continue;
                t = behavior.execute(t, this.lucy);
            }
            return t;
        }

        protected <T> T processMethodAndProperties(T t, ConfigBindResult result, Lifecycle current) {
            for (MethodDesc md : this.beanDesc.getAllMethodDesc()) {
                if (!result.hasMethodDesc(md)) continue;
                t = this.processBehavior(t, result, current, (DescType)md);
            }
            for (PropertyDesc pd : this.beanDesc.getAllPropertyDesc()) {
                if (!result.hasPropertyDesc(pd)) continue;
                t = this.processBehavior(t, result, current, (DescType)pd);
            }
            return t;
        }

        @Override
        public void setLucy(Lucy lucy) {
            this.lucy = lucy;
        }

        public void dispose() {
            this.beanDesc = null;
            this.lucy = null;
        }

        @Override
        public ComponentBuilder loadConfiguration(LucyConfiguration conf) {
            this.conf = (LucyConfiguration)Assertion.notNull((Object)conf);
            return this;
        }
    }
}

