/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy;

import org.t2framework.commons.Disposer;
import org.t2framework.commons.util.Assertion;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.exception.LucyStartupFailException;
import org.t2framework.lucy.impl.DefaultLucyConfiguration;
import org.t2framework.lucy.impl.LucyImpl;
import org.t2framework.lucy.spi.LucyConfiguration;

public final class LucyBootstrap {
    private static Lucy lucy;
    protected static boolean initialized;

    public static Lucy init() {
        return LucyBootstrap.init((String)null);
    }

    public static Lucy init(String componentDefinitionPath) {
        return LucyBootstrap.init(new DefaultLucyConfiguration(), componentDefinitionPath);
    }

    public static Lucy init(LucyConfiguration config) {
        return LucyBootstrap.init(config, null);
    }

    public static synchronized Lucy init(LucyConfiguration config, Object componentDefinition) {
        Assertion.notNull((Object)config);
        if (initialized) {
            return lucy;
        }
        if (lucy == null) {
            lucy = new LucyImpl(config);
        }
        lucy.init();
        if (componentDefinition != null) {
            lucy.load(componentDefinition);
        }
        return lucy;
    }

    public static Lucy getLucy() {
        if (lucy == null) {
            throw new LucyStartupFailException();
        }
        return lucy;
    }

    public static synchronized void destroy() {
        if (lucy != null) {
            lucy.destroy();
            lucy = null;
        }
        Disposer.dispose();
        initialized = false;
    }

    static {
        initialized = false;
    }
}

