/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.behavior;

import java.util.Map;
import org.t2framework.commons.Constants;
import org.t2framework.commons.annotation.ConfigurationTarget;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.lucy.Lifecycle;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.annotation.core.InitMethod;
import org.t2framework.lucy.config.meta.impl.InitMethodConfig;
import org.t2framework.lucy.config.meta.impl.LifeCycleMethodConfig;
import org.t2framework.lucy.spi.AbstractBehavior;

@ConfigurationTarget(value={InitMethod.class, InitMethodConfig.class})
public class InitMethodBehavior
extends AbstractBehavior {
    protected Map<MethodDesc, Object> initedCache = CollectionsUtil.newHashMap();

    public InitMethodBehavior(BeanDesc beanDesc, MethodDesc md, Config cd) {
        super(beanDesc, md, cd);
    }

    @Override
    public <T> T execute(T t, Lucy lucy) {
        MethodDesc methodDesc = this.getMethodDesc();
        if (methodDesc != null && !this.initedCache.containsKey(methodDesc)) {
            Config cd = this.getConfig();
            if (cd == null || cd.hasAnnotation()) {
                methodDesc.invoke(t, Constants.EMPTY_ARRAY);
            } else {
                methodDesc.invoke(t, ((LifeCycleMethodConfig)cd).getArgs());
            }
            this.initedCache.put(methodDesc, t);
        }
        return t;
    }

    @Override
    public <T> void destroy() {
        this.initedCache.clear();
    }

    @Override
    public Lifecycle getLifecycle() {
        return Lifecycle.COMPONENT_INITIALIZE;
    }
}

