/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.stax;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.PrintableUtil;

public class Attributes {
    protected Map<String, Attribute> map = CollectionsUtil.newHashMap();

    public Attributes(StartElement se) {
        Assertion.notNull((Object)se);
        this.init(se.getAttributes());
    }

    public Attributes(Map<String, Attribute> map) {
        this.map = (Map)Assertion.notNull(map);
    }

    protected void init(Iterator<Attribute> iterator) {
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            this.map.put(attribute.getName().getLocalPart(), attribute);
        }
    }

    public boolean hasAnyAttribute() {
        return this.map.size() > 0;
    }

    public boolean hasAttribute(String name) {
        return this.map.containsKey(name);
    }

    public String getValue(String name) {
        Attribute attribute = this.map.get(name);
        return attribute != null ? attribute.getValue() : null;
    }

    public String getAndRemoveValue(String name) {
        Attribute attribute = this.map.remove(name);
        return attribute != null ? attribute.getValue() : null;
    }

    public boolean isSpecified(String name) {
        Attribute attribute = this.map.get(name);
        return attribute != null ? attribute.isSpecified() : false;
    }

    public String getAllValueAsString() {
        return PrintableUtil.toPrintableString(this.map.values());
    }
}

