/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.stax;

import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.NameDesc;
import org.t2framework.commons.meta.impl.ClassDescImpl;
import org.t2framework.commons.meta.impl.NameDescImpl;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.lucy.config.meta.AutoInject;
import org.t2framework.lucy.config.meta.ConfigurableBeanDesc;
import org.t2framework.lucy.config.meta.InstanceConfigFactory;
import org.t2framework.lucy.config.stax.Attributes;
import org.t2framework.lucy.config.stax.LucyConfigTagHandler;
import org.t2framework.lucy.config.stax.XmlEventContext;
import org.t2framework.lucy.config.stax.XmlEventHandler;

public class ComponentTagHandler
implements XmlEventHandler {
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String INSTANCE_ATTRIBUTE = "instance";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String AUTOINJECT_ATTRIBUTE = "autoinject";

    @Override
    public void start(XmlEventContext context, Attributes attributes) {
        String instance;
        String value = attributes.getAndRemoveValue(CLASS_ATTRIBUTE);
        Class c = null;
        if (!StringUtil.isEmpty((String)value)) {
            c = Reflections.ClassUtil.forName((String)value);
        }
        if (StringUtil.isEmpty((String)(instance = attributes.getAndRemoveValue(INSTANCE_ATTRIBUTE)))) {
            instance = "singleton";
        }
        ConfigurableBeanDesc<Object> beanDesc = this.createConfigurableBeanDesc(c, instance);
        String name = attributes.getAndRemoveValue(NAME_ATTRIBUTE);
        if (!StringUtil.isEmpty((String)name)) {
            beanDesc.setNameDesc(this.createNameDesc(name));
        }
        String autoinject = attributes.getAndRemoveValue(AUTOINJECT_ATTRIBUTE);
        beanDesc.setAutoinject(autoinject);
        context.push(beanDesc);
    }

    @Override
    public void end(XmlEventContext context, String body) {
        ConfigurableBeanDesc beanDesc = (ConfigurableBeanDesc)((Object)context.pop());
        AutoInject.get(beanDesc.getAutoinject()).setupAutoInject(beanDesc);
        LucyConfigTagHandler.LucyConfig config = (LucyConfigTagHandler.LucyConfig)context.peek();
        config.addBeanDesc((BeanDesc<?>)beanDesc);
    }

    protected ConfigurableBeanDesc<Object> createConfigurableBeanDesc(Class<?> c, String instance) {
        return new ConfigurableBeanDesc<Object>(this.createClassDesc(c, instance));
    }

    protected ClassDesc<Object> createClassDesc(Class<?> clazz, String instance) {
        ClassDescImpl cd = new ClassDescImpl(clazz);
        cd.addConfig((Config)InstanceConfigFactory.getInstanceConfig(instance));
        return cd;
    }

    protected NameDesc<Object> createNameDesc(String name) {
        return new NameDescImpl((Object)name);
    }
}

