/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.stax;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.t2framework.commons.el.Expression;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConstructorDesc;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.meta.impl.MethodDescImpl;
import org.t2framework.commons.meta.impl.PropertyDescImpl;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.JavaBeansUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.config.meta.ConfigurableBeanDesc;
import org.t2framework.lucy.config.meta.InjectConfig;
import org.t2framework.lucy.config.meta.impl.ConstructorInjectConfig;
import org.t2framework.lucy.config.meta.impl.MethodInjectConfig;
import org.t2framework.lucy.config.meta.impl.PropertyInjectConfig;
import org.t2framework.lucy.config.stax.AbstractExpressionHandler;
import org.t2framework.lucy.config.stax.Attributes;
import org.t2framework.lucy.config.stax.XmlEventContext;
import org.t2framework.lucy.config.stax.XmlEventHandler;
import org.t2framework.lucy.exception.MethodNotFoundException;

public class InjectTagHandler
extends AbstractExpressionHandler
implements XmlEventHandler {
    protected static Logger logger = Logger.getLogger(InjectTagHandler.class);

    @Override
    public void start(XmlEventContext context, Attributes attributes) {
        ConfigurableBeanDesc beanDesc = (ConfigurableBeanDesc)((Object)context.peek());
        Class<?>[] paramTypes = this.findParamTypes(attributes.getAndRemoveValue("parameterTypes"));
        String methodName = attributes.getAndRemoveValue("method");
        if (attributes.hasAnyAttribute()) {
            this.logForUnknownValue(context, attributes);
        }
        if (!StringUtil.isEmpty((String)methodName)) {
            this.setupMethod(context, beanDesc, methodName, paramTypes);
        } else {
            this.setupConstructor(beanDesc);
        }
    }

    protected void setupMethod(XmlEventContext context, ConfigurableBeanDesc beanDesc, String methodName, Class<?>[] paramTypes) {
        Class c = beanDesc.getComponentClass();
        Method method = this.find(context, c, methodName, paramTypes);
        if (JavaBeansUtil.isSetMethod((String)methodName)) {
            beanDesc.addPropertyDesc(this.createPropertyDesc(c, method, paramTypes));
        } else {
            beanDesc.addMethodDesc(this.createMethodDesc(method, paramTypes));
        }
    }

    protected void setupConstructor(ConfigurableBeanDesc beanDesc) {
        Class c = beanDesc.getComponentClass();
        Constructor<?>[] constructors = c.getConstructors();
        if (constructors.length == 1 && constructors[0].getParameterTypes().length == 0) {
            throw new IllegalStateException("method attribute must not be blank");
        }
        ConstructorDesc cd = beanDesc.getConstructorDesc();
        if (!cd.hasConfig(InjectConfig.class)) {
            ConstructorInjectConfig injectConfig = new ConstructorInjectConfig();
            cd.addConfig((Config)injectConfig);
            beanDesc.setConstructorDesc(cd);
        } else {
            ConstructorInjectConfig config = (ConstructorInjectConfig)cd.findConfig(InjectConfig.class);
            config.incrementArgumentSize();
        }
    }

    protected Class<?>[] findParamTypes(String paramTypesStr) {
        if (!StringUtil.isEmpty((String)paramTypesStr)) {
            return null;
        }
        String[] params = StringUtil.split((String)paramTypesStr, (String)",");
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = Reflections.ClassUtil.forName((String)params[i]);
        }
        return paramTypes;
    }

    @Override
    public void end(XmlEventContext context, String body) {
        ConfigurableBeanDesc beanDesc = (ConfigurableBeanDesc)((Object)context.peek());
        String source = body.trim();
        Expression<Lucy> expression = this.getExpression(source);
        if (expression != null) {
            beanDesc.getLatest().add(expression);
        }
    }

    public MethodDesc createMethodDesc(Method method, Class<?>[] paramTypes) {
        MethodDescImpl md = new MethodDescImpl(method);
        MethodInjectConfig injectConfig = new MethodInjectConfig(paramTypes);
        md.addConfig((Config)injectConfig);
        return md;
    }

    public PropertyDesc<?> createPropertyDesc(Class<?> componentClass, Method writeMethod, Class<?>[] paramTypes) {
        String propertyName = JavaBeansUtil.getPropertyName((String)writeMethod.getName());
        Method readMethod = this.getReadMethod(componentClass, writeMethod);
        Class propertyType = null;
        propertyType = readMethod != null ? readMethod.getReturnType() : JavaBeansUtil.findPropertyTypeFromWriteMethod((Method)writeMethod);
        PropertyDescImpl pd = new PropertyDescImpl(componentClass, propertyType, propertyName);
        pd.setWriteMethod(writeMethod);
        if (readMethod != null) {
            pd.setReadMethod(readMethod);
        }
        PropertyInjectConfig injectDesc = new PropertyInjectConfig(writeMethod.getParameterTypes());
        pd.addConfig((Config)injectDesc);
        return pd;
    }

    protected <T> Method getReadMethod(Class<T> componentClass, Method writeMethod) {
        return JavaBeansUtil.getReadMethodFromWriteMethod(componentClass, (Method)writeMethod);
    }

    protected Method find(XmlEventContext context, Class<?> componentClass, String methodName, Class<?>[] paramTypes) {
        List list = CollectionsUtil.newArrayList();
        for (Method m : componentClass.getMethods()) {
            if (!methodName.equals(m.getName())) continue;
            list.add(m);
        }
        if (list == null || list.isEmpty()) {
            throw new MethodNotFoundException(componentClass, methodName, context.getLineNumber(), context.getColumnNumber());
        }
        if (list.size() == 1) {
            return (Method)list.get(0);
        }
        if (paramTypes == null) {
            return (Method)list.get(0);
        }
        return Reflections.MethodUtil.getDeclaredMethod(componentClass, (String)methodName, (Class[])paramTypes);
    }

    protected void logForUnknownValue(XmlEventContext context, Attributes attributes) {
        logger.log("DLucyCore0003", new Object[]{"inject", attributes.getAllValueAsString(), context.getLineNumber(), context.getColumnNumber()});
    }
}

