/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.inject;

import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.lucy.annotation.core.Inject;
import org.t2framework.lucy.config.meta.InjectConfig;
import org.t2framework.lucy.inject.AbstractInjector;

public class InjectorUtil {
    public static boolean hasInjectAnnotation(ConfigContainer container) {
        if (container == null) {
            return false;
        }
        return container.hasConfig(Inject.class);
    }

    public static boolean hasInjectConfiguration(ConfigContainer container) {
        if (container == null) {
            return false;
        }
        return container.hasConfig(InjectConfig.class);
    }

    public static boolean isInjectAnnotation(Config config) {
        if (config == null || !config.hasAnnotation()) {
            return false;
        }
        return config.getAnnotation().annotationType() == Inject.class;
    }

    public static Class[] getTypes(ConfigContainer container) {
        if (!InjectorUtil.hasInjectAnnotation(container) && !InjectorUtil.hasInjectConfiguration(container)) {
            return null;
        }
        Class[] types = null;
        for (Config config : container) {
            Class type = config.getType();
            if (type.equals(Inject.class)) {
                types = ((Inject)config.getAnnotation()).types();
                if (types.length == 1 && types[0] == Object.class) {
                    types = null;
                }
                return types;
            }
            if (!type.equals(InjectConfig.class)) continue;
            return ((InjectConfig)config).getParameterTypes();
        }
        return types;
    }

    public static <T> T getInjectableComponent(Class<? super T> type, AbstractInjector.InjectInfo info, int namesIndex, InjectHandler<T> handler) {
        int namesLength;
        T value = null;
        value = InjectorUtil.isSimplyByType(info) ? (T)handler.getFromType(type) : (namesIndex < (namesLength = info.getNames().length) ? (T)handler.getFromIdentifier(info.getNames()[namesIndex]) : (T)handler.getFromType(type));
        return value;
    }

    private static boolean isSimplyByType(AbstractInjector.InjectInfo info) {
        return info == null || !info.hasNames();
    }

    public static interface InjectHandler<T> {
        public T getFromType(Class var1);

        public T getFromIdentifier(Object var1);
    }
}

