/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ConnectionFactoryRegistry;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.appengine.DatastoreAdapter;
import org.datanucleus.store.appengine.DatastoreConnectionFactoryImpl;
import org.datanucleus.store.appengine.DatastoreExtent;
import org.datanucleus.store.appengine.DatastoreFKListStoreSpecialization;
import org.datanucleus.store.appengine.DatastoreFKSetStore;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.MetaDataValidator;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.FKArrayStoreSpecialization;
import org.datanucleus.store.mapped.scostore.FKListStoreSpecialization;
import org.datanucleus.store.mapped.scostore.FKMapStore;
import org.datanucleus.store.mapped.scostore.FKSetStore;
import org.datanucleus.store.mapped.scostore.JoinArrayStore;
import org.datanucleus.store.mapped.scostore.JoinListStore;
import org.datanucleus.store.mapped.scostore.JoinMapStore;
import org.datanucleus.store.mapped.scostore.JoinSetStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreManager
extends MappedStoreManager {
    private final Set<String> validatedClasses = Collections.synchronizedSet(new HashSet());
    private static final String EXTENSION_PREFIX = "gae.";
    public static final String PARENT_PK = "gae.parent-pk";
    public static final String ENCODED_PK = "gae.encoded-pk";
    public static final String PK_NAME = "gae.pk-name";
    public static final String PK_ID = "gae.pk-id";

    public DatastoreManager(ClassLoaderResolver clr, OMFContext omfContext) {
        super("appengine", clr, DatastoreManager.addDefaultPropertyValues(omfContext));
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.google.appengine.api.datastore.DatastoreService", (String)"appengine-api.jar");
        this.persistenceHandler = new DatastorePersistenceHandler((StoreManager)this);
        this.dba = new DatastoreAdapter();
        this.initialiseIdentifierFactory(omfContext);
        this.logConfiguration();
    }

    private static OMFContext addDefaultPropertyValues(OMFContext omfContext) {
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        conf.setProperty("datanucleus.attachSameDatastore", (Object)Boolean.TRUE.toString());
        if (conf.getProperty("datanucleus.appengine.autoCreateDatastoreTxns") == null) {
            conf.setProperty("datanucleus.appengine.autoCreateDatastoreTxns", (Object)Boolean.TRUE.toString());
        }
        return omfContext;
    }

    public NucleusConnection getNucleusConnection(ObjectManager om) {
        ConnectionFactory cf = this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory(this.txConnectionFactoryName);
        final boolean enlisted = om.getTransaction().isActive();
        final ManagedConnection mc = cf.getConnection((ObjectManager)(enlisted ? om : null), null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    // empty if block
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    public Date getDatastoreDate() {
        throw new UnsupportedOperationException();
    }

    public Extent getExtent(ObjectManager om, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        this.validateMetaDataForClass(cmd, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        return new DatastoreExtent(om, c, subclasses, cmd);
    }

    protected void initialiseIdentifierFactory(OMFContext omfContext) {
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        String idFactoryName = conf.getStringProperty("datanucleus.identifierFactory");
        String idFactoryClassName = omfContext.getPluginManager().getAttributeValueForExtension("org.datanucleus.store_identifierfactory", "name", idFactoryName, "class-name");
        if (idFactoryClassName == null) {
            throw new NucleusUserException(idFactoryName).setFatal();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        this.addStringPropIfNotNull(conf, props, "datanucleus.mapping.Catalog", "DefaultCatalog");
        this.addStringPropIfNotNull(conf, props, "datanucleus.mapping.Schema", "DefaultSchema");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.case", "RequiredCase");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.wordSeparator", "WordSeparator");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.tablePrefix", "TablePrefix");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.tableSuffix", "TableSuffix");
        try {
            Class<?> cls = Class.forName(idFactoryClassName);
            Class[] argTypes = new Class[]{org.datanucleus.store.mapped.DatastoreAdapter.class, ClassLoaderResolver.class, Map.class};
            Object[] args = new Object[]{this.dba, omfContext.getClassLoaderResolver(null), props};
            this.identifierFactory = (IdentifierFactory)ClassUtils.newInstance(cls, (Class[])argTypes, (Object[])args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(idFactoryName + ":" + idFactoryClassName, (Throwable)cnfe).setFatal();
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)e);
            throw new NucleusException(idFactoryClassName, (Throwable)e).setFatal();
        }
    }

    private void addStringPropIfNotNull(PersistenceConfiguration conf, Map<String, String> map, String propName, String mapKeyName) {
        String val = conf.getStringProperty(propName);
        if (val != null) {
            map.put(mapKeyName, val);
        }
    }

    public Collection<String> getSupportedOptions() {
        HashSet<String> opts = new HashSet<String>();
        opts.add("TransactionIsolationLevel.read-committed");
        opts.add("BackedSCO");
        return opts;
    }

    public FetchStatement getFetchStatement(DatastoreContainerObject table) {
        throw new UnsupportedOperationException();
    }

    public DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        return null;
    }

    protected StoreData newStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        DatastoreTable table = new DatastoreTable(this, (AbstractClassMetaData)cmd, clr, this.dba);
        MappedStoreData sd = new MappedStoreData(cmd, (DatastoreContainerObject)table, true);
        this.registerStoreData((StoreData)sd);
        table.buildMapping();
        return sd;
    }

    public FieldManager getFieldManagerForResultProcessing(StateManager sm, Object obj, StatementMappingForClass resultMappings) {
        ObjectManager om = sm.getObjectManager();
        Class cls = om.getClassLoaderResolver().classForName(sm.getClassMetaData().getFullClassName());
        Object internalKey = EntityUtils.idToInternalKey(sm.getObjectManager(), cls, obj);
        return new KeyOnlyFieldManager(internalKey);
    }

    public Object getResultValueAtPosition(Object key, JavaTypeMapping mapping, int position) {
        return key;
    }

    public boolean insertValuesOnInsert(DatastoreMapping datastoreMapping) {
        return true;
    }

    public boolean allowsBatching() {
        return false;
    }

    public FieldManager getFieldManagerForStatementGeneration(StateManager sm, Object stmt, StatementMappingForClass stmtMappings, boolean checkNonNullable) {
        return null;
    }

    public ResultObjectFactory newResultObjectFactory(DatastoreClass table, AbstractClassMetaData acmd, StatementMappingForClass mappingDefinition, boolean ignoreCache, boolean discriminator, FetchPlan fetchPlan, Class persistentClass) {
        return null;
    }

    protected FKListStoreSpecialization newFKListStoreSpecialization(ClassLoaderResolver clr) {
        return new DatastoreFKListStoreSpecialization(LOCALISER, clr, this);
    }

    protected FKSetStore newFKSetStore(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return new DatastoreFKSetStore(ammd, this, clr);
    }

    protected FKArrayStoreSpecialization newFKArrayStoreSpecialization(ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("FK Arrays not supported.");
    }

    protected FKMapStore newFKMapStore(AbstractMemberMetaData clr, ClassLoaderResolver amd) {
        throw new UnsupportedOperationException("FK Maps not supported.");
    }

    protected JoinArrayStore newJoinArrayStore(DatastoreContainerObject arrayTable, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("Join Arrays not supported.");
    }

    protected JoinMapStore newJoinMapStore(DatastoreContainerObject mapTable, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("Join Maps not supported.");
    }

    protected JoinListStore newJoinListStore(AbstractMemberMetaData amd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        throw new UnsupportedOperationException("Join Lists not supported.");
    }

    protected JoinSetStore newJoinSetStore(AbstractMemberMetaData amd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        throw new UnsupportedOperationException("Join Sets not supported.");
    }

    public DatastorePersistenceHandler getPersistenceHandler() {
        return (DatastorePersistenceHandler)super.getPersistenceHandler();
    }

    String getTxConnectionFactoryName() {
        return this.txConnectionFactoryName;
    }

    String getNonTxConnectionFactoryName() {
        return this.nontxConnectionFactoryName;
    }

    boolean connectionFactoryIsTransactional() {
        ConnectionFactoryRegistry registry = this.getOMFContext().getConnectionFactoryRegistry();
        DatastoreConnectionFactoryImpl connFactory = (DatastoreConnectionFactoryImpl)registry.lookupConnectionFactory(this.txConnectionFactoryName);
        return connFactory.isTransactional();
    }

    public DatastoreTable getDatastoreClass(String className, ClassLoaderResolver clr) {
        try {
            return (DatastoreTable)super.getDatastoreClass(className, clr);
        }
        catch (NoTableManagedException e) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && !api.isPersistable(cls)) {
                throw new NoTableManagedException("Class " + className + " does not seem to have been enhanced.  You may want to rerun " + "the enhancer and check for errors in the output.");
            }
            throw e;
        }
    }

    private static boolean memberHasExtension(AbstractClassMetaData acmd, int pos, String extensionName) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(pos);
        return ammd.hasExtension(extensionName);
    }

    static boolean hasEncodedPKField(AbstractClassMetaData acmd) {
        int pkPos = acmd.getPKMemberPositions()[0];
        return DatastoreManager.isEncodedPKField(acmd, pkPos);
    }

    static boolean isEncodedPKField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, ENCODED_PK);
    }

    static boolean isParentPKField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, PARENT_PK);
    }

    static boolean isPKNameField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, PK_NAME);
    }

    static boolean isPKIdField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, PK_ID);
    }

    public void validateMetaDataForClass(AbstractClassMetaData acmd, ClassLoaderResolver clr) {
        if (this.validatedClasses.add(acmd.getFullClassName())) {
            new MetaDataValidator(acmd, this.getMetaDataManager(), clr).validate();
        }
    }

    public void close() {
        this.validatedClasses.clear();
        super.close();
    }

    private static final class KeyOnlyFieldManager
    implements FieldManager {
        private final Object key;

        private KeyOnlyFieldManager(Object key) {
            this.key = key;
        }

        public void storeBooleanField(int fieldNumber, boolean value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeByteField(int fieldNumber, byte value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeCharField(int fieldNumber, char value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeDoubleField(int fieldNumber, double value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeFloatField(int fieldNumber, float value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeIntField(int fieldNumber, int value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeLongField(int fieldNumber, long value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeShortField(int fieldNumber, short value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeStringField(int fieldNumber, String value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeObjectField(int fieldNumber, Object value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public boolean fetchBooleanField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public byte fetchByteField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public char fetchCharField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public double fetchDoubleField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public float fetchFloatField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public int fetchIntField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public long fetchLongField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public short fetchShortField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public String fetchStringField(int fieldNumber) {
            return (String)this.key;
        }

        public Object fetchObjectField(int fieldNumber) {
            return this.key;
        }
    }
}

